/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceprogram.client;

import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.governanceprogram.ffdc.GovernanceProgramErrorCode;
import org.odpi.openmetadata.accessservices.governanceprogram.ffdc.exceptions.AppointmentIdNotUniqueException;
import org.odpi.openmetadata.accessservices.governanceprogram.ffdc.exceptions.EmployeeNumberNotUniqueException;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.GovernanceDomain;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceProgramOMASAPIResponse;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;

class RESTExceptionHandler
extends org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler {
    public void validateGovernanceDomain(GovernanceDomain governanceDomain, String nameParameter, String methodName) throws InvalidParameterException {
        if (governanceDomain == null) {
            GovernanceProgramErrorCode errorCode = GovernanceProgramErrorCode.NULL_ENUM;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{nameParameter, methodName});
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), nameParameter);
        }
    }

    public void detectAndThrowEmployeeNumberNotUniqueException(String methodName, GovernanceProgramOMASAPIResponse restResult) throws EmployeeNumberNotUniqueException {
        String exceptionClassName = EmployeeNumberNotUniqueException.class.getName();
        if (restResult != null && exceptionClassName.equals(restResult.getExceptionClassName())) {
            Object duplicateProfilesObject;
            List duplicateProfiles = null;
            Map exceptionProperties = restResult.getExceptionProperties();
            if (exceptionProperties != null && (duplicateProfilesObject = exceptionProperties.get("duplicateProfiles")) != null) {
                duplicateProfiles = (List)duplicateProfilesObject;
            }
            throw new EmployeeNumberNotUniqueException(restResult.getRelatedHTTPCode(), ((Object)((Object)this)).getClass().getName(), methodName, restResult.getExceptionErrorMessage(), restResult.getExceptionSystemAction(), restResult.getExceptionUserAction(), duplicateProfiles);
        }
    }

    public void detectAndThrowAppointmentIdNotUniqueException(String methodName, GovernanceProgramOMASAPIResponse restResult) throws AppointmentIdNotUniqueException {
        String exceptionClassName = EmployeeNumberNotUniqueException.class.getName();
        if (restResult != null && exceptionClassName.equals(restResult.getExceptionClassName())) {
            Object duplicateProfilesObject;
            List duplicatesPosts = null;
            Map exceptionProperties = restResult.getExceptionProperties();
            if (exceptionProperties != null && (duplicateProfilesObject = exceptionProperties.get("duplicatePosts")) != null) {
                duplicatesPosts = (List)duplicateProfilesObject;
            }
            throw new AppointmentIdNotUniqueException(restResult.getRelatedHTTPCode(), ((Object)((Object)this)).getClass().getName(), methodName, restResult.getExceptionErrorMessage(), restResult.getExceptionSystemAction(), restResult.getExceptionUserAction(), duplicatesPosts);
        }
    }
}

