/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceprogram.client;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.governanceprogram.api.GovernanceLeadershipInterface;
import org.odpi.openmetadata.accessservices.governanceprogram.client.GovernanceProgramRESTClient;
import org.odpi.openmetadata.accessservices.governanceprogram.client.RESTExceptionHandler;
import org.odpi.openmetadata.accessservices.governanceprogram.ffdc.exceptions.AppointmentIdNotUniqueException;
import org.odpi.openmetadata.accessservices.governanceprogram.ffdc.exceptions.EmployeeNumberNotUniqueException;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.ExternalReference;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.GovernanceDomain;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.GovernanceOfficer;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.PersonalProfile;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.AppointmentRequestBody;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceDomainRequestBody;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceOfficerDetailsRequestBody;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceOfficerListResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceOfficerResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceOfficerValidatorRequestBody;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceProgramOMASAPIResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.PersonalDetailsRequestBody;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.PersonalProfileListResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.PersonalProfileResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.PersonalProfileValidatorRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponseBase;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;

public class GovernanceProgramLeadership
implements GovernanceLeadershipInterface {
    private String serverName;
    private String omasServerURL;
    private GovernanceProgramRESTClient restClient;
    private InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
    private RESTExceptionHandler exceptionHandler = new RESTExceptionHandler();

    public GovernanceProgramLeadership(String serverName, String omasServerURL) throws InvalidParameterException {
        String methodName = "Constructor (no security)";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(omasServerURL, serverName, "Constructor (no security)");
        this.serverName = serverName;
        this.omasServerURL = omasServerURL;
        this.restClient = new GovernanceProgramRESTClient(serverName, omasServerURL);
    }

    public GovernanceProgramLeadership(String serverName, String omasServerURL, String userId, String password) throws InvalidParameterException {
        String methodName = "Constructor (with security)";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(omasServerURL, serverName, "Constructor (with security)");
        this.serverName = serverName;
        this.omasServerURL = omasServerURL;
        this.restClient = new GovernanceProgramRESTClient(serverName, omasServerURL, userId, password);
    }

    public String createPersonalProfile(String userId, String profileUserId, String employeeNumber, String fullName, String knownName, String jobTitle, String jobRoleDescription, Map<String, String> additionalProperties) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "createPersonalProfile";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/leadership/personal-profiles";
        String profileUserIdParameterName = "profileUserId";
        String employeeNumberParameterName = "employeeNumber";
        String knownNameParameterName = "knownName";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(this.omasServerURL, this.serverName, "createPersonalProfile");
        this.invalidParameterHandler.validateUserId(userId, "createPersonalProfile");
        this.invalidParameterHandler.validateName(profileUserId, "profileUserId", "createPersonalProfile");
        this.invalidParameterHandler.validateName(employeeNumber, "employeeNumber", "createPersonalProfile");
        this.invalidParameterHandler.validateName(knownName, "knownName", "createPersonalProfile");
        PersonalDetailsRequestBody requestBody = new PersonalDetailsRequestBody();
        requestBody.setUserId(profileUserId);
        requestBody.setEmployeeNumber(employeeNumber);
        requestBody.setFullName(fullName);
        requestBody.setKnownName(knownName);
        requestBody.setJobTitle(jobTitle);
        requestBody.setJobRoleDescription(jobRoleDescription);
        requestBody.setAdditionalProperties(additionalProperties);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createPersonalProfile", this.omasServerURL + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/leadership/personal-profiles", requestBody, new Object[]{this.serverName, userId});
        this.exceptionHandler.detectAndThrowInvalidParameterException("createPersonalProfile", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("createPersonalProfile", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("createPersonalProfile", (FFDCResponseBase)restResult);
        return restResult.getGUID();
    }

    public void updatePersonalProfile(String userId, String profileGUID, String employeeNumber, String fullName, String knownName, String jobTitle, String jobRoleDescription, Map<String, String> additionalProperties) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "updatePersonalProfile";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/leadership/personal-profiles/{2}";
        String guidParameterName = "profileGUID";
        String employeeNumberParameterName = "employeeNumber";
        String knownNameParameterName = "knownName";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(this.omasServerURL, this.serverName, "updatePersonalProfile");
        this.invalidParameterHandler.validateUserId(userId, "updatePersonalProfile");
        this.invalidParameterHandler.validateGUID(profileGUID, "profileGUID", "updatePersonalProfile");
        this.invalidParameterHandler.validateName(employeeNumber, "employeeNumber", "updatePersonalProfile");
        this.invalidParameterHandler.validateName(knownName, "knownName", "updatePersonalProfile");
        PersonalDetailsRequestBody requestBody = new PersonalDetailsRequestBody();
        requestBody.setEmployeeNumber(employeeNumber);
        requestBody.setFullName(fullName);
        requestBody.setKnownName(knownName);
        requestBody.setJobTitle(jobTitle);
        requestBody.setJobRoleDescription(jobRoleDescription);
        requestBody.setAdditionalProperties(additionalProperties);
        VoidResponse restResult = this.restClient.callVoidPostRESTCall("updatePersonalProfile", this.omasServerURL + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/leadership/personal-profiles/{2}", requestBody, new Object[]{this.serverName, userId, profileGUID});
        this.exceptionHandler.detectAndThrowInvalidParameterException("updatePersonalProfile", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("updatePersonalProfile", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("updatePersonalProfile", (FFDCResponseBase)restResult);
    }

    public void deletePersonalProfile(String userId, String profileGUID, String employeeNumber) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "deletePersonalProfile";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/leadership/personal-profiles/{2}/delete";
        String guidParameterName = "profileGUID";
        String employeeNumberParameterName = "employeeNumber";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(this.omasServerURL, this.serverName, "deletePersonalProfile");
        this.invalidParameterHandler.validateUserId(userId, "deletePersonalProfile");
        this.invalidParameterHandler.validateGUID(profileGUID, "profileGUID", "deletePersonalProfile");
        this.invalidParameterHandler.validateName(employeeNumber, "employeeNumber", "deletePersonalProfile");
        PersonalProfileValidatorRequestBody requestBody = new PersonalProfileValidatorRequestBody();
        requestBody.setEmployeeNumber(employeeNumber);
        VoidResponse restResult = this.restClient.callVoidPostRESTCall("deletePersonalProfile", this.omasServerURL + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/leadership/personal-profiles/{2}/delete", requestBody, new Object[]{this.serverName, userId, profileGUID});
        this.exceptionHandler.detectAndThrowInvalidParameterException("deletePersonalProfile", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("deletePersonalProfile", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("deletePersonalProfile", (FFDCResponseBase)restResult);
    }

    public PersonalProfile getPersonalProfileByGUID(String userId, String profileGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getPersonalProfileByGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/leadership/personal-profiles/{2}";
        String guidParameterName = "profileGUID";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(this.omasServerURL, this.serverName, "getPersonalProfileByGUID");
        this.invalidParameterHandler.validateUserId(userId, "getPersonalProfileByGUID");
        this.invalidParameterHandler.validateGUID(profileGUID, "profileGUID", "getPersonalProfileByGUID");
        PersonalProfileResponse restResult = this.restClient.callPersonalProfileGetRESTCall("getPersonalProfileByGUID", this.omasServerURL + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/leadership/personal-profiles/{2}", this.serverName, userId, profileGUID);
        this.exceptionHandler.detectAndThrowInvalidParameterException("getPersonalProfileByGUID", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("getPersonalProfileByGUID", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("getPersonalProfileByGUID", (FFDCResponseBase)restResult);
        return restResult.getPersonalProfile();
    }

    public PersonalProfile getPersonalProfileByEmployeeNumber(String userId, String employeeNumber) throws InvalidParameterException, EmployeeNumberNotUniqueException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getPersonalProfileByEmployeeNumber";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/leadership/personal-profiles/by-employee-number/{2}";
        String employeeNumberParameterName = "employeeNumber";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(this.omasServerURL, this.serverName, "getPersonalProfileByEmployeeNumber");
        this.invalidParameterHandler.validateUserId(userId, "getPersonalProfileByEmployeeNumber");
        this.invalidParameterHandler.validateName(employeeNumber, "employeeNumber", "getPersonalProfileByEmployeeNumber");
        PersonalProfileResponse restResult = this.restClient.callPersonalProfileGetRESTCall("getPersonalProfileByEmployeeNumber", this.omasServerURL + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/leadership/personal-profiles/by-employee-number/{2}", this.serverName, userId, employeeNumber);
        this.exceptionHandler.detectAndThrowInvalidParameterException("getPersonalProfileByEmployeeNumber", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowEmployeeNumberNotUniqueException("getPersonalProfileByEmployeeNumber", (GovernanceProgramOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("getPersonalProfileByEmployeeNumber", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("getPersonalProfileByEmployeeNumber", (FFDCResponseBase)restResult);
        return restResult.getPersonalProfile();
    }

    public List<PersonalProfile> getPersonalProfilesByName(String userId, String name) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getPersonalProfilesByName";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/leadership/personal-profiles/by-name/{2}";
        String nameParameterName = "name";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(this.omasServerURL, this.serverName, "getPersonalProfilesByName");
        this.invalidParameterHandler.validateUserId(userId, "getPersonalProfilesByName");
        this.invalidParameterHandler.validateName(name, "name", "getPersonalProfilesByName");
        PersonalProfileListResponse restResult = this.restClient.callPersonalProfileListGetRESTCall("getPersonalProfilesByName", this.omasServerURL + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/leadership/personal-profiles/by-name/{2}", this.serverName, userId, name);
        this.exceptionHandler.detectAndThrowInvalidParameterException("getPersonalProfilesByName", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("getPersonalProfilesByName", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("getPersonalProfilesByName", (FFDCResponseBase)restResult);
        return restResult.getPersonalProfiles();
    }

    public String createGovernanceOfficer(String userId, GovernanceDomain governanceDomain, String appointmentId, String appointmentContext, String title, Map<String, String> additionalProperties, List<ExternalReference> externalReferences) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "createGovernanceOfficer";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/leadership/governance-officers";
        String appointmentIdParameterName = "appointmentId";
        String titleParameterName = "title";
        String governanceDomainParameterName = "governanceDomain";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(this.omasServerURL, this.serverName, "createGovernanceOfficer");
        this.invalidParameterHandler.validateUserId(userId, "createGovernanceOfficer");
        this.invalidParameterHandler.validateName(appointmentId, "appointmentId", "createGovernanceOfficer");
        this.invalidParameterHandler.validateName(title, "title", "createGovernanceOfficer");
        this.exceptionHandler.validateGovernanceDomain(governanceDomain, "governanceDomain", "createGovernanceOfficer");
        GovernanceOfficerDetailsRequestBody requestBody = new GovernanceOfficerDetailsRequestBody();
        requestBody.setGovernanceDomain(governanceDomain);
        requestBody.setAppointmentId(appointmentId);
        requestBody.setAppointmentContext(appointmentContext);
        requestBody.setTitle(title);
        requestBody.setAdditionalProperties(additionalProperties);
        requestBody.setExternalReferences(externalReferences);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createGovernanceOfficer", this.omasServerURL + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/leadership/governance-officers", requestBody, new Object[]{this.serverName, userId});
        this.exceptionHandler.detectAndThrowInvalidParameterException("createGovernanceOfficer", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("createGovernanceOfficer", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("createGovernanceOfficer", (FFDCResponseBase)restResult);
        return restResult.getGUID();
    }

    public void updateGovernanceOfficer(String userId, String governanceOfficerGUID, GovernanceDomain governanceDomain, String appointmentId, String appointmentContext, String title, Map<String, String> additionalProperties, List<ExternalReference> externalReferences) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "updateGovernanceOfficer";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/leadership/governance-officers/{2}";
        String guidParameterName = "governanceOfficerGUID";
        String appointmentIdParameterName = "appointmentId";
        String titleParameterName = "title";
        String governanceDomainParameterName = "governanceDomain";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(this.omasServerURL, this.serverName, "updateGovernanceOfficer");
        this.invalidParameterHandler.validateUserId(userId, "updateGovernanceOfficer");
        this.invalidParameterHandler.validateGUID(governanceOfficerGUID, "governanceOfficerGUID", "updateGovernanceOfficer");
        this.invalidParameterHandler.validateName(appointmentId, "appointmentId", "updateGovernanceOfficer");
        this.invalidParameterHandler.validateName(title, "title", "updateGovernanceOfficer");
        this.exceptionHandler.validateGovernanceDomain(governanceDomain, "governanceDomain", "updateGovernanceOfficer");
        GovernanceOfficerDetailsRequestBody requestBody = new GovernanceOfficerDetailsRequestBody();
        requestBody.setGovernanceDomain(governanceDomain);
        requestBody.setAppointmentId(appointmentId);
        requestBody.setAppointmentContext(appointmentContext);
        requestBody.setTitle(title);
        requestBody.setAdditionalProperties(additionalProperties);
        requestBody.setExternalReferences(externalReferences);
        VoidResponse restResult = this.restClient.callVoidPostRESTCall("updateGovernanceOfficer", this.omasServerURL + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/leadership/governance-officers/{2}", requestBody, new Object[]{this.serverName, userId, governanceOfficerGUID});
        this.exceptionHandler.detectAndThrowInvalidParameterException("updateGovernanceOfficer", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("updateGovernanceOfficer", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("updateGovernanceOfficer", (FFDCResponseBase)restResult);
    }

    public void deleteGovernanceOfficer(String userId, String governanceOfficerGUID, String appointmentId, GovernanceDomain governanceDomain) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "deleteGovernanceOfficer";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/leadership/governance-officers/{2}/delete";
        String guidParameterName = "governanceOfficerGUID";
        String appointmentIdParameterName = "appointmentId";
        String governanceDomainParameterName = "governanceDomain";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(this.omasServerURL, this.serverName, "deleteGovernanceOfficer");
        this.invalidParameterHandler.validateGUID(governanceOfficerGUID, "governanceOfficerGUID", "deleteGovernanceOfficer");
        this.invalidParameterHandler.validateUserId(userId, "deleteGovernanceOfficer");
        this.invalidParameterHandler.validateName(appointmentId, "appointmentId", "deleteGovernanceOfficer");
        this.exceptionHandler.validateGovernanceDomain(governanceDomain, "governanceDomain", "deleteGovernanceOfficer");
        GovernanceOfficerValidatorRequestBody requestBody = new GovernanceOfficerValidatorRequestBody();
        requestBody.setGovernanceDomain(governanceDomain);
        requestBody.setAppointmentId(appointmentId);
        VoidResponse restResult = this.restClient.callVoidPostRESTCall("deleteGovernanceOfficer", this.omasServerURL + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/leadership/governance-officers/{2}/delete", requestBody, new Object[]{this.serverName, userId, governanceOfficerGUID});
        this.exceptionHandler.detectAndThrowInvalidParameterException("deleteGovernanceOfficer", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("deleteGovernanceOfficer", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("deleteGovernanceOfficer", (FFDCResponseBase)restResult);
    }

    public GovernanceOfficer getGovernanceOfficerByGUID(String userId, String governanceOfficerGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getGovernanceOfficerByGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/leadership/governance-officers/{2}";
        String guidParameterName = "governanceOfficerGUID";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(this.omasServerURL, this.serverName, "getGovernanceOfficerByGUID");
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceOfficerByGUID");
        this.invalidParameterHandler.validateGUID(governanceOfficerGUID, "governanceOfficerGUID", "getGovernanceOfficerByGUID");
        GovernanceOfficerResponse restResult = this.restClient.callGovernanceOfficerGetRESTCall("getGovernanceOfficerByGUID", this.omasServerURL + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/leadership/governance-officers/{2}", this.serverName, userId, governanceOfficerGUID);
        this.exceptionHandler.detectAndThrowInvalidParameterException("getGovernanceOfficerByGUID", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("getGovernanceOfficerByGUID", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("getGovernanceOfficerByGUID", (FFDCResponseBase)restResult);
        return restResult.getGovernanceOfficer();
    }

    public GovernanceOfficer getGovernanceOfficerByAppointmentId(String userId, String appointmentId) throws InvalidParameterException, AppointmentIdNotUniqueException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getGovernanceOfficerByAppointmentId";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/leadership/governance-officers/by-appointment-id/{2}";
        String appointmentIdParameterName = "appointmentId";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(this.omasServerURL, this.serverName, "getGovernanceOfficerByAppointmentId");
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceOfficerByAppointmentId");
        this.invalidParameterHandler.validateName(appointmentId, "appointmentId", "getGovernanceOfficerByAppointmentId");
        GovernanceOfficerResponse restResult = this.restClient.callGovernanceOfficerGetRESTCall("getGovernanceOfficerByAppointmentId", this.omasServerURL + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/leadership/governance-officers/by-appointment-id/{2}", this.serverName, userId, appointmentId);
        this.exceptionHandler.detectAndThrowInvalidParameterException("getGovernanceOfficerByAppointmentId", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowAppointmentIdNotUniqueException("getGovernanceOfficerByAppointmentId", (GovernanceProgramOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("getGovernanceOfficerByAppointmentId", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("getGovernanceOfficerByAppointmentId", (FFDCResponseBase)restResult);
        return restResult.getGovernanceOfficer();
    }

    public List<GovernanceOfficer> getGovernanceOfficers(String userId) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getGovernanceOfficers";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/leadership/governance-officers";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(this.omasServerURL, this.serverName, "getGovernanceOfficers");
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceOfficers");
        GovernanceOfficerListResponse restResult = this.restClient.callGovernanceOfficerListGetRESTCall("getGovernanceOfficers", this.omasServerURL + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/leadership/governance-officers", this.serverName, userId);
        this.exceptionHandler.detectAndThrowInvalidParameterException("getGovernanceOfficers", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("getGovernanceOfficers", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("getGovernanceOfficers", (FFDCResponseBase)restResult);
        return restResult.getGovernanceOfficers();
    }

    public List<GovernanceOfficer> getActiveGovernanceOfficers(String userId) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getGovernanceOfficers";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/leadership/governance-officers/active";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(this.omasServerURL, this.serverName, "getGovernanceOfficers");
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceOfficers");
        GovernanceOfficerListResponse restResult = this.restClient.callGovernanceOfficerListGetRESTCall("getGovernanceOfficers", this.omasServerURL + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/leadership/governance-officers/active", this.serverName, userId);
        this.exceptionHandler.detectAndThrowInvalidParameterException("getGovernanceOfficers", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("getGovernanceOfficers", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("getGovernanceOfficers", (FFDCResponseBase)restResult);
        return restResult.getGovernanceOfficers();
    }

    public List<GovernanceOfficer> getGovernanceOfficersByDomain(String userId, GovernanceDomain governanceDomain) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getGovernanceOfficersByDomain";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/leadership/governance-officers/by-domain";
        String governanceDomainParameterName = "governanceDomain";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(this.omasServerURL, this.serverName, "getGovernanceOfficersByDomain");
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceOfficersByDomain");
        this.exceptionHandler.validateGovernanceDomain(governanceDomain, "governanceDomain", "getGovernanceOfficersByDomain");
        GovernanceDomainRequestBody requestBody = new GovernanceDomainRequestBody();
        requestBody.setGovernanceDomain(governanceDomain);
        GovernanceOfficerListResponse restResult = this.restClient.callGovernanceOfficerListPostRESTCall("getGovernanceOfficersByDomain", this.omasServerURL + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/leadership/governance-officers/by-domain", requestBody, this.serverName, userId);
        this.exceptionHandler.detectAndThrowInvalidParameterException("getGovernanceOfficersByDomain", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("getGovernanceOfficersByDomain", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("getGovernanceOfficersByDomain", (FFDCResponseBase)restResult);
        return restResult.getGovernanceOfficers();
    }

    public void appointGovernanceOfficer(String userId, String governanceOfficerGUID, String profileGUID, Date startDate) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "appointGovernanceOfficer";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/leadership/governance-officers/{2}/appoint";
        String governanceOfficerGUIDParameterName = "governanceOfficerGUID";
        String profileGUIDParameterName = "profileGUID";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(this.omasServerURL, this.serverName, "appointGovernanceOfficer");
        this.invalidParameterHandler.validateUserId(userId, "appointGovernanceOfficer");
        this.invalidParameterHandler.validateGUID(governanceOfficerGUID, "governanceOfficerGUID", "appointGovernanceOfficer");
        this.invalidParameterHandler.validateGUID(profileGUID, "profileGUID", "appointGovernanceOfficer");
        AppointmentRequestBody requestBody = new AppointmentRequestBody();
        requestBody.setGUID(profileGUID);
        requestBody.setEffectiveDate(startDate);
        VoidResponse restResult = this.restClient.callVoidPostRESTCall("appointGovernanceOfficer", this.omasServerURL + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/leadership/governance-officers/{2}/appoint", requestBody, new Object[]{this.serverName, userId, governanceOfficerGUID});
        this.exceptionHandler.detectAndThrowInvalidParameterException("appointGovernanceOfficer", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("appointGovernanceOfficer", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("appointGovernanceOfficer", (FFDCResponseBase)restResult);
    }

    public void relieveGovernanceOfficer(String userId, String governanceOfficerGUID, String profileGUID, Date endDate) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "relieveGovernanceOfficer";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/leadership/governance-officers/{2}/relieve";
        String governanceOfficerGUIDParameterName = "governanceOfficerGUID";
        String profileGUIDParameterName = "profileGUID";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(this.omasServerURL, this.serverName, "relieveGovernanceOfficer");
        this.invalidParameterHandler.validateUserId(userId, "relieveGovernanceOfficer");
        this.invalidParameterHandler.validateGUID(governanceOfficerGUID, "governanceOfficerGUID", "relieveGovernanceOfficer");
        this.invalidParameterHandler.validateGUID(profileGUID, "profileGUID", "relieveGovernanceOfficer");
        AppointmentRequestBody requestBody = new AppointmentRequestBody();
        requestBody.setGUID(profileGUID);
        requestBody.setEffectiveDate(endDate);
        VoidResponse restResult = this.restClient.callVoidPostRESTCall("relieveGovernanceOfficer", this.omasServerURL + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/leadership/governance-officers/{2}/relieve", requestBody, new Object[]{this.serverName, userId, governanceOfficerGUID});
        this.exceptionHandler.detectAndThrowInvalidParameterException("relieveGovernanceOfficer", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("relieveGovernanceOfficer", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("relieveGovernanceOfficer", (FFDCResponseBase)restResult);
    }
}

