/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceprogram.client;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.governanceprogram.api.GovernanceLeadershipInterface;
import org.odpi.openmetadata.accessservices.governanceprogram.client.GovernanceProgramRESTClient;
import org.odpi.openmetadata.accessservices.governanceprogram.client.RESTExceptionHandler;
import org.odpi.openmetadata.accessservices.governanceprogram.ffdc.exceptions.AppointmentIdNotUniqueException;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.ExternalReference;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.GovernanceDomain;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.GovernanceOfficer;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.AppointmentRequestBody;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceDomainRequestBody;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceOfficerDetailsRequestBody;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceOfficerListResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceOfficerResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceOfficerValidatorRequestBody;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceProgramOMASAPIResponse;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponseBase;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;

public class GovernanceProgramLeadership
implements GovernanceLeadershipInterface {
    private String serverName;
    private String serverPlatformURLRoot;
    private GovernanceProgramRESTClient restClient;
    private InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
    private RESTExceptionHandler exceptionHandler = new RESTExceptionHandler();
    private AuditLog auditLog = null;

    public GovernanceProgramLeadership(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        String methodName = "Constructor (no security)";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (no security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new GovernanceProgramRESTClient(serverName, serverPlatformURLRoot);
    }

    public GovernanceProgramLeadership(String serverName, String serverPlatformURLRoot, String userId, String password) throws InvalidParameterException {
        String methodName = "Constructor (with security)";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (with security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new GovernanceProgramRESTClient(serverName, serverPlatformURLRoot, userId, password);
    }

    public GovernanceProgramLeadership(String serverName, String serverPlatformURLRoot, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        String methodName = "Constructor (no security)";
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (no security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new GovernanceProgramRESTClient(serverName, serverPlatformURLRoot);
        this.auditLog = auditLog;
    }

    public GovernanceProgramLeadership(String serverName, String serverPlatformURLRoot, String userId, String password, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        String methodName = "Constructor (with security)";
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (with security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new GovernanceProgramRESTClient(serverName, serverPlatformURLRoot, userId, password);
        this.auditLog = auditLog;
    }

    public String createGovernanceOfficer(String userId, GovernanceDomain governanceDomain, String appointmentId, String appointmentContext, String title, Map<String, String> additionalProperties, List<ExternalReference> externalReferences) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "createGovernanceOfficer";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/leadership/governance-officers";
        String appointmentIdParameterName = "appointmentId";
        String titleParameterName = "title";
        String governanceDomainParameterName = "governanceDomain";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(this.serverPlatformURLRoot, this.serverName, "createGovernanceOfficer");
        this.invalidParameterHandler.validateUserId(userId, "createGovernanceOfficer");
        this.invalidParameterHandler.validateName(appointmentId, "appointmentId", "createGovernanceOfficer");
        this.invalidParameterHandler.validateName(title, "title", "createGovernanceOfficer");
        this.exceptionHandler.validateGovernanceDomain(governanceDomain, "governanceDomain", "createGovernanceOfficer");
        GovernanceOfficerDetailsRequestBody requestBody = new GovernanceOfficerDetailsRequestBody();
        requestBody.setGovernanceDomain(governanceDomain);
        requestBody.setAppointmentId(appointmentId);
        requestBody.setAppointmentContext(appointmentContext);
        requestBody.setTitle(title);
        requestBody.setAdditionalProperties(additionalProperties);
        requestBody.setExternalReferences(externalReferences);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createGovernanceOfficer", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/leadership/governance-officers", requestBody, new Object[]{this.serverName, userId});
        this.exceptionHandler.detectAndThrowInvalidParameterException((FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException((FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException((FFDCResponseBase)restResult);
        return restResult.getGUID();
    }

    public void updateGovernanceOfficer(String userId, String governanceOfficerGUID, GovernanceDomain governanceDomain, String appointmentId, String appointmentContext, String title, Map<String, String> additionalProperties, List<ExternalReference> externalReferences) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "updateGovernanceOfficer";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/leadership/governance-officers/{2}";
        String guidParameterName = "governanceOfficerGUID";
        String appointmentIdParameterName = "appointmentId";
        String titleParameterName = "title";
        String governanceDomainParameterName = "governanceDomain";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(this.serverPlatformURLRoot, this.serverName, "updateGovernanceOfficer");
        this.invalidParameterHandler.validateUserId(userId, "updateGovernanceOfficer");
        this.invalidParameterHandler.validateGUID(governanceOfficerGUID, "governanceOfficerGUID", "updateGovernanceOfficer");
        this.invalidParameterHandler.validateName(appointmentId, "appointmentId", "updateGovernanceOfficer");
        this.invalidParameterHandler.validateName(title, "title", "updateGovernanceOfficer");
        this.exceptionHandler.validateGovernanceDomain(governanceDomain, "governanceDomain", "updateGovernanceOfficer");
        GovernanceOfficerDetailsRequestBody requestBody = new GovernanceOfficerDetailsRequestBody();
        requestBody.setGovernanceDomain(governanceDomain);
        requestBody.setAppointmentId(appointmentId);
        requestBody.setAppointmentContext(appointmentContext);
        requestBody.setTitle(title);
        requestBody.setAdditionalProperties(additionalProperties);
        requestBody.setExternalReferences(externalReferences);
        VoidResponse restResult = this.restClient.callVoidPostRESTCall("updateGovernanceOfficer", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/leadership/governance-officers/{2}", requestBody, new Object[]{this.serverName, userId, governanceOfficerGUID});
        this.exceptionHandler.detectAndThrowInvalidParameterException((FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException((FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException((FFDCResponseBase)restResult);
    }

    public void deleteGovernanceOfficer(String userId, String governanceOfficerGUID, String appointmentId, GovernanceDomain governanceDomain) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "deleteGovernanceOfficer";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/leadership/governance-officers/{2}/delete";
        String guidParameterName = "governanceOfficerGUID";
        String appointmentIdParameterName = "appointmentId";
        String governanceDomainParameterName = "governanceDomain";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(this.serverPlatformURLRoot, this.serverName, "deleteGovernanceOfficer");
        this.invalidParameterHandler.validateGUID(governanceOfficerGUID, "governanceOfficerGUID", "deleteGovernanceOfficer");
        this.invalidParameterHandler.validateUserId(userId, "deleteGovernanceOfficer");
        this.invalidParameterHandler.validateName(appointmentId, "appointmentId", "deleteGovernanceOfficer");
        this.exceptionHandler.validateGovernanceDomain(governanceDomain, "governanceDomain", "deleteGovernanceOfficer");
        GovernanceOfficerValidatorRequestBody requestBody = new GovernanceOfficerValidatorRequestBody();
        requestBody.setGovernanceDomain(governanceDomain);
        requestBody.setAppointmentId(appointmentId);
        VoidResponse restResult = this.restClient.callVoidPostRESTCall("deleteGovernanceOfficer", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/leadership/governance-officers/{2}/delete", requestBody, new Object[]{this.serverName, userId, governanceOfficerGUID});
        this.exceptionHandler.detectAndThrowInvalidParameterException((FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException((FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException((FFDCResponseBase)restResult);
    }

    public GovernanceOfficer getGovernanceOfficerByGUID(String userId, String governanceOfficerGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getGovernanceOfficerByGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/leadership/governance-officers/{2}";
        String guidParameterName = "governanceOfficerGUID";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(this.serverPlatformURLRoot, this.serverName, "getGovernanceOfficerByGUID");
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceOfficerByGUID");
        this.invalidParameterHandler.validateGUID(governanceOfficerGUID, "governanceOfficerGUID", "getGovernanceOfficerByGUID");
        GovernanceOfficerResponse restResult = this.restClient.callGovernanceOfficerGetRESTCall("getGovernanceOfficerByGUID", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/leadership/governance-officers/{2}", this.serverName, userId, governanceOfficerGUID);
        this.exceptionHandler.detectAndThrowInvalidParameterException((FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException((FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException((FFDCResponseBase)restResult);
        return restResult.getGovernanceOfficer();
    }

    public GovernanceOfficer getGovernanceOfficerByAppointmentId(String userId, String appointmentId) throws InvalidParameterException, AppointmentIdNotUniqueException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getGovernanceOfficerByAppointmentId";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/leadership/governance-officers/by-appointment-id/{2}";
        String appointmentIdParameterName = "appointmentId";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(this.serverPlatformURLRoot, this.serverName, "getGovernanceOfficerByAppointmentId");
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceOfficerByAppointmentId");
        this.invalidParameterHandler.validateName(appointmentId, "appointmentId", "getGovernanceOfficerByAppointmentId");
        GovernanceOfficerResponse restResult = this.restClient.callGovernanceOfficerGetRESTCall("getGovernanceOfficerByAppointmentId", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/leadership/governance-officers/by-appointment-id/{2}", this.serverName, userId, appointmentId);
        this.exceptionHandler.detectAndThrowInvalidParameterException((FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowAppointmentIdNotUniqueException("getGovernanceOfficerByAppointmentId", (GovernanceProgramOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException((FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException((FFDCResponseBase)restResult);
        return restResult.getGovernanceOfficer();
    }

    public List<GovernanceOfficer> getGovernanceOfficers(String userId) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getGovernanceOfficers";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/leadership/governance-officers";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(this.serverPlatformURLRoot, this.serverName, "getGovernanceOfficers");
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceOfficers");
        GovernanceOfficerListResponse restResult = this.restClient.callGovernanceOfficerListGetRESTCall("getGovernanceOfficers", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/leadership/governance-officers", this.serverName, userId);
        this.exceptionHandler.detectAndThrowInvalidParameterException((FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException((FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException((FFDCResponseBase)restResult);
        return restResult.getGovernanceOfficers();
    }

    public List<GovernanceOfficer> getActiveGovernanceOfficers(String userId) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getGovernanceOfficers";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/leadership/governance-officers/active";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(this.serverPlatformURLRoot, this.serverName, "getGovernanceOfficers");
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceOfficers");
        GovernanceOfficerListResponse restResult = this.restClient.callGovernanceOfficerListGetRESTCall("getGovernanceOfficers", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/leadership/governance-officers/active", this.serverName, userId);
        this.exceptionHandler.detectAndThrowInvalidParameterException((FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException((FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException((FFDCResponseBase)restResult);
        return restResult.getGovernanceOfficers();
    }

    public List<GovernanceOfficer> getGovernanceOfficersByDomain(String userId, GovernanceDomain governanceDomain) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getGovernanceOfficersByDomain";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/leadership/governance-officers/by-domain";
        String governanceDomainParameterName = "governanceDomain";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(this.serverPlatformURLRoot, this.serverName, "getGovernanceOfficersByDomain");
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceOfficersByDomain");
        this.exceptionHandler.validateGovernanceDomain(governanceDomain, "governanceDomain", "getGovernanceOfficersByDomain");
        GovernanceDomainRequestBody requestBody = new GovernanceDomainRequestBody();
        requestBody.setGovernanceDomain(governanceDomain);
        GovernanceOfficerListResponse restResult = this.restClient.callGovernanceOfficerListPostRESTCall("getGovernanceOfficersByDomain", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/leadership/governance-officers/by-domain", requestBody, this.serverName, userId);
        this.exceptionHandler.detectAndThrowInvalidParameterException((FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException((FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException((FFDCResponseBase)restResult);
        return restResult.getGovernanceOfficers();
    }

    public void appointGovernanceOfficer(String userId, String governanceOfficerGUID, String profileGUID, Date startDate) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "appointGovernanceOfficer";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/leadership/governance-officers/{2}/appoint";
        String governanceOfficerGUIDParameterName = "governanceOfficerGUID";
        String profileGUIDParameterName = "profileGUID";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(this.serverPlatformURLRoot, this.serverName, "appointGovernanceOfficer");
        this.invalidParameterHandler.validateUserId(userId, "appointGovernanceOfficer");
        this.invalidParameterHandler.validateGUID(governanceOfficerGUID, "governanceOfficerGUID", "appointGovernanceOfficer");
        this.invalidParameterHandler.validateGUID(profileGUID, "profileGUID", "appointGovernanceOfficer");
        AppointmentRequestBody requestBody = new AppointmentRequestBody();
        requestBody.setGUID(profileGUID);
        requestBody.setEffectiveDate(startDate);
        VoidResponse restResult = this.restClient.callVoidPostRESTCall("appointGovernanceOfficer", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/leadership/governance-officers/{2}/appoint", requestBody, new Object[]{this.serverName, userId, governanceOfficerGUID});
        this.exceptionHandler.detectAndThrowInvalidParameterException((FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException((FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException((FFDCResponseBase)restResult);
    }

    public void relieveGovernanceOfficer(String userId, String governanceOfficerGUID, String profileGUID, Date endDate) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "relieveGovernanceOfficer";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/leadership/governance-officers/{2}/relieve";
        String governanceOfficerGUIDParameterName = "governanceOfficerGUID";
        String profileGUIDParameterName = "profileGUID";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(this.serverPlatformURLRoot, this.serverName, "relieveGovernanceOfficer");
        this.invalidParameterHandler.validateUserId(userId, "relieveGovernanceOfficer");
        this.invalidParameterHandler.validateGUID(governanceOfficerGUID, "governanceOfficerGUID", "relieveGovernanceOfficer");
        this.invalidParameterHandler.validateGUID(profileGUID, "profileGUID", "relieveGovernanceOfficer");
        AppointmentRequestBody requestBody = new AppointmentRequestBody();
        requestBody.setGUID(profileGUID);
        requestBody.setEffectiveDate(endDate);
        VoidResponse restResult = this.restClient.callVoidPostRESTCall("relieveGovernanceOfficer", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/leadership/governance-officers/{2}/relieve", requestBody, new Object[]{this.serverName, userId, governanceOfficerGUID});
        this.exceptionHandler.detectAndThrowInvalidParameterException((FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException((FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException((FFDCResponseBase)restResult);
    }
}

