/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceprogram.client;

import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.governanceprogram.api.GovernanceZoneManagerInterface;
import org.odpi.openmetadata.accessservices.governanceprogram.client.GovernanceProgramRESTClient;
import org.odpi.openmetadata.accessservices.governanceprogram.metadataelements.GovernanceZoneElement;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.GovernanceZoneProperties;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.ZoneListResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.ZoneResponse;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;

public class GovernanceZoneManager
implements GovernanceZoneManagerInterface {
    private String serverName;
    private String serverPlatformURLRoot;
    private GovernanceProgramRESTClient restClient;
    private InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
    private AuditLog auditLog = null;

    public GovernanceZoneManager(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        String methodName = "Constructor (no security)";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (no security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new GovernanceProgramRESTClient(serverName, serverPlatformURLRoot);
    }

    public GovernanceZoneManager(String serverName, String serverPlatformURLRoot, String userId, String password) throws InvalidParameterException {
        String methodName = "Constructor (with security)";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (with security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new GovernanceProgramRESTClient(serverName, serverPlatformURLRoot, userId, password);
    }

    public GovernanceZoneManager(String serverName, String serverPlatformURLRoot, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        String methodName = "Constructor (no security)";
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (no security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new GovernanceProgramRESTClient(serverName, serverPlatformURLRoot);
        this.auditLog = auditLog;
    }

    public GovernanceZoneManager(String serverName, String serverPlatformURLRoot, String userId, String password, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        String methodName = "Constructor (with security)";
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (with security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new GovernanceProgramRESTClient(serverName, serverPlatformURLRoot, userId, password);
        this.auditLog = auditLog;
    }

    public void createGovernanceZone(String userId, String qualifiedName, String displayName, String description, String criteria, String scope, int domainIdentifier, Map<String, String> additionalProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createGovernanceZone";
        String qualifiedNameParameter = "qualifiedName";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-zone-manager/governance-zones";
        this.invalidParameterHandler.validateUserId(userId, "createGovernanceZone");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "createGovernanceZone");
        GovernanceZoneProperties requestBody = new GovernanceZoneProperties();
        requestBody.setQualifiedName(qualifiedName);
        requestBody.setDisplayName(displayName);
        requestBody.setDescription(description);
        requestBody.setCriteria(criteria);
        requestBody.setScope(scope);
        requestBody.setDomainIdentifier(domainIdentifier);
        requestBody.setAdditionalProperties(additionalProperties);
        this.restClient.callVoidPostRESTCall("createGovernanceZone", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-zone-manager/governance-zones", requestBody, new Object[]{this.serverName, userId});
    }

    public GovernanceZoneElement getGovernanceZone(String userId, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernanceZone";
        String qualifiedNameParameter = "qualifiedName";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-zone-manager/governance-zones/name/{2}";
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceZone");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "getGovernanceZone");
        ZoneResponse restResult = this.restClient.callZoneGetRESTCall("getGovernanceZone", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-zone-manager/governance-zones/name/{2}", this.serverName, userId, qualifiedName);
        return restResult.getGovernanceZone();
    }

    public List<GovernanceZoneElement> getGovernanceZones(String userId, int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernanceZones";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-zone-manager/governance-zones?startingFrom={4}&maximumResults={5}";
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceZones");
        ZoneListResponse restResult = this.restClient.callZoneListGetRESTCall("getGovernanceZones", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-zone-manager/governance-zones?startingFrom={4}&maximumResults={5}", this.serverName, userId, Integer.toString(startingFrom), Integer.toString(maximumResults));
        return restResult.getGovernanceZones();
    }
}

