/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceprogram.client;

import java.util.List;
import org.odpi.openmetadata.accessservices.governanceprogram.api.GovernanceClassificationLevelInterface;
import org.odpi.openmetadata.accessservices.governanceprogram.client.rest.GovernanceProgramRESTClient;
import org.odpi.openmetadata.accessservices.governanceprogram.metadataelements.GovernanceLevelIdentifierElement;
import org.odpi.openmetadata.accessservices.governanceprogram.metadataelements.GovernanceLevelIdentifierSetElement;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.GovernanceLevelIdentifierProperties;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.GovernanceLevelIdentifierSetProperties;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceLevelIdentifierResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceLevelIdentifierSetListResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceLevelIdentifierSetResponse;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;

public class GovernanceClassificationLevelManager
implements GovernanceClassificationLevelInterface {
    private String serverName;
    private String serverPlatformURLRoot;
    private GovernanceProgramRESTClient restClient;
    private InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
    private NullRequestBody nullRequestBody = new NullRequestBody();

    public GovernanceClassificationLevelManager(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        String methodName = "Constructor (no security)";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (no security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new GovernanceProgramRESTClient(serverName, serverPlatformURLRoot);
    }

    public GovernanceClassificationLevelManager(String serverName, String serverPlatformURLRoot, String userId, String password) throws InvalidParameterException {
        String methodName = "Constructor (with security)";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (with security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new GovernanceProgramRESTClient(serverName, serverPlatformURLRoot, userId, password);
    }

    public GovernanceClassificationLevelManager(String serverName, String serverPlatformURLRoot, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        String methodName = "Constructor (no security)";
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (no security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new GovernanceProgramRESTClient(serverName, serverPlatformURLRoot, auditLog);
    }

    public GovernanceClassificationLevelManager(String serverName, String serverPlatformURLRoot, String userId, String password, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        String methodName = "Constructor (with security)";
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (with security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new GovernanceProgramRESTClient(serverName, serverPlatformURLRoot, userId, password, auditLog);
    }

    public GovernanceClassificationLevelManager(String serverName, String serverPlatformURLRoot, GovernanceProgramRESTClient restClient, int maxPageSize) throws InvalidParameterException {
        String methodName = "Constructor (with security)";
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (with security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = restClient;
    }

    public String createStandardGovernanceClassificationLevels(String userId, String classificationName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createStandardGovernanceClassificationLevels";
        String classificationNameParameter = "classificationName";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/classification-level-sets/standard-set/{2}";
        this.invalidParameterHandler.validateUserId(userId, "createStandardGovernanceClassificationLevels");
        this.invalidParameterHandler.validateName(classificationName, "classificationName", "createStandardGovernanceClassificationLevels");
        GUIDResponse response = this.restClient.callGUIDPostRESTCall("createStandardGovernanceClassificationLevels", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/classification-level-sets/standard-set/{2}", this.nullRequestBody, new Object[]{this.serverName, userId, classificationName});
        return response.getGUID();
    }

    public String createGovernanceLevelIdentifierSet(String userId, GovernanceLevelIdentifierSetProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createGovernanceLevelIdentifierSet";
        String classificationNameParameter = "classificationName";
        String identifierPropertyNameParameter = "identifierPropertyName";
        String propertiesParameter = "properties";
        String qualifiedNameParameter = "qualifiedName";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/classification-level-sets";
        this.invalidParameterHandler.validateUserId(userId, "createGovernanceLevelIdentifierSet");
        this.invalidParameterHandler.validateObject((Object)properties, "properties", "createGovernanceLevelIdentifierSet");
        this.invalidParameterHandler.validateName(properties.getQualifiedName(), "qualifiedName", "createGovernanceLevelIdentifierSet");
        this.invalidParameterHandler.validateName(properties.getClassificationName(), "classificationName", "createGovernanceLevelIdentifierSet");
        this.invalidParameterHandler.validateName(properties.getIdentifierPropertyName(), "identifierPropertyName", "createGovernanceLevelIdentifierSet");
        GUIDResponse response = this.restClient.callGUIDPostRESTCall("createGovernanceLevelIdentifierSet", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/classification-level-sets", properties, new Object[]{this.serverName, userId});
        return response.getGUID();
    }

    public void updateGovernanceLevelIdentifierSet(String userId, String setGUID, GovernanceLevelIdentifierSetProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateGovernanceLevelIdentifierSet";
        String classificationNameParameter = "classificationName";
        String identifierPropertyNameParameter = "identifierPropertyName";
        String guidParameter = "setGUID";
        String propertiesParameter = "properties";
        String qualifiedNameParameter = "qualifiedName";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/classification-level-sets/{2}/update";
        this.invalidParameterHandler.validateUserId(userId, "updateGovernanceLevelIdentifierSet");
        this.invalidParameterHandler.validateGUID(setGUID, "setGUID", "updateGovernanceLevelIdentifierSet");
        this.invalidParameterHandler.validateObject((Object)properties, "properties", "updateGovernanceLevelIdentifierSet");
        this.invalidParameterHandler.validateName(properties.getQualifiedName(), "qualifiedName", "updateGovernanceLevelIdentifierSet");
        this.invalidParameterHandler.validateName(properties.getClassificationName(), "classificationName", "updateGovernanceLevelIdentifierSet");
        this.invalidParameterHandler.validateName(properties.getIdentifierPropertyName(), "identifierPropertyName", "updateGovernanceLevelIdentifierSet");
        this.restClient.callVoidPostRESTCall("updateGovernanceLevelIdentifierSet", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/classification-level-sets/{2}/update", properties, new Object[]{this.serverName, userId, setGUID});
    }

    public void removeGovernanceLevelIdentifierSet(String userId, String setGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeGovernanceLevelIdentifierSet";
        String guidParameter = "setGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/classification-level-sets/{2}/delete";
        this.invalidParameterHandler.validateUserId(userId, "removeGovernanceLevelIdentifierSet");
        this.invalidParameterHandler.validateGUID(setGUID, "setGUID", "removeGovernanceLevelIdentifierSet");
        this.restClient.callVoidPostRESTCall("removeGovernanceLevelIdentifierSet", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/classification-level-sets/{2}/delete", this.nullRequestBody, new Object[]{this.serverName, userId, setGUID});
    }

    public List<GovernanceLevelIdentifierSetElement> getGovernanceLevelIdentifierSets(String userId) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernanceLevelIdentifierSets";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/classification-level-sets";
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceLevelIdentifierSets");
        GovernanceLevelIdentifierSetListResponse restResult = this.restClient.callLevelIdentifierSetListGetRESTCall("getGovernanceLevelIdentifierSets", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/classification-level-sets", this.serverName, userId);
        return restResult.getElements();
    }

    public GovernanceLevelIdentifierSetElement getGovernanceLevelIdentifierSet(String userId, String classificationName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernanceLevelIdentifierSet";
        String classificationNameParameter = "classificationName";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/classification-level-sets/classification-name/{2}";
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceLevelIdentifierSet");
        this.invalidParameterHandler.validateName(classificationName, "classificationName", "getGovernanceLevelIdentifierSet");
        GovernanceLevelIdentifierSetResponse restResult = this.restClient.callLevelIdentifierSetGetRESTCall("getGovernanceLevelIdentifierSet", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/classification-level-sets/classification-name/{2}", this.serverName, userId, classificationName);
        return restResult.getElement();
    }

    public GovernanceLevelIdentifierSetElement getGovernanceLevelIdentifierSetByGUID(String userId, String setGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernanceLevelIdentifierSet";
        String guidParameter = "setGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/classification-level-sets/{2}";
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceLevelIdentifierSet");
        this.invalidParameterHandler.validateGUID(setGUID, "setGUID", "getGovernanceLevelIdentifierSet");
        GovernanceLevelIdentifierSetResponse restResult = this.restClient.callLevelIdentifierSetGetRESTCall("getGovernanceLevelIdentifierSet", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/classification-level-sets/{2}", this.serverName, userId, setGUID);
        return restResult.getElement();
    }

    public String createGovernanceLevelIdentifier(String userId, String setGUID, GovernanceLevelIdentifierProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createGovernanceLevelIdentifier";
        String guidParameter = "setGUID";
        String qualifiedNameParameter = "qualifiedName";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/classification-level-sets/{2}/identifier";
        this.invalidParameterHandler.validateUserId(userId, "createGovernanceLevelIdentifier");
        this.invalidParameterHandler.validateGUID(setGUID, "setGUID", "createGovernanceLevelIdentifier");
        this.invalidParameterHandler.validateObject((Object)properties, "qualifiedName", "createGovernanceLevelIdentifier");
        this.invalidParameterHandler.validateName(properties.getQualifiedName(), "qualifiedName", "createGovernanceLevelIdentifier");
        GUIDResponse response = this.restClient.callGUIDPostRESTCall("createGovernanceLevelIdentifier", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/classification-level-sets/{2}/identifier", properties, new Object[]{this.serverName, userId, setGUID});
        return response.getGUID();
    }

    public void updateGovernanceLevelIdentifier(String userId, String identifierGUID, GovernanceLevelIdentifierProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateGovernanceLevelIdentifier";
        String guidParameter = "identifierGUID";
        String qualifiedNameParameter = "qualifiedName";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/classification-level-sets/identifier/{2}/update";
        this.invalidParameterHandler.validateUserId(userId, "updateGovernanceLevelIdentifier");
        this.invalidParameterHandler.validateGUID(identifierGUID, "identifierGUID", "updateGovernanceLevelIdentifier");
        this.invalidParameterHandler.validateObject((Object)properties, "qualifiedName", "updateGovernanceLevelIdentifier");
        this.invalidParameterHandler.validateName(properties.getQualifiedName(), "qualifiedName", "updateGovernanceLevelIdentifier");
        this.restClient.callVoidPostRESTCall("updateGovernanceLevelIdentifier", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/classification-level-sets/identifier/{2}/update", properties, new Object[]{this.serverName, userId, identifierGUID});
    }

    public void removeGovernanceLevelIdentifier(String userId, String identifierGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeGovernanceLevelIdentifier";
        String guidParameter = "identifierGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/classification-level-sets/identifier/{2}/delete";
        this.invalidParameterHandler.validateUserId(userId, "removeGovernanceLevelIdentifier");
        this.invalidParameterHandler.validateGUID(identifierGUID, "identifierGUID", "removeGovernanceLevelIdentifier");
        this.restClient.callVoidPostRESTCall("removeGovernanceLevelIdentifier", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/classification-level-sets/identifier/{2}/delete", this.nullRequestBody, new Object[]{this.serverName, userId, identifierGUID});
    }

    public GovernanceLevelIdentifierElement getGovernanceLevelIdentifier(String userId, String classificationName, int levelIdentifier) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernanceLevelIdentifier";
        String classificationNameParameter = "classificationName";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/classification-level-sets/classification-name/{2}/identifier/{3}";
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceLevelIdentifier");
        this.invalidParameterHandler.validateName(classificationName, "classificationName", "getGovernanceLevelIdentifier");
        GovernanceLevelIdentifierResponse restResult = this.restClient.callLevelIdentifierGetRESTCall("getGovernanceLevelIdentifier", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/classification-level-sets/classification-name/{2}/identifier/{3}", this.serverName, userId, classificationName, levelIdentifier);
        return restResult.getElement();
    }
}

