/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceprogram.client;

import java.util.List;
import org.odpi.openmetadata.accessservices.governanceprogram.api.CertificationManagementInterface;
import org.odpi.openmetadata.accessservices.governanceprogram.client.rest.GovernanceProgramRESTClient;
import org.odpi.openmetadata.accessservices.governanceprogram.metadataelements.CertificationTypeElement;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.CertificationProperties;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.CertificationTypeProperties;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.CertificateIdRequestBody;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.CertificationTypeListResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.CertificationTypeResponse;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;

public class CertificationManager
implements CertificationManagementInterface {
    private String serverName;
    private String serverPlatformURLRoot;
    private GovernanceProgramRESTClient restClient;
    private InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
    private NullRequestBody nullRequestBody = new NullRequestBody();

    public CertificationManager(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        String methodName = "Constructor (no security)";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (no security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new GovernanceProgramRESTClient(serverName, serverPlatformURLRoot);
    }

    public CertificationManager(String serverName, String serverPlatformURLRoot, String userId, String password) throws InvalidParameterException {
        String methodName = "Constructor (with security)";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (with security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new GovernanceProgramRESTClient(serverName, serverPlatformURLRoot, userId, password);
    }

    public CertificationManager(String serverName, String serverPlatformURLRoot, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        String methodName = "Constructor (no security)";
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (no security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new GovernanceProgramRESTClient(serverName, serverPlatformURLRoot, auditLog);
    }

    public CertificationManager(String serverName, String serverPlatformURLRoot, String userId, String password, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        String methodName = "Constructor (with security)";
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (with security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new GovernanceProgramRESTClient(serverName, serverPlatformURLRoot, userId, password, auditLog);
    }

    public CertificationManager(String serverName, String serverPlatformURLRoot, GovernanceProgramRESTClient restClient, int maxPageSize) throws InvalidParameterException {
        String methodName = "Constructor (with security)";
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (with security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = restClient;
    }

    public String createCertificationType(String userId, CertificationTypeProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createCertificationType";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/certification-types";
        String docIdParameterName = "documentIdentifier";
        String titleParameterName = "title";
        String propertiesParameterName = "properties";
        this.invalidParameterHandler.validateUserId(userId, "createCertificationType");
        this.invalidParameterHandler.validateObject((Object)properties, "properties", "createCertificationType");
        this.invalidParameterHandler.validateName(properties.getDocumentIdentifier(), "documentIdentifier", "createCertificationType");
        this.invalidParameterHandler.validateName(properties.getTitle(), "title", "createCertificationType");
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createCertificationType", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/certification-types", properties, new Object[]{this.serverName, userId});
        return restResult.getGUID();
    }

    public void updateCertificationType(String userId, String certificationTypeGUID, boolean isMergeUpdate, CertificationTypeProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateCertificationType";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/certification-types/{2}/update?isMergeUpdate={3}";
        String guidParameterName = "certificationTypeGUID";
        String docIdParameterName = "documentIdentifier";
        String titleParameterName = "title";
        String propertiesParameterName = "properties";
        this.invalidParameterHandler.validateUserId(userId, "updateCertificationType");
        this.invalidParameterHandler.validateGUID(certificationTypeGUID, "certificationTypeGUID", "updateCertificationType");
        this.invalidParameterHandler.validateObject((Object)properties, "properties", "updateCertificationType");
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(properties.getDocumentIdentifier(), "documentIdentifier", "updateCertificationType");
            this.invalidParameterHandler.validateName(properties.getTitle(), "title", "updateCertificationType");
        }
        this.restClient.callVoidPostRESTCall("updateCertificationType", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/certification-types/{2}/update?isMergeUpdate={3}", properties, new Object[]{this.serverName, userId, certificationTypeGUID, isMergeUpdate});
    }

    public void deleteCertificationType(String userId, String certificationTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "deleteCertificationType";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/certification-types/{2}/delete";
        String guidParameterName = "certificationTypeGUID";
        this.invalidParameterHandler.validateGUID(certificationTypeGUID, "certificationTypeGUID", "deleteCertificationType");
        this.invalidParameterHandler.validateUserId(userId, "deleteCertificationType");
        this.restClient.callVoidPostRESTCall("deleteCertificationType", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/certification-types/{2}/delete", this.nullRequestBody, new Object[]{this.serverName, userId, certificationTypeGUID});
    }

    public CertificationTypeElement getCertificationTypeByGUID(String userId, String certificationTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getCertificationTypeByGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/certification-types/{2}";
        String guidParameterName = "certificationTypeGUID";
        this.invalidParameterHandler.validateUserId(userId, "getCertificationTypeByGUID");
        this.invalidParameterHandler.validateGUID(certificationTypeGUID, "certificationTypeGUID", "getCertificationTypeByGUID");
        CertificationTypeResponse restResult = this.restClient.callCertificationTypeGetRESTCall("getCertificationTypeByGUID", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/certification-types/{2}", this.serverName, userId, certificationTypeGUID);
        return restResult.getElement();
    }

    public CertificationTypeElement getCertificationTypeByDocId(String userId, String documentIdentifier) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getCertificationTypeByDocId";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/certification-types/by-document-id/{2}";
        String documentIdParameterName = "documentId";
        this.invalidParameterHandler.validateUserId(userId, "getCertificationTypeByDocId");
        this.invalidParameterHandler.validateName(documentIdentifier, "documentId", "getCertificationTypeByDocId");
        CertificationTypeResponse restResult = this.restClient.callCertificationTypeGetRESTCall("getCertificationTypeByDocId", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/certification-types/by-document-id/{2}", this.serverName, userId, documentIdentifier);
        return restResult.getElement();
    }

    public List<CertificationTypeElement> getCertificationTypesByTitle(String userId, String title, int startFrom, int pageSize) throws UserNotAuthorizedException, InvalidParameterException, PropertyServerException {
        String methodName = "getCertificationTypesByTitle";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/certification-types/by-title?startFrom={2}&pageSize={3}";
        String titleParameterName = "title";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(this.serverPlatformURLRoot, this.serverName, "getCertificationTypesByTitle");
        this.invalidParameterHandler.validateUserId(userId, "getCertificationTypesByTitle");
        this.invalidParameterHandler.validateSearchString(title, "title", "getCertificationTypesByTitle");
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getCertificationTypesByTitle");
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setSearchString(title);
        requestBody.setSearchStringParameterName("title");
        CertificationTypeListResponse restResult = this.restClient.callCertificationTypeListPostRESTCall("getCertificationTypesByTitle", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/certification-types/by-title?startFrom={2}&pageSize={3}", requestBody, this.serverName, userId, startFrom, queryPageSize);
        return restResult.getElements();
    }

    public List<CertificationTypeElement> getCertificationTypeByDomainId(String userId, int domainIdentifier, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getCertificationTypeByDomainId";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/certification-types/by-domain/{2}?startFrom={3}&pageSize={4}";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(this.serverPlatformURLRoot, this.serverName, "getCertificationTypeByDomainId");
        this.invalidParameterHandler.validateUserId(userId, "getCertificationTypeByDomainId");
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getCertificationTypeByDomainId");
        CertificationTypeListResponse restResult = this.restClient.callCertificationTypeListGetRESTCall("getCertificationTypeByDomainId", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/certification-types/by-domain/{2}?startFrom={3}&pageSize={4}", this.serverName, userId, domainIdentifier, startFrom, queryPageSize);
        return restResult.getElements();
    }

    public void certifyElement(String userId, String elementGUID, String certificationTypeGUID, CertificationProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "certifyElement";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/certification-types/{2}/elements/{3}/certify";
        String elementGUIDParameterName = "elementGUID";
        String certificationTypeGUIDParameterName = "certificationTypeGUID";
        this.invalidParameterHandler.validateUserId(userId, "certifyElement");
        this.invalidParameterHandler.validateGUID(elementGUID, "elementGUID", "certifyElement");
        this.invalidParameterHandler.validateGUID(certificationTypeGUID, "certificationTypeGUID", "certifyElement");
        this.restClient.callVoidPostRESTCall("certifyElement", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/certification-types/{2}/elements/{3}/certify", properties, new Object[]{this.serverName, userId, certificationTypeGUID, elementGUID});
    }

    public void updateCertification(String userId, String elementGUID, String certificationTypeGUID, boolean isMergeUpdate, CertificationProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateCertification";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/certification-types/{2}/elements/{3}/update?isMergeUpdate={4}";
        String elementGUIDParameterName = "elementGUID";
        String certificationTypeGUIDParameterName = "certificationTypeGUID";
        this.invalidParameterHandler.validateUserId(userId, "updateCertification");
        this.invalidParameterHandler.validateGUID(elementGUID, "elementGUID", "updateCertification");
        this.invalidParameterHandler.validateGUID(certificationTypeGUID, "certificationTypeGUID", "updateCertification");
        this.restClient.callVoidPostRESTCall("updateCertification", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/certification-types/{2}/elements/{3}/update?isMergeUpdate={4}", properties, new Object[]{this.serverName, userId, certificationTypeGUID, elementGUID, isMergeUpdate});
    }

    public void decertifyElement(String userId, String elementGUID, String certificationTypeGUID, String certificateId) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "decertifyElement";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/certification-types/{2}/elements/{3}/decertify";
        String elementGUIDParameterName = "elementGUID";
        String certificationTypeGUIDParameterName = "certificationTypeGUID";
        this.invalidParameterHandler.validateUserId(userId, "decertifyElement");
        this.invalidParameterHandler.validateGUID(elementGUID, "elementGUID", "decertifyElement");
        this.invalidParameterHandler.validateGUID(certificationTypeGUID, "certificationTypeGUID", "decertifyElement");
        CertificateIdRequestBody requestBody = new CertificateIdRequestBody();
        requestBody.setCertificateId(certificateId);
        this.restClient.callVoidPostRESTCall("decertifyElement", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/certification-types/{2}/elements/{3}/decertify", requestBody, new Object[]{this.serverName, userId, certificationTypeGUID, elementGUID});
    }
}

