/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceprogram.client;

import java.util.List;
import org.odpi.openmetadata.accessservices.governanceprogram.api.GovernanceZonesInterface;
import org.odpi.openmetadata.accessservices.governanceprogram.client.rest.GovernanceProgramRESTClient;
import org.odpi.openmetadata.accessservices.governanceprogram.metadataelements.GovernanceZoneDefinition;
import org.odpi.openmetadata.accessservices.governanceprogram.metadataelements.GovernanceZoneElement;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.GovernanceZoneProperties;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceZoneDefinitionResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceZoneListResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceZoneResponse;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;

public class GovernanceZoneManager
implements GovernanceZonesInterface {
    private String serverName;
    private String serverPlatformURLRoot;
    private GovernanceProgramRESTClient restClient;
    private InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
    private NullRequestBody nullRequestBody = new NullRequestBody();

    public GovernanceZoneManager(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        String methodName = "Constructor (no security)";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (no security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new GovernanceProgramRESTClient(serverName, serverPlatformURLRoot);
    }

    public GovernanceZoneManager(String serverName, String serverPlatformURLRoot, String userId, String password) throws InvalidParameterException {
        String methodName = "Constructor (with security)";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (with security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new GovernanceProgramRESTClient(serverName, serverPlatformURLRoot, userId, password);
    }

    public GovernanceZoneManager(String serverName, String serverPlatformURLRoot, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        String methodName = "Constructor (no security)";
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (no security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new GovernanceProgramRESTClient(serverName, serverPlatformURLRoot, auditLog);
    }

    public GovernanceZoneManager(String serverName, String serverPlatformURLRoot, String userId, String password, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        String methodName = "Constructor (with security)";
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (with security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new GovernanceProgramRESTClient(serverName, serverPlatformURLRoot, userId, password, auditLog);
    }

    public GovernanceZoneManager(String serverName, String serverPlatformURLRoot, GovernanceProgramRESTClient restClient, int maxPageSize) throws InvalidParameterException {
        String methodName = "Constructor (with security)";
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (with security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = restClient;
    }

    public String createGovernanceZone(String userId, GovernanceZoneProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createGovernanceZone";
        String propertiesParameter = "properties";
        String qualifiedNameParameter = "qualifiedName";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-zones";
        this.invalidParameterHandler.validateUserId(userId, "createGovernanceZone");
        this.invalidParameterHandler.validateObject((Object)properties, "properties", "createGovernanceZone");
        this.invalidParameterHandler.validateName(properties.getQualifiedName(), "qualifiedName", "createGovernanceZone");
        GUIDResponse response = this.restClient.callGUIDPostRESTCall("createGovernanceZone", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-zones", properties, new Object[]{this.serverName, userId});
        return response.getGUID();
    }

    public void updateGovernanceZone(String userId, String zoneGUID, boolean isMergeUpdate, GovernanceZoneProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateGovernanceZone";
        String guidParameter = "zoneGUID";
        String qualifiedNameParameter = "qualifiedName";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-zones/{2}?isMergeUpdate={3}";
        this.invalidParameterHandler.validateUserId(userId, "updateGovernanceZone");
        this.invalidParameterHandler.validateGUID(zoneGUID, "zoneGUID", "updateGovernanceZone");
        this.invalidParameterHandler.validateObject((Object)properties, "qualifiedName", "updateGovernanceZone");
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(properties.getQualifiedName(), "qualifiedName", "updateGovernanceZone");
        }
        this.restClient.callVoidPostRESTCall("updateGovernanceZone", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-zones/{2}?isMergeUpdate={3}", properties, new Object[]{this.serverName, userId, zoneGUID, isMergeUpdate});
    }

    public void deleteGovernanceZone(String userId, String zoneGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "deleteGovernanceZone";
        String guidParameter = "zoneGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-zones/{2}/delete}";
        this.invalidParameterHandler.validateUserId(userId, "deleteGovernanceZone");
        this.invalidParameterHandler.validateGUID(zoneGUID, "zoneGUID", "deleteGovernanceZone");
        this.restClient.callVoidPostRESTCall("deleteGovernanceZone", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-zones/{2}/delete}", this.nullRequestBody, new Object[]{this.serverName, userId, zoneGUID});
    }

    public void linkZonesInHierarchy(String userId, String parentZoneGUID, String childZoneGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "linkZonesInHierarchy";
        String parentZoneGUIDParameterName = "parentZoneGUID";
        String childZoneGUIDParameterName = "childZoneGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-zones/{2}/nested-zone/{3}/link";
        this.invalidParameterHandler.validateUserId(userId, "linkZonesInHierarchy");
        this.invalidParameterHandler.validateGUID(parentZoneGUID, "parentZoneGUID", "linkZonesInHierarchy");
        this.invalidParameterHandler.validateGUID(childZoneGUID, "childZoneGUID", "linkZonesInHierarchy");
        this.restClient.callVoidPostRESTCall("linkZonesInHierarchy", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-zones/{2}/nested-zone/{3}/link", this.nullRequestBody, new Object[]{this.serverName, userId, parentZoneGUID, childZoneGUID});
    }

    public void unlinkZonesInHierarchy(String userId, String parentZoneGUID, String childZoneGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "unlinkZonesInHierarchy";
        String parentZoneGUIDParameterName = "parentZoneGUID";
        String childZoneGUIDParameterName = "childZoneGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-zones/{2}/nested-zone/{3}/unlink";
        this.invalidParameterHandler.validateUserId(userId, "unlinkZonesInHierarchy");
        this.invalidParameterHandler.validateGUID(parentZoneGUID, "parentZoneGUID", "unlinkZonesInHierarchy");
        this.invalidParameterHandler.validateGUID(childZoneGUID, "childZoneGUID", "unlinkZonesInHierarchy");
        this.restClient.callVoidPostRESTCall("unlinkZonesInHierarchy", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-zones/{2}/nested-zone/{3}/unlink", this.nullRequestBody, new Object[]{this.serverName, userId, parentZoneGUID, childZoneGUID});
    }

    public void linkZoneToGovernanceDefinition(String userId, String zoneGUID, String definitionGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "linkZoneToGovernanceDefinition";
        String zoneGUIDParameterName = "zoneGUID";
        String definitionGUIDParameterName = "definitionGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-zones/{2}/governed-by/{3}/link";
        this.invalidParameterHandler.validateUserId(userId, "linkZoneToGovernanceDefinition");
        this.invalidParameterHandler.validateGUID(zoneGUID, "zoneGUID", "linkZoneToGovernanceDefinition");
        this.invalidParameterHandler.validateGUID(definitionGUID, "definitionGUID", "linkZoneToGovernanceDefinition");
        this.restClient.callVoidPostRESTCall("linkZoneToGovernanceDefinition", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-zones/{2}/governed-by/{3}/link", this.nullRequestBody, new Object[]{this.serverName, userId, zoneGUID, definitionGUID});
    }

    public void unlinkZoneFromGovernanceDefinition(String userId, String zoneGUID, String definitionGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "unlinkZoneToGovernanceDefinition";
        String zoneGUIDParameterName = "zoneGUID";
        String definitionGUIDParameterName = "definitionGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-zones/{2}/governed-by/{3}/unlink";
        this.invalidParameterHandler.validateUserId(userId, "unlinkZoneToGovernanceDefinition");
        this.invalidParameterHandler.validateGUID(zoneGUID, "zoneGUID", "unlinkZoneToGovernanceDefinition");
        this.invalidParameterHandler.validateGUID(definitionGUID, "definitionGUID", "unlinkZoneToGovernanceDefinition");
        this.restClient.callVoidPostRESTCall("unlinkZoneToGovernanceDefinition", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-zones/{2}/governed-by/{3}/unlink", this.nullRequestBody, new Object[]{this.serverName, userId, zoneGUID, definitionGUID});
    }

    public GovernanceZoneElement getGovernanceZoneByGUID(String userId, String zoneGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernanceZoneByGUID";
        String guidParameter = "zoneGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-zones/{2}";
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceZoneByGUID");
        this.invalidParameterHandler.validateGUID(zoneGUID, "zoneGUID", "getGovernanceZoneByGUID");
        GovernanceZoneResponse restResult = this.restClient.callGovernanceZoneGetRESTCall("getGovernanceZoneByGUID", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-zones/{2}", this.serverName, userId, zoneGUID);
        return restResult.getElement();
    }

    public GovernanceZoneElement getGovernanceZoneByName(String userId, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernanceZoneByName";
        String qualifiedNameParameter = "qualifiedName";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-zones/name/{2}";
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceZoneByName");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "getGovernanceZoneByName");
        GovernanceZoneResponse restResult = this.restClient.callGovernanceZoneGetRESTCall("getGovernanceZoneByName", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-zones/name/{2}", this.serverName, userId, qualifiedName);
        return restResult.getElement();
    }

    public List<GovernanceZoneElement> getGovernanceZonesForDomain(String userId, int domainIdentifier, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernanceZonesForDomain";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-zones/for-domain?domainIdentifier={2}&startFrom={3}&pageSize={4}";
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceZonesForDomain");
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getGovernanceZonesForDomain");
        GovernanceZoneListResponse restResult = this.restClient.callGovernanceZoneListGetRESTCall("getGovernanceZonesForDomain", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-zones/for-domain?domainIdentifier={2}&startFrom={3}&pageSize={4}", this.serverName, userId, domainIdentifier, startFrom, queryPageSize);
        return restResult.getElementList();
    }

    public GovernanceZoneDefinition getGovernanceZoneDefinitionByGUID(String userId, String zoneGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernanceZoneDefinitionByGUID";
        String guidParameter = "zoneGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-zones/{2}/with-definitions";
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceZoneDefinitionByGUID");
        this.invalidParameterHandler.validateGUID(zoneGUID, "zoneGUID", "getGovernanceZoneDefinitionByGUID");
        GovernanceZoneDefinitionResponse restResult = this.restClient.callGovernanceZoneDefinitionGetRESTCall("getGovernanceZoneDefinitionByGUID", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-zones/{2}/with-definitions", this.serverName, userId, zoneGUID);
        return restResult.getProperties();
    }
}

