/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceprogram.client;

import org.odpi.openmetadata.accessservices.governanceprogram.client.rest.GovernanceProgramRESTClient;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.client.ConnectedAssetClientBase;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.client.OCFRESTClient;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectionCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetUniverse;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;

public class ConnectedAssetClient
extends ConnectedAssetClientBase {
    private final GovernanceProgramRESTClient restClient;
    private static final String serviceURLName = "governance-program";

    public ConnectedAssetClient(String serverName, String serverPlatformURLRoot, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, auditLog);
        this.restClient = new GovernanceProgramRESTClient(serverName, serverPlatformURLRoot, auditLog);
    }

    public ConnectedAssetClient(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot);
        this.restClient = new GovernanceProgramRESTClient(serverName, serverPlatformURLRoot);
    }

    public ConnectedAssetClient(String serverName, String serverPlatformURLRoot, String userId, String password, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, auditLog);
        this.restClient = new GovernanceProgramRESTClient(serverName, serverPlatformURLRoot, userId, password, auditLog);
    }

    public ConnectedAssetClient(String serverName, String serverPlatformURLRoot, String userId, String password) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot);
        this.restClient = new GovernanceProgramRESTClient(serverName, serverPlatformURLRoot, userId, password);
    }

    public ConnectedAssetClient(String serverName, String serverPlatformURLRoot, GovernanceProgramRESTClient restClient, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, auditLog);
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.restClient = restClient;
    }

    public String getAssetForConnection(String userId, String connectionGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getAssetForConnection";
        String guidParameter = "connectionGUID";
        this.invalidParameterHandler.validateUserId(userId, "getAssetForConnection");
        this.invalidParameterHandler.validateGUID(connectionGUID, "connectionGUID", "getAssetForConnection");
        return super.getAssetForConnection((OCFRESTClient)this.restClient, serviceURLName, userId, connectionGUID);
    }

    public AssetUniverse getAssetProperties(String userId, String assetGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return super.getAssetProperties(serviceURLName, userId, assetGUID);
    }

    public Connector getConnectorByName(String userId, String connectionName) throws InvalidParameterException, ConnectionCheckedException, ConnectorCheckedException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getConnectorByName";
        String nameParameter = "connectionName";
        this.invalidParameterHandler.validateUserId(userId, "getConnectorByName");
        this.invalidParameterHandler.validateName(connectionName, "connectionName", "getConnectorByName");
        Connection connection = super.getConnectionByName((OCFRESTClient)this.restClient, serviceURLName, userId, connectionName);
        if (connection != null) {
            return super.getConnectorForConnection((OCFRESTClient)this.restClient, serviceURLName, userId, connection, "getConnectorByName");
        }
        return null;
    }

    public Connector getConnectorForAsset(String userId, String assetGUID) throws InvalidParameterException, ConnectionCheckedException, ConnectorCheckedException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getConnectorForAsset";
        String guidParameter = "assetGUID";
        this.invalidParameterHandler.validateUserId(userId, "getConnectorForAsset");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "getConnectorForAsset");
        Connection connection = super.getConnectionForAsset((OCFRESTClient)this.restClient, serviceURLName, userId, assetGUID);
        if (connection != null) {
            return super.getConnectorForConnection((OCFRESTClient)this.restClient, serviceURLName, userId, connection, "getConnectorForAsset");
        }
        return null;
    }

    public Connector getConnectorByGUID(String userId, String connectionGUID) throws InvalidParameterException, ConnectionCheckedException, ConnectorCheckedException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getConnectorByGUID";
        String guidParameter = "connectionGUID";
        this.invalidParameterHandler.validateUserId(userId, "getConnectorByGUID");
        this.invalidParameterHandler.validateGUID(connectionGUID, "connectionGUID", "getConnectorByGUID");
        Connection connection = super.getConnectionByGUID((OCFRESTClient)this.restClient, serviceURLName, userId, connectionGUID);
        if (connection != null) {
            return super.getConnectorForConnection((OCFRESTClient)this.restClient, serviceURLName, userId, connection, "getConnectorByGUID");
        }
        return null;
    }

    public Connector getConnectorByConnection(String userId, Connection connection) throws InvalidParameterException, ConnectionCheckedException, ConnectorCheckedException {
        String methodName = "getConnectorByConnection";
        this.invalidParameterHandler.validateUserId(userId, "getConnectorByConnection");
        return super.getConnectorForConnection((OCFRESTClient)this.restClient, serviceURLName, userId, connection, "getConnectorByConnection");
    }
}

