/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceprogram.client;

import java.util.List;
import org.odpi.openmetadata.accessservices.governanceprogram.api.ExternalReferencesInterface;
import org.odpi.openmetadata.accessservices.governanceprogram.client.GovernanceProgramBaseClient;
import org.odpi.openmetadata.accessservices.governanceprogram.client.rest.GovernanceProgramRESTClient;
import org.odpi.openmetadata.accessservices.governanceprogram.metadataelements.ExternalReferenceElement;
import org.odpi.openmetadata.accessservices.governanceprogram.metadataelements.RelatedElement;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.ExternalReferenceLinkProperties;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.ExternalReferenceProperties;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.ReferenceableProperties;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.RelationshipProperties;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.ExternalReferenceListResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.ExternalReferenceResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;

public class ExternalReferenceManager
extends GovernanceProgramBaseClient
implements ExternalReferencesInterface {
    public ExternalReferenceManager(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot);
    }

    public ExternalReferenceManager(String serverName, String serverPlatformURLRoot, String userId, String password) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password);
    }

    public ExternalReferenceManager(String serverName, String serverPlatformURLRoot, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, maxPageSize, auditLog);
    }

    public ExternalReferenceManager(String serverName, String serverPlatformURLRoot, String userId, String password, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password, maxPageSize, auditLog);
    }

    public ExternalReferenceManager(String serverName, String serverPlatformURLRoot, GovernanceProgramRESTClient restClient, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, restClient, maxPageSize);
    }

    public String createExternalReference(String userId, String anchorGUID, ExternalReferenceProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createExternalReference";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/external-references";
        String propertiesParameterName = "properties";
        return super.createReferenceable(userId, (ReferenceableProperties)properties, "properties", "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/external-references", "createExternalReference");
    }

    public void updateExternalReference(String userId, String externalReferenceGUID, boolean isMergeUpdate, ExternalReferenceProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateExternalReference";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/external-references/{2}/update?isMergeUpdate={4}";
        String guidParameterName = "externalReferenceGUID";
        String propertiesParameterName = "properties";
        super.updateReferenceable(userId, externalReferenceGUID, "externalReferenceGUID", isMergeUpdate, (ReferenceableProperties)properties, "properties", "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/external-references/{2}/update?isMergeUpdate={4}", "updateExternalReference");
    }

    public void deleteExternalReference(String userId, String externalReferenceGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "deleteExternalReference";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/external-references/{2}/delete";
        String guidParameterName = "externalReferenceGUID";
        super.removeReferenceable(userId, externalReferenceGUID, "externalReferenceGUID", "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/external-references/{2}/delete", "deleteExternalReference");
    }

    public void linkExternalReferenceToElement(String userId, String attachedToGUID, String externalReferenceGUID, ExternalReferenceLinkProperties linkProperties) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "linkExternalReferenceToElement";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/elements/{2}/external-references/{3}/link";
        String elementGUIDParameterName = "attachedToGUID";
        String externalReferenceGUIDParameterName = "externalReferenceGUID";
        super.setupRelationship(userId, attachedToGUID, "attachedToGUID", null, (RelationshipProperties)linkProperties, externalReferenceGUID, "externalReferenceGUID", "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/elements/{2}/external-references/{3}/link", "linkExternalReferenceToElement");
    }

    public void unlinkExternalReferenceFromElement(String userId, String attachedToGUID, String externalReferenceGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "unlinkExternalReferenceToElement";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/elements/{2}/external-references/{3}/unlink";
        String elementGUIDParameterName = "attachedToGUID";
        String externalReferenceGUIDParameterName = "externalReferenceGUID";
        super.clearRelationship(userId, attachedToGUID, "attachedToGUID", null, externalReferenceGUID, "externalReferenceGUID", "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/elements/{2}/external-references/{3}/unlink", "unlinkExternalReferenceToElement");
    }

    public ExternalReferenceElement getExternalReferenceByGUID(String userId, String externalReferenceGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getExternalReferenceByGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/external-references/{2}";
        String guidParameterName = "externalReferenceGUID";
        this.invalidParameterHandler.validateUserId(userId, "getExternalReferenceByGUID");
        this.invalidParameterHandler.validateGUID(externalReferenceGUID, "externalReferenceGUID", "getExternalReferenceByGUID");
        ExternalReferenceResponse restResult = this.restClient.callExternalReferenceGetRESTCall("getExternalReferenceByGUID", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/external-references/{2}", this.serverName, userId, externalReferenceGUID);
        return restResult.getElement();
    }

    public List<ExternalReferenceElement> findExternalReferencesById(String userId, String resourceId, int startFrom, int pageSize) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "findExternalReferencesById";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/external-references/by-resource-id?startFrom={2}&pageSize={3}";
        String resourceIdParameterName = "resourceId";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(this.serverPlatformURLRoot, this.serverName, "findExternalReferencesById");
        this.invalidParameterHandler.validateUserId(userId, "findExternalReferencesById");
        this.invalidParameterHandler.validateSearchString(resourceId, "resourceId", "findExternalReferencesById");
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "findExternalReferencesById");
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setSearchString(resourceId);
        requestBody.setSearchStringParameterName("resourceId");
        ExternalReferenceListResponse restResult = this.restClient.callExternalReferenceListPostRESTCall("findExternalReferencesById", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/external-references/by-resource-id?startFrom={2}&pageSize={3}", requestBody, this.serverName, userId, startFrom, queryPageSize);
        return restResult.getElements();
    }

    public List<ExternalReferenceElement> getExternalReferencesByURL(String userId, String url, int startFrom, int pageSize) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getExternalReferencesByURL";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/external-references/by-url?startFrom={2}&pageSize={3}";
        String urlParameterName = "resourceId";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(this.serverPlatformURLRoot, this.serverName, "getExternalReferencesByURL");
        this.invalidParameterHandler.validateUserId(userId, "getExternalReferencesByURL");
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getExternalReferencesByURL");
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setName(url);
        requestBody.setNameParameterName("resourceId");
        ExternalReferenceListResponse restResult = this.restClient.callExternalReferenceListPostRESTCall("getExternalReferencesByURL", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/external-references/by-url?startFrom={2}&pageSize={3}", requestBody, this.serverName, userId, startFrom, queryPageSize);
        return restResult.getElements();
    }

    public List<ExternalReferenceElement> retrieveAttachedExternalReferences(String userId, String attachedToGUID, int startFrom, int pageSize) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "retrieveAttachedExternalReferences";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/elements/{2}/external-references?startFrom={3}&pageSize={4}";
        String guidParameterName = "attachedToGUID";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(this.serverPlatformURLRoot, this.serverName, "retrieveAttachedExternalReferences");
        this.invalidParameterHandler.validateUserId(userId, "retrieveAttachedExternalReferences");
        this.invalidParameterHandler.validateGUID(attachedToGUID, "attachedToGUID", "retrieveAttachedExternalReferences");
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "retrieveAttachedExternalReferences");
        ExternalReferenceListResponse restResult = this.restClient.callExternalReferenceListGetRESTCall("retrieveAttachedExternalReferences", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/elements/{2}/external-references?startFrom={3}&pageSize={4}", this.serverName, userId, attachedToGUID, startFrom, queryPageSize);
        return restResult.getElements();
    }

    public List<RelatedElement> getElementsForExternalReference(String userId, String externalReferenceGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getElementsForExternalReference";
        String guidParameter = "externalReferenceGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/elements/external-references/{2}?&startFrom={3}&pageSize={4}";
        return super.getRelatedElements(userId, externalReferenceGUID, "externalReferenceGUID", "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/elements/external-references/{2}?&startFrom={3}&pageSize={4}", startFrom, pageSize, "getElementsForExternalReference");
    }
}

