/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceprogram.client;

import java.util.List;
import org.odpi.openmetadata.accessservices.governanceprogram.api.GovernanceDomainInterface;
import org.odpi.openmetadata.accessservices.governanceprogram.client.GovernanceProgramBaseClient;
import org.odpi.openmetadata.accessservices.governanceprogram.client.rest.GovernanceProgramRESTClient;
import org.odpi.openmetadata.accessservices.governanceprogram.metadataelements.GovernanceDomainElement;
import org.odpi.openmetadata.accessservices.governanceprogram.metadataelements.GovernanceDomainSetElement;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.GovernanceDomain;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.GovernanceDomainProperties;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.GovernanceDomainSetProperties;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.ReferenceableProperties;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceDomainListResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceDomainResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceDomainSetListResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceDomainSetResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;

public class GovernanceDomainManager
extends GovernanceProgramBaseClient
implements GovernanceDomainInterface {
    public GovernanceDomainManager(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot);
    }

    public GovernanceDomainManager(String serverName, String serverPlatformURLRoot, String userId, String password) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password);
    }

    public GovernanceDomainManager(String serverName, String serverPlatformURLRoot, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, maxPageSize, auditLog);
    }

    public GovernanceDomainManager(String serverName, String serverPlatformURLRoot, String userId, String password, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password, maxPageSize, auditLog);
    }

    public GovernanceDomainManager(String serverName, String serverPlatformURLRoot, GovernanceProgramRESTClient restClient, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, restClient, maxPageSize);
    }

    public String createStandardGovernanceDomains(String userId) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createStandardGovernanceDomains";
        String setName = "EgeriaStandardDomains";
        String setDescription = "Initial list of governance domain definitions for the following governance domains.\n\n* Unclassified - The governance domain is not specified - that is the definition applies to all domains - this is the default value for governance definitions within the governance program.\n* Data - The data (information) governance domain\n* Privacy - The data privacy governance domain\n* Security - The security governance domain.\n* IT Infrastructure - The IT infrastructure management governance domain.\n* Software Development - The software development lifecycle (SDLC) governance domain.\n* Corporate - The corporate governance domain.\n* Asset Management - The physical asset management governance domain.\n";
        this.invalidParameterHandler.validateUserId(userId, "createStandardGovernanceDomains");
        GovernanceDomainSetProperties governanceDomainSetProperties = new GovernanceDomainSetProperties();
        governanceDomainSetProperties.setQualifiedName("GovernanceDomainSet:EgeriaStandardDomains");
        governanceDomainSetProperties.setDisplayName("EgeriaStandardDomains");
        governanceDomainSetProperties.setDescription("Initial list of governance domain definitions for the following governance domains.\n\n* Unclassified - The governance domain is not specified - that is the definition applies to all domains - this is the default value for governance definitions within the governance program.\n* Data - The data (information) governance domain\n* Privacy - The data privacy governance domain\n* Security - The security governance domain.\n* IT Infrastructure - The IT infrastructure management governance domain.\n* Software Development - The software development lifecycle (SDLC) governance domain.\n* Corporate - The corporate governance domain.\n* Asset Management - The physical asset management governance domain.\n");
        String setGUID = this.createGovernanceDomainSet(userId, governanceDomainSetProperties);
        for (GovernanceDomain governanceDomain : GovernanceDomain.values()) {
            if (governanceDomain == GovernanceDomain.OTHER) continue;
            GovernanceDomainProperties governanceDomainProperties = new GovernanceDomainProperties();
            governanceDomainProperties.setQualifiedName("GovernanceDomain:" + governanceDomain.getName());
            governanceDomainProperties.setDisplayName(governanceDomain.getName());
            governanceDomainProperties.setDomainIdentifier(governanceDomain.getOrdinal());
            governanceDomainProperties.setDescription(governanceDomain.getDescription());
            this.createGovernanceDomain(userId, setGUID, governanceDomainProperties);
        }
        return setGUID;
    }

    public String createGovernanceDomainSet(String userId, GovernanceDomainSetProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createGovernanceDomainSet";
        String propertiesParameter = "properties";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-domain-sets";
        return super.createReferenceable(userId, (ReferenceableProperties)properties, "properties", "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-domain-sets", "createGovernanceDomainSet");
    }

    public void updateGovernanceDomainSet(String userId, String governanceDomainSetGUID, GovernanceDomainSetProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateGovernanceDomainSet";
        String guidParameter = "governanceDomainSetGUID";
        String propertiesParameter = "properties";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-domain-sets/{2}/update";
        super.updateReferenceable(userId, governanceDomainSetGUID, "governanceDomainSetGUID", false, (ReferenceableProperties)properties, "properties", "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-domain-sets/{2}/update", "updateGovernanceDomainSet");
    }

    public void removeGovernanceDomainSet(String userId, String governanceDomainSetGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeGovernanceDomainSet";
        String guidParameter = "governanceDomainSetGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-domain-sets/{2}/delete";
        super.removeReferenceable(userId, governanceDomainSetGUID, "governanceDomainSetGUID", "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-domain-sets/{2}/delete", "removeGovernanceDomainSet");
    }

    public List<GovernanceDomainSetElement> findGovernanceDomainSets(String userId, String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findGovernanceDomainSets";
        String searchStringParameterName = "searchString";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-domain-sets/by-search-string?startFrom={2}&pageSize={3}";
        this.invalidParameterHandler.validateUserId(userId, "findGovernanceDomainSets");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findGovernanceDomainSets");
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "findGovernanceDomainSets");
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        GovernanceDomainSetListResponse restResult = this.restClient.callGovernanceDomainSetListPostRESTCall("findGovernanceDomainSets", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-domain-sets/by-search-string?startFrom={2}&pageSize={3}", requestBody, this.serverName, userId, startFrom, queryPageSize);
        return restResult.getElements();
    }

    public List<GovernanceDomainSetElement> getGovernanceDomainSetsByName(String userId, String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernanceDomainSetsByName";
        String nameParameterName = "name";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-domain-sets/by-name?startFrom={2}&pageSize={3}";
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceDomainSetsByName");
        this.invalidParameterHandler.validateName(name, "name", "getGovernanceDomainSetsByName");
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getGovernanceDomainSetsByName");
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setName(name);
        requestBody.setNameParameterName("name");
        GovernanceDomainSetListResponse restResult = this.restClient.callGovernanceDomainSetListPostRESTCall("getGovernanceDomainSetsByName", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-domain-sets/by-name?startFrom={2}&pageSize={3}", requestBody, this.serverName, userId, startFrom, queryPageSize);
        return restResult.getElements();
    }

    public GovernanceDomainSetElement getGovernanceDomainSetByGUID(String userId, String governanceDomainSetGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernanceDomainSetByGUID";
        String guidParameterName = "governanceDomainSetGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-domain-sets/{2}";
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceDomainSetByGUID");
        this.invalidParameterHandler.validateName(governanceDomainSetGUID, "governanceDomainSetGUID", "getGovernanceDomainSetByGUID");
        GovernanceDomainSetResponse restResult = this.restClient.callGovernanceDomainSetGetRESTCall("getGovernanceDomainSetByGUID", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-domain-sets/{2}", this.serverName, userId, governanceDomainSetGUID);
        return restResult.getElement();
    }

    public String createGovernanceDomain(String userId, String setGUID, GovernanceDomainProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createGovernanceDomain";
        String guidParameter = "setGUID";
        String propertiesParameter = "properties";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-domain-sets/governance-domains";
        return super.createReferenceableWithAnchor(userId, setGUID, "setGUID", (ReferenceableProperties)properties, "properties", "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-domain-sets/governance-domains", "createGovernanceDomain");
    }

    public void updateGovernanceDomain(String userId, String governanceDomainGUID, GovernanceDomainProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateGovernanceDomain";
        String guidParameter = "governanceDomainGUID";
        String propertiesParameter = "properties";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-domains/{2}/update";
        super.updateReferenceable(userId, governanceDomainGUID, "governanceDomainGUID", false, (ReferenceableProperties)properties, "properties", "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-domains/{2}/update", "updateGovernanceDomain");
    }

    public void deleteGovernanceDomain(String userId, String governanceDomainGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "deleteGovernanceDomain";
        String guidParameter = "governanceDomainGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-domains/{2}/delete";
        super.removeReferenceable(userId, governanceDomainGUID, "governanceDomainGUID", "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-domains/{2}/delete", "deleteGovernanceDomain");
    }

    public void addDomainToSet(String userId, String governanceDomainSetGUID, String governanceDomainGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addDomainToSet";
        String guid1Parameter = "governanceDomainSetGUID";
        String guid2Parameter = "governanceDomainGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-domain-sets/{2}/governance-domains/{3}";
        super.setupRelationship(userId, governanceDomainSetGUID, "governanceDomainSetGUID", null, null, governanceDomainGUID, "governanceDomainGUID", "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-domain-sets/{2}/governance-domains/{3}", "addDomainToSet");
    }

    public void removeDomainFromSet(String userId, String governanceDomainSetGUID, String governanceDomainGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeDomainFromSet";
        String guid1Parameter = "governanceDomainSetGUID";
        String guid2Parameter = "governanceDomainGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-domain-sets/{2}/governance-domains/{3}/delete";
        super.clearRelationship(userId, governanceDomainSetGUID, "governanceDomainSetGUID", null, governanceDomainGUID, "governanceDomainGUID", "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-domain-sets/{2}/governance-domains/{3}/delete", "removeDomainFromSet");
    }

    public List<GovernanceDomainElement> getGovernanceDomains(String userId, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernanceDomains";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-domains?startFrom={2}&pageSize={3}";
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceDomains");
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getGovernanceDomains");
        GovernanceDomainListResponse restResult = this.restClient.callGovernanceDomainListGetRESTCall("getGovernanceDomains", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-domains?startFrom={2}&pageSize={3}", this.serverName, userId, startFrom, queryPageSize);
        return restResult.getElements();
    }

    public List<GovernanceDomainElement> findGovernanceDomains(String userId, String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findGovernanceDomains";
        String searchStringParameterName = "searchString";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-domains/by-search-string?startFrom={2}&pageSize={3}";
        this.invalidParameterHandler.validateUserId(userId, "findGovernanceDomains");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findGovernanceDomains");
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "findGovernanceDomains");
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        GovernanceDomainListResponse restResult = this.restClient.callGovernanceDomainListPostRESTCall("findGovernanceDomains", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-domains/by-search-string?startFrom={2}&pageSize={3}", requestBody, this.serverName, userId, startFrom, queryPageSize);
        return restResult.getElements();
    }

    public List<GovernanceDomainSetElement> getSetsForGovernanceDomain(String userId, String governanceDomainGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getSetsForGovernanceDomain";
        String guidParameterName = "governanceDomainGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-domain-sets/by-governance-domains/{2}?startFrom={3}&pageSize={4}";
        this.invalidParameterHandler.validateUserId(userId, "getSetsForGovernanceDomain");
        this.invalidParameterHandler.validateGUID(governanceDomainGUID, "governanceDomainGUID", "getSetsForGovernanceDomain");
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getSetsForGovernanceDomain");
        GovernanceDomainSetListResponse restResult = this.restClient.callGovernanceDomainSetListGetRESTCall("getSetsForGovernanceDomain", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-domain-sets/by-governance-domains/{2}?startFrom={3}&pageSize={4}", this.serverName, userId, governanceDomainGUID, startFrom, queryPageSize);
        return restResult.getElements();
    }

    public List<GovernanceDomainElement> getGovernanceDomainsByName(String userId, String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernanceDomainsByName";
        String nameParameterName = "name";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-domains/by-name?startFrom={2}&pageSize={3}";
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceDomainsByName");
        this.invalidParameterHandler.validateName(name, "name", "getGovernanceDomainsByName");
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getGovernanceDomainsByName");
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setName(name);
        requestBody.setNameParameterName("name");
        GovernanceDomainListResponse restResult = this.restClient.callGovernanceDomainListPostRESTCall("getGovernanceDomainsByName", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-domains/by-name?startFrom={2}&pageSize={3}", requestBody, this.serverName, userId, startFrom, queryPageSize);
        return restResult.getElements();
    }

    public GovernanceDomainElement getGovernanceDomainByGUID(String userId, String governanceDomainGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernanceDomainByGUID";
        String guidParameterName = "governanceDomainGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-domains/{2}";
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceDomainByGUID");
        this.invalidParameterHandler.validateGUID(governanceDomainGUID, "governanceDomainGUID", "getGovernanceDomainByGUID");
        GovernanceDomainResponse restResult = this.restClient.callGovernanceDomainGetRESTCall("getGovernanceDomainByGUID", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-domains/{2}", this.serverName, userId, governanceDomainGUID);
        return restResult.getElement();
    }

    public GovernanceDomainElement getGovernanceDomainByIdentifier(String userId, int domainIdentifier) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernanceDomainByIdentifier";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-domains/by-identifier/{2}";
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceDomainByIdentifier");
        GovernanceDomainResponse restResult = this.restClient.callGovernanceDomainGetRESTCall("getGovernanceDomainByIdentifier", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-domains/by-identifier/{2}", this.serverName, userId, domainIdentifier);
        return restResult.getElement();
    }
}

