/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceprogram.client;

import java.util.List;
import org.odpi.openmetadata.accessservices.governanceprogram.api.GovernanceMetricsInterface;
import org.odpi.openmetadata.accessservices.governanceprogram.client.GovernanceProgramBaseClient;
import org.odpi.openmetadata.accessservices.governanceprogram.client.rest.GovernanceProgramRESTClient;
import org.odpi.openmetadata.accessservices.governanceprogram.metadataelements.GovernanceMetricElement;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.ClassificationProperties;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.GovernanceDefinitionMetricProperties;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.GovernanceExpectationsProperties;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.GovernanceMeasurementsDataSetProperties;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.GovernanceMeasurementsProperties;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.GovernanceMetricProperties;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.GovernanceResultsProperties;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.ReferenceableProperties;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.RelationshipProperties;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceMetricListResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceMetricResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;

public class GovernanceMetricsManager
extends GovernanceProgramBaseClient
implements GovernanceMetricsInterface {
    public GovernanceMetricsManager(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot);
    }

    public GovernanceMetricsManager(String serverName, String serverPlatformURLRoot, String userId, String password) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password);
    }

    public GovernanceMetricsManager(String serverName, String serverPlatformURLRoot, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, maxPageSize, auditLog);
    }

    public GovernanceMetricsManager(String serverName, String serverPlatformURLRoot, String userId, String password, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password, maxPageSize, auditLog);
    }

    public GovernanceMetricsManager(String serverName, String serverPlatformURLRoot, GovernanceProgramRESTClient restClient, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, restClient, maxPageSize);
    }

    public String createGovernanceMetric(String userId, GovernanceMetricProperties metricProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createGovernanceMetric";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-metrics";
        String propertiesParameterName = "metricProperties";
        return super.createReferenceable(userId, (ReferenceableProperties)metricProperties, "metricProperties", "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-metrics", "createGovernanceMetric");
    }

    public void updateGovernanceMetric(String userId, String metricGUID, boolean isMergeUpdate, GovernanceMetricProperties metricProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateGovernanceMetric";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-metrics/{2}/update?isMergeUpdate={4}";
        String guidParameterName = "metricGUID";
        String propertiesParameterName = "metricProperties";
        super.updateReferenceable(userId, metricGUID, "metricGUID", isMergeUpdate, (ReferenceableProperties)metricProperties, "metricProperties", "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-metrics/{2}/update?isMergeUpdate={4}", "updateGovernanceMetric");
    }

    public void deleteGovernanceMetric(String userId, String metricGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "deleteExternalReference";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-metrics/{2}/delete";
        String guidParameterName = "metricGUID";
        super.removeReferenceable(userId, metricGUID, "metricGUID", "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-metrics/{2}/delete", "deleteExternalReference");
    }

    public void setupGovernanceDefinitionMetric(String userId, String metricGUID, String governanceDefinitionGUID, GovernanceDefinitionMetricProperties rationale) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupGovernanceDefinitionMetric";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-metrics/{2}/governance-definitions/{3}/link";
        String metricGUIDParameterName = "metricGUID";
        String governanceDefinitionGUIDParameterName = "governanceDefinitionGUID";
        super.setupRelationship(userId, metricGUID, "metricGUID", null, (RelationshipProperties)rationale, governanceDefinitionGUID, "governanceDefinitionGUID", "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-metrics/{2}/governance-definitions/{3}/link", "setupGovernanceDefinitionMetric");
    }

    public void clearGovernanceDefinitionMetric(String userId, String metricGUID, String governanceDefinitionGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearGovernanceDefinitionMetric";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-metrics/{2}/governance-definitions/{3}/unlink";
        String metricGUIDParameterName = "metricGUID";
        String governanceDefinitionGUIDParameterName = "governanceDefinitionGUID";
        super.clearRelationship(userId, metricGUID, "metricGUID", null, governanceDefinitionGUID, "governanceDefinitionGUID", "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-metrics/{2}/governance-definitions/{3}/unlink", "clearGovernanceDefinitionMetric");
    }

    public void setupGovernanceResults(String userId, String metricGUID, String dataSetGUID, GovernanceResultsProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupGovernanceResults";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-metrics/{2}/governance-results/{3}/link";
        String metricGUIDParameterName = "metricGUID";
        String dataSetGUIDParameterName = "dataSetGUID";
        super.setupRelationship(userId, metricGUID, "metricGUID", null, (RelationshipProperties)properties, dataSetGUID, "dataSetGUID", "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-metrics/{2}/governance-results/{3}/link", "setupGovernanceResults");
    }

    public void clearGovernanceResults(String userId, String metricGUID, String dataSetGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearGovernanceResults";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-metrics/{2}/governance-results/{3}/unlink";
        String metricGUIDParameterName = "metricGUID";
        String governanceDefinitionGUIDParameterName = "dataSetGUID";
        this.clearRelationship(userId, metricGUID, "metricGUID", null, dataSetGUID, "dataSetGUID", "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-metrics/{2}/governance-results/{3}/unlink", "clearGovernanceResults");
    }

    public void setGovernanceMeasurementsDataSet(String userId, String dataSetGUID, GovernanceMeasurementsDataSetProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setGovernanceMeasurementsDataSet";
        String guidParameter = "dataSetGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/data-sets/{2}/classify-as-governance-measurements-set";
        super.setReferenceableClassification(userId, dataSetGUID, "dataSetGUID", (ClassificationProperties)properties, "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/data-sets/{2}/classify-as-governance-measurements-set", "setGovernanceMeasurementsDataSet");
    }

    public void clearGovernanceMeasurementsDataSet(String userId, String dataSetGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearGovernanceMeasurementsDataSet";
        String guidParameter = "dataSetGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/data-sets/{2}/classify-as-governance-measurements-set/delete";
        super.removeReferenceableClassification(userId, dataSetGUID, "dataSetGUID", "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/data-sets/{2}/classify-as-governance-measurements-set/delete", "clearGovernanceMeasurementsDataSet");
    }

    public void setGovernanceExpectations(String userId, String elementGUID, GovernanceExpectationsProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setGovernanceExpectations";
        String guidParameter = "elementGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/elements/{2}/classify-with-governance-expectations";
        super.setReferenceableClassification(userId, elementGUID, "elementGUID", (ClassificationProperties)properties, "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/elements/{2}/classify-with-governance-expectations", "setGovernanceExpectations");
    }

    public void clearGovernanceExpectations(String userId, String elementGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearGovernanceExpectations";
        String guidParameter = "elementGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/elements/{2}/classify-with-governance-expectations/delete";
        super.removeReferenceableClassification(userId, elementGUID, "elementGUID", "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/elements/{2}/classify-with-governance-expectations/delete", "clearGovernanceExpectations");
    }

    public void setGovernanceMeasurements(String userId, String elementGUID, GovernanceMeasurementsProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setGovernanceMeasurements";
        String guidParameter = "elementGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/elements/{2}/classify-with-governance-measurements";
        super.setReferenceableClassification(userId, elementGUID, "elementGUID", (ClassificationProperties)properties, "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/elements/{2}/classify-with-governance-measurements", "setGovernanceMeasurements");
    }

    public void clearGovernanceMeasurements(String userId, String elementGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearGovernanceMeasurements";
        String guidParameter = "elementGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/elements/{2}/classify-with-governance-measurements/delete";
        super.removeReferenceableClassification(userId, elementGUID, "elementGUID", "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/elements/{2}/classify-with-governance-measurements/delete", "clearGovernanceMeasurements");
    }

    public GovernanceMetricElement getGovernanceMetricByGUID(String userId, String metricGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernanceMetricByGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-metrics/{2}";
        String guidParameterName = "metricGUID";
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceMetricByGUID");
        this.invalidParameterHandler.validateGUID(metricGUID, "metricGUID", "getGovernanceMetricByGUID");
        GovernanceMetricResponse restResult = this.restClient.callGovernanceMetricGetRESTCall("getGovernanceMetricByGUID", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-metrics/{2}", this.serverName, userId, metricGUID);
        return restResult.getElement();
    }

    public List<GovernanceMetricElement> findGovernanceMetrics(String userId, String searchString, int startFrom, int pageSize) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "findGovernanceMetrics";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-metrics/by-search-string?startFrom={2}&pageSize={3}";
        String searchStringParameterName = "searchString";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(this.serverPlatformURLRoot, this.serverName, "findGovernanceMetrics");
        this.invalidParameterHandler.validateUserId(userId, "findGovernanceMetrics");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findGovernanceMetrics");
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "findGovernanceMetrics");
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        GovernanceMetricListResponse restResult = this.restClient.callGovernanceMetricListPostRESTCall("findGovernanceMetrics", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-metrics/by-search-string?startFrom={2}&pageSize={3}", requestBody, this.serverName, userId, startFrom, queryPageSize);
        return restResult.getElements();
    }
}

