/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceprogram.client;

import java.util.List;
import org.odpi.openmetadata.accessservices.governanceprogram.api.RelatedElementsManagementInterface;
import org.odpi.openmetadata.accessservices.governanceprogram.client.rest.GovernanceProgramRESTClient;
import org.odpi.openmetadata.accessservices.governanceprogram.metadataelements.GovernanceDefinitionElement;
import org.odpi.openmetadata.accessservices.governanceprogram.metadataelements.GovernanceRoleElement;
import org.odpi.openmetadata.accessservices.governanceprogram.metadataelements.RelatedElement;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.AssignmentScopeProperties;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.ClassificationProperties;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.GovernanceDefinitionProperties;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.GovernanceDefinitionStatus;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.GovernanceRoleProperties;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.ReferenceableProperties;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.RelationshipProperties;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.ResourceListProperties;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.StakeholderProperties;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.ClassificationRequestBody;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.ElementStubListResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.ExternalSourceRequestBody;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceDefinitionListResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceDefinitionRequestBody;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceRoleListResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceRoleRequestBody;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceStatusRequestBody;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.ReferenceableRequestBody;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.RelatedElementListResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.RelationshipRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementStub;

public class GovernanceProgramBaseClient
implements RelatedElementsManagementInterface {
    final String serverName;
    final String serverPlatformURLRoot;
    final InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
    final GovernanceProgramRESTClient restClient;
    private static final String elementsURLTemplatePrefix = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/related-elements";
    protected NullRequestBody nullRequestBody = new NullRequestBody();

    public GovernanceProgramBaseClient(String serverName, String serverPlatformURLRoot, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        String methodName = "Client Constructor";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.restClient = new GovernanceProgramRESTClient(serverName, serverPlatformURLRoot, auditLog);
    }

    public GovernanceProgramBaseClient(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        String methodName = "Client Constructor";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new GovernanceProgramRESTClient(serverName, serverPlatformURLRoot);
    }

    public GovernanceProgramBaseClient(String serverName, String serverPlatformURLRoot, String userId, String password) throws InvalidParameterException {
        String methodName = "Client Constructor";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new GovernanceProgramRESTClient(serverName, serverPlatformURLRoot, userId, password);
    }

    public GovernanceProgramBaseClient(String serverName, String serverPlatformURLRoot, String userId, String password, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        String methodName = "Client Constructor";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.restClient = new GovernanceProgramRESTClient(serverName, serverPlatformURLRoot, userId, password, auditLog);
    }

    public GovernanceProgramBaseClient(String serverName, String serverPlatformURLRoot, GovernanceProgramRESTClient restClient, int maxPageSize) throws InvalidParameterException {
        String methodName = "Client Constructor";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.restClient = restClient;
    }

    String createReferenceable(String userId, ReferenceableProperties properties, String propertiesParameterName, String urlTemplate, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateObject((Object)properties, propertiesParameterName, methodName);
        this.invalidParameterHandler.validateName(properties.getQualifiedName(), "qualifiedName", methodName);
        ReferenceableRequestBody requestBody = new ReferenceableRequestBody();
        requestBody.setProperties(properties);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall(methodName, this.serverPlatformURLRoot + urlTemplate, requestBody, new Object[]{this.serverName, userId});
        return restResult.getGUID();
    }

    String createReferenceableWithAnchor(String userId, String anchorGUID, String anchorGUIDParameterName, ReferenceableProperties properties, String propertiesParameterName, String urlTemplate, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(anchorGUID, anchorGUIDParameterName, methodName);
        this.invalidParameterHandler.validateObject((Object)properties, propertiesParameterName, methodName);
        this.invalidParameterHandler.validateName(properties.getQualifiedName(), "qualifiedName", methodName);
        ReferenceableRequestBody requestBody = new ReferenceableRequestBody();
        requestBody.setAnchorGUID(anchorGUID);
        requestBody.setProperties(properties);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall(methodName, this.serverPlatformURLRoot + urlTemplate, requestBody, new Object[]{this.serverName, userId});
        return restResult.getGUID();
    }

    String createGovernanceDefinition(String userId, GovernanceDefinitionProperties properties, String propertiesParameterName, GovernanceDefinitionStatus initialStatus, String urlTemplate, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String docIdParameterName = "documentIdentifier";
        String titleParameterName = "title";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateObject((Object)properties, propertiesParameterName, methodName);
        this.invalidParameterHandler.validateName(properties.getDocumentIdentifier(), "documentIdentifier", methodName);
        this.invalidParameterHandler.validateName(properties.getTitle(), "title", methodName);
        GovernanceDefinitionRequestBody requestBody = new GovernanceDefinitionRequestBody();
        requestBody.setProperties(properties);
        requestBody.setInitialStatus(initialStatus);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall(methodName, this.serverPlatformURLRoot + urlTemplate, requestBody, new Object[]{this.serverName, userId});
        return restResult.getGUID();
    }

    String createGovernanceRole(String userId, GovernanceRoleProperties properties, String propertiesParameterName, String urlTemplate, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String qualifiedNameParameterName = "qualifiedName";
        String titleParameterName = "title";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateObject((Object)properties, propertiesParameterName, methodName);
        this.invalidParameterHandler.validateName(properties.getQualifiedName(), "qualifiedName", methodName);
        this.invalidParameterHandler.validateName(properties.getTitle(), "title", methodName);
        GovernanceRoleRequestBody requestBody = new GovernanceRoleRequestBody();
        requestBody.setProperties(properties);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall(methodName, this.serverPlatformURLRoot + urlTemplate, requestBody, new Object[]{this.serverName, userId});
        return restResult.getGUID();
    }

    void updateReferenceable(String userId, String elementGUID, String elementGUIDParameterName, boolean isMergeUpdate, ReferenceableProperties properties, String propertiesParameterName, String urlTemplate, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(elementGUID, elementGUIDParameterName, methodName);
        this.invalidParameterHandler.validateObject((Object)properties, propertiesParameterName, methodName);
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(properties.getQualifiedName(), "qualifiedName", methodName);
        }
        ReferenceableRequestBody requestBody = new ReferenceableRequestBody();
        requestBody.setProperties(properties);
        this.restClient.callVoidPostRESTCall(methodName, this.serverPlatformURLRoot + urlTemplate, requestBody, new Object[]{this.serverName, userId, elementGUID, isMergeUpdate});
    }

    void updateGovernanceDefinition(String userId, String elementGUID, String elementGUIDParameterName, boolean isMergeUpdate, GovernanceDefinitionProperties properties, String propertiesParameterName, String urlTemplate, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String docIdParameterName = "documentIdentifier";
        String titleParameterName = "title";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(elementGUID, elementGUIDParameterName, methodName);
        this.invalidParameterHandler.validateObject((Object)properties, propertiesParameterName, methodName);
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(properties.getDocumentIdentifier(), "documentIdentifier", methodName);
            this.invalidParameterHandler.validateName(properties.getTitle(), "title", methodName);
        }
        GovernanceDefinitionRequestBody requestBody = new GovernanceDefinitionRequestBody();
        requestBody.setProperties(properties);
        this.restClient.callVoidPostRESTCall(methodName, this.serverPlatformURLRoot + urlTemplate, requestBody, new Object[]{this.serverName, userId, elementGUID, isMergeUpdate});
    }

    public void updateGovernanceDefinitionStatus(String userId, String elementGUID, String elementGUIDParameterName, GovernanceDefinitionStatus newStatus, String propertiesParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-definitions/{2}/update-status";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(elementGUID, elementGUIDParameterName, methodName);
        this.invalidParameterHandler.validateEnum((Object)newStatus, propertiesParameterName, methodName);
        GovernanceStatusRequestBody requestBody = new GovernanceStatusRequestBody();
        requestBody.setStatus(newStatus);
        this.restClient.callVoidPostRESTCall(methodName, this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-definitions/{2}/update-status", requestBody, new Object[]{this.serverName, userId, elementGUID});
    }

    void updateGovernanceRole(String userId, String elementGUID, String elementGUIDParameterName, boolean isMergeUpdate, GovernanceRoleProperties properties, String propertiesParameterName, String urlTemplate, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String roleIdParameterName = "roleId";
        String titleParameterName = "title";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(elementGUID, elementGUIDParameterName, methodName);
        this.invalidParameterHandler.validateObject((Object)properties, propertiesParameterName, methodName);
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(properties.getRoleId(), "roleId", methodName);
            this.invalidParameterHandler.validateName(properties.getTitle(), "title", methodName);
        }
        GovernanceRoleRequestBody requestBody = new GovernanceRoleRequestBody();
        requestBody.setProperties(properties);
        this.restClient.callVoidPostRESTCall(methodName, this.serverPlatformURLRoot + urlTemplate, requestBody, new Object[]{this.serverName, userId, elementGUID, isMergeUpdate});
    }

    void setReferenceableClassification(String userId, String elementGUID, String elementGUIDParameter, ClassificationProperties properties, String urlTemplate, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(elementGUID, elementGUIDParameter, methodName);
        ClassificationRequestBody requestBody = new ClassificationRequestBody();
        requestBody.setProperties(properties);
        this.restClient.callVoidPostRESTCall(methodName, this.serverPlatformURLRoot + urlTemplate, requestBody, new Object[]{this.serverName, userId, elementGUID});
    }

    void removeReferenceableClassification(String userId, String elementGUID, String elementGUIDParameter, String urlTemplate, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(elementGUID, elementGUIDParameter, methodName);
        ExternalSourceRequestBody requestBody = new ExternalSourceRequestBody();
        this.restClient.callVoidPostRESTCall(methodName, this.serverPlatformURLRoot + urlTemplate, requestBody, new Object[]{this.serverName, userId, elementGUID});
    }

    void setupRelationship(String userId, String primaryElementGUID, String primaryElementGUIDParameterName, String relationshipName, RelationshipProperties properties, String secondaryElementGUID, String secondaryElementGUIDParameterName, String urlTemplate, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(primaryElementGUID, primaryElementGUIDParameterName, methodName);
        this.invalidParameterHandler.validateGUID(secondaryElementGUID, secondaryElementGUIDParameterName, methodName);
        RelationshipRequestBody requestBody = new RelationshipRequestBody();
        requestBody.setRelationshipName(relationshipName);
        requestBody.setProperties(properties);
        this.restClient.callVoidPostRESTCall(methodName, this.serverPlatformURLRoot + urlTemplate, requestBody, new Object[]{this.serverName, userId, primaryElementGUID, secondaryElementGUID});
    }

    String setupMultiLinkRelationship(String userId, String primaryElementGUID, String primaryElementGUIDParameterName, String relationshipName, RelationshipProperties properties, String secondaryElementGUID, String secondaryElementGUIDParameterName, String urlTemplate, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(primaryElementGUID, primaryElementGUIDParameterName, methodName);
        this.invalidParameterHandler.validateGUID(secondaryElementGUID, secondaryElementGUIDParameterName, methodName);
        RelationshipRequestBody requestBody = new RelationshipRequestBody();
        requestBody.setRelationshipName(relationshipName);
        requestBody.setProperties(properties);
        GUIDResponse response = this.restClient.callGUIDPostRESTCall(methodName, this.serverPlatformURLRoot + urlTemplate, requestBody, new Object[]{this.serverName, userId, primaryElementGUID, secondaryElementGUID});
        return response.getGUID();
    }

    public void updateRelationship(String userId, String relationshipGUID, String relationshipGUIDParameterName, boolean isMergeUpdate, String relationshipName, RelationshipProperties properties, String urlTemplate, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(relationshipGUID, relationshipGUIDParameterName, methodName);
        RelationshipRequestBody requestBody = new RelationshipRequestBody();
        requestBody.setRelationshipName(relationshipName);
        requestBody.setProperties(properties);
        this.restClient.callVoidPostRESTCall(methodName, this.serverPlatformURLRoot + urlTemplate, requestBody, new Object[]{this.serverName, userId, relationshipGUID, isMergeUpdate});
    }

    void clearRelationship(String userId, String relationshipGUID, String relationshipGUIDParameterName, String relationshipName, String urlTemplate, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(relationshipGUID, relationshipGUIDParameterName, methodName);
        RelationshipRequestBody requestBody = new RelationshipRequestBody();
        requestBody.setRelationshipName(relationshipName);
        this.restClient.callVoidPostRESTCall(methodName, this.serverPlatformURLRoot + urlTemplate, requestBody, new Object[]{this.serverName, userId, relationshipGUID});
    }

    void clearRelationship(String userId, String primaryElementGUID, String primaryElementGUIDParameterName, String relationshipName, String secondaryElementGUID, String secondaryElementGUIDParameterName, String urlTemplate, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(primaryElementGUID, primaryElementGUIDParameterName, methodName);
        this.invalidParameterHandler.validateGUID(secondaryElementGUID, secondaryElementGUIDParameterName, methodName);
        RelationshipRequestBody requestBody = new RelationshipRequestBody();
        requestBody.setRelationshipName(relationshipName);
        this.restClient.callVoidPostRESTCall(methodName, this.serverPlatformURLRoot + urlTemplate, requestBody, new Object[]{this.serverName, userId, primaryElementGUID, secondaryElementGUID});
    }

    List<RelatedElement> getRelatedElements(String userId, String startingElementGUID, String startingElementGUIDParameterName, String urlTemplate, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(startingElementGUID, startingElementGUIDParameterName, methodName);
        RelatedElementListResponse restResult = this.restClient.callRelatedElementListGetRESTCall(methodName, this.serverPlatformURLRoot + urlTemplate, this.serverName, userId, startingElementGUID, Integer.toString(startFrom), Integer.toString(pageSize));
        return restResult.getElementList();
    }

    List<ElementStub> getElementStubsByName(String userId, String name, String nameParameterName, String urlTemplate, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(name, nameParameterName, methodName);
        ElementStubListResponse restResult = this.restClient.callElementStubListGetRESTCall(methodName, this.serverPlatformURLRoot + urlTemplate, this.serverName, userId, name, Integer.toString(startFrom), Integer.toString(pageSize));
        return restResult.getElements();
    }

    List<GovernanceDefinitionElement> getGovernanceDefinitionElements(String userId, String startingElementGUID, String startingElementGUIDParameterName, String urlTemplate, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(startingElementGUID, startingElementGUIDParameterName, methodName);
        GovernanceDefinitionListResponse restResult = this.restClient.callGovernanceDefinitionListGetRESTCall(methodName, this.serverPlatformURLRoot + urlTemplate, this.serverName, userId, startingElementGUID, Integer.toString(startFrom), Integer.toString(pageSize));
        return restResult.getElements();
    }

    List<GovernanceRoleElement> getGovernanceRoleElements(String userId, String startingElementGUID, String startingElementGUIDParameterName, String urlTemplate, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(startingElementGUID, startingElementGUIDParameterName, methodName);
        GovernanceRoleListResponse restResult = this.restClient.callGovernanceRoleListGetRESTCall(methodName, urlTemplate, this.serverName, userId, startingElementGUID, Integer.toString(startFrom), Integer.toString(pageSize));
        return restResult.getElements();
    }

    public void removeReferenceable(String userId, String elementGUID, String elementGUIDParameterName, String urlTemplate, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(elementGUID, elementGUIDParameterName, methodName);
        ExternalSourceRequestBody requestBody = new ExternalSourceRequestBody();
        this.restClient.callVoidPostRESTCall(methodName, this.serverPlatformURLRoot + urlTemplate, requestBody, new Object[]{this.serverName, userId, elementGUID});
    }

    public void setupMoreInformation(String userId, String elementGUID, RelationshipProperties properties, String detailGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupMoreInformation";
        String elementGUIDParameterName = "elementGUID";
        String detailGUIDParameterName = "detailGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/related-elements/{2}/more-information/{3}";
        this.setupRelationship(userId, elementGUID, "elementGUID", null, properties, detailGUID, "detailGUID", "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/related-elements/{2}/more-information/{3}", "setupMoreInformation");
    }

    public void clearMoreInformation(String userId, String elementGUID, String detailGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearMoreInformation";
        String elementGUIDParameterName = "elementGUID";
        String detailGUIDParameterName = "detailGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/related-elements/{2}/more-information/{3}/delete";
        this.clearRelationship(userId, elementGUID, "elementGUID", null, detailGUID, "detailGUID", "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/related-elements/{2}/more-information/{3}/delete", "clearMoreInformation");
    }

    public List<RelatedElement> getMoreInformation(String userId, String elementGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getMoreInformation";
        String guidPropertyName = "elementGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/related-elements/more-information/by-descriptive-element/{2}?startFrom={3}&pageSize={4}";
        return this.getRelatedElements(userId, elementGUID, "elementGUID", "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/related-elements/more-information/by-descriptive-element/{2}?startFrom={3}&pageSize={4}", startFrom, pageSize, "getMoreInformation");
    }

    public List<RelatedElement> getDescriptiveElements(String userId, String detailGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getDescriptiveElements";
        String guidPropertyName = "detailGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/related-elements/more-information/by-detail-element/{2}?startFrom={3}&pageSize={4}";
        return this.getRelatedElements(userId, detailGUID, "detailGUID", "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/related-elements/more-information/by-detail-element/{2}?startFrom={3}&pageSize={4}", startFrom, pageSize, "getDescriptiveElements");
    }

    public void setupGovernedBy(String userId, String elementGUID, RelationshipProperties properties, String governanceDefinitionGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupGovernedBy";
        String elementGUIDParameterName = "elementGUID";
        String governanceDefinitionGUIDParameterName = "governanceDefinitionGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/related-elements/{2}/governed-by/{3}";
        this.setupRelationship(userId, elementGUID, "elementGUID", null, properties, governanceDefinitionGUID, "governanceDefinitionGUID", "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/related-elements/{2}/governed-by/{3}", "setupGovernedBy");
    }

    public void clearGovernedBy(String userId, String elementGUID, String governanceDefinitionGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearGovernedBy";
        String elementGUIDParameterName = "elementGUID";
        String governanceDefinitionGUIDParameterName = "governanceDefinitionGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/related-elements/{2}/governed-by/{3}/delete";
        this.clearRelationship(userId, elementGUID, "elementGUID", null, governanceDefinitionGUID, "governanceDefinitionGUID", "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/related-elements/{2}/governed-by/{3}/delete", "clearGovernedBy");
    }

    public List<GovernanceDefinitionElement> getGovernanceDefinitionsForElement(String userId, String elementGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernanceDefinitionsForElement";
        String guidPropertyName = "elementGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/related-elements/governed-by/by-element/{2}?startFrom={3}&pageSize={4}";
        return this.getGovernanceDefinitionElements(userId, elementGUID, "elementGUID", "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/related-elements/governed-by/by-element/{2}?startFrom={3}&pageSize={4}", startFrom, pageSize, "getGovernanceDefinitionsForElement");
    }

    public List<RelatedElement> getGovernedElements(String userId, String governanceDefinitionGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernedElements";
        String guidPropertyName = "governanceDefinitionGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/related-elements/governed-by/by-governance-definition/{2}?startFrom={3}&pageSize={4}";
        return this.getRelatedElements(userId, governanceDefinitionGUID, "governanceDefinitionGUID", "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/related-elements/governed-by/by-governance-definition/{2}?startFrom={3}&pageSize={4}", startFrom, pageSize, "getGovernedElements");
    }

    public void setupGovernanceDefinitionScope(String userId, String governanceDefinitionGUID, String scopeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupGovernanceDefinitionScope";
        String scopeGUIDParameterName = "scopeGUID";
        String governanceDefinitionGUIDParameterName = "governanceDefinitionGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/related-elements/{2}/governance-definition-scopes/{3}";
        this.setupRelationship(userId, scopeGUID, "scopeGUID", null, null, governanceDefinitionGUID, "governanceDefinitionGUID", "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/related-elements/{2}/governance-definition-scopes/{3}", "setupGovernanceDefinitionScope");
    }

    public void clearGovernanceDefinitionScope(String userId, String governanceDefinitionGUID, String scopeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearGovernanceDefinitionScope";
        String scopeGUIDParameterName = "scopeGUID";
        String governanceDefinitionGUIDParameterName = "governanceDefinitionGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/related-elements/{2}/governance-definition-scopes/{3}/delete";
        this.clearRelationship(userId, scopeGUID, "scopeGUID", null, governanceDefinitionGUID, "governanceDefinitionGUID", "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/related-elements/{2}/governance-definition-scopes/{3}/delete", "clearGovernanceDefinitionScope");
    }

    public List<RelatedElement> getGovernanceDefinitionScopes(String userId, String governanceDefinitionGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernanceDefinitionScopes";
        String guidPropertyName = "governanceDefinitionGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/related-elements/governance-definition-scopes/by-governance-definition/{2}?startFrom={3}&pageSize={4}";
        return this.getRelatedElements(userId, governanceDefinitionGUID, "governanceDefinitionGUID", "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/related-elements/governance-definition-scopes/by-governance-definition/{2}?startFrom={3}&pageSize={4}", startFrom, pageSize, "getGovernanceDefinitionScopes");
    }

    public List<GovernanceDefinitionElement> getScopedGovernanceDefinitions(String userId, String scopeGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getScopedGovernanceDefinitions";
        String guidPropertyName = "scopeGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/related-elements/governance-definition-scopes/by-scope/{2}?startFrom={3}&pageSize={4}";
        return this.getGovernanceDefinitionElements(userId, scopeGUID, "scopeGUID", "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/related-elements/governance-definition-scopes/by-scope/{2}?startFrom={3}&pageSize={4}", startFrom, pageSize, "getScopedGovernanceDefinitions");
    }

    public void setupGovernanceResponsibilityAssignment(String userId, String governanceResponsibilityGUID, String personRoleGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupGovernanceResponsibilityAssignment";
        String personRoleGUIDParameterName = "personRoleGUID";
        String governanceResponsibilityGUIDParameterName = "governanceResponsibilityGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/related-elements/{2}/governance-responsibility-assignments/{3}";
        this.setupRelationship(userId, personRoleGUID, "personRoleGUID", null, null, governanceResponsibilityGUID, "governanceResponsibilityGUID", "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/related-elements/{2}/governance-responsibility-assignments/{3}", "setupGovernanceResponsibilityAssignment");
    }

    public void clearGovernanceResponsibilityAssignment(String userId, String governanceResponsibilityGUID, String personRoleGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearGovernanceResponsibilityAssignment";
        String personRoleGUIDParameterName = "personRoleGUID";
        String governanceResponsibilityGUIDParameterName = "governanceResponsibilityGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/related-elements/{2}/governance-responsibility-assignments/{3}/delete";
        this.clearRelationship(userId, personRoleGUID, "personRoleGUID", null, governanceResponsibilityGUID, "governanceResponsibilityGUID", "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/related-elements/{2}/governance-responsibility-assignments/{3}/delete", "clearGovernanceResponsibilityAssignment");
    }

    public List<GovernanceRoleElement> getResponsibleRoles(String userId, String governanceResponsibilityGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getResponsibleRole";
        String guidPropertyName = "governanceResponsibilityGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/related-elements/governance-responsibility-assignments/by-responsibility/{2}?startFrom={3}&pageSize={4}";
        return this.getGovernanceRoleElements(userId, governanceResponsibilityGUID, "governanceResponsibilityGUID", "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/related-elements/governance-responsibility-assignments/by-responsibility/{2}?startFrom={3}&pageSize={4}", startFrom, pageSize, "getResponsibleRole");
    }

    public List<GovernanceDefinitionElement> getRoleResponsibilities(String userId, String personRoleGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getRoleResponsibilities";
        String guidPropertyName = "personRoleGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/related-elements/governance-responsibility-assignments/by-role/{2}?startFrom={3}&pageSize={4}";
        return this.getGovernanceDefinitionElements(userId, personRoleGUID, "personRoleGUID", "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/related-elements/governance-responsibility-assignments/by-role/{2}?startFrom={3}&pageSize={4}", startFrom, pageSize, "getRoleResponsibilities");
    }

    public void setupStakeholder(String userId, String elementGUID, StakeholderProperties properties, String stakeholderGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupStakeholder";
        String elementGUIDParameterName = "elementGUID";
        String stakeholderGUIDParameterName = "stakeholderGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/related-elements/{2}/stakeholders/{3}";
        this.setupRelationship(userId, elementGUID, "elementGUID", null, (RelationshipProperties)properties, stakeholderGUID, "stakeholderGUID", "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/related-elements/{2}/stakeholders/{3}", "setupStakeholder");
    }

    public void clearStakeholder(String userId, String elementGUID, String stakeholderGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearStakeholder";
        String elementGUIDParameterName = "elementGUID";
        String stakeholderGUIDParameterName = "stakeholderGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/related-elements/{2}/stakeholders/{3}/delete";
        this.clearRelationship(userId, elementGUID, "elementGUID", null, stakeholderGUID, "stakeholderGUID", "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/related-elements/{2}/stakeholders/{3}/delete", "clearStakeholder");
    }

    public List<RelatedElement> getStakeholders(String userId, String elementGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getStakeholders";
        String guidPropertyName = "elementGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/related-elements/stakeholders/by-commissioned-element/{2}?startFrom={3}&pageSize={4}";
        return this.getRelatedElements(userId, elementGUID, "elementGUID", "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/related-elements/stakeholders/by-commissioned-element/{2}?startFrom={3}&pageSize={4}", startFrom, pageSize, "getStakeholders");
    }

    public List<RelatedElement> getStakeholderCommissionedElements(String userId, String stakeholderGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getStakeholderCommissionedElements";
        String guidPropertyName = "stakeholderGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/related-elements/stakeholders/by-stakeholder/{2}?startFrom={3}&pageSize={4}";
        return this.getRelatedElements(userId, stakeholderGUID, "stakeholderGUID", "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/related-elements/stakeholders/by-stakeholder/{2}?startFrom={3}&pageSize={4}", startFrom, pageSize, "getStakeholderCommissionedElements");
    }

    public void setupAssignmentScope(String userId, String elementGUID, AssignmentScopeProperties properties, String scopeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupAssignmentScope";
        String elementGUIDParameterName = "elementGUID";
        String scopeGUIDParameterName = "scopeGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/related-elements/{2}/assignment-scopes/{3}";
        this.setupRelationship(userId, elementGUID, "elementGUID", null, (RelationshipProperties)properties, scopeGUID, "scopeGUID", "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/related-elements/{2}/assignment-scopes/{3}", "setupAssignmentScope");
    }

    public void clearAssignmentScope(String userId, String elementGUID, String scopeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearAssignmentScope";
        String elementGUIDParameterName = "elementGUID";
        String scopeGUIDParameterName = "scopeGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/related-elements/{2}/assignment-scopes/{3}/delete";
        this.clearRelationship(userId, elementGUID, "elementGUID", null, scopeGUID, "scopeGUID", "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/related-elements/{2}/assignment-scopes/{3}/delete", "clearAssignmentScope");
    }

    public List<RelatedElement> getAssignedScopes(String userId, String elementGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getAssignedScopes";
        String guidPropertyName = "elementGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/related-elements/assignment-scopes/by-assigned-actor/{2}?startFrom={3}&pageSize={4}";
        return this.getRelatedElements(userId, elementGUID, "elementGUID", "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/related-elements/assignment-scopes/by-assigned-actor/{2}?startFrom={3}&pageSize={4}", startFrom, pageSize, "getAssignedScopes");
    }

    public List<RelatedElement> getAssignedActors(String userId, String scopeGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getAssignedActors";
        String guidPropertyName = "scopeGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/related-elements/assignment-scopes/by-assigned-scope/{2}?startFrom={3}&pageSize={4}";
        return this.getRelatedElements(userId, scopeGUID, "scopeGUID", "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/related-elements/assignment-scopes/by-assigned-scope/{2}?startFrom={3}&pageSize={4}", startFrom, pageSize, "getAssignedActors");
    }

    public void setupResource(String userId, String elementGUID, ResourceListProperties properties, String resourceGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupResource";
        String elementGUIDParameterName = "elementGUID";
        String resourceGUIDParameterName = "resourceGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/related-elements/{2}/resource-list/{3}";
        this.setupRelationship(userId, elementGUID, "elementGUID", null, (RelationshipProperties)properties, resourceGUID, "resourceGUID", "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/related-elements/{2}/resource-list/{3}", "setupResource");
    }

    public void clearResource(String userId, String elementGUID, String resourceGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearResource";
        String elementGUIDParameterName = "elementGUID";
        String resourceGUIDParameterName = "resourceGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/related-elements/{2}/resource-list/{3}/delete";
        this.clearRelationship(userId, elementGUID, "elementGUID", null, resourceGUID, "resourceGUID", "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/related-elements/{2}/resource-list/{3}/delete", "clearResource");
    }

    public List<RelatedElement> getResourceList(String userId, String elementGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getResourceList";
        String guidPropertyName = "elementGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/related-elements/resource-list/by-assignee/{2}?startFrom={3}&pageSize={4}";
        return this.getRelatedElements(userId, elementGUID, "elementGUID", "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/related-elements/resource-list/by-assignee/{2}?startFrom={3}&pageSize={4}", startFrom, pageSize, "getResourceList");
    }

    public List<RelatedElement> getSupportedByResource(String userId, String resourceGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getSupportedByResource";
        String guidPropertyName = "resourceGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/related-elements/resource-list/by-resource/{2}?startFrom={3}&pageSize={4}";
        return this.getRelatedElements(userId, resourceGUID, "resourceGUID", "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/related-elements/resource-list/by-resource/{2}?startFrom={3}&pageSize={4}", startFrom, pageSize, "getSupportedByResource");
    }
}

