/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceprogram.client;

import java.util.List;
import org.odpi.openmetadata.accessservices.governanceprogram.api.GovernanceProgramReviewInterface;
import org.odpi.openmetadata.accessservices.governanceprogram.client.GovernanceProgramBaseClient;
import org.odpi.openmetadata.accessservices.governanceprogram.client.rest.GovernanceProgramRESTClient;
import org.odpi.openmetadata.accessservices.governanceprogram.metadataelements.GovernanceDefinitionElement;
import org.odpi.openmetadata.accessservices.governanceprogram.metadataelements.GovernanceDefinitionGraph;
import org.odpi.openmetadata.accessservices.governanceprogram.metadataelements.GovernanceMetricImplementation;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.ElementStubListResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceDefinitionGraphResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceDefinitionListResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceDefinitionResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceMetricImplementationListResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementStub;

public class GovernanceProgramReviewManager
extends GovernanceProgramBaseClient
implements GovernanceProgramReviewInterface {
    public GovernanceProgramReviewManager(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot);
    }

    public GovernanceProgramReviewManager(String serverName, String serverPlatformURLRoot, String userId, String password) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password);
    }

    public GovernanceProgramReviewManager(String serverName, String serverPlatformURLRoot, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, maxPageSize, auditLog);
    }

    public GovernanceProgramReviewManager(String serverName, String serverPlatformURLRoot, String userId, String password, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password, maxPageSize, auditLog);
    }

    public GovernanceProgramReviewManager(String serverName, String serverPlatformURLRoot, GovernanceProgramRESTClient restClient, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, restClient, maxPageSize);
    }

    public GovernanceDefinitionElement getGovernanceDefinitionByGUID(String userId, String definitionGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernanceDefinitionByGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/review/governance-definitions/{2}";
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceDefinitionByGUID");
        GovernanceDefinitionResponse restResult = this.restClient.callGovernanceDefinitionGetRESTCall("getGovernanceDefinitionByGUID", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/review/governance-definitions/{2}", this.serverName, userId, definitionGUID);
        return restResult.getElement();
    }

    public List<GovernanceDefinitionElement> getGovernanceDefinitionsForDomain(String userId, String typeName, int domainIdentifier, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernanceDefinitionsForDomain";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/review/governance-definitions/{2}/for-domain?domainIdentifier={3}&startFrom={4}&pageSize={5}";
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceDefinitionsForDomain");
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getGovernanceDefinitionsForDomain");
        GovernanceDefinitionListResponse restResult = this.restClient.callGovernanceDefinitionListGetRESTCall("getGovernanceDefinitionsForDomain", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/review/governance-definitions/{2}/for-domain?domainIdentifier={3}&startFrom={4}&pageSize={5}", this.serverName, userId, this.getTypeName(typeName), domainIdentifier, typeName, startFrom, queryPageSize);
        return restResult.getElements();
    }

    public List<GovernanceDefinitionElement> getGovernanceDefinitionsForDocId(String userId, String typeName, String docId, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernanceDefinitionsForDocId";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/review/governance-definitions/{2}/for-document-id/{3}?startFrom={4}&pageSize={5}";
        String docIdParameterName = "docId";
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceDefinitionsForDocId");
        this.invalidParameterHandler.validateName("docId", "docId", "getGovernanceDefinitionsForDocId");
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getGovernanceDefinitionsForDocId");
        GovernanceDefinitionListResponse restResult = this.restClient.callGovernanceDefinitionListGetRESTCall("getGovernanceDefinitionsForDocId", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/review/governance-definitions/{2}/for-document-id/{3}?startFrom={4}&pageSize={5}", this.serverName, userId, this.getTypeName(typeName), docId, startFrom, queryPageSize);
        return restResult.getElements();
    }

    private String getTypeName(String suppliedTypeName) {
        String defaultTypeName = "GovernanceDefinition";
        if (suppliedTypeName != null) {
            return suppliedTypeName;
        }
        return "GovernanceDefinition";
    }

    public GovernanceDefinitionGraph getGovernanceDefinitionInContext(String userId, String governanceDefinitionGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernanceDefinitionInContext";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/review/governance-definitions/{2}/in-context";
        String guidParameterName = "governanceDefinitionGUID";
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceDefinitionInContext");
        this.invalidParameterHandler.validateGUID(governanceDefinitionGUID, "governanceDefinitionGUID", "getGovernanceDefinitionInContext");
        GovernanceDefinitionGraphResponse restResult = this.restClient.callGovernanceDefinitionGraphGetRESTCall("getGovernanceDefinitionInContext", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/review/governance-definitions/{2}/in-context", this.serverName, userId, governanceDefinitionGUID);
        return restResult.getElement();
    }

    public List<GovernanceDefinitionElement> findGovernanceDefinitions(String userId, String typeName, String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findGovernanceDefinitions";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/review/governance-definitions/{2}/by-search-string?startFrom={3}&pageSize={4}";
        String searchStringParameterName = "searchString";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(this.serverPlatformURLRoot, this.serverName, "findGovernanceDefinitions");
        this.invalidParameterHandler.validateUserId(userId, "findGovernanceDefinitions");
        this.invalidParameterHandler.validateSearchString(searchString, searchString, "findGovernanceDefinitions");
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "findGovernanceDefinitions");
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        GovernanceDefinitionListResponse restResult = this.restClient.callGovernanceDefinitionListPostRESTCall("findGovernanceDefinitions", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/review/governance-definitions/{2}/by-search-string?startFrom={3}&pageSize={4}", requestBody, this.serverName, userId, this.getTypeName(typeName), startFrom, queryPageSize);
        return restResult.getElements();
    }

    public List<GovernanceMetricImplementation> getGovernanceDefinitionMetrics(String userId, String governanceDefinitionGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernanceDefinitionMetrics";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/review/governance-definitions/{2}/metrics-implementation?startFrom={3}&pageSize={4}";
        String guidParameterName = "governanceDefinitionGUID";
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceDefinitionMetrics");
        this.invalidParameterHandler.validateGUID(governanceDefinitionGUID, "governanceDefinitionGUID", "getGovernanceDefinitionMetrics");
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getGovernanceDefinitionMetrics");
        GovernanceMetricImplementationListResponse restResult = this.restClient.callGovernanceMetricsImplementationListGetRESTCall("getGovernanceDefinitionMetrics", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/review/governance-definitions/{2}/metrics-implementation?startFrom={3}&pageSize={4}", this.serverName, userId, governanceDefinitionGUID, startFrom, queryPageSize);
        return restResult.getElements();
    }

    public List<ElementStub> getGovernanceZoneMembers(String userId, String zoneName, String subTypeName, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getElementsGovernedByDefinition";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/review/governance-zones/{2}/members/{3}?startFrom={4}&pageSize={5}";
        String nameParameterName = "zoneName";
        String assetTypeName = "Asset";
        this.invalidParameterHandler.validateUserId(userId, "getElementsGovernedByDefinition");
        this.invalidParameterHandler.validateGUID(zoneName, "zoneName", "getElementsGovernedByDefinition");
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getElementsGovernedByDefinition");
        String typeName = "Asset";
        if (subTypeName != null) {
            typeName = subTypeName;
        }
        ElementStubListResponse restResult = this.restClient.callElementStubListGetRESTCall("getElementsGovernedByDefinition", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/review/governance-zones/{2}/members/{3}?startFrom={4}&pageSize={5}", this.serverName, userId, zoneName, typeName, startFrom, queryPageSize);
        return restResult.getElements();
    }
}

