/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceprogram.client;

import java.util.List;
import org.odpi.openmetadata.accessservices.governanceprogram.api.RightsManagementInterface;
import org.odpi.openmetadata.accessservices.governanceprogram.client.GovernanceProgramBaseClient;
import org.odpi.openmetadata.accessservices.governanceprogram.client.rest.GovernanceProgramRESTClient;
import org.odpi.openmetadata.accessservices.governanceprogram.metadataelements.LicenseElement;
import org.odpi.openmetadata.accessservices.governanceprogram.metadataelements.LicenseTypeElement;
import org.odpi.openmetadata.accessservices.governanceprogram.metadataelements.RelatedElement;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.GovernanceDefinitionProperties;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.GovernanceDefinitionStatus;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.LicenseProperties;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.LicenseTypeProperties;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.RelationshipProperties;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.LicenseListResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.LicenseTypeListResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.LicenseTypeResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;

public class RightsManager
extends GovernanceProgramBaseClient
implements RightsManagementInterface {
    public RightsManager(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot);
    }

    public RightsManager(String serverName, String serverPlatformURLRoot, String userId, String password) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password);
    }

    public RightsManager(String serverName, String serverPlatformURLRoot, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, maxPageSize, auditLog);
    }

    public RightsManager(String serverName, String serverPlatformURLRoot, String userId, String password, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password, maxPageSize, auditLog);
    }

    public RightsManager(String serverName, String serverPlatformURLRoot, GovernanceProgramRESTClient restClient, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, restClient, maxPageSize);
    }

    public String createLicenseType(String userId, LicenseTypeProperties properties, GovernanceDefinitionStatus initialStatus) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createLicenseType";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/license-types";
        String propertiesParameterName = "properties";
        return super.createGovernanceDefinition(userId, (GovernanceDefinitionProperties)properties, "properties", initialStatus, "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/license-types", "createLicenseType");
    }

    public void updateLicenseType(String userId, String licenseTypeGUID, boolean isMergeUpdate, LicenseTypeProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateLicenseType";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/license-types/{2}/update?isMergeUpdate={3}";
        String guidParameterName = "licenseTypeGUID";
        String propertiesParameterName = "properties";
        super.updateGovernanceDefinition(userId, licenseTypeGUID, "licenseTypeGUID", isMergeUpdate, (GovernanceDefinitionProperties)properties, "properties", "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/license-types/{2}/update?isMergeUpdate={3}", "updateLicenseType");
    }

    public void setLicenseTypeStatus(String userId, String licenseTypeGUID, GovernanceDefinitionStatus newStatus) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setGovernanceDefinitionStatus";
        String guidParameterName = "licenseTypeGUID";
        String propertiesParameterName = "newStatus";
        super.updateGovernanceDefinitionStatus(userId, licenseTypeGUID, "licenseTypeGUID", newStatus, "newStatus", "setGovernanceDefinitionStatus");
    }

    public void deleteLicenseType(String userId, String licenseTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "deleteLicenseType";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/license-types/{2}/delete";
        String guidParameterName = "licenseTypeGUID";
        super.removeReferenceable(userId, licenseTypeGUID, "licenseTypeGUID", "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/license-types/{2}/delete", "deleteLicenseType");
    }

    public LicenseTypeElement getLicenseTypeByGUID(String userId, String licenseTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getLicenseTypeByGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/license-types/{2}";
        String guidParameterName = "licenseTypeGUID";
        this.invalidParameterHandler.validateUserId(userId, "getLicenseTypeByGUID");
        this.invalidParameterHandler.validateGUID(licenseTypeGUID, "licenseTypeGUID", "getLicenseTypeByGUID");
        LicenseTypeResponse restResult = this.restClient.callLicenseTypeGetRESTCall("getLicenseTypeByGUID", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/license-types/{2}", this.serverName, userId, licenseTypeGUID);
        return restResult.getElement();
    }

    public LicenseTypeElement getLicenseTypeByDocId(String userId, String documentIdentifier) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getLicenseTypeByDocId";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/license-types/by-document-id/{2}";
        String documentIdParameterName = "documentId";
        this.invalidParameterHandler.validateUserId(userId, "getLicenseTypeByDocId");
        this.invalidParameterHandler.validateName(documentIdentifier, "documentId", "getLicenseTypeByDocId");
        LicenseTypeResponse restResult = this.restClient.callLicenseTypeGetRESTCall("getLicenseTypeByDocId", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/license-types/by-document-id/{2}", this.serverName, userId, documentIdentifier);
        return restResult.getElement();
    }

    public List<LicenseTypeElement> getLicenseTypesByTitle(String userId, String title, int startFrom, int pageSize) throws UserNotAuthorizedException, InvalidParameterException, PropertyServerException {
        String methodName = "getLicenseTypesByTitle";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/license-types/by-title?startFrom={2}&pageSize={3}";
        String titleParameterName = "title";
        this.invalidParameterHandler.validateUserId(userId, "getLicenseTypesByTitle");
        this.invalidParameterHandler.validateSearchString(title, "title", "getLicenseTypesByTitle");
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getLicenseTypesByTitle");
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setSearchString(title);
        requestBody.setSearchStringParameterName("title");
        LicenseTypeListResponse restResult = this.restClient.callLicenseTypeListPostRESTCall("getLicenseTypesByTitle", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/license-types/by-title?startFrom={2}&pageSize={3}", requestBody, this.serverName, userId, startFrom, queryPageSize);
        return restResult.getElements();
    }

    public List<LicenseTypeElement> getLicenseTypeByDomainId(String userId, int domainIdentifier, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getLicenseTypeByDomainId";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/license-types/by-domain/{2}?startFrom={3}&pageSize={4}";
        this.invalidParameterHandler.validateUserId(userId, "getLicenseTypeByDomainId");
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getLicenseTypeByDomainId");
        LicenseTypeListResponse restResult = this.restClient.callLicenseTypeListGetRESTCall("getLicenseTypeByDomainId", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/license-types/by-domain/{2}?startFrom={3}&pageSize={4}", this.serverName, userId, domainIdentifier, startFrom, queryPageSize);
        return restResult.getElements();
    }

    public String licenseElement(String userId, String elementGUID, String licenseTypeGUID, LicenseProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "licenseElement";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/elements/{2}/license-types/{3}";
        String elementGUIDParameterName = "elementGUID";
        String licenseTypeGUIDParameterName = "licenseTypeGUID";
        return super.setupMultiLinkRelationship(userId, elementGUID, "elementGUID", null, (RelationshipProperties)properties, licenseTypeGUID, "licenseTypeGUID", "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/elements/{2}/license-types/{3}", "licenseElement");
    }

    public void updateLicense(String userId, String licenseGUID, boolean isMergeUpdate, LicenseProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateLicense";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/licenses/{2}/update?isMergeUpdate={3}";
        String licenseGUIDParameterName = "licenseGUID";
        super.updateRelationship(userId, licenseGUID, "licenseGUID", isMergeUpdate, null, (RelationshipProperties)properties, "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/licenses/{2}/update?isMergeUpdate={3}", "updateLicense");
    }

    public void unlicenseElement(String userId, String licenseGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "unlicenseElement";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/licenses/{2}/delete";
        String licenseGUIDParameterName = "licenseGUID";
        super.clearRelationship(userId, licenseGUID, "licenseGUID", null, "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/licenses/{2}/delete", "unlicenseElement");
    }

    public List<RelatedElement> getLicensedElements(String userId, String licenseGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getLicencedElements";
        String guidParameter = "licenseGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/elements/licenses/{2}?&startFrom={3}&pageSize={4}";
        return super.getRelatedElements(userId, licenseGUID, "licenseGUID", "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/elements/licenses/{2}?&startFrom={3}&pageSize={4}", startFrom, pageSize, "getLicencedElements");
    }

    public List<LicenseElement> getLicenses(String userId, String elementGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getLicences";
        String guidParameterName = "elementGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/elements/{2}/licenses?&startFrom={3}&pageSize={4}";
        this.invalidParameterHandler.validateUserId(userId, "getLicences");
        this.invalidParameterHandler.validateGUID(elementGUID, "elementGUID", "getLicences");
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getLicences");
        LicenseListResponse restResult = this.restClient.callLicenseListGetRESTCall("getLicences", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/elements/{2}/licenses?&startFrom={3}&pageSize={4}", this.serverName, userId, elementGUID, startFrom, queryPageSize);
        return restResult.getElements();
    }
}

