/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceprogram.client;

import java.util.List;
import org.odpi.openmetadata.accessservices.governanceprogram.api.SubjectAreasInterface;
import org.odpi.openmetadata.accessservices.governanceprogram.client.GovernanceProgramBaseClient;
import org.odpi.openmetadata.accessservices.governanceprogram.client.rest.GovernanceProgramRESTClient;
import org.odpi.openmetadata.accessservices.governanceprogram.metadataelements.SubjectAreaDefinition;
import org.odpi.openmetadata.accessservices.governanceprogram.metadataelements.SubjectAreaElement;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.ClassificationProperties;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.ReferenceableProperties;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.SubjectAreaClassificationProperties;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.SubjectAreaProperties;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.SubjectAreaDefinitionResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.SubjectAreaListResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.SubjectAreaResponse;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementStub;

public class SubjectAreaManager
extends GovernanceProgramBaseClient
implements SubjectAreasInterface {
    public SubjectAreaManager(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot);
    }

    public SubjectAreaManager(String serverName, String serverPlatformURLRoot, String userId, String password) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password);
    }

    public SubjectAreaManager(String serverName, String serverPlatformURLRoot, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, maxPageSize, auditLog);
    }

    public SubjectAreaManager(String serverName, String serverPlatformURLRoot, String userId, String password, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password, maxPageSize, auditLog);
    }

    public SubjectAreaManager(String serverName, String serverPlatformURLRoot, GovernanceProgramRESTClient restClient, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, restClient, maxPageSize);
    }

    public String createSubjectArea(String userId, SubjectAreaProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createSubjectArea";
        String propertiesParameter = "properties";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/subject-areas";
        return super.createReferenceable(userId, (ReferenceableProperties)properties, "properties", "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/subject-areas", "createSubjectArea");
    }

    public void updateSubjectArea(String userId, String subjectAreaGUID, boolean isMergeUpdate, SubjectAreaProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateSubjectArea";
        String guidParameter = "subjectAreaGUID";
        String propertiesParameter = "properties";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/subject-areas/{2}?isMergeUpdate={3}";
        super.updateReferenceable(userId, subjectAreaGUID, "subjectAreaGUID", isMergeUpdate, (ReferenceableProperties)properties, "properties", "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/subject-areas/{2}?isMergeUpdate={3}", "updateSubjectArea");
    }

    public void deleteSubjectArea(String userId, String subjectAreaGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "deleteSubjectArea";
        String guidParameter = "subjectAreaGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/subject-areas/{2}/delete}";
        super.removeReferenceable(userId, subjectAreaGUID, "subjectAreaGUID", "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/subject-areas/{2}/delete}", "deleteSubjectArea");
    }

    public void linkSubjectAreasInHierarchy(String userId, String parentSubjectAreaGUID, String childSubjectAreaGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "linkSubjectAreasInHierarchy";
        String parentSubjectAreaGUIDParameterName = "parentSubjectAreaGUID";
        String childSubjectAreaGUIDParameterName = "childSubjectAreaGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/subject-areas/{2}/nested-subject-area/{3}/link";
        super.setupRelationship(userId, parentSubjectAreaGUID, "parentSubjectAreaGUID", null, null, childSubjectAreaGUID, "childSubjectAreaGUID", "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/subject-areas/{2}/nested-subject-area/{3}/link", "linkSubjectAreasInHierarchy");
    }

    public void unlinkSubjectAreasInHierarchy(String userId, String parentSubjectAreaGUID, String childSubjectAreaGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "unlinkSubjectAreasInHierarchy";
        String parentSubjectAreaGUIDParameterName = "parentSubjectAreaGUID";
        String childSubjectAreaGUIDParameterName = "childSubjectAreaGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/subject-areas/{2}/nested-subject-area/{3}/unlink";
        super.clearRelationship(userId, parentSubjectAreaGUID, "parentSubjectAreaGUID", null, childSubjectAreaGUID, "childSubjectAreaGUID", "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/subject-areas/{2}/nested-subject-area/{3}/unlink", "unlinkSubjectAreasInHierarchy");
    }

    public SubjectAreaElement getSubjectAreaByGUID(String userId, String subjectAreaGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getSubjectAreaByGUID";
        String guidParameter = "subjectAreaGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/subject-areas/{2}";
        this.invalidParameterHandler.validateUserId(userId, "getSubjectAreaByGUID");
        this.invalidParameterHandler.validateGUID(subjectAreaGUID, "subjectAreaGUID", "getSubjectAreaByGUID");
        SubjectAreaResponse restResult = this.restClient.callSubjectAreaGetRESTCall("getSubjectAreaByGUID", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/subject-areas/{2}", this.serverName, userId, subjectAreaGUID);
        return restResult.getElement();
    }

    public SubjectAreaElement getSubjectAreaByName(String userId, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getSubjectAreaByName";
        String qualifiedNameParameter = "qualifiedName";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/subject-areas/name/{2}";
        this.invalidParameterHandler.validateUserId(userId, "getSubjectAreaByName");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "getSubjectAreaByName");
        SubjectAreaResponse restResult = this.restClient.callSubjectAreaGetRESTCall("getSubjectAreaByName", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/subject-areas/name/{2}", this.serverName, userId, qualifiedName);
        return restResult.getElement();
    }

    public List<SubjectAreaElement> getSubjectAreasForDomain(String userId, int domainIdentifier, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getSubjectAreasForDomain";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/subject-areas/for-domain?domainIdentifier={2}&startFrom={3}&pageSize={4}";
        this.invalidParameterHandler.validateUserId(userId, "getSubjectAreasForDomain");
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getSubjectAreasForDomain");
        SubjectAreaListResponse restResult = this.restClient.callSubjectAreaListGetRESTCall("getSubjectAreasForDomain", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/subject-areas/for-domain?domainIdentifier={2}&startFrom={3}&pageSize={4}", this.serverName, userId, domainIdentifier, startFrom, queryPageSize);
        return restResult.getElementList();
    }

    public SubjectAreaDefinition getSubjectAreaDefinitionByGUID(String userId, String subjectAreaGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getSubjectAreaDefinitionByGUID";
        String guidParameter = "subjectAreaGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/subject-areas/{2}/with-definitions";
        this.invalidParameterHandler.validateUserId(userId, "getSubjectAreaDefinitionByGUID");
        this.invalidParameterHandler.validateGUID(subjectAreaGUID, "subjectAreaGUID", "getSubjectAreaDefinitionByGUID");
        SubjectAreaDefinitionResponse restResult = this.restClient.callSubjectAreaDefinitionGetRESTCall("getSubjectAreaDefinitionByGUID", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/subject-areas/{2}/with-definitions", this.serverName, userId, subjectAreaGUID);
        return restResult.getProperties();
    }

    public void addSubjectAreaMemberClassification(String userId, String elementGUID, SubjectAreaClassificationProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addSubjectAreaMemberClassification";
        String guidParameter = "elementGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/elements/{2}/subject-area";
        super.setReferenceableClassification(userId, elementGUID, "elementGUID", (ClassificationProperties)properties, "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/elements/{2}/subject-area", "addSubjectAreaMemberClassification");
    }

    public void deleteSubjectAreaMemberClassification(String userId, String elementGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "deleteSubjectAreaMemberClassification";
        String guidParameter = "elementGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/elements/{2}/subject-area/delete";
        super.removeReferenceableClassification(userId, elementGUID, "elementGUID", "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/elements/{2}/subject-area/delete", "deleteSubjectAreaMemberClassification");
    }

    public List<ElementStub> getMembersOfSubjectArea(String userId, String subjectAreaName, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getMembersOfSubjectArea";
        String nameParameter = "subjectAreaName";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/subject-areas/{2}/members?startFrom={3}&pageSize={4}";
        return super.getElementStubsByName(userId, subjectAreaName, "subjectAreaName", "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/subject-areas/{2}/members?startFrom={3}&pageSize={4}", startFrom, pageSize, "getMembersOfSubjectArea");
    }
}

