/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceprogram.client;

import java.util.List;
import org.odpi.openmetadata.accessservices.governanceprogram.api.GovernanceZonesInterface;
import org.odpi.openmetadata.accessservices.governanceprogram.client.GovernanceProgramBaseClient;
import org.odpi.openmetadata.accessservices.governanceprogram.client.rest.GovernanceProgramRESTClient;
import org.odpi.openmetadata.accessservices.governanceprogram.metadataelements.GovernanceZoneDefinition;
import org.odpi.openmetadata.accessservices.governanceprogram.metadataelements.GovernanceZoneElement;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.GovernanceZoneProperties;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.ReferenceableProperties;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceZoneDefinitionResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceZoneListResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceZoneResponse;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;

public class GovernanceZoneManager
extends GovernanceProgramBaseClient
implements GovernanceZonesInterface {
    public GovernanceZoneManager(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot);
    }

    public GovernanceZoneManager(String serverName, String serverPlatformURLRoot, String userId, String password) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password);
    }

    public GovernanceZoneManager(String serverName, String serverPlatformURLRoot, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, maxPageSize, auditLog);
    }

    public GovernanceZoneManager(String serverName, String serverPlatformURLRoot, String userId, String password, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password, maxPageSize, auditLog);
    }

    public GovernanceZoneManager(String serverName, String serverPlatformURLRoot, GovernanceProgramRESTClient restClient, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, restClient, maxPageSize);
    }

    public String createGovernanceZone(String userId, GovernanceZoneProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createGovernanceZone";
        String propertiesParameter = "properties";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-zones";
        return super.createReferenceable(userId, (ReferenceableProperties)properties, "properties", urlTemplate, "createGovernanceZone");
    }

    public void updateGovernanceZone(String userId, String zoneGUID, boolean isMergeUpdate, GovernanceZoneProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateGovernanceZone";
        String guidParameter = "zoneGUID";
        String propertiesParameter = "properties";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-zones/{2}?isMergeUpdate={3}";
        super.updateReferenceable(userId, zoneGUID, "zoneGUID", isMergeUpdate, (ReferenceableProperties)properties, "properties", urlTemplate, "updateGovernanceZone");
    }

    public void deleteGovernanceZone(String userId, String zoneGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "deleteGovernanceZone";
        String guidParameter = "zoneGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-zones/{2}/delete}";
        super.removeReferenceable(userId, zoneGUID, "zoneGUID", urlTemplate, "deleteGovernanceZone");
    }

    public void linkZonesInHierarchy(String userId, String parentZoneGUID, String childZoneGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "linkZonesInHierarchy";
        String parentZoneGUIDParameterName = "parentZoneGUID";
        String childZoneGUIDParameterName = "childZoneGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-zones/{2}/nested-zone/{3}/link";
        super.setupRelationship(userId, parentZoneGUID, "parentZoneGUID", null, null, childZoneGUID, "childZoneGUID", urlTemplate, "linkZonesInHierarchy");
    }

    public void unlinkZonesInHierarchy(String userId, String parentZoneGUID, String childZoneGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "unlinkZonesInHierarchy";
        String parentZoneGUIDParameterName = "parentZoneGUID";
        String childZoneGUIDParameterName = "childZoneGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-zones/{2}/nested-zone/{3}/unlink";
        this.clearRelationship(userId, parentZoneGUID, "parentZoneGUID", null, childZoneGUID, "childZoneGUID", urlTemplate, "unlinkZonesInHierarchy");
    }

    public GovernanceZoneElement getGovernanceZoneByGUID(String userId, String zoneGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernanceZoneByGUID";
        String guidParameter = "zoneGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-zones/{2}";
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceZoneByGUID");
        this.invalidParameterHandler.validateGUID(zoneGUID, "zoneGUID", "getGovernanceZoneByGUID");
        GovernanceZoneResponse restResult = this.restClient.callGovernanceZoneGetRESTCall("getGovernanceZoneByGUID", urlTemplate, this.serverName, userId, zoneGUID);
        return restResult.getElement();
    }

    public GovernanceZoneElement getGovernanceZoneByName(String userId, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernanceZoneByName";
        String qualifiedNameParameter = "qualifiedName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-zones/name/{2}";
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceZoneByName");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "getGovernanceZoneByName");
        GovernanceZoneResponse restResult = this.restClient.callGovernanceZoneGetRESTCall("getGovernanceZoneByName", urlTemplate, this.serverName, userId, qualifiedName);
        return restResult.getElement();
    }

    public List<GovernanceZoneElement> getGovernanceZonesForDomain(String userId, int domainIdentifier, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernanceZonesForDomain";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-zones/for-domain?domainIdentifier={2}&startFrom={3}&pageSize={4}";
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceZonesForDomain");
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getGovernanceZonesForDomain");
        GovernanceZoneListResponse restResult = this.restClient.callGovernanceZoneListGetRESTCall("getGovernanceZonesForDomain", urlTemplate, this.serverName, userId, domainIdentifier, startFrom, queryPageSize);
        return restResult.getElementList();
    }

    public GovernanceZoneDefinition getGovernanceZoneDefinitionByGUID(String userId, String zoneGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernanceZoneDefinitionByGUID";
        String guidParameter = "zoneGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-zones/{2}/with-definitions";
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceZoneDefinitionByGUID");
        this.invalidParameterHandler.validateGUID(zoneGUID, "zoneGUID", "getGovernanceZoneDefinitionByGUID");
        GovernanceZoneDefinitionResponse restResult = this.restClient.callGovernanceZoneDefinitionGetRESTCall("getGovernanceZoneDefinitionByGUID", urlTemplate, this.serverName, userId, zoneGUID);
        return restResult.getProperties();
    }
}

