/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceprogram.client;

import java.util.List;
import org.odpi.openmetadata.accessservices.governanceprogram.api.GovernanceMetricsInterface;
import org.odpi.openmetadata.accessservices.governanceprogram.client.rest.GovernanceProgramRESTClient;
import org.odpi.openmetadata.accessservices.governanceprogram.metadataelements.GovernanceMetricElement;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.GovernanceMetricProperties;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceMetricListResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceMetricResponse;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.StringRequestBody;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;

public class GovernanceMetricsManager
implements GovernanceMetricsInterface {
    private String serverName;
    private String serverPlatformURLRoot;
    private GovernanceProgramRESTClient restClient;
    private InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
    private NullRequestBody nullRequestBody = new NullRequestBody();

    public GovernanceMetricsManager(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        String methodName = "Constructor (no security)";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (no security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new GovernanceProgramRESTClient(serverName, serverPlatformURLRoot);
    }

    public GovernanceMetricsManager(String serverName, String serverPlatformURLRoot, String userId, String password) throws InvalidParameterException {
        String methodName = "Constructor (with security)";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (with security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new GovernanceProgramRESTClient(serverName, serverPlatformURLRoot, userId, password);
    }

    public GovernanceMetricsManager(String serverName, String serverPlatformURLRoot, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        String methodName = "Constructor (no security)";
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (no security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new GovernanceProgramRESTClient(serverName, serverPlatformURLRoot, auditLog);
    }

    public GovernanceMetricsManager(String serverName, String serverPlatformURLRoot, String userId, String password, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        String methodName = "Constructor (with security)";
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (with security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new GovernanceProgramRESTClient(serverName, serverPlatformURLRoot, userId, password, auditLog);
    }

    public GovernanceMetricsManager(String serverName, String serverPlatformURLRoot, GovernanceProgramRESTClient restClient, int maxPageSize) throws InvalidParameterException {
        String methodName = "Constructor (with security)";
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (with security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = restClient;
    }

    public String createGovernanceMetric(String userId, GovernanceMetricProperties metricProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createGovernanceMetric";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-metrics";
        String qualifiedNameParameterName = "qualifiedName";
        String propertiesParameterName = "metricProperties";
        this.invalidParameterHandler.validateUserId(userId, "createGovernanceMetric");
        this.invalidParameterHandler.validateObject((Object)metricProperties, "metricProperties", "createGovernanceMetric");
        this.invalidParameterHandler.validateName(metricProperties.getQualifiedName(), "qualifiedName", "createGovernanceMetric");
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createGovernanceMetric", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-metrics", metricProperties, new Object[]{this.serverName, userId});
        return restResult.getGUID();
    }

    public void updateGovernanceMetric(String userId, String metricGUID, boolean isMergeUpdate, GovernanceMetricProperties metricProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateGovernanceMetric";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-metrics/{2}/update?isMergeUpdate={4}";
        String qualifiedNameParameterName = "qualifiedName";
        String guidParameterName = "metricGUID";
        String propertiesParameterName = "metricProperties";
        this.invalidParameterHandler.validateUserId(userId, "updateGovernanceMetric");
        this.invalidParameterHandler.validateGUID(metricGUID, "metricGUID", "updateGovernanceMetric");
        this.invalidParameterHandler.validateObject((Object)metricProperties, "metricProperties", "updateGovernanceMetric");
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(metricProperties.getQualifiedName(), "qualifiedName", "updateGovernanceMetric");
        }
        this.restClient.callVoidPostRESTCall("updateGovernanceMetric", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-metrics/{2}/update?isMergeUpdate={4}", metricProperties, new Object[]{this.serverName, userId, metricGUID, isMergeUpdate});
    }

    public void deleteGovernanceMetric(String userId, String metricGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "deleteExternalReference";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-metrics/{2}/delete";
        String guidParameterName = "metricGUID";
        this.invalidParameterHandler.validateUserId(userId, "deleteExternalReference");
        this.invalidParameterHandler.validateGUID(metricGUID, "metricGUID", "deleteExternalReference");
        this.restClient.callVoidPostRESTCall("deleteExternalReference", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-metrics/{2}/delete", this.nullRequestBody, new Object[]{this.serverName, userId, metricGUID});
    }

    public void setupGovernanceDefinitionMetric(String userId, String metricGUID, String governanceDefinitionGUID, String rationale) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupGovernanceDefinitionMetric";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-metrics/{2}/governance-definitions/{3}/link";
        String metricGUIDParameterName = "metricGUID";
        String governanceDefinitionGUIDParameterName = "governanceDefinitionGUID";
        this.invalidParameterHandler.validateUserId(userId, "setupGovernanceDefinitionMetric");
        this.invalidParameterHandler.validateGUID(metricGUID, "metricGUID", "setupGovernanceDefinitionMetric");
        this.invalidParameterHandler.validateGUID(governanceDefinitionGUID, "governanceDefinitionGUID", "setupGovernanceDefinitionMetric");
        StringRequestBody requestBody = new StringRequestBody();
        requestBody.setString(rationale);
        this.restClient.callVoidPostRESTCall("setupGovernanceDefinitionMetric", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-metrics/{2}/governance-definitions/{3}/link", requestBody, new Object[]{this.serverName, userId, metricGUID, governanceDefinitionGUID});
    }

    public void clearGovernanceDefinitionMetric(String userId, String metricGUID, String governanceDefinitionGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupGovernanceDefinitionMetric";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-metrics/{2}/governance-definitions/{3}/unlink";
        String metricGUIDParameterName = "metricGUID";
        String governanceDefinitionGUIDParameterName = "governanceDefinitionGUID";
        this.invalidParameterHandler.validateUserId(userId, "setupGovernanceDefinitionMetric");
        this.invalidParameterHandler.validateGUID(metricGUID, "metricGUID", "setupGovernanceDefinitionMetric");
        this.invalidParameterHandler.validateGUID(governanceDefinitionGUID, "governanceDefinitionGUID", "setupGovernanceDefinitionMetric");
        this.restClient.callVoidPostRESTCall("setupGovernanceDefinitionMetric", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-metrics/{2}/governance-definitions/{3}/unlink", this.nullRequestBody, new Object[]{this.serverName, userId, metricGUID, governanceDefinitionGUID});
    }

    public GovernanceMetricElement getGovernanceMetricByGUID(String userId, String metricGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernanceMetricByGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-metrics/{2}";
        String guidParameterName = "metricGUID";
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceMetricByGUID");
        this.invalidParameterHandler.validateGUID(metricGUID, "metricGUID", "getGovernanceMetricByGUID");
        GovernanceMetricResponse restResult = this.restClient.callGovernanceMetricGetRESTCall("getGovernanceMetricByGUID", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-metrics/{2}", this.serverName, userId, metricGUID);
        return restResult.getElement();
    }

    public List<GovernanceMetricElement> findGovernanceMetrics(String userId, String searchString, int startFrom, int pageSize) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "findGovernanceMetrics";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-metrics/by-search-string?startFrom={2}&pageSize={3}";
        String searchStringParameterName = "searchString";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(this.serverPlatformURLRoot, this.serverName, "findGovernanceMetrics");
        this.invalidParameterHandler.validateUserId(userId, "findGovernanceMetrics");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findGovernanceMetrics");
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "findGovernanceMetrics");
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        GovernanceMetricListResponse restResult = this.restClient.callGovernanceMetricListPostRESTCall("findGovernanceMetrics", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-metrics/by-search-string?startFrom={2}&pageSize={3}", requestBody, this.serverName, userId, startFrom, queryPageSize);
        return restResult.getElements();
    }
}

