/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceprogram.client;

import java.util.List;
import org.odpi.openmetadata.accessservices.governanceprogram.api.SubjectAreasInterface;
import org.odpi.openmetadata.accessservices.governanceprogram.client.rest.GovernanceProgramRESTClient;
import org.odpi.openmetadata.accessservices.governanceprogram.metadataelements.SubjectAreaDefinition;
import org.odpi.openmetadata.accessservices.governanceprogram.metadataelements.SubjectAreaElement;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.SubjectAreaProperties;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.SubjectAreaDefinitionResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.SubjectAreaListResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.SubjectAreaResponse;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;

public class SubjectAreaManager
implements SubjectAreasInterface {
    private String serverName;
    private String serverPlatformURLRoot;
    private GovernanceProgramRESTClient restClient;
    private InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
    private NullRequestBody nullRequestBody = new NullRequestBody();

    public SubjectAreaManager(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        String methodName = "Constructor (no security)";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (no security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new GovernanceProgramRESTClient(serverName, serverPlatformURLRoot);
    }

    public SubjectAreaManager(String serverName, String serverPlatformURLRoot, String userId, String password) throws InvalidParameterException {
        String methodName = "Constructor (with security)";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (with security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new GovernanceProgramRESTClient(serverName, serverPlatformURLRoot, userId, password);
    }

    public SubjectAreaManager(String serverName, String serverPlatformURLRoot, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        String methodName = "Constructor (no security)";
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (no security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new GovernanceProgramRESTClient(serverName, serverPlatformURLRoot, auditLog);
    }

    public SubjectAreaManager(String serverName, String serverPlatformURLRoot, String userId, String password, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        String methodName = "Constructor (with security)";
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (with security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new GovernanceProgramRESTClient(serverName, serverPlatformURLRoot, userId, password, auditLog);
    }

    public SubjectAreaManager(String serverName, String serverPlatformURLRoot, GovernanceProgramRESTClient restClient, int maxPageSize) throws InvalidParameterException {
        String methodName = "Constructor (with security)";
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (with security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = restClient;
    }

    public String createSubjectArea(String userId, SubjectAreaProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createSubjectArea";
        String qualifiedNameParameter = "qualifiedName";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/subject-areas";
        this.invalidParameterHandler.validateUserId(userId, "createSubjectArea");
        this.invalidParameterHandler.validateObject((Object)properties, "qualifiedName", "createSubjectArea");
        this.invalidParameterHandler.validateName(properties.getQualifiedName(), "qualifiedName", "createSubjectArea");
        GUIDResponse response = this.restClient.callGUIDPostRESTCall("createSubjectArea", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/subject-areas", properties, new Object[]{this.serverName, userId});
        return response.getGUID();
    }

    public void updateSubjectArea(String userId, String subjectAreaGUID, boolean isMergeUpdate, SubjectAreaProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateSubjectArea";
        String guidParameter = "subjectAreaGUID";
        String qualifiedNameParameter = "qualifiedName";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-zones/{2}?isMergeUpdate={3}";
        this.invalidParameterHandler.validateUserId(userId, "updateSubjectArea");
        this.invalidParameterHandler.validateGUID(subjectAreaGUID, "subjectAreaGUID", "updateSubjectArea");
        this.invalidParameterHandler.validateObject((Object)properties, "qualifiedName", "updateSubjectArea");
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(properties.getQualifiedName(), "qualifiedName", "updateSubjectArea");
        }
        this.restClient.callVoidPostRESTCall("updateSubjectArea", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-zones/{2}?isMergeUpdate={3}", properties, new Object[]{this.serverName, userId, subjectAreaGUID, isMergeUpdate});
    }

    public void deleteSubjectArea(String userId, String subjectAreaGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "deleteSubjectArea";
        String guidParameter = "subjectAreaGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/subject-areas/{2}/delete}";
        this.invalidParameterHandler.validateUserId(userId, "deleteSubjectArea");
        this.invalidParameterHandler.validateGUID(subjectAreaGUID, "subjectAreaGUID", "deleteSubjectArea");
        this.restClient.callVoidPostRESTCall("deleteSubjectArea", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/subject-areas/{2}/delete}", this.nullRequestBody, new Object[]{this.serverName, userId, subjectAreaGUID});
    }

    public void linkSubjectAreasInHierarchy(String userId, String parentSubjectAreaGUID, String childSubjectAreaGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "linkSubjectAreasInHierarchy";
        String parentSubjectAreaGUIDParameterName = "parentSubjectAreaGUID";
        String childSubjectAreaGUIDParameterName = "childSubjectAreaGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/subject-areas/{2}/nested-area/{3}/link";
        this.invalidParameterHandler.validateUserId(userId, "linkSubjectAreasInHierarchy");
        this.invalidParameterHandler.validateGUID(parentSubjectAreaGUID, "parentSubjectAreaGUID", "linkSubjectAreasInHierarchy");
        this.invalidParameterHandler.validateGUID(childSubjectAreaGUID, "childSubjectAreaGUID", "linkSubjectAreasInHierarchy");
        this.restClient.callVoidPostRESTCall("linkSubjectAreasInHierarchy", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/subject-areas/{2}/nested-area/{3}/link", this.nullRequestBody, new Object[]{this.serverName, userId, parentSubjectAreaGUID, childSubjectAreaGUID});
    }

    public void unlinkSubjectAreasInHierarchy(String userId, String parentSubjectAreaGUID, String childSubjectAreaGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "unlinkSubjectAreasInHierarchy";
        String parentSubjectAreaGUIDParameterName = "parentSubjectAreaGUID";
        String childSubjectAreaGUIDParameterName = "childSubjectAreaGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/subject-areas/{2}/nested-area/{3}/unlink";
        this.invalidParameterHandler.validateUserId(userId, "unlinkSubjectAreasInHierarchy");
        this.invalidParameterHandler.validateGUID(parentSubjectAreaGUID, "parentSubjectAreaGUID", "unlinkSubjectAreasInHierarchy");
        this.invalidParameterHandler.validateGUID(childSubjectAreaGUID, "childSubjectAreaGUID", "unlinkSubjectAreasInHierarchy");
        this.restClient.callVoidPostRESTCall("unlinkSubjectAreasInHierarchy", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/subject-areas/{2}/nested-area/{3}/unlink", this.nullRequestBody, new Object[]{this.serverName, userId, parentSubjectAreaGUID, childSubjectAreaGUID});
    }

    public void linkSubjectAreaToGovernanceDefinition(String userId, String subjectAreaGUID, String definitionGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "linkSubjectAreaToGovernanceDefinition";
        String subjectAreaGUIDParameterName = "subjectAreaGUID";
        String definitionGUIDParameterName = "definitionGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/subject-areas/{2}/governed-by/{3}/link";
        this.invalidParameterHandler.validateUserId(userId, "linkSubjectAreaToGovernanceDefinition");
        this.invalidParameterHandler.validateGUID(subjectAreaGUID, "subjectAreaGUID", "linkSubjectAreaToGovernanceDefinition");
        this.invalidParameterHandler.validateGUID(definitionGUID, "definitionGUID", "linkSubjectAreaToGovernanceDefinition");
        this.restClient.callVoidPostRESTCall("linkSubjectAreaToGovernanceDefinition", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/subject-areas/{2}/governed-by/{3}/link", this.nullRequestBody, new Object[]{this.serverName, userId, subjectAreaGUID, definitionGUID});
    }

    public void unlinkSubjectAreaFromGovernanceDefinition(String userId, String subjectAreaGUID, String definitionGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "unlinkSubjectAreaFromGovernanceDefinition";
        String subjectAreaGUIDParameterName = "subjectAreaGUID";
        String definitionGUIDParameterName = "definitionGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-zones/{2}/governed-by/{3}/unlink";
        this.invalidParameterHandler.validateUserId(userId, "unlinkSubjectAreaFromGovernanceDefinition");
        this.invalidParameterHandler.validateGUID(subjectAreaGUID, "subjectAreaGUID", "unlinkSubjectAreaFromGovernanceDefinition");
        this.invalidParameterHandler.validateGUID(definitionGUID, "definitionGUID", "unlinkSubjectAreaFromGovernanceDefinition");
        this.restClient.callVoidPostRESTCall("unlinkSubjectAreaFromGovernanceDefinition", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-zones/{2}/governed-by/{3}/unlink", this.nullRequestBody, new Object[]{this.serverName, userId, subjectAreaGUID, definitionGUID});
    }

    public SubjectAreaElement getSubjectAreaByGUID(String userId, String subjectAreaGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getSubjectAreaByGUID";
        String guidParameter = "subjectAreaGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/subject-areas/{2}";
        this.invalidParameterHandler.validateUserId(userId, "getSubjectAreaByGUID");
        this.invalidParameterHandler.validateGUID(subjectAreaGUID, "subjectAreaGUID", "getSubjectAreaByGUID");
        SubjectAreaResponse restResult = this.restClient.callSubjectAreaGetRESTCall("getSubjectAreaByGUID", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/subject-areas/{2}", this.serverName, userId, subjectAreaGUID);
        return restResult.getElement();
    }

    public SubjectAreaElement getSubjectAreaByName(String userId, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getSubjectAreaByName";
        String qualifiedNameParameter = "qualifiedName";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/subject-areas/name/{2}";
        this.invalidParameterHandler.validateUserId(userId, "getSubjectAreaByName");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "getSubjectAreaByName");
        SubjectAreaResponse restResult = this.restClient.callSubjectAreaGetRESTCall("getSubjectAreaByName", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/subject-areas/name/{2}", this.serverName, userId, qualifiedName);
        return restResult.getElement();
    }

    public List<SubjectAreaElement> getSubjectAreasForDomain(String userId, int domainIdentifier, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getSubjectAreasForDomain";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/subject-areas/for-domain?domainIdentifier={2}&startFrom={3}&pageSize={4}";
        this.invalidParameterHandler.validateUserId(userId, "getSubjectAreasForDomain");
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getSubjectAreasForDomain");
        SubjectAreaListResponse restResult = this.restClient.callSubjectAreaListGetRESTCall("getSubjectAreasForDomain", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/subject-areas/for-domain?domainIdentifier={2}&startFrom={3}&pageSize={4}", this.serverName, userId, domainIdentifier, startFrom, queryPageSize);
        return restResult.getElementList();
    }

    public SubjectAreaDefinition getSubjectAreaDefinitionByGUID(String userId, String subjectAreaGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getSubjectAreaDefinitionByGUID";
        String guidParameter = "subjectAreaGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/subject-areas/{2}/with-definitions";
        this.invalidParameterHandler.validateUserId(userId, "getSubjectAreaDefinitionByGUID");
        this.invalidParameterHandler.validateGUID(subjectAreaGUID, "subjectAreaGUID", "getSubjectAreaDefinitionByGUID");
        SubjectAreaDefinitionResponse restResult = this.restClient.callSubjectAreaDefinitionGetRESTCall("getSubjectAreaDefinitionByGUID", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/subject-areas/{2}/with-definitions", this.serverName, userId, subjectAreaGUID);
        return restResult.getProperties();
    }
}

