/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceprogram.client;

import java.util.List;
import org.odpi.openmetadata.accessservices.governanceprogram.api.GovernanceDomainInterface;
import org.odpi.openmetadata.accessservices.governanceprogram.client.rest.GovernanceProgramRESTClient;
import org.odpi.openmetadata.accessservices.governanceprogram.metadataelements.GovernanceDomainElement;
import org.odpi.openmetadata.accessservices.governanceprogram.metadataelements.GovernanceDomainSetElement;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.GovernanceDomainProperties;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.GovernanceDomainSetProperties;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceDomainListResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceDomainResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceDomainSetListResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceDomainSetResponse;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;

public class GovernanceDomainManager
implements GovernanceDomainInterface {
    private String serverName;
    private String serverPlatformURLRoot;
    private GovernanceProgramRESTClient restClient;
    private InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
    private NullRequestBody nullRequestBody = new NullRequestBody();

    public GovernanceDomainManager(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        String methodName = "Constructor (no security)";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (no security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new GovernanceProgramRESTClient(serverName, serverPlatformURLRoot);
    }

    public GovernanceDomainManager(String serverName, String serverPlatformURLRoot, String userId, String password) throws InvalidParameterException {
        String methodName = "Constructor (with security)";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (with security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new GovernanceProgramRESTClient(serverName, serverPlatformURLRoot, userId, password);
    }

    public GovernanceDomainManager(String serverName, String serverPlatformURLRoot, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        String methodName = "Constructor (no security)";
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (no security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new GovernanceProgramRESTClient(serverName, serverPlatformURLRoot, auditLog);
    }

    public GovernanceDomainManager(String serverName, String serverPlatformURLRoot, String userId, String password, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        String methodName = "Constructor (with security)";
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (with security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new GovernanceProgramRESTClient(serverName, serverPlatformURLRoot, userId, password, auditLog);
    }

    public GovernanceDomainManager(String serverName, String serverPlatformURLRoot, GovernanceProgramRESTClient restClient, int maxPageSize) throws InvalidParameterException {
        String methodName = "Constructor (with security)";
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (with security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = restClient;
    }

    public String createStandardGovernanceDomains(String userId) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createStandardGovernanceDomains";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-domain-sets/standard-set";
        this.invalidParameterHandler.validateUserId(userId, "createStandardGovernanceDomains");
        GUIDResponse response = this.restClient.callGUIDPostRESTCall("createStandardGovernanceDomains", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-domain-sets/standard-set", this.nullRequestBody, new Object[]{this.serverName, userId});
        return response.getGUID();
    }

    public String createGovernanceDomainSet(String userId, GovernanceDomainSetProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createGovernanceDomainSet";
        String propertiesParameter = "properties";
        String qualifiedNameParameter = "qualifiedName";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-domain-sets";
        this.invalidParameterHandler.validateUserId(userId, "createGovernanceDomainSet");
        this.invalidParameterHandler.validateObject((Object)properties, "properties", "createGovernanceDomainSet");
        this.invalidParameterHandler.validateName(properties.getQualifiedName(), "qualifiedName", "createGovernanceDomainSet");
        GUIDResponse response = this.restClient.callGUIDPostRESTCall("createGovernanceDomainSet", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-domain-sets", properties, new Object[]{this.serverName, userId});
        return response.getGUID();
    }

    public void updateGovernanceDomainSet(String userId, String governanceDomainSetGUID, GovernanceDomainSetProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateGovernanceDomainSet";
        String guidParameter = "governanceDomainSetGUID";
        String propertiesParameter = "properties";
        String qualifiedNameParameter = "qualifiedName";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-domain-sets/{2}/update";
        this.invalidParameterHandler.validateUserId(userId, "updateGovernanceDomainSet");
        this.invalidParameterHandler.validateGUID(governanceDomainSetGUID, "governanceDomainSetGUID", "updateGovernanceDomainSet");
        this.invalidParameterHandler.validateObject((Object)properties, "properties", "updateGovernanceDomainSet");
        this.invalidParameterHandler.validateName(properties.getQualifiedName(), "qualifiedName", "updateGovernanceDomainSet");
        this.restClient.callVoidPostRESTCall("updateGovernanceDomainSet", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-domain-sets/{2}/update", properties, new Object[]{this.serverName, userId, governanceDomainSetGUID});
    }

    public void removeGovernanceDomainSet(String userId, String governanceDomainSetGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeGovernanceDomainSet";
        String guidParameter = "governanceDomainSetGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-domain-sets/{2}/delete";
        this.invalidParameterHandler.validateUserId(userId, "removeGovernanceDomainSet");
        this.invalidParameterHandler.validateGUID(governanceDomainSetGUID, "governanceDomainSetGUID", "removeGovernanceDomainSet");
        this.restClient.callVoidPostRESTCall("removeGovernanceDomainSet", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-domain-sets/{2}/delete", this.nullRequestBody, new Object[]{this.serverName, userId, governanceDomainSetGUID});
    }

    public List<GovernanceDomainSetElement> findGovernanceDomainSets(String userId, String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findGovernanceDomainSets";
        String searchStringParameterName = "searchString";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-domain-sets/by-search-string?startFrom={2}&pageSize={3}";
        this.invalidParameterHandler.validateUserId(userId, "findGovernanceDomainSets");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findGovernanceDomainSets");
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "findGovernanceDomainSets");
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        GovernanceDomainSetListResponse restResult = this.restClient.callGovernanceDomainSetListPostRESTCall("findGovernanceDomainSets", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-domain-sets/by-search-string?startFrom={2}&pageSize={3}", requestBody, this.serverName, userId, startFrom, queryPageSize);
        return restResult.getElements();
    }

    public List<GovernanceDomainSetElement> getGovernanceDomainSetsByName(String userId, String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernanceDomainSetsByName";
        String nameParameterName = "name";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-domain-sets/by-name?startFrom={2}&pageSize={3}";
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceDomainSetsByName");
        this.invalidParameterHandler.validateName(name, "name", "getGovernanceDomainSetsByName");
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getGovernanceDomainSetsByName");
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setName(name);
        requestBody.setNameParameterName("name");
        GovernanceDomainSetListResponse restResult = this.restClient.callGovernanceDomainSetListPostRESTCall("getGovernanceDomainSetsByName", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-domain-sets/by-name?startFrom={2}&pageSize={3}", requestBody, this.serverName, userId, startFrom, queryPageSize);
        return restResult.getElements();
    }

    public GovernanceDomainSetElement getGovernanceDomainSetByGUID(String userId, String governanceDomainSetGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernanceDomainSetByGUID";
        String guidParameterName = "governanceDomainSetGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-domain-sets/{2}";
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceDomainSetByGUID");
        this.invalidParameterHandler.validateName(governanceDomainSetGUID, "governanceDomainSetGUID", "getGovernanceDomainSetByGUID");
        GovernanceDomainSetResponse restResult = this.restClient.callGovernanceDomainSetGetRESTCall("getGovernanceDomainSetByGUID", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-domain-sets/{2}", this.serverName, userId, governanceDomainSetGUID);
        return restResult.getElement();
    }

    public String createGovernanceDomain(String userId, String setGUID, GovernanceDomainProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createGovernanceDomain";
        String guidParameter = "setGUID";
        String qualifiedNameParameter = "qualifiedName";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-domain-sets/{2}/governance-domains";
        this.invalidParameterHandler.validateUserId(userId, "createGovernanceDomain");
        this.invalidParameterHandler.validateGUID(setGUID, "setGUID", "createGovernanceDomain");
        this.invalidParameterHandler.validateObject((Object)properties, "qualifiedName", "createGovernanceDomain");
        this.invalidParameterHandler.validateName(properties.getQualifiedName(), "qualifiedName", "createGovernanceDomain");
        GUIDResponse response = this.restClient.callGUIDPostRESTCall("createGovernanceDomain", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-domain-sets/{2}/governance-domains", properties, new Object[]{this.serverName, userId, setGUID});
        return response.getGUID();
    }

    public void updateGovernanceDomain(String userId, String governanceDomainGUID, GovernanceDomainProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateGovernanceDomain";
        String guidParameter = "governanceDomainGUID";
        String qualifiedNameParameter = "qualifiedName";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-domain-sets/governance-domains/{2}/update";
        this.invalidParameterHandler.validateUserId(userId, "updateGovernanceDomain");
        this.invalidParameterHandler.validateGUID(governanceDomainGUID, "governanceDomainGUID", "updateGovernanceDomain");
        this.invalidParameterHandler.validateObject((Object)properties, "qualifiedName", "updateGovernanceDomain");
        this.invalidParameterHandler.validateName(properties.getQualifiedName(), "qualifiedName", "updateGovernanceDomain");
        this.restClient.callVoidPostRESTCall("updateGovernanceDomain", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-domain-sets/governance-domains/{2}/update", properties, new Object[]{this.serverName, userId, governanceDomainGUID});
    }

    public void deleteGovernanceDomain(String userId, String governanceDomainGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "deleteGovernanceDomain";
        String guidParameter = "governanceDomainGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-domain-sets/governance-domains/{2}/delete";
        this.invalidParameterHandler.validateUserId(userId, "deleteGovernanceDomain");
        this.invalidParameterHandler.validateGUID(governanceDomainGUID, "governanceDomainGUID", "deleteGovernanceDomain");
        this.restClient.callVoidPostRESTCall("deleteGovernanceDomain", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-domain-sets/governance-domains/{2}/delete", this.nullRequestBody, new Object[]{this.serverName, userId, governanceDomainGUID});
    }

    public List<GovernanceDomainElement> getGovernanceDomains(String userId, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernanceDomains";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-domain-sets/governance-domains?startFrom={2}&pageSize={3}";
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceDomains");
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getGovernanceDomains");
        GovernanceDomainListResponse restResult = this.restClient.callGovernanceDomainListGetRESTCall("getGovernanceDomains", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-domain-sets/governance-domains?startFrom={2}&pageSize={3}", this.serverName, userId, startFrom, queryPageSize);
        return restResult.getElements();
    }

    public List<GovernanceDomainElement> findGovernanceDomains(String userId, String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findGovernanceDomains";
        String searchStringParameterName = "searchString";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-domain-sets/governance-domains/by-search-string?startFrom={2}&pageSize={3}";
        this.invalidParameterHandler.validateUserId(userId, "findGovernanceDomains");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findGovernanceDomains");
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "findGovernanceDomains");
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        GovernanceDomainListResponse restResult = this.restClient.callGovernanceDomainListPostRESTCall("findGovernanceDomains", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-domain-sets/governance-domains/by-search-string?startFrom={2}&pageSize={3}", requestBody, this.serverName, userId, startFrom, queryPageSize);
        return restResult.getElements();
    }

    public List<GovernanceDomainSetElement> getSetsForGovernanceDomain(String userId, String governanceDomainGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getSetsForGovernanceDomain";
        String guidParameterName = "governanceDomainGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-domain-sets/governance-domains/{2}?startFrom={3}&pageSize={4}";
        this.invalidParameterHandler.validateUserId(userId, "getSetsForGovernanceDomain");
        this.invalidParameterHandler.validateGUID(governanceDomainGUID, "governanceDomainGUID", "getSetsForGovernanceDomain");
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getSetsForGovernanceDomain");
        GovernanceDomainSetListResponse restResult = this.restClient.callGovernanceDomainSetListPostRESTCall("getSetsForGovernanceDomain", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-domain-sets/governance-domains/{2}?startFrom={3}&pageSize={4}", this.serverName, userId, governanceDomainGUID, startFrom, queryPageSize);
        return restResult.getElements();
    }

    public List<GovernanceDomainElement> getGovernanceDomainsByName(String userId, String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernanceDomainsByName";
        String nameParameterName = "name";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-domain-sets/governance-domains/by-name?startFrom={2}&pageSize={3}";
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceDomainsByName");
        this.invalidParameterHandler.validateName(name, "name", "getGovernanceDomainsByName");
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getGovernanceDomainsByName");
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setName(name);
        requestBody.setNameParameterName("name");
        GovernanceDomainListResponse restResult = this.restClient.callGovernanceDomainListPostRESTCall("getGovernanceDomainsByName", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-domain-sets/governance-domains/by-name?startFrom={2}&pageSize={3}", requestBody, this.serverName, userId, startFrom, queryPageSize);
        return restResult.getElements();
    }

    public GovernanceDomainElement getGovernanceDomainByGUID(String userId, String governanceDomainGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernanceDomainByGUID";
        String guidParameterName = "governanceDomainGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-domains/{2}";
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceDomainByGUID");
        this.invalidParameterHandler.validateGUID(governanceDomainGUID, "governanceDomainGUID", "getGovernanceDomainByGUID");
        GovernanceDomainResponse restResult = this.restClient.callGovernanceDomainGetRESTCall("getGovernanceDomainByGUID", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-domains/{2}", this.serverName, userId, governanceDomainGUID);
        return restResult.getElement();
    }

    public GovernanceDomainElement getGovernanceDomainByIdentifier(String userId, int domainIdentifier) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernanceDomainByIdentifier";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-domains/by-identifier/{2}";
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceDomainByIdentifier");
        GovernanceDomainResponse restResult = this.restClient.callGovernanceDomainGetRESTCall("getGovernanceDomainByIdentifier", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-domains/by-identifier/{2}", this.serverName, userId, domainIdentifier);
        return restResult.getElement();
    }
}

