/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceprogram.client;

import java.util.List;
import org.odpi.openmetadata.accessservices.governanceprogram.api.GovernanceProgramReviewInterface;
import org.odpi.openmetadata.accessservices.governanceprogram.client.rest.GovernanceProgramRESTClient;
import org.odpi.openmetadata.accessservices.governanceprogram.metadataelements.ElementStub;
import org.odpi.openmetadata.accessservices.governanceprogram.metadataelements.GovernanceDefinitionElement;
import org.odpi.openmetadata.accessservices.governanceprogram.metadataelements.GovernanceDefinitionGraph;
import org.odpi.openmetadata.accessservices.governanceprogram.metadataelements.GovernanceMetricImplementation;
import org.odpi.openmetadata.accessservices.governanceprogram.metadataelements.GovernanceZoneInAction;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.ElementStubListResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceDefinitionGraphResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceDefinitionListResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceMetricImplementationListResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceZoneInActionResponse;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;

public class GovernanceProgramReviewManager
implements GovernanceProgramReviewInterface {
    private String serverName;
    private String serverPlatformURLRoot;
    private GovernanceProgramRESTClient restClient;
    private InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();

    public GovernanceProgramReviewManager(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        String methodName = "Constructor (no security)";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (no security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new GovernanceProgramRESTClient(serverName, serverPlatformURLRoot);
    }

    public GovernanceProgramReviewManager(String serverName, String serverPlatformURLRoot, String userId, String password) throws InvalidParameterException {
        String methodName = "Constructor (with security)";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (with security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new GovernanceProgramRESTClient(serverName, serverPlatformURLRoot, userId, password);
    }

    public GovernanceProgramReviewManager(String serverName, String serverPlatformURLRoot, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        String methodName = "Constructor (no security)";
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (no security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new GovernanceProgramRESTClient(serverName, serverPlatformURLRoot, auditLog);
    }

    public GovernanceProgramReviewManager(String serverName, String serverPlatformURLRoot, String userId, String password, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        String methodName = "Constructor (with security)";
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (with security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new GovernanceProgramRESTClient(serverName, serverPlatformURLRoot, userId, password, auditLog);
    }

    public GovernanceProgramReviewManager(String serverName, String serverPlatformURLRoot, GovernanceProgramRESTClient restClient, int maxPageSize) throws InvalidParameterException {
        String methodName = "Constructor (with security)";
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (with security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = restClient;
    }

    public List<GovernanceDefinitionElement> getGovernanceDefinitionsForDomain(String userId, String typeName, int domainIdentifier, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernanceDefinitionsForDomain";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/review/governance-definitions/for-domain?domainIdentifier={2}&typeName={3}&startFrom={4}&pageSize={5}";
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceDefinitionsForDomain");
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getGovernanceDefinitionsForDomain");
        GovernanceDefinitionListResponse restResult = this.restClient.callGovernanceDefinitionListGetRESTCall("getGovernanceDefinitionsForDomain", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/review/governance-definitions/for-domain?domainIdentifier={2}&typeName={3}&startFrom={4}&pageSize={5}", this.serverName, userId, domainIdentifier, typeName, startFrom, queryPageSize);
        return restResult.getElements();
    }

    public List<GovernanceDefinitionElement> getGovernanceDefinitionsForDocId(String userId, String typeName, String docId, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernanceDefinitionsForDocId";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/review/governance-definitions/for-document-id/{2}?startFrom={3}&pageSize={4}";
        String docIdParameterName = "docId";
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceDefinitionsForDocId");
        this.invalidParameterHandler.validateName("docId", "docId", "getGovernanceDefinitionsForDocId");
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getGovernanceDefinitionsForDocId");
        GovernanceDefinitionListResponse restResult = this.restClient.callGovernanceDefinitionListGetRESTCall("getGovernanceDefinitionsForDocId", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/review/governance-definitions/for-document-id/{2}?startFrom={3}&pageSize={4}", this.serverName, userId, docId, startFrom, queryPageSize);
        return restResult.getElements();
    }

    public GovernanceDefinitionGraph getGovernanceDefinitionInContext(String userId, String governanceDefinitionGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernanceDefinitionInContext";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/review/governance-definitions/{2}/in-context";
        String guidParameterName = "governanceDefinitionGUID";
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceDefinitionInContext");
        this.invalidParameterHandler.validateGUID(governanceDefinitionGUID, "governanceDefinitionGUID", "getGovernanceDefinitionInContext");
        GovernanceDefinitionGraphResponse restResult = this.restClient.callGovernanceDefinitionGraphGetRESTCall("getGovernanceDefinitionInContext", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/review/governance-definitions/{2}/in-context", this.serverName, userId, governanceDefinitionGUID);
        return restResult.getElement();
    }

    public List<ElementStub> getElementsGovernedByDefinition(String userId, String governanceDefinitionGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getElementsGovernedByDefinition";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/review/governance-definitions/{2}/elements?startFrom={3}&pageSize={4}";
        String guidParameterName = "governanceDefinitionGUID";
        this.invalidParameterHandler.validateUserId(userId, "getElementsGovernedByDefinition");
        this.invalidParameterHandler.validateGUID(governanceDefinitionGUID, "governanceDefinitionGUID", "getElementsGovernedByDefinition");
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getElementsGovernedByDefinition");
        ElementStubListResponse restResult = this.restClient.callElementStubListGetRESTCall("getElementsGovernedByDefinition", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/review/governance-definitions/{2}/elements?startFrom={3}&pageSize={4}", this.serverName, userId, governanceDefinitionGUID, startFrom, queryPageSize);
        return restResult.getElements();
    }

    public List<GovernanceDefinitionElement> findGovernanceDefinitions(String userId, String typeName, String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findGovernanceDefinitions";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/review/governance-definitions/by-search-string?startFrom={2}&pageSize={3}";
        String searchStringParameterName = "searchString";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(this.serverPlatformURLRoot, this.serverName, "findGovernanceDefinitions");
        this.invalidParameterHandler.validateUserId(userId, "findGovernanceDefinitions");
        this.invalidParameterHandler.validateSearchString(searchString, searchString, "findGovernanceDefinitions");
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "findGovernanceDefinitions");
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        GovernanceDefinitionListResponse restResult = this.restClient.callGovernanceDefinitionListPostRESTCall("findGovernanceDefinitions", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/review/governance-definitions/by-search-string?startFrom={2}&pageSize={3}", requestBody, this.serverName, userId, startFrom, queryPageSize);
        return restResult.getElements();
    }

    public List<GovernanceMetricImplementation> getGovernanceDefinitionMetrics(String userId, String governanceDefinitionGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernanceDefinitionMetrics";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/review/governance-definitions/{2}/metrics-implementation?startFrom={2}&pageSize={3}";
        String guidParameterName = "governanceDefinitionGUID";
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceDefinitionMetrics");
        this.invalidParameterHandler.validateGUID(governanceDefinitionGUID, "governanceDefinitionGUID", "getGovernanceDefinitionMetrics");
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getGovernanceDefinitionMetrics");
        GovernanceMetricImplementationListResponse restResult = this.restClient.callGovernanceMetricsImplementationListGetRESTCall("getGovernanceDefinitionMetrics", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/review/governance-definitions/{2}/metrics-implementation?startFrom={2}&pageSize={3}", this.serverName, userId, governanceDefinitionGUID, startFrom, queryPageSize);
        return restResult.getElements();
    }

    public GovernanceZoneInAction getGovernanceZoneInAction(String userId, String zoneGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getElementsGovernedByDefinition";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/review/governance-zones/{2}/in-action";
        String guidParameterName = "zoneGUID";
        this.invalidParameterHandler.validateUserId(userId, "getElementsGovernedByDefinition");
        this.invalidParameterHandler.validateGUID(zoneGUID, "zoneGUID", "getElementsGovernedByDefinition");
        GovernanceZoneInActionResponse restResult = this.restClient.callGovernanceZoneInActionGetRESTCall("getElementsGovernedByDefinition", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/review/governance-zones/{2}/in-action", this.serverName, userId, zoneGUID);
        return restResult.getElement();
    }

    public List<ElementStub> getGovernanceZoneMembers(String userId, String zoneGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getElementsGovernedByDefinition";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/review/governance-zones/{2}/members?startFrom={2}&pageSize={3}";
        String guidParameterName = "zoneGUID";
        this.invalidParameterHandler.validateUserId(userId, "getElementsGovernedByDefinition");
        this.invalidParameterHandler.validateGUID(zoneGUID, "zoneGUID", "getElementsGovernedByDefinition");
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getElementsGovernedByDefinition");
        ElementStubListResponse restResult = this.restClient.callElementStubListGetRESTCall("getElementsGovernedByDefinition", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/review/governance-zones/{2}/members?startFrom={2}&pageSize={3}", this.serverName, userId, zoneGUID, startFrom, queryPageSize);
        return restResult.getElements();
    }
}

