/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceprogram.client;

import org.odpi.openmetadata.accessservices.governanceprogram.api.GovernanceDefinitionsInterface;
import org.odpi.openmetadata.accessservices.governanceprogram.client.rest.GovernanceProgramRESTClient;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.GovernanceDefinitionProperties;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.GovernanceDefinitionStatus;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.StringRequestBody;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;

public class GovernanceDefinitionManager
implements GovernanceDefinitionsInterface {
    private String serverName;
    private String serverPlatformURLRoot;
    private GovernanceProgramRESTClient restClient;
    private InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
    private NullRequestBody nullRequestBody = new NullRequestBody();

    public GovernanceDefinitionManager(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        String methodName = "Constructor (no security)";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (no security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new GovernanceProgramRESTClient(serverName, serverPlatformURLRoot);
    }

    public GovernanceDefinitionManager(String serverName, String serverPlatformURLRoot, String userId, String password) throws InvalidParameterException {
        String methodName = "Constructor (with security)";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (with security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new GovernanceProgramRESTClient(serverName, serverPlatformURLRoot, userId, password);
    }

    public GovernanceDefinitionManager(String serverName, String serverPlatformURLRoot, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        String methodName = "Constructor (no security)";
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (no security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new GovernanceProgramRESTClient(serverName, serverPlatformURLRoot, auditLog);
    }

    public GovernanceDefinitionManager(String serverName, String serverPlatformURLRoot, String userId, String password, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        String methodName = "Constructor (with security)";
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (with security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new GovernanceProgramRESTClient(serverName, serverPlatformURLRoot, userId, password, auditLog);
    }

    public GovernanceDefinitionManager(String serverName, String serverPlatformURLRoot, GovernanceProgramRESTClient restClient, int maxPageSize) throws InvalidParameterException {
        String methodName = "Constructor (with security)";
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (with security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = restClient;
    }

    public String createGovernanceDefinition(String userId, GovernanceDefinitionProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createGovernanceDefinition";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-definitions";
        String docIdParameterName = "documentIdentifier";
        String titleParameterName = "title";
        String propertiesParameterName = "properties";
        this.invalidParameterHandler.validateUserId(userId, "createGovernanceDefinition");
        this.invalidParameterHandler.validateObject((Object)properties, "properties", "createGovernanceDefinition");
        this.invalidParameterHandler.validateName(properties.getDocumentIdentifier(), "documentIdentifier", "createGovernanceDefinition");
        this.invalidParameterHandler.validateName(properties.getTitle(), "title", "createGovernanceDefinition");
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createGovernanceDefinition", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-definitions", properties, new Object[]{this.serverName, userId});
        return restResult.getGUID();
    }

    public void updateGovernanceDefinition(String userId, String definitionGUID, boolean isMergeUpdate, GovernanceDefinitionProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateGovernanceDefinition";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-definitions/{2}/update?isMergeUpdate={3}";
        String guidParameterName = "definitionGUID";
        String docIdParameterName = "documentIdentifier";
        String titleParameterName = "title";
        String propertiesParameterName = "properties";
        this.invalidParameterHandler.validateUserId(userId, "updateGovernanceDefinition");
        this.invalidParameterHandler.validateGUID(definitionGUID, "definitionGUID", "updateGovernanceDefinition");
        this.invalidParameterHandler.validateObject((Object)properties, "properties", "updateGovernanceDefinition");
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(properties.getDocumentIdentifier(), "documentIdentifier", "updateGovernanceDefinition");
            this.invalidParameterHandler.validateName(properties.getTitle(), "title", "updateGovernanceDefinition");
        }
        this.restClient.callVoidPostRESTCall("updateGovernanceDefinition", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-definitions/{2}/update?isMergeUpdate={3}", properties, new Object[]{this.serverName, userId, definitionGUID, isMergeUpdate});
    }

    public void setGovernanceDefinitionStatus(String userId, String definitionGUID, GovernanceDefinitionStatus newStatus) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setGovernanceDefinitionStatus";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-definitions/{2}/update-status";
        String guidParameterName = "definitionGUID";
        String propertiesParameterName = "newStatus";
        this.invalidParameterHandler.validateUserId(userId, "setGovernanceDefinitionStatus");
        this.invalidParameterHandler.validateGUID(definitionGUID, "definitionGUID", "setGovernanceDefinitionStatus");
        this.invalidParameterHandler.validateEnum((Object)newStatus, "newStatus", "setGovernanceDefinitionStatus");
        this.restClient.callVoidPostRESTCall("setGovernanceDefinitionStatus", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-definitions/{2}/update-status", newStatus, new Object[]{this.serverName, userId, definitionGUID});
    }

    public void deleteGovernanceDefinition(String userId, String definitionGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "deleteGovernanceDefinition";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-definitions/{2}/delete";
        String guidParameterName = "definitionGUID";
        this.invalidParameterHandler.validateGUID(definitionGUID, "definitionGUID", "deleteGovernanceDefinition");
        this.invalidParameterHandler.validateUserId(userId, "deleteGovernanceDefinition");
        this.restClient.callVoidPostRESTCall("deleteGovernanceDefinition", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-definitions/{2}/delete", this.nullRequestBody, new Object[]{this.serverName, userId, definitionGUID});
    }

    public void linkPeerDefinitions(String userId, String definitionOneGUID, String definitionTwoGUID, String relationshipTypeName, String description) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "linkPeerDefinitions";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-definitions/{2}/peers/{3}/link-as/{4}";
        String definitionOneGUIDParameterName = "definitionOneGUID";
        String definitionTwoGUIDParameterName = "definitionTwoGUID";
        String relationshipTypeNameParameterName = "relationshipTypeName";
        this.invalidParameterHandler.validateUserId(userId, "linkPeerDefinitions");
        this.invalidParameterHandler.validateGUID(definitionOneGUID, "definitionOneGUID", "linkPeerDefinitions");
        this.invalidParameterHandler.validateGUID(definitionTwoGUID, "definitionTwoGUID", "linkPeerDefinitions");
        this.invalidParameterHandler.validateName(relationshipTypeName, "relationshipTypeName", "linkPeerDefinitions");
        StringRequestBody requestBody = new StringRequestBody();
        requestBody.setString(description);
        this.restClient.callVoidPostRESTCall("linkPeerDefinitions", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-definitions/{2}/peers/{3}/link-as/{4}", requestBody, new Object[]{this.serverName, userId, definitionOneGUID, definitionTwoGUID, relationshipTypeName});
    }

    public void unlinkPeerDefinitions(String userId, String definitionOneGUID, String definitionTwoGUID, String relationshipTypeName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "unlinkPeerDefinitions";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-definitions/{2}/peers/{3}/unlink-as/{4}";
        String definitionOneGUIDParameterName = "definitionOneGUID";
        String definitionTwoGUIDParameterName = "definitionTwoGUID";
        String relationshipTypeNameParameterName = "relationshipTypeName";
        this.invalidParameterHandler.validateUserId(userId, "unlinkPeerDefinitions");
        this.invalidParameterHandler.validateGUID(definitionOneGUID, "definitionOneGUID", "unlinkPeerDefinitions");
        this.invalidParameterHandler.validateGUID(definitionTwoGUID, "definitionTwoGUID", "unlinkPeerDefinitions");
        this.invalidParameterHandler.validateName(relationshipTypeName, "relationshipTypeName", "unlinkPeerDefinitions");
        this.restClient.callVoidPostRESTCall("unlinkPeerDefinitions", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-definitions/{2}/peers/{3}/unlink-as/{4}", null, new Object[]{this.serverName, userId, definitionOneGUID, definitionTwoGUID, relationshipTypeName});
    }

    public void setupSupportingDefinition(String userId, String definitionGUID, String supportingDefinitionGUID, String relationshipTypeName, String rationale) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupSupportingDefinition";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-definitions/{2}/supporting-definitions/{3}/link-as/{4}";
        String definitionOneGUIDParameterName = "definitionGUID";
        String definitionTwoGUIDParameterName = "supportingDefinitionGUID";
        String relationshipTypeNameParameterName = "relationshipTypeName";
        this.invalidParameterHandler.validateUserId(userId, "setupSupportingDefinition");
        this.invalidParameterHandler.validateGUID(definitionGUID, "definitionGUID", "setupSupportingDefinition");
        this.invalidParameterHandler.validateGUID(supportingDefinitionGUID, "supportingDefinitionGUID", "setupSupportingDefinition");
        this.invalidParameterHandler.validateName(relationshipTypeName, "relationshipTypeName", "setupSupportingDefinition");
        StringRequestBody requestBody = new StringRequestBody();
        requestBody.setString(rationale);
        this.restClient.callVoidPostRESTCall("setupSupportingDefinition", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-definitions/{2}/supporting-definitions/{3}/link-as/{4}", requestBody, new Object[]{this.serverName, userId, definitionGUID, supportingDefinitionGUID, relationshipTypeName});
    }

    public void clearSupportingDefinition(String userId, String definitionGUID, String supportingDefinitionGUID, String relationshipTypeName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearSupportingDefinition";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-definitions/{2}/supporting-definitions/{3}/unlink-as/{4}";
        String definitionOneGUIDParameterName = "definitionGUID";
        String definitionTwoGUIDParameterName = "supportingDefinitionGUID";
        String relationshipTypeNameParameterName = "relationshipTypeName";
        this.invalidParameterHandler.validateUserId(userId, "clearSupportingDefinition");
        this.invalidParameterHandler.validateGUID(definitionGUID, "definitionGUID", "clearSupportingDefinition");
        this.invalidParameterHandler.validateGUID(supportingDefinitionGUID, "supportingDefinitionGUID", "clearSupportingDefinition");
        this.invalidParameterHandler.validateName(relationshipTypeName, "relationshipTypeName", "clearSupportingDefinition");
        this.restClient.callVoidPostRESTCall("clearSupportingDefinition", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-definitions/{2}/supporting-definitions/{3}/unlink-as/{4}", this.nullRequestBody, new Object[]{this.serverName, userId, definitionGUID, supportingDefinitionGUID, relationshipTypeName});
    }
}

