/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceprogram.client;

import java.util.List;
import org.odpi.openmetadata.accessservices.governanceprogram.api.RightsManagementInterface;
import org.odpi.openmetadata.accessservices.governanceprogram.client.rest.GovernanceProgramRESTClient;
import org.odpi.openmetadata.accessservices.governanceprogram.metadataelements.LicenseTypeElement;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.GovernanceDefinitionStatus;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.LicenseProperties;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.LicenseTypeProperties;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.CertificateIdRequestBody;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.LicenseTypeListResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.LicenseTypeRequestBody;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.LicenseTypeResponse;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;

public class RightsManager
implements RightsManagementInterface {
    private String serverName;
    private String serverPlatformURLRoot;
    private GovernanceProgramRESTClient restClient;
    private InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
    private NullRequestBody nullRequestBody = new NullRequestBody();

    public RightsManager(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        String methodName = "Constructor (no security)";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (no security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new GovernanceProgramRESTClient(serverName, serverPlatformURLRoot);
    }

    public RightsManager(String serverName, String serverPlatformURLRoot, String userId, String password) throws InvalidParameterException {
        String methodName = "Constructor (with security)";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (with security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new GovernanceProgramRESTClient(serverName, serverPlatformURLRoot, userId, password);
    }

    public RightsManager(String serverName, String serverPlatformURLRoot, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        String methodName = "Constructor (no security)";
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (no security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new GovernanceProgramRESTClient(serverName, serverPlatformURLRoot, auditLog);
    }

    public RightsManager(String serverName, String serverPlatformURLRoot, String userId, String password, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        String methodName = "Constructor (with security)";
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (with security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new GovernanceProgramRESTClient(serverName, serverPlatformURLRoot, userId, password, auditLog);
    }

    public RightsManager(String serverName, String serverPlatformURLRoot, GovernanceProgramRESTClient restClient, int maxPageSize) throws InvalidParameterException {
        String methodName = "Constructor (with security)";
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (with security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = restClient;
    }

    public String createLicenseType(String userId, LicenseTypeProperties properties, GovernanceDefinitionStatus initialStatus) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createLicenseType";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/license-types";
        String docIdParameterName = "documentIdentifier";
        String titleParameterName = "title";
        String propertiesParameterName = "properties";
        this.invalidParameterHandler.validateUserId(userId, "createLicenseType");
        this.invalidParameterHandler.validateObject((Object)properties, "properties", "createLicenseType");
        this.invalidParameterHandler.validateName(properties.getDocumentIdentifier(), "documentIdentifier", "createLicenseType");
        this.invalidParameterHandler.validateName(properties.getTitle(), "title", "createLicenseType");
        LicenseTypeRequestBody requestBody = new LicenseTypeRequestBody();
        requestBody.setProperties(properties);
        requestBody.setInitialStatus(initialStatus);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createLicenseType", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/license-types", requestBody, new Object[]{this.serverName, userId});
        return restResult.getGUID();
    }

    public void updateLicenseType(String userId, String licenseTypeGUID, boolean isMergeUpdate, LicenseTypeProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateLicenseType";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/license-types/{2}/update?isMergeUpdate={3}";
        String guidParameterName = "licenseTypeGUID";
        String docIdParameterName = "documentIdentifier";
        String titleParameterName = "title";
        String propertiesParameterName = "properties";
        this.invalidParameterHandler.validateUserId(userId, "updateLicenseType");
        this.invalidParameterHandler.validateGUID(licenseTypeGUID, "licenseTypeGUID", "updateLicenseType");
        this.invalidParameterHandler.validateObject((Object)properties, "properties", "updateLicenseType");
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(properties.getDocumentIdentifier(), "documentIdentifier", "updateLicenseType");
            this.invalidParameterHandler.validateName(properties.getTitle(), "title", "updateLicenseType");
        }
        this.restClient.callVoidPostRESTCall("updateLicenseType", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/license-types/{2}/update?isMergeUpdate={3}", properties, new Object[]{this.serverName, userId, licenseTypeGUID, isMergeUpdate});
    }

    public void deleteLicenseType(String userId, String licenseTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "deleteLicenseType";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/license-types/{2}/delete";
        String guidParameterName = "licenseTypeGUID";
        this.invalidParameterHandler.validateGUID(licenseTypeGUID, "licenseTypeGUID", "deleteLicenseType");
        this.invalidParameterHandler.validateUserId(userId, "deleteLicenseType");
        this.restClient.callVoidPostRESTCall("deleteLicenseType", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/license-types/{2}/delete", this.nullRequestBody, new Object[]{this.serverName, userId, licenseTypeGUID});
    }

    public LicenseTypeElement getLicenseTypeByGUID(String userId, String licenseTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getLicenseTypeByGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/license-types/{2}";
        String guidParameterName = "licenseTypeGUID";
        this.invalidParameterHandler.validateUserId(userId, "getLicenseTypeByGUID");
        this.invalidParameterHandler.validateGUID(licenseTypeGUID, "licenseTypeGUID", "getLicenseTypeByGUID");
        LicenseTypeResponse restResult = this.restClient.callLicenseTypeGetRESTCall("getLicenseTypeByGUID", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/license-types/{2}", this.serverName, userId, licenseTypeGUID);
        return restResult.getElement();
    }

    public LicenseTypeElement getLicenseTypeByDocId(String userId, String documentIdentifier) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getLicenseTypeByDocId";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/license-types/by-document-id/{2}";
        String documentIdParameterName = "documentId";
        this.invalidParameterHandler.validateUserId(userId, "getLicenseTypeByDocId");
        this.invalidParameterHandler.validateName(documentIdentifier, "documentId", "getLicenseTypeByDocId");
        LicenseTypeResponse restResult = this.restClient.callLicenseTypeGetRESTCall("getLicenseTypeByDocId", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/license-types/by-document-id/{2}", this.serverName, userId, documentIdentifier);
        return restResult.getElement();
    }

    public List<LicenseTypeElement> getLicenseTypesByTitle(String userId, String title, int startFrom, int pageSize) throws UserNotAuthorizedException, InvalidParameterException, PropertyServerException {
        String methodName = "getLicenseTypesByTitle";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/license-types/by-title?startFrom={2}&pageSize={3}";
        String titleParameterName = "title";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(this.serverPlatformURLRoot, this.serverName, "getLicenseTypesByTitle");
        this.invalidParameterHandler.validateUserId(userId, "getLicenseTypesByTitle");
        this.invalidParameterHandler.validateSearchString(title, "title", "getLicenseTypesByTitle");
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getLicenseTypesByTitle");
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setSearchString(title);
        requestBody.setSearchStringParameterName("title");
        LicenseTypeListResponse restResult = this.restClient.callLicenseTypeListPostRESTCall("getLicenseTypesByTitle", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/license-types/by-title?startFrom={2}&pageSize={3}", requestBody, this.serverName, userId, startFrom, queryPageSize);
        return restResult.getElements();
    }

    public List<LicenseTypeElement> getLicenseTypeByDomainId(String userId, int domainIdentifier, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getLicenseTypeByDomainId";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/license-types/by-domain/{2}?startFrom={3}&pageSize={4}";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(this.serverPlatformURLRoot, this.serverName, "getLicenseTypeByDomainId");
        this.invalidParameterHandler.validateUserId(userId, "getLicenseTypeByDomainId");
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getLicenseTypeByDomainId");
        LicenseTypeListResponse restResult = this.restClient.callLicenseTypeListGetRESTCall("getLicenseTypeByDomainId", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/license-types/by-domain/{2}?startFrom={3}&pageSize={4}", this.serverName, userId, domainIdentifier, startFrom, queryPageSize);
        return restResult.getElements();
    }

    public void licenseElement(String userId, String elementGUID, String licenseTypeGUID, LicenseProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "certifyElement";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/license-types/{2}/elements/{3}/license";
        String elementGUIDParameterName = "elementGUID";
        String licenseTypeGUIDParameterName = "licenseTypeGUID";
        this.invalidParameterHandler.validateUserId(userId, "certifyElement");
        this.invalidParameterHandler.validateGUID(elementGUID, "elementGUID", "certifyElement");
        this.invalidParameterHandler.validateGUID(licenseTypeGUID, "licenseTypeGUID", "certifyElement");
        this.restClient.callVoidPostRESTCall("certifyElement", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/license-types/{2}/elements/{3}/license", properties, new Object[]{this.serverName, userId, licenseTypeGUID, elementGUID});
    }

    public void updateLicense(String userId, String elementGUID, String licenseTypeGUID, boolean isMergeUpdate, LicenseProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateLicense";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/license-types/{2}/elements/{3}/update?isMergeUpdate={4}";
        String elementGUIDParameterName = "elementGUID";
        String licenseTypeGUIDParameterName = "licenseTypeGUID";
        this.invalidParameterHandler.validateUserId(userId, "updateLicense");
        this.invalidParameterHandler.validateGUID(elementGUID, "elementGUID", "updateLicense");
        this.invalidParameterHandler.validateGUID(licenseTypeGUID, "licenseTypeGUID", "updateLicense");
        this.restClient.callVoidPostRESTCall("updateLicense", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/license-types/{2}/elements/{3}/update?isMergeUpdate={4}", properties, new Object[]{this.serverName, userId, licenseTypeGUID, elementGUID, isMergeUpdate});
    }

    public void unlicenseElement(String userId, String elementGUID, String licenseTypeGUID, String certificateId) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "decertifyElement";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/license-types/{2}/elements/{3}/unlicense";
        String elementGUIDParameterName = "elementGUID";
        String licenseTypeGUIDParameterName = "licenseTypeGUID";
        this.invalidParameterHandler.validateUserId(userId, "decertifyElement");
        this.invalidParameterHandler.validateGUID(elementGUID, "elementGUID", "decertifyElement");
        this.invalidParameterHandler.validateGUID(licenseTypeGUID, "licenseTypeGUID", "decertifyElement");
        CertificateIdRequestBody requestBody = new CertificateIdRequestBody();
        requestBody.setCertificateId(certificateId);
        this.restClient.callVoidPostRESTCall("decertifyElement", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/license-types/{2}/elements/{3}/unlicense", requestBody, new Object[]{this.serverName, userId, licenseTypeGUID, elementGUID});
    }
}

