/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceprogram.client;

import java.util.List;
import org.odpi.openmetadata.accessservices.governanceprogram.api.ExternalReferencesInterface;
import org.odpi.openmetadata.accessservices.governanceprogram.client.rest.GovernanceProgramRESTClient;
import org.odpi.openmetadata.accessservices.governanceprogram.metadataelements.ExternalReferenceElement;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.ExternalReferenceLinkProperties;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.ExternalReferenceProperties;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.ExternalReferenceListResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.ExternalReferenceResponse;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;

public class ExternalReferenceManager
implements ExternalReferencesInterface {
    private String serverName;
    private String serverPlatformURLRoot;
    private GovernanceProgramRESTClient restClient;
    private InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
    private NullRequestBody nullRequestBody = new NullRequestBody();

    public ExternalReferenceManager(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        String methodName = "Constructor (no security)";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (no security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new GovernanceProgramRESTClient(serverName, serverPlatformURLRoot);
    }

    public ExternalReferenceManager(String serverName, String serverPlatformURLRoot, String userId, String password) throws InvalidParameterException {
        String methodName = "Constructor (with security)";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (with security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new GovernanceProgramRESTClient(serverName, serverPlatformURLRoot, userId, password);
    }

    public ExternalReferenceManager(String serverName, String serverPlatformURLRoot, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        String methodName = "Constructor (no security)";
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (no security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new GovernanceProgramRESTClient(serverName, serverPlatformURLRoot, auditLog);
    }

    public ExternalReferenceManager(String serverName, String serverPlatformURLRoot, String userId, String password, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        String methodName = "Constructor (with security)";
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (with security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new GovernanceProgramRESTClient(serverName, serverPlatformURLRoot, userId, password, auditLog);
    }

    public ExternalReferenceManager(String serverName, String serverPlatformURLRoot, GovernanceProgramRESTClient restClient, int maxPageSize) throws InvalidParameterException {
        String methodName = "Constructor (with security)";
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (with security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = restClient;
    }

    public String createExternalReference(String userId, String anchorGUID, ExternalReferenceProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createExternalReference";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/external-references";
        String qualifiedNameParameterName = "qualifiedName";
        String uriParameterName = "uri";
        String propertiesParameterName = "properties";
        this.invalidParameterHandler.validateUserId(userId, "createExternalReference");
        this.invalidParameterHandler.validateObject((Object)properties, "properties", "createExternalReference");
        this.invalidParameterHandler.validateName(properties.getQualifiedName(), "qualifiedName", "createExternalReference");
        this.invalidParameterHandler.validateName(properties.getURI(), "uri", "createExternalReference");
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createExternalReference", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/external-references", properties, new Object[]{this.serverName, userId});
        return restResult.getGUID();
    }

    public void updateExternalReference(String userId, String externalReferenceGUID, boolean isMergeUpdate, ExternalReferenceProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateExternalReference";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/external-references/{2}/update?isMergeUpdate={4}";
        String qualifiedNameParameterName = "qualifiedName";
        String guidParameterName = "externalReferenceGUID";
        String uriParameterName = "uri";
        String propertiesParameterName = "properties";
        this.invalidParameterHandler.validateUserId(userId, "updateExternalReference");
        this.invalidParameterHandler.validateGUID(externalReferenceGUID, "externalReferenceGUID", "updateExternalReference");
        this.invalidParameterHandler.validateObject((Object)properties, "properties", "updateExternalReference");
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(properties.getQualifiedName(), "qualifiedName", "updateExternalReference");
            this.invalidParameterHandler.validateName(properties.getURI(), "uri", "updateExternalReference");
        }
        this.restClient.callVoidPostRESTCall("updateExternalReference", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/external-references/{2}/update?isMergeUpdate={4}", properties, new Object[]{this.serverName, userId, externalReferenceGUID, isMergeUpdate});
    }

    public void deleteExternalReference(String userId, String externalReferenceGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "deleteExternalReference";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/external-references/{2}/delete";
        String guidParameterName = "externalReferenceGUID";
        this.invalidParameterHandler.validateUserId(userId, "deleteExternalReference");
        this.invalidParameterHandler.validateGUID(externalReferenceGUID, "externalReferenceGUID", "deleteExternalReference");
        this.restClient.callVoidPostRESTCall("deleteExternalReference", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/external-references/{2}/delete", this.nullRequestBody, new Object[]{this.serverName, userId, externalReferenceGUID});
    }

    public void linkExternalReferenceToElement(String userId, String attachedToGUID, String externalReferenceGUID, ExternalReferenceLinkProperties linkProperties) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "linkExternalReferenceToElement";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/external-references/{2}/elements/{3}/link";
        String elementGUIDParameterName = "attachedToGUID";
        String externalReferenceGUIDParameterName = "externalReferenceGUID";
        this.invalidParameterHandler.validateUserId(userId, "linkExternalReferenceToElement");
        this.invalidParameterHandler.validateGUID(attachedToGUID, "attachedToGUID", "linkExternalReferenceToElement");
        this.invalidParameterHandler.validateGUID(externalReferenceGUID, "externalReferenceGUID", "linkExternalReferenceToElement");
        this.restClient.callVoidPostRESTCall("linkExternalReferenceToElement", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/external-references/{2}/elements/{3}/link", linkProperties, new Object[]{this.serverName, userId, externalReferenceGUID, attachedToGUID});
    }

    public void unlinkExternalReferenceFromElement(String userId, String attachedToGUID, String externalReferenceGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "unlinkExternalReferenceToElement";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/external-references/{2}/elements/{3}/unlink";
        String elementGUIDParameterName = "attachedToGUID";
        String externalReferenceGUIDParameterName = "externalReferenceGUID";
        this.invalidParameterHandler.validateUserId(userId, "unlinkExternalReferenceToElement");
        this.invalidParameterHandler.validateGUID(attachedToGUID, "attachedToGUID", "unlinkExternalReferenceToElement");
        this.invalidParameterHandler.validateGUID(externalReferenceGUID, "externalReferenceGUID", "unlinkExternalReferenceToElement");
        this.restClient.callVoidPostRESTCall("unlinkExternalReferenceToElement", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/external-references/{2}/elements/{3}/unlink", this.nullRequestBody, new Object[]{this.serverName, userId, externalReferenceGUID, attachedToGUID});
    }

    public ExternalReferenceElement getExternalReferenceByGUID(String userId, String externalReferenceGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getExternalReferenceByGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/external-references/{2}";
        String guidParameterName = "externalReferenceGUID";
        this.invalidParameterHandler.validateUserId(userId, "getExternalReferenceByGUID");
        this.invalidParameterHandler.validateGUID(externalReferenceGUID, "externalReferenceGUID", "getExternalReferenceByGUID");
        ExternalReferenceResponse restResult = this.restClient.callExternalReferenceGetRESTCall("getExternalReferenceByGUID", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/external-references/{2}", this.serverName, userId, externalReferenceGUID);
        return restResult.getElement();
    }

    public List<ExternalReferenceElement> findExternalReferencesById(String userId, String resourceId, int startFrom, int pageSize) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "findExternalReferencesById";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/external-references/by-resource-id?startFrom={2}&pageSize={3}";
        String resourceIdParameterName = "resourceId";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(this.serverPlatformURLRoot, this.serverName, "findExternalReferencesById");
        this.invalidParameterHandler.validateUserId(userId, "findExternalReferencesById");
        this.invalidParameterHandler.validateSearchString(resourceId, "resourceId", "findExternalReferencesById");
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "findExternalReferencesById");
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setSearchString(resourceId);
        requestBody.setSearchStringParameterName("resourceId");
        ExternalReferenceListResponse restResult = this.restClient.callExternalReferenceListPostRESTCall("findExternalReferencesById", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/external-references/by-resource-id?startFrom={2}&pageSize={3}", requestBody, this.serverName, userId, startFrom, queryPageSize);
        return restResult.getElements();
    }

    public List<ExternalReferenceElement> getExternalReferencesByURL(String userId, String url, int startFrom, int pageSize) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getExternalReferencesByURL";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/external-references/by-url?startFrom={2}&pageSize={3}";
        String urlParameterName = "resourceId";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(this.serverPlatformURLRoot, this.serverName, "getExternalReferencesByURL");
        this.invalidParameterHandler.validateUserId(userId, "getExternalReferencesByURL");
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getExternalReferencesByURL");
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setName(url);
        requestBody.setNameParameterName("resourceId");
        ExternalReferenceListResponse restResult = this.restClient.callExternalReferenceListPostRESTCall("getExternalReferencesByURL", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/external-references/by-url?startFrom={2}&pageSize={3}", requestBody, this.serverName, userId, startFrom, queryPageSize);
        return restResult.getElements();
    }

    public List<ExternalReferenceElement> retrieveAttachedExternalReferences(String userId, String attachedToGUID, int startFrom, int pageSize) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "retrieveAttachedExternalReferences";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/external-references/for-element/{2}?startFrom={3}&pageSize={4}";
        String guidParameterName = "attachedToGUID";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(this.serverPlatformURLRoot, this.serverName, "retrieveAttachedExternalReferences");
        this.invalidParameterHandler.validateUserId(userId, "retrieveAttachedExternalReferences");
        this.invalidParameterHandler.validateGUID(attachedToGUID, "attachedToGUID", "retrieveAttachedExternalReferences");
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "retrieveAttachedExternalReferences");
        ExternalReferenceListResponse restResult = this.restClient.callExternalReferenceListGetRESTCall("retrieveAttachedExternalReferences", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/external-references/for-element/{2}?startFrom={3}&pageSize={4}", this.serverName, userId, attachedToGUID, startFrom, queryPageSize);
        return restResult.getElements();
    }
}

