/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceprogram.client;

import java.util.List;
import org.odpi.openmetadata.accessservices.governanceprogram.api.GovernanceClassificationLevelInterface;
import org.odpi.openmetadata.accessservices.governanceprogram.client.GovernanceProgramBaseClient;
import org.odpi.openmetadata.accessservices.governanceprogram.client.rest.GovernanceProgramRESTClient;
import org.odpi.openmetadata.accessservices.governanceprogram.metadataelements.GovernanceLevelIdentifierElement;
import org.odpi.openmetadata.accessservices.governanceprogram.metadataelements.GovernanceLevelIdentifierSetElement;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.GovernanceLevelIdentifierProperties;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.GovernanceLevelIdentifierSetProperties;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.ReferenceableProperties;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceLevelIdentifierResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceLevelIdentifierSetListResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceLevelIdentifierSetResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;

public class GovernanceClassificationLevelManager
extends GovernanceProgramBaseClient
implements GovernanceClassificationLevelInterface {
    public GovernanceClassificationLevelManager(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot);
    }

    public GovernanceClassificationLevelManager(String serverName, String serverPlatformURLRoot, String userId, String password) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password);
    }

    public GovernanceClassificationLevelManager(String serverName, String serverPlatformURLRoot, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, maxPageSize, auditLog);
    }

    public GovernanceClassificationLevelManager(String serverName, String serverPlatformURLRoot, String userId, String password, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password, maxPageSize, auditLog);
    }

    public GovernanceClassificationLevelManager(String serverName, String serverPlatformURLRoot, GovernanceProgramRESTClient restClient, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, restClient, maxPageSize);
    }

    public String createStandardGovernanceClassificationLevels(String userId, String classificationName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createStandardGovernanceClassificationLevels";
        String classificationNameParameter = "classificationName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/classification-level-sets/standard-set/{2}";
        this.invalidParameterHandler.validateUserId(userId, "createStandardGovernanceClassificationLevels");
        this.invalidParameterHandler.validateName(classificationName, "classificationName", "createStandardGovernanceClassificationLevels");
        GUIDResponse response = this.restClient.callGUIDPostRESTCall("createStandardGovernanceClassificationLevels", urlTemplate, this.nullRequestBody, new Object[]{this.serverName, userId, classificationName});
        return response.getGUID();
    }

    public String createGovernanceLevelIdentifierSet(String userId, GovernanceLevelIdentifierSetProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createGovernanceLevelIdentifierSet";
        String classificationNameParameter = "classificationName";
        String identifierPropertyNameParameter = "identifierPropertyName";
        String propertiesParameter = "properties";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/classification-level-sets";
        this.invalidParameterHandler.validateObject((Object)properties, "properties", "createGovernanceLevelIdentifierSet");
        this.invalidParameterHandler.validateName(properties.getClassificationName(), "classificationName", "createGovernanceLevelIdentifierSet");
        this.invalidParameterHandler.validateName(properties.getIdentifierPropertyName(), "identifierPropertyName", "createGovernanceLevelIdentifierSet");
        return super.createReferenceable(userId, (ReferenceableProperties)properties, "properties", urlTemplate, "createGovernanceLevelIdentifierSet");
    }

    public void updateGovernanceLevelIdentifierSet(String userId, String setGUID, GovernanceLevelIdentifierSetProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateGovernanceLevelIdentifierSet";
        String classificationNameParameter = "classificationName";
        String identifierPropertyNameParameter = "identifierPropertyName";
        String guidParameter = "setGUID";
        String propertiesParameter = "properties";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/classification-level-sets/{2}/update";
        this.invalidParameterHandler.validateObject((Object)properties, "properties", "updateGovernanceLevelIdentifierSet");
        this.invalidParameterHandler.validateName(properties.getClassificationName(), "classificationName", "updateGovernanceLevelIdentifierSet");
        this.invalidParameterHandler.validateName(properties.getIdentifierPropertyName(), "identifierPropertyName", "updateGovernanceLevelIdentifierSet");
        super.updateReferenceable(userId, setGUID, "setGUID", false, (ReferenceableProperties)properties, "properties", urlTemplate, "updateGovernanceLevelIdentifierSet");
    }

    public void removeGovernanceLevelIdentifierSet(String userId, String setGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeGovernanceLevelIdentifierSet";
        String guidParameter = "setGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/classification-level-sets/{2}/delete";
        super.removeReferenceable(userId, setGUID, "setGUID", urlTemplate, "removeGovernanceLevelIdentifierSet");
    }

    public List<GovernanceLevelIdentifierSetElement> getGovernanceLevelIdentifierSets(String userId) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernanceLevelIdentifierSets";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/classification-level-sets";
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceLevelIdentifierSets");
        GovernanceLevelIdentifierSetListResponse restResult = this.restClient.callLevelIdentifierSetListGetRESTCall("getGovernanceLevelIdentifierSets", urlTemplate, this.serverName, userId);
        return restResult.getElements();
    }

    public GovernanceLevelIdentifierSetElement getGovernanceLevelIdentifierSet(String userId, String classificationName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernanceLevelIdentifierSet";
        String classificationNameParameter = "classificationName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/classification-level-sets/classification-name/{2}";
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceLevelIdentifierSet");
        this.invalidParameterHandler.validateName(classificationName, "classificationName", "getGovernanceLevelIdentifierSet");
        GovernanceLevelIdentifierSetResponse restResult = this.restClient.callLevelIdentifierSetGetRESTCall("getGovernanceLevelIdentifierSet", urlTemplate, this.serverName, userId, classificationName);
        return restResult.getElement();
    }

    public GovernanceLevelIdentifierSetElement getGovernanceLevelIdentifierSetByGUID(String userId, String setGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernanceLevelIdentifierSet";
        String guidParameter = "setGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/classification-level-sets/{2}";
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceLevelIdentifierSet");
        this.invalidParameterHandler.validateGUID(setGUID, "setGUID", "getGovernanceLevelIdentifierSet");
        GovernanceLevelIdentifierSetResponse restResult = this.restClient.callLevelIdentifierSetGetRESTCall("getGovernanceLevelIdentifierSet", urlTemplate, this.serverName, userId, setGUID);
        return restResult.getElement();
    }

    public String createGovernanceLevelIdentifier(String userId, String setGUID, GovernanceLevelIdentifierProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createGovernanceLevelIdentifier";
        String guidParameter = "setGUID";
        String propertiesParameter = "qualifiedName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/classification-level-sets/identifier";
        return super.createReferenceableWithAnchor(userId, setGUID, "setGUID", (ReferenceableProperties)properties, "qualifiedName", urlTemplate, "createGovernanceLevelIdentifier");
    }

    public void updateGovernanceLevelIdentifier(String userId, String identifierGUID, GovernanceLevelIdentifierProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateGovernanceLevelIdentifier";
        String guidParameter = "identifierGUID";
        String propertiesParameter = "properties";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/classification-level-sets/identifier/{2}/update";
        super.updateReferenceable(userId, identifierGUID, "identifierGUID", false, (ReferenceableProperties)properties, "properties", urlTemplate, "updateGovernanceLevelIdentifier");
    }

    public void removeGovernanceLevelIdentifier(String userId, String identifierGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeGovernanceLevelIdentifier";
        String guidParameter = "identifierGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/classification-level-sets/identifier/{2}/delete";
        super.removeReferenceable(userId, identifierGUID, "identifierGUID", urlTemplate, "removeGovernanceLevelIdentifier");
    }

    public GovernanceLevelIdentifierElement getGovernanceLevelIdentifier(String userId, String classificationName, int levelIdentifier) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernanceLevelIdentifier";
        String classificationNameParameter = "classificationName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/classification-level-sets/classification-name/{2}/identifier/{3}";
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceLevelIdentifier");
        this.invalidParameterHandler.validateName(classificationName, "classificationName", "getGovernanceLevelIdentifier");
        GovernanceLevelIdentifierResponse restResult = this.restClient.callLevelIdentifierGetRESTCall("getGovernanceLevelIdentifier", urlTemplate, this.serverName, userId, classificationName, levelIdentifier);
        return restResult.getElement();
    }
}

