/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceprogram.client;

import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.governanceprogram.api.GovernanceRolesInterface;
import org.odpi.openmetadata.accessservices.governanceprogram.client.GovernanceProgramBaseClient;
import org.odpi.openmetadata.accessservices.governanceprogram.client.rest.GovernanceProgramRESTClient;
import org.odpi.openmetadata.accessservices.governanceprogram.metadataelements.GovernanceRoleAppointee;
import org.odpi.openmetadata.accessservices.governanceprogram.metadataelements.GovernanceRoleElement;
import org.odpi.openmetadata.accessservices.governanceprogram.metadataelements.GovernanceRoleHistory;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.GovernanceRoleProperties;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.AppointmentRequestBody;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceRoleAppointeeListResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceRoleHistoryResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceRoleListResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceRoleResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;

public class GovernanceRoleManager
extends GovernanceProgramBaseClient
implements GovernanceRolesInterface {
    public GovernanceRoleManager(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot);
    }

    public GovernanceRoleManager(String serverName, String serverPlatformURLRoot, String userId, String password) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password);
    }

    public GovernanceRoleManager(String serverName, String serverPlatformURLRoot, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, maxPageSize, auditLog);
    }

    public GovernanceRoleManager(String serverName, String serverPlatformURLRoot, String userId, String password, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password, maxPageSize, auditLog);
    }

    public GovernanceRoleManager(String serverName, String serverPlatformURLRoot, GovernanceProgramRESTClient restClient, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, restClient, maxPageSize);
    }

    public String createGovernanceRole(String userId, GovernanceRoleProperties properties) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "createGovernanceRole";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-roles";
        String propertiesParameterName = "properties";
        return super.createGovernanceRole(userId, properties, "properties", urlTemplate, "createGovernanceRole");
    }

    public void updateGovernanceRole(String userId, String governanceRoleGUID, boolean isMergeUpdate, GovernanceRoleProperties properties) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "updateGovernanceRole";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-roles/{2}?isMergeUpdate={3}";
        String guidParameterName = "governanceRoleGUID";
        String propertiesParameterName = "properties";
        super.updateGovernanceRole(userId, governanceRoleGUID, "governanceRoleGUID", isMergeUpdate, properties, "properties", urlTemplate, "updateGovernanceRole");
    }

    public void deleteGovernanceRole(String userId, String governanceRoleGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "deleteGovernanceRole";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-roles/{2}/delete";
        String guidParameterName = "governanceRoleGUID";
        this.invalidParameterHandler.validateGUID(governanceRoleGUID, "governanceRoleGUID", "deleteGovernanceRole");
        this.invalidParameterHandler.validateUserId(userId, "deleteGovernanceRole");
        super.removeReferenceable(userId, governanceRoleGUID, "governanceRoleGUID", urlTemplate, "deleteGovernanceRole");
    }

    public GovernanceRoleElement getGovernanceRoleByGUID(String userId, String governanceRoleGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getGovernanceRoleByGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-roles/{2}";
        String guidParameterName = "governanceRoleGUID";
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceRoleByGUID");
        this.invalidParameterHandler.validateGUID(governanceRoleGUID, "governanceRoleGUID", "getGovernanceRoleByGUID");
        GovernanceRoleResponse restResult = this.restClient.callGovernanceRoleGetRESTCall("getGovernanceRoleByGUID", urlTemplate, this.serverName, userId, governanceRoleGUID);
        return restResult.getElement();
    }

    public GovernanceRoleHistory getGovernanceRoleHistoryByGUID(String userId, String governanceRoleGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getGovernanceRoleHistoryByGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-roles/{2}/history";
        String guidParameterName = "governanceRoleGUID";
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceRoleHistoryByGUID");
        this.invalidParameterHandler.validateGUID(governanceRoleGUID, "governanceRoleGUID", "getGovernanceRoleHistoryByGUID");
        GovernanceRoleHistoryResponse restResult = this.restClient.callGovernanceRoleHistoryGetRESTCall("getGovernanceRoleHistoryByGUID", urlTemplate, this.serverName, userId, governanceRoleGUID);
        return restResult.getElement();
    }

    public List<GovernanceRoleElement> getGovernanceRoleByRoleId(String userId, String roleId) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getGovernanceRoleByRoleId";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-roles/by-role-id/{2}";
        String appointmentIdParameterName = "appointmentId";
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceRoleByRoleId");
        this.invalidParameterHandler.validateName(roleId, "appointmentId", "getGovernanceRoleByRoleId");
        GovernanceRoleListResponse restResult = this.restClient.callGovernanceRoleListGetRESTCall("getGovernanceRoleByRoleId", urlTemplate, this.serverName, userId, roleId);
        return restResult.getElements();
    }

    public List<GovernanceRoleElement> getGovernanceRolesByDomainId(String userId, int domainIdentifier, int startFrom, int pageSize) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getGovernanceRolesByDomainId";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-roles/by-domain/{2}?startFrom={3}&pageSize={4}";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(this.serverPlatformURLRoot, this.serverName, "getGovernanceRolesByDomainId");
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceRolesByDomainId");
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getGovernanceRolesByDomainId");
        GovernanceRoleListResponse restResult = this.restClient.callGovernanceRoleListGetRESTCall("getGovernanceRolesByDomainId", urlTemplate, this.serverName, userId, domainIdentifier, startFrom, queryPageSize);
        return restResult.getElements();
    }

    public List<GovernanceRoleElement> getGovernanceRolesByTitle(String userId, String title, int startFrom, int pageSize) throws UserNotAuthorizedException, InvalidParameterException, PropertyServerException {
        String methodName = "getGovernanceRolesByTitle";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-roles/by-title?startFrom={2}&pageSize={3}";
        String titleParameterName = "title";
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceRolesByTitle");
        this.invalidParameterHandler.validateSearchString(title, "title", "getGovernanceRolesByTitle");
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getGovernanceRolesByTitle");
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setSearchString(title);
        requestBody.setSearchStringParameterName("title");
        GovernanceRoleListResponse restResult = this.restClient.callGovernanceRoleListPostRESTCall("getGovernanceRolesByTitle", urlTemplate, requestBody, this.serverName, userId, startFrom, queryPageSize);
        return restResult.getElements();
    }

    public List<GovernanceRoleAppointee> getCurrentGovernanceRoleAppointments(String userId, int domainIdentifier, int startFrom, int pageSize) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getCurrentGovernanceRoleAppointments";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-roles/by-domain/{2}/current-appointments?startFrom={3}&pageSize={4}";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(this.serverPlatformURLRoot, this.serverName, "getCurrentGovernanceRoleAppointments");
        this.invalidParameterHandler.validateUserId(userId, "getCurrentGovernanceRoleAppointments");
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getCurrentGovernanceRoleAppointments");
        GovernanceRoleAppointeeListResponse restResult = this.restClient.callGovernanceRoleAppointeeListGetRESTCall("getCurrentGovernanceRoleAppointments", urlTemplate, this.serverName, userId, domainIdentifier, startFrom, queryPageSize);
        return restResult.getElements();
    }

    public String appointGovernanceRole(String userId, String governanceRoleGUID, String profileGUID, Date startDate) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "appointGovernanceRole";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-roles/{2}/appoint";
        String governanceRoleGUIDParameterName = "governanceRoleGUID";
        String profileGUIDParameterName = "profileGUID";
        this.invalidParameterHandler.validateUserId(userId, "appointGovernanceRole");
        this.invalidParameterHandler.validateGUID(governanceRoleGUID, "governanceRoleGUID", "appointGovernanceRole");
        this.invalidParameterHandler.validateGUID(profileGUID, "profileGUID", "appointGovernanceRole");
        AppointmentRequestBody requestBody = new AppointmentRequestBody();
        requestBody.setProfileGUID(profileGUID);
        requestBody.setEffectiveDate(startDate);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("appointGovernanceRole", urlTemplate, requestBody, new Object[]{this.serverName, userId, governanceRoleGUID});
        return restResult.getGUID();
    }

    public void relieveGovernanceRole(String userId, String governanceRoleGUID, String profileGUID, String appointmentGUID, Date endDate) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "relieveGovernanceRole";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-roles/{2}/relieve/{3}";
        String governanceRoleGUIDParameterName = "governanceRoleGUID";
        String profileGUIDParameterName = "profileGUID";
        this.invalidParameterHandler.validateUserId(userId, "relieveGovernanceRole");
        this.invalidParameterHandler.validateGUID(governanceRoleGUID, "governanceRoleGUID", "relieveGovernanceRole");
        this.invalidParameterHandler.validateGUID(profileGUID, "profileGUID", "relieveGovernanceRole");
        AppointmentRequestBody requestBody = new AppointmentRequestBody();
        requestBody.setProfileGUID(profileGUID);
        requestBody.setEffectiveDate(endDate);
        this.restClient.callVoidPostRESTCall("relieveGovernanceRole", urlTemplate, requestBody, new Object[]{this.serverName, userId, governanceRoleGUID, appointmentGUID});
    }
}

