/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceprogram.client;

import java.util.List;
import org.odpi.openmetadata.accessservices.governanceprogram.api.ExternalReferencesInterface;
import org.odpi.openmetadata.accessservices.governanceprogram.client.GovernanceProgramBaseClient;
import org.odpi.openmetadata.accessservices.governanceprogram.client.rest.GovernanceProgramRESTClient;
import org.odpi.openmetadata.commonservices.ffdc.rest.ExternalReferenceResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.ExternalReferencesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ExternalReferenceElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.RelatedElementStub;
import org.odpi.openmetadata.frameworks.openmetadata.properties.ReferenceableProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.RelationshipProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.externalreferences.ExternalReferenceLinkProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.externalreferences.ExternalReferenceProperties;

public class ExternalReferenceManager
extends GovernanceProgramBaseClient
implements ExternalReferencesInterface {
    public ExternalReferenceManager(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot);
    }

    public ExternalReferenceManager(String serverName, String serverPlatformURLRoot, String userId, String password) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password);
    }

    public ExternalReferenceManager(String serverName, String serverPlatformURLRoot, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, maxPageSize, auditLog);
    }

    public ExternalReferenceManager(String serverName, String serverPlatformURLRoot, String userId, String password, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password, maxPageSize, auditLog);
    }

    public ExternalReferenceManager(String serverName, String serverPlatformURLRoot, GovernanceProgramRESTClient restClient, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, restClient, maxPageSize);
    }

    public String createExternalReference(String userId, String anchorGUID, ExternalReferenceProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createExternalReference";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/external-references";
        String propertiesParameterName = "properties";
        return super.createReferenceable(userId, (ReferenceableProperties)properties, "properties", urlTemplate, "createExternalReference");
    }

    public void updateExternalReference(String userId, String externalReferenceGUID, boolean isMergeUpdate, ExternalReferenceProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateExternalReference";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/external-references/{2}/update?isMergeUpdate={4}";
        String guidParameterName = "externalReferenceGUID";
        String propertiesParameterName = "properties";
        super.updateReferenceable(userId, externalReferenceGUID, "externalReferenceGUID", isMergeUpdate, (ReferenceableProperties)properties, "properties", urlTemplate, "updateExternalReference");
    }

    public void deleteExternalReference(String userId, String externalReferenceGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "deleteExternalReference";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/external-references/{2}/delete";
        String guidParameterName = "externalReferenceGUID";
        super.removeReferenceable(userId, externalReferenceGUID, "externalReferenceGUID", urlTemplate, "deleteExternalReference");
    }

    public void linkExternalReferenceToElement(String userId, String attachedToGUID, String externalReferenceGUID, ExternalReferenceLinkProperties linkProperties) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "linkExternalReferenceToElement";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/elements/{2}/external-references/{3}/link";
        String elementGUIDParameterName = "attachedToGUID";
        String externalReferenceGUIDParameterName = "externalReferenceGUID";
        super.setupRelationship(userId, attachedToGUID, "attachedToGUID", null, (RelationshipProperties)linkProperties, externalReferenceGUID, "externalReferenceGUID", urlTemplate, "linkExternalReferenceToElement");
    }

    public void unlinkExternalReferenceFromElement(String userId, String attachedToGUID, String externalReferenceGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "unlinkExternalReferenceToElement";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/elements/{2}/external-references/{3}/unlink";
        String elementGUIDParameterName = "attachedToGUID";
        String externalReferenceGUIDParameterName = "externalReferenceGUID";
        super.clearRelationship(userId, attachedToGUID, "attachedToGUID", null, externalReferenceGUID, "externalReferenceGUID", urlTemplate, "unlinkExternalReferenceToElement");
    }

    public ExternalReferenceElement getExternalReferenceByGUID(String userId, String externalReferenceGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getExternalReferenceByGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/external-references/{2}";
        String guidParameterName = "externalReferenceGUID";
        this.invalidParameterHandler.validateUserId(userId, "getExternalReferenceByGUID");
        this.invalidParameterHandler.validateGUID(externalReferenceGUID, "externalReferenceGUID", "getExternalReferenceByGUID");
        ExternalReferenceResponse restResult = this.restClient.callExternalReferenceGetRESTCall("getExternalReferenceByGUID", urlTemplate, new Object[]{this.serverName, userId, externalReferenceGUID});
        return restResult.getElement();
    }

    public List<ExternalReferenceElement> findExternalReferencesById(String userId, String resourceId, int startFrom, int pageSize) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "findExternalReferencesById";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/external-references/by-resource-id?startFrom={2}&pageSize={3}";
        String resourceIdParameterName = "resourceId";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(this.serverPlatformURLRoot, this.serverName, "findExternalReferencesById");
        this.invalidParameterHandler.validateUserId(userId, "findExternalReferencesById");
        this.invalidParameterHandler.validateSearchString(resourceId, "resourceId", "findExternalReferencesById");
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "findExternalReferencesById");
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setSearchString(resourceId);
        requestBody.setSearchStringParameterName("resourceId");
        ExternalReferencesResponse restResult = this.restClient.callExternalReferencesPostRESTCall("findExternalReferencesById", urlTemplate, requestBody, new Object[]{this.serverName, userId, startFrom, queryPageSize});
        return restResult.getElements();
    }

    public List<ExternalReferenceElement> getExternalReferencesByURL(String userId, String url, int startFrom, int pageSize) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getExternalReferencesByURL";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/external-references/by-url?startFrom={2}&pageSize={3}";
        String urlParameterName = "resourceId";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(this.serverPlatformURLRoot, this.serverName, "getExternalReferencesByURL");
        this.invalidParameterHandler.validateUserId(userId, "getExternalReferencesByURL");
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getExternalReferencesByURL");
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setName(url);
        requestBody.setNameParameterName("resourceId");
        ExternalReferencesResponse restResult = this.restClient.callExternalReferencesPostRESTCall("getExternalReferencesByURL", urlTemplate, requestBody, new Object[]{this.serverName, userId, startFrom, queryPageSize});
        return restResult.getElements();
    }

    public List<ExternalReferenceElement> retrieveAttachedExternalReferences(String userId, String attachedToGUID, int startFrom, int pageSize) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "retrieveAttachedExternalReferences";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/elements/{2}/external-references?startFrom={3}&pageSize={4}";
        String guidParameterName = "attachedToGUID";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(this.serverPlatformURLRoot, this.serverName, "retrieveAttachedExternalReferences");
        this.invalidParameterHandler.validateUserId(userId, "retrieveAttachedExternalReferences");
        this.invalidParameterHandler.validateGUID(attachedToGUID, "attachedToGUID", "retrieveAttachedExternalReferences");
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "retrieveAttachedExternalReferences");
        ExternalReferencesResponse restResult = this.restClient.callExternalReferencesGetRESTCall("retrieveAttachedExternalReferences", urlTemplate, new Object[]{this.serverName, userId, attachedToGUID, startFrom, queryPageSize});
        return restResult.getElements();
    }

    public List<RelatedElementStub> getElementsForExternalReference(String userId, String externalReferenceGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getElementsForExternalReference";
        String guidParameter = "externalReferenceGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/elements/external-references/{2}?&startFrom={3}&pageSize={4}";
        return super.getRelatedElements(userId, externalReferenceGUID, "externalReferenceGUID", urlTemplate, startFrom, pageSize, "getElementsForExternalReference");
    }
}

