/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceprogram.client;

import org.odpi.openmetadata.accessservices.governanceprogram.api.GovernanceDefinitionsInterface;
import org.odpi.openmetadata.accessservices.governanceprogram.client.GovernanceProgramBaseClient;
import org.odpi.openmetadata.accessservices.governanceprogram.client.rest.GovernanceProgramRESTClient;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.openmetadata.enums.GovernanceDefinitionStatus;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.properties.RelationshipProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.actors.PeerDefinitionProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.governance.GovernanceDefinitionProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.governance.SupportingDefinitionProperties;

public class GovernanceDefinitionManager
extends GovernanceProgramBaseClient
implements GovernanceDefinitionsInterface {
    public GovernanceDefinitionManager(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot);
    }

    public GovernanceDefinitionManager(String serverName, String serverPlatformURLRoot, String userId, String password) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password);
    }

    public GovernanceDefinitionManager(String serverName, String serverPlatformURLRoot, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, maxPageSize, auditLog);
    }

    public GovernanceDefinitionManager(String serverName, String serverPlatformURLRoot, String userId, String password, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password, maxPageSize, auditLog);
    }

    public GovernanceDefinitionManager(String serverName, String serverPlatformURLRoot, GovernanceProgramRESTClient restClient, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, restClient, maxPageSize);
    }

    public String createGovernanceDefinition(String userId, GovernanceDefinitionProperties properties, GovernanceDefinitionStatus initialStatus) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createGovernanceDefinition";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-definitions";
        String propertiesParameterName = "properties";
        return super.createGovernanceDefinition(userId, properties, "properties", initialStatus, urlTemplate, "createGovernanceDefinition");
    }

    public void updateGovernanceDefinition(String userId, String definitionGUID, boolean isMergeUpdate, GovernanceDefinitionProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateGovernanceDefinition";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-definitions/{2}/update?isMergeUpdate={3}";
        String guidParameterName = "definitionGUID";
        String propertiesParameterName = "properties";
        super.updateGovernanceDefinition(userId, definitionGUID, "definitionGUID", isMergeUpdate, properties, "properties", urlTemplate, "updateGovernanceDefinition");
    }

    public void setGovernanceDefinitionStatus(String userId, String definitionGUID, GovernanceDefinitionStatus newStatus) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setGovernanceDefinitionStatus";
        String guidParameterName = "definitionGUID";
        String propertiesParameterName = "newStatus";
        super.updateGovernanceDefinitionStatus(userId, definitionGUID, "definitionGUID", newStatus, "newStatus", "setGovernanceDefinitionStatus");
    }

    public void deleteGovernanceDefinition(String userId, String definitionGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "deleteGovernanceDefinition";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-definitions/{2}/delete";
        String guidParameterName = "definitionGUID";
        super.removeReferenceable(userId, definitionGUID, "definitionGUID", urlTemplate, "deleteGovernanceDefinition");
    }

    public void linkPeerDefinitions(String userId, String definitionOneGUID, String definitionTwoGUID, String relationshipTypeName, PeerDefinitionProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "linkPeerDefinitions";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-definitions/{2}/peers/{3}/link";
        String definitionOneGUIDParameterName = "definitionOneGUID";
        String definitionTwoGUIDParameterName = "definitionTwoGUID";
        String relationshipTypeNameParameterName = "relationshipTypeName";
        this.invalidParameterHandler.validateName(relationshipTypeName, "relationshipTypeName", "linkPeerDefinitions");
        super.setupRelationship(userId, definitionOneGUID, "definitionOneGUID", relationshipTypeName, (RelationshipProperties)properties, definitionTwoGUID, "definitionTwoGUID", urlTemplate, "linkPeerDefinitions");
    }

    public void unlinkPeerDefinitions(String userId, String definitionOneGUID, String definitionTwoGUID, String relationshipTypeName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "unlinkPeerDefinitions";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-definitions/{2}/peers/{3}/unlink";
        String definitionOneGUIDParameterName = "definitionOneGUID";
        String definitionTwoGUIDParameterName = "definitionTwoGUID";
        String relationshipTypeNameParameterName = "relationshipTypeName";
        this.invalidParameterHandler.validateName(relationshipTypeName, "relationshipTypeName", "unlinkPeerDefinitions");
        super.clearRelationship(userId, definitionOneGUID, "definitionOneGUID", relationshipTypeName, "definitionTwoGUID", "definitionTwoGUID", urlTemplate, "unlinkPeerDefinitions");
    }

    public void setupSupportingDefinition(String userId, String definitionGUID, String supportingDefinitionGUID, String relationshipTypeName, SupportingDefinitionProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupSupportingDefinition";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-definitions/{2}/supporting-definitions/{3}/link";
        String definitionOneGUIDParameterName = "definitionGUID";
        String definitionTwoGUIDParameterName = "supportingDefinitionGUID";
        String relationshipTypeNameParameterName = "relationshipTypeName";
        this.invalidParameterHandler.validateName(relationshipTypeName, "relationshipTypeName", "setupSupportingDefinition");
        super.setupRelationship(userId, definitionGUID, "definitionGUID", relationshipTypeName, (RelationshipProperties)properties, supportingDefinitionGUID, "supportingDefinitionGUID", urlTemplate, "setupSupportingDefinition");
    }

    public void clearSupportingDefinition(String userId, String definitionGUID, String supportingDefinitionGUID, String relationshipTypeName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearSupportingDefinition";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-definitions/{2}/supporting-definitions/{3}/unlink";
        String definitionOneGUIDParameterName = "definitionGUID";
        String definitionTwoGUIDParameterName = "supportingDefinitionGUID";
        String relationshipTypeNameParameterName = "relationshipTypeName";
        this.invalidParameterHandler.validateName(relationshipTypeName, "relationshipTypeName", "clearSupportingDefinition");
        super.clearRelationship(userId, definitionGUID, "definitionGUID", relationshipTypeName, "supportingDefinitionGUID", "supportingDefinitionGUID", urlTemplate, "clearSupportingDefinition");
    }
}

