/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceprogram.client;

import java.util.List;
import org.odpi.openmetadata.accessservices.governanceprogram.api.GovernanceMetricsInterface;
import org.odpi.openmetadata.accessservices.governanceprogram.client.GovernanceProgramBaseClient;
import org.odpi.openmetadata.accessservices.governanceprogram.client.rest.GovernanceProgramRESTClient;
import org.odpi.openmetadata.commonservices.ffdc.rest.GovernanceMetricResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GovernanceMetricsResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.GovernanceMetricElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.ClassificationProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.ReferenceableProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.RelationshipProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.governance.GovernanceDefinitionMetricProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.governance.GovernanceExpectationsProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.governance.GovernanceMeasurementsDataSetProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.governance.GovernanceMeasurementsProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.governance.GovernanceMetricProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.governance.GovernanceResultsProperties;

public class GovernanceMetricsManager
extends GovernanceProgramBaseClient
implements GovernanceMetricsInterface {
    public GovernanceMetricsManager(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot);
    }

    public GovernanceMetricsManager(String serverName, String serverPlatformURLRoot, String userId, String password) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password);
    }

    public GovernanceMetricsManager(String serverName, String serverPlatformURLRoot, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, maxPageSize, auditLog);
    }

    public GovernanceMetricsManager(String serverName, String serverPlatformURLRoot, String userId, String password, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password, maxPageSize, auditLog);
    }

    public GovernanceMetricsManager(String serverName, String serverPlatformURLRoot, GovernanceProgramRESTClient restClient, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, restClient, maxPageSize);
    }

    public String createGovernanceMetric(String userId, GovernanceMetricProperties metricProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createGovernanceMetric";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-metrics";
        String propertiesParameterName = "metricProperties";
        return super.createReferenceable(userId, (ReferenceableProperties)metricProperties, "metricProperties", urlTemplate, "createGovernanceMetric");
    }

    public void updateGovernanceMetric(String userId, String metricGUID, boolean isMergeUpdate, GovernanceMetricProperties metricProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateGovernanceMetric";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-metrics/{2}/update?isMergeUpdate={4}";
        String guidParameterName = "metricGUID";
        String propertiesParameterName = "metricProperties";
        super.updateReferenceable(userId, metricGUID, "metricGUID", isMergeUpdate, (ReferenceableProperties)metricProperties, "metricProperties", urlTemplate, "updateGovernanceMetric");
    }

    public void deleteGovernanceMetric(String userId, String metricGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "deleteExternalReference";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-metrics/{2}/delete";
        String guidParameterName = "metricGUID";
        super.removeReferenceable(userId, metricGUID, "metricGUID", urlTemplate, "deleteExternalReference");
    }

    public void setupGovernanceDefinitionMetric(String userId, String metricGUID, String governanceDefinitionGUID, GovernanceDefinitionMetricProperties rationale) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupGovernanceDefinitionMetric";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-metrics/{2}/governance-definitions/{3}/link";
        String metricGUIDParameterName = "metricGUID";
        String governanceDefinitionGUIDParameterName = "governanceDefinitionGUID";
        super.setupRelationship(userId, metricGUID, "metricGUID", null, (RelationshipProperties)rationale, governanceDefinitionGUID, "governanceDefinitionGUID", urlTemplate, "setupGovernanceDefinitionMetric");
    }

    public void clearGovernanceDefinitionMetric(String userId, String metricGUID, String governanceDefinitionGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearGovernanceDefinitionMetric";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-metrics/{2}/governance-definitions/{3}/unlink";
        String metricGUIDParameterName = "metricGUID";
        String governanceDefinitionGUIDParameterName = "governanceDefinitionGUID";
        super.clearRelationship(userId, metricGUID, "metricGUID", null, governanceDefinitionGUID, "governanceDefinitionGUID", urlTemplate, "clearGovernanceDefinitionMetric");
    }

    public void setupGovernanceResults(String userId, String metricGUID, String dataSetGUID, GovernanceResultsProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupGovernanceResults";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-metrics/{2}/governance-results/{3}/link";
        String metricGUIDParameterName = "metricGUID";
        String dataSetGUIDParameterName = "dataSetGUID";
        super.setupRelationship(userId, metricGUID, "metricGUID", null, (RelationshipProperties)properties, dataSetGUID, "dataSetGUID", urlTemplate, "setupGovernanceResults");
    }

    public void clearGovernanceResults(String userId, String metricGUID, String dataSetGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearGovernanceResults";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-metrics/{2}/governance-results/{3}/unlink";
        String metricGUIDParameterName = "metricGUID";
        String governanceDefinitionGUIDParameterName = "dataSetGUID";
        this.clearRelationship(userId, metricGUID, "metricGUID", null, dataSetGUID, "dataSetGUID", urlTemplate, "clearGovernanceResults");
    }

    public void setGovernanceMeasurementsDataSet(String userId, String dataSetGUID, GovernanceMeasurementsDataSetProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setGovernanceMeasurementsDataSet";
        String guidParameter = "dataSetGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/data-sets/{2}/classify-as-governance-measurements-set";
        super.setReferenceableClassification(userId, dataSetGUID, "dataSetGUID", (ClassificationProperties)properties, urlTemplate, "setGovernanceMeasurementsDataSet");
    }

    public void clearGovernanceMeasurementsDataSet(String userId, String dataSetGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearGovernanceMeasurementsDataSet";
        String guidParameter = "dataSetGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/data-sets/{2}/classify-as-governance-measurements-set/delete";
        super.removeReferenceableClassification(userId, dataSetGUID, "dataSetGUID", urlTemplate, "clearGovernanceMeasurementsDataSet");
    }

    public void setGovernanceExpectations(String userId, String elementGUID, GovernanceExpectationsProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setGovernanceExpectations";
        String guidParameter = "elementGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/elements/{2}/classify-with-governance-expectations";
        super.setReferenceableClassification(userId, elementGUID, "elementGUID", (ClassificationProperties)properties, urlTemplate, "setGovernanceExpectations");
    }

    public void clearGovernanceExpectations(String userId, String elementGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearGovernanceExpectations";
        String guidParameter = "elementGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/elements/{2}/classify-with-governance-expectations/delete";
        super.removeReferenceableClassification(userId, elementGUID, "elementGUID", urlTemplate, "clearGovernanceExpectations");
    }

    public void setGovernanceMeasurements(String userId, String elementGUID, GovernanceMeasurementsProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setGovernanceMeasurements";
        String guidParameter = "elementGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/elements/{2}/classify-with-governance-measurements";
        super.setReferenceableClassification(userId, elementGUID, "elementGUID", (ClassificationProperties)properties, urlTemplate, "setGovernanceMeasurements");
    }

    public void clearGovernanceMeasurements(String userId, String elementGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearGovernanceMeasurements";
        String guidParameter = "elementGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/elements/{2}/classify-with-governance-measurements/delete";
        super.removeReferenceableClassification(userId, elementGUID, "elementGUID", urlTemplate, "clearGovernanceMeasurements");
    }

    public GovernanceMetricElement getGovernanceMetricByGUID(String userId, String metricGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernanceMetricByGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-metrics/{2}";
        String guidParameterName = "metricGUID";
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceMetricByGUID");
        this.invalidParameterHandler.validateGUID(metricGUID, "metricGUID", "getGovernanceMetricByGUID");
        GovernanceMetricResponse restResult = this.restClient.callGovernanceMetricGetRESTCall("getGovernanceMetricByGUID", urlTemplate, this.serverName, userId, metricGUID);
        return restResult.getElement();
    }

    public List<GovernanceMetricElement> findGovernanceMetrics(String userId, String searchString, int startFrom, int pageSize) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "findGovernanceMetrics";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-metrics/by-search-string?startFrom={2}&pageSize={3}";
        String searchStringParameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, "findGovernanceMetrics");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findGovernanceMetrics");
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "findGovernanceMetrics");
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        GovernanceMetricsResponse restResult = this.restClient.callGovernanceMetricListPostRESTCall("findGovernanceMetrics", urlTemplate, requestBody, this.serverName, userId, startFrom, queryPageSize);
        return restResult.getElements();
    }
}

