/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceprogram.client;

import java.util.List;
import org.odpi.openmetadata.accessservices.governanceprogram.api.GovernanceStatusLevelInterface;
import org.odpi.openmetadata.accessservices.governanceprogram.client.GovernanceProgramBaseClient;
import org.odpi.openmetadata.accessservices.governanceprogram.client.rest.GovernanceProgramRESTClient;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GovernanceStatusIdentifierResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GovernanceStatusIdentifierSetResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GovernanceStatusIdentifierSetsResponse;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.GovernanceStatusIdentifierElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.GovernanceStatusIdentifierSetElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.ReferenceableProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.governance.GovernanceStatusIdentifierProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.governance.GovernanceStatusIdentifierSetProperties;

public class GovernanceStatusLevelManager
extends GovernanceProgramBaseClient
implements GovernanceStatusLevelInterface {
    public GovernanceStatusLevelManager(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot);
    }

    public GovernanceStatusLevelManager(String serverName, String serverPlatformURLRoot, String userId, String password) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password);
    }

    public GovernanceStatusLevelManager(String serverName, String serverPlatformURLRoot, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, maxPageSize, auditLog);
    }

    public GovernanceStatusLevelManager(String serverName, String serverPlatformURLRoot, String userId, String password, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password, maxPageSize, auditLog);
    }

    public GovernanceStatusLevelManager(String serverName, String serverPlatformURLRoot, GovernanceProgramRESTClient restClient, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, restClient, maxPageSize);
    }

    public String createStandardGovernanceStatusLevels(String userId) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createStandardGovernanceStatusLevels";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-status-sets/standard-set";
        this.invalidParameterHandler.validateUserId(userId, "createStandardGovernanceStatusLevels");
        GUIDResponse response = this.restClient.callGUIDPostRESTCall("createStandardGovernanceStatusLevels", urlTemplate, this.nullRequestBody, new Object[]{this.serverName, userId});
        return response.getGUID();
    }

    public String createGovernanceStatusIdentifierSet(String userId, GovernanceStatusIdentifierSetProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createGovernanceStatusIdentifierSet";
        String propertiesParameter = "properties";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-status-sets";
        return super.createReferenceable(userId, (ReferenceableProperties)properties, "properties", urlTemplate, "createGovernanceStatusIdentifierSet");
    }

    public void updateGovernanceStatusIdentifierSet(String userId, String setGUID, GovernanceStatusIdentifierSetProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateGovernanceStatusIdentifierSet";
        String guidParameter = "setGUID";
        String propertiesParameter = "properties";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-status-sets/{2}/update";
        super.updateReferenceable(userId, setGUID, "setGUID", false, (ReferenceableProperties)properties, "properties", urlTemplate, "updateGovernanceStatusIdentifierSet");
    }

    public void removeGovernanceStatusIdentifierSet(String userId, String setGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeGovernanceStatusIdentifierSet";
        String guidParameter = "setGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-status-sets/{2}/delete";
        super.removeReferenceable(userId, setGUID, "setGUID", urlTemplate, "removeGovernanceStatusIdentifierSet");
    }

    public List<GovernanceStatusIdentifierSetElement> getGovernanceStatusIdentifierSets(String userId) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernanceStatusIdentifierSets";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-status-sets";
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceStatusIdentifierSets");
        GovernanceStatusIdentifierSetsResponse restResult = this.restClient.callStatusIdentifierSetListGetRESTCall("getGovernanceStatusIdentifierSets", urlTemplate, this.serverName, userId);
        return restResult.getElements();
    }

    public GovernanceStatusIdentifierSetElement getGovernanceStatusIdentifierSetByGUID(String userId, String setGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernanceStatusIdentifierSet";
        String guidParameter = "setGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-status-sets/{2}";
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceStatusIdentifierSet");
        this.invalidParameterHandler.validateGUID(setGUID, "setGUID", "getGovernanceStatusIdentifierSet");
        GovernanceStatusIdentifierSetResponse restResult = this.restClient.callStatusIdentifierSetGetRESTCall("getGovernanceStatusIdentifierSet", urlTemplate, this.serverName, userId, setGUID);
        return restResult.getElement();
    }

    public String createGovernanceStatusIdentifier(String userId, String setGUID, GovernanceStatusIdentifierProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createGovernanceStatusIdentifier";
        String guidParameter = "setGUID";
        String propertiesParameter = "qualifiedName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-status-sets/identifier";
        return super.createReferenceableWithAnchor(userId, setGUID, "setGUID", (ReferenceableProperties)properties, "qualifiedName", urlTemplate, "createGovernanceStatusIdentifier");
    }

    public void updateGovernanceStatusIdentifier(String userId, String identifierGUID, GovernanceStatusIdentifierProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateGovernanceStatusIdentifier";
        String guidParameter = "identifierGUID";
        String propertiesParameter = "properties";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-status-sets/identifier/{2}/update";
        super.updateReferenceable(userId, identifierGUID, "identifierGUID", false, (ReferenceableProperties)properties, "properties", urlTemplate, "updateGovernanceStatusIdentifier");
    }

    public void removeGovernanceStatusIdentifier(String userId, String identifierGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeGovernanceStatusIdentifier";
        String guidParameter = "identifierGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-status-sets/identifier/{2}/delete";
        super.removeReferenceable(userId, identifierGUID, "identifierGUID", urlTemplate, "removeGovernanceStatusIdentifier");
    }

    public GovernanceStatusIdentifierElement getGovernanceStatusIdentifier(String userId, int levelIdentifier) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernanceStatusIdentifier";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/governance-status-sets/identifier/{2}";
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceStatusIdentifier");
        GovernanceStatusIdentifierResponse restResult = this.restClient.callStatusIdentifierGetRESTCall("getGovernanceStatusIdentifier", urlTemplate, this.serverName, userId, levelIdentifier);
        return restResult.getElement();
    }
}

