/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceprogram.client;

import java.util.List;
import org.odpi.openmetadata.accessservices.governanceprogram.api.RightsManagementInterface;
import org.odpi.openmetadata.accessservices.governanceprogram.client.GovernanceProgramBaseClient;
import org.odpi.openmetadata.accessservices.governanceprogram.client.rest.GovernanceProgramRESTClient;
import org.odpi.openmetadata.commonservices.ffdc.rest.LicenseTypeResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.LicenseTypesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.LicensesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.openmetadata.enums.GovernanceDefinitionStatus;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.LicenseElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.LicenseTypeElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.RelatedElementStub;
import org.odpi.openmetadata.frameworks.openmetadata.properties.RelationshipProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.governance.GovernanceDefinitionProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.governance.LicenseProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.governance.LicenseTypeProperties;

public class RightsManager
extends GovernanceProgramBaseClient
implements RightsManagementInterface {
    public RightsManager(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot);
    }

    public RightsManager(String serverName, String serverPlatformURLRoot, String userId, String password) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password);
    }

    public RightsManager(String serverName, String serverPlatformURLRoot, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, maxPageSize, auditLog);
    }

    public RightsManager(String serverName, String serverPlatformURLRoot, String userId, String password, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password, maxPageSize, auditLog);
    }

    public RightsManager(String serverName, String serverPlatformURLRoot, GovernanceProgramRESTClient restClient, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, restClient, maxPageSize);
    }

    public String createLicenseType(String userId, LicenseTypeProperties properties, GovernanceDefinitionStatus initialStatus) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createLicenseType";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/license-types";
        String propertiesParameterName = "properties";
        return super.createGovernanceDefinition(userId, (GovernanceDefinitionProperties)properties, "properties", initialStatus, urlTemplate, "createLicenseType");
    }

    public void updateLicenseType(String userId, String licenseTypeGUID, boolean isMergeUpdate, LicenseTypeProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateLicenseType";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/license-types/{2}/update?isMergeUpdate={3}";
        String guidParameterName = "licenseTypeGUID";
        String propertiesParameterName = "properties";
        super.updateGovernanceDefinition(userId, licenseTypeGUID, "licenseTypeGUID", isMergeUpdate, (GovernanceDefinitionProperties)properties, "properties", urlTemplate, "updateLicenseType");
    }

    public void setLicenseTypeStatus(String userId, String licenseTypeGUID, GovernanceDefinitionStatus newStatus) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setGovernanceDefinitionStatus";
        String guidParameterName = "licenseTypeGUID";
        String propertiesParameterName = "newStatus";
        super.updateGovernanceDefinitionStatus(userId, licenseTypeGUID, "licenseTypeGUID", newStatus, "newStatus", "setGovernanceDefinitionStatus");
    }

    public void deleteLicenseType(String userId, String licenseTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "deleteLicenseType";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/license-types/{2}/delete";
        String guidParameterName = "licenseTypeGUID";
        super.removeReferenceable(userId, licenseTypeGUID, "licenseTypeGUID", urlTemplate, "deleteLicenseType");
    }

    public LicenseTypeElement getLicenseTypeByGUID(String userId, String licenseTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getLicenseTypeByGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/license-types/{2}";
        String guidParameterName = "licenseTypeGUID";
        this.invalidParameterHandler.validateUserId(userId, "getLicenseTypeByGUID");
        this.invalidParameterHandler.validateGUID(licenseTypeGUID, "licenseTypeGUID", "getLicenseTypeByGUID");
        LicenseTypeResponse restResult = this.restClient.callLicenseTypeGetRESTCall("getLicenseTypeByGUID", urlTemplate, this.serverName, userId, licenseTypeGUID);
        return restResult.getElement();
    }

    public LicenseTypeElement getLicenseTypeByDocId(String userId, String documentIdentifier) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getLicenseTypeByDocId";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/license-types/by-document-id/{2}";
        String documentIdParameterName = "documentId";
        this.invalidParameterHandler.validateUserId(userId, "getLicenseTypeByDocId");
        this.invalidParameterHandler.validateName(documentIdentifier, "documentId", "getLicenseTypeByDocId");
        LicenseTypeResponse restResult = this.restClient.callLicenseTypeGetRESTCall("getLicenseTypeByDocId", urlTemplate, this.serverName, userId, documentIdentifier);
        return restResult.getElement();
    }

    public List<LicenseTypeElement> getLicenseTypesByTitle(String userId, String title, int startFrom, int pageSize) throws UserNotAuthorizedException, InvalidParameterException, PropertyServerException {
        String methodName = "getLicenseTypesByTitle";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/license-types/by-title?startFrom={2}&pageSize={3}";
        String titleParameterName = "title";
        this.invalidParameterHandler.validateUserId(userId, "getLicenseTypesByTitle");
        this.invalidParameterHandler.validateSearchString(title, "title", "getLicenseTypesByTitle");
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getLicenseTypesByTitle");
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setSearchString(title);
        requestBody.setSearchStringParameterName("title");
        LicenseTypesResponse restResult = this.restClient.callLicenseTypeListPostRESTCall("getLicenseTypesByTitle", urlTemplate, requestBody, new Object[]{this.serverName, userId, startFrom, queryPageSize});
        return restResult.getElements();
    }

    public List<LicenseTypeElement> getLicenseTypeByDomainId(String userId, int domainIdentifier, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getLicenseTypeByDomainId";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/license-types/by-domain/{2}?startFrom={3}&pageSize={4}";
        this.invalidParameterHandler.validateUserId(userId, "getLicenseTypeByDomainId");
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getLicenseTypeByDomainId");
        LicenseTypesResponse restResult = this.restClient.callLicenseTypesGetRESTCall("getLicenseTypeByDomainId", urlTemplate, this.serverName, userId, domainIdentifier, startFrom, queryPageSize);
        return restResult.getElements();
    }

    public String licenseElement(String userId, String elementGUID, String licenseTypeGUID, LicenseProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "licenseElement";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/elements/{2}/license-types/{3}";
        String elementGUIDParameterName = "elementGUID";
        String licenseTypeGUIDParameterName = "licenseTypeGUID";
        return super.setupMultiLinkRelationship(userId, elementGUID, "elementGUID", null, (RelationshipProperties)properties, licenseTypeGUID, "licenseTypeGUID", urlTemplate, "licenseElement");
    }

    public void updateLicense(String userId, String licenseGUID, boolean isMergeUpdate, LicenseProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateLicense";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/licenses/{2}/update?isMergeUpdate={3}";
        String licenseGUIDParameterName = "licenseGUID";
        super.updateRelationship(userId, licenseGUID, "licenseGUID", isMergeUpdate, null, (RelationshipProperties)properties, urlTemplate, "updateLicense");
    }

    public void unlicenseElement(String userId, String licenseGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "unlicenseElement";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/licenses/{2}/delete";
        String licenseGUIDParameterName = "licenseGUID";
        super.clearRelationship(userId, licenseGUID, "licenseGUID", null, urlTemplate, "unlicenseElement");
    }

    public List<RelatedElementStub> getLicensedElements(String userId, String licenseGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getLicencedElements";
        String guidParameter = "licenseGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/elements/licenses/{2}?&startFrom={3}&pageSize={4}";
        return super.getRelatedElements(userId, licenseGUID, "licenseGUID", urlTemplate, startFrom, pageSize, "getLicencedElements");
    }

    public List<LicenseElement> getLicenses(String userId, String elementGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getLicences";
        String guidParameterName = "elementGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-program/users/{1}/elements/{2}/licenses?&startFrom={3}&pageSize={4}";
        this.invalidParameterHandler.validateUserId(userId, "getLicences");
        this.invalidParameterHandler.validateGUID(elementGUID, "elementGUID", "getLicences");
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getLicences");
        LicensesResponse restResult = this.restClient.callLicensesGetRESTCall("getLicences", urlTemplate, new Object[]{this.serverName, userId, elementGUID, startFrom, queryPageSize});
        return restResult.getElements();
    }
}

