/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceprogram.fvt.errorhandling;

import org.odpi.openmetadata.accessservices.governanceprogram.client.GovernanceDomainManager;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.GovernanceDomainProperties;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.fvt.utilities.exceptions.FVTUnexpectedCondition;

class CreateGovernanceDomainInvalidParameterTest {
    private final String testCaseName = "CreateGovernanceDomainInvalidParameterTest";
    private final String setGUID = "TestSetGUID";

    CreateGovernanceDomainInvalidParameterTest(String userId, GovernanceDomainManager client) throws FVTUnexpectedCondition {
        String activityName = "testCreateGovernanceDomain";
        try {
            this.testCreateGovernanceDomainNoUserId(client);
            this.testCreateGovernanceDomainNoProperties(client, userId);
            this.testCreateGovernanceDomainNoQualifiedName(client, userId);
        }
        catch (Throwable unexpectedError) {
            throw new FVTUnexpectedCondition("CreateGovernanceDomainInvalidParameterTest", "testCreateGovernanceDomain", unexpectedError);
        }
    }

    private void testCreateGovernanceDomainNoUserId(GovernanceDomainManager client) throws FVTUnexpectedCondition {
        String activityName = "testCreateGovernanceDomainNoUserId";
        GovernanceDomainProperties properties = new GovernanceDomainProperties();
        try {
            client.createGovernanceDomain(null, "TestSetGUID", properties);
            throw new FVTUnexpectedCondition("CreateGovernanceDomainInvalidParameterTest", "testCreateGovernanceDomainNoUserId");
        }
        catch (InvalidParameterException invalidParameterException) {
        }
        catch (Throwable unexpectedError) {
            throw new FVTUnexpectedCondition("CreateGovernanceDomainInvalidParameterTest", "testCreateGovernanceDomainNoUserId", unexpectedError);
        }
    }

    private void testCreateGovernanceDomainNoProperties(GovernanceDomainManager client, String userId) throws FVTUnexpectedCondition {
        String activityName = "testCreateGovernanceDomainNoProperties";
        try {
            client.createGovernanceDomain(userId, "TestSetGUID", null);
            throw new FVTUnexpectedCondition("CreateGovernanceDomainInvalidParameterTest", "testCreateGovernanceDomainNoProperties");
        }
        catch (InvalidParameterException invalidParameterException) {
        }
        catch (Throwable unexpectedError) {
            throw new FVTUnexpectedCondition("CreateGovernanceDomainInvalidParameterTest", "testCreateGovernanceDomainNoProperties", unexpectedError);
        }
    }

    private void testCreateGovernanceDomainNoQualifiedName(GovernanceDomainManager client, String userId) throws FVTUnexpectedCondition {
        String activityName = "testCreateGovernanceDomainNoQualifiedName";
        try {
            GovernanceDomainProperties properties = new GovernanceDomainProperties();
            client.createGovernanceDomain(userId, "TestSetGUID", properties);
            throw new FVTUnexpectedCondition("CreateGovernanceDomainInvalidParameterTest", "testCreateGovernanceDomainNoQualifiedName");
        }
        catch (InvalidParameterException properties) {
        }
        catch (Throwable unexpectedError) {
            throw new FVTUnexpectedCondition("CreateGovernanceDomainInvalidParameterTest", "testCreateGovernanceDomainNoQualifiedName", unexpectedError);
        }
    }
}

