/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceprogram.fvt.errorhandling;

import org.odpi.openmetadata.accessservices.governanceprogram.client.RightsManager;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.LicenseTypeProperties;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.fvt.utilities.exceptions.FVTUnexpectedCondition;

class CreateLicenseTypeInvalidParameterTest {
    private final String testCaseName = "CreateLicenseTypeInvalidParameterTest";

    CreateLicenseTypeInvalidParameterTest(String userId, RightsManager client) throws FVTUnexpectedCondition {
        String activityName = "testCreateLicenseType";
        try {
            this.testCreateLicenseTypeNoUserId(client);
            this.testCreateLicenseTypeNoProperties(client, userId);
            this.testCreateLicenseTypeNoQualifiedName(client, userId);
        }
        catch (Throwable unexpectedError) {
            throw new FVTUnexpectedCondition("CreateLicenseTypeInvalidParameterTest", "testCreateLicenseType", unexpectedError);
        }
    }

    private void testCreateLicenseTypeNoUserId(RightsManager client) throws FVTUnexpectedCondition {
        String activityName = "testCreateLicenseTypeNoUserId";
        LicenseTypeProperties properties = new LicenseTypeProperties();
        try {
            client.createLicenseType(null, properties);
            throw new FVTUnexpectedCondition("CreateLicenseTypeInvalidParameterTest", "testCreateLicenseTypeNoUserId");
        }
        catch (InvalidParameterException invalidParameterException) {
        }
        catch (Throwable unexpectedError) {
            throw new FVTUnexpectedCondition("CreateLicenseTypeInvalidParameterTest", "testCreateLicenseTypeNoUserId", unexpectedError);
        }
    }

    private void testCreateLicenseTypeNoProperties(RightsManager client, String userId) throws FVTUnexpectedCondition {
        String activityName = "testCreateLicenseTypeNoProperties";
        try {
            client.createLicenseType(userId, null);
            throw new FVTUnexpectedCondition("CreateLicenseTypeInvalidParameterTest", "testCreateLicenseTypeNoProperties");
        }
        catch (InvalidParameterException invalidParameterException) {
        }
        catch (Throwable unexpectedError) {
            throw new FVTUnexpectedCondition("CreateLicenseTypeInvalidParameterTest", "testCreateLicenseTypeNoProperties", unexpectedError);
        }
    }

    private void testCreateLicenseTypeNoQualifiedName(RightsManager client, String userId) throws FVTUnexpectedCondition {
        String activityName = "testCreateLicenseTypeNoQualifiedName";
        try {
            LicenseTypeProperties properties = new LicenseTypeProperties();
            client.createLicenseType(userId, properties);
            throw new FVTUnexpectedCondition("CreateLicenseTypeInvalidParameterTest", "testCreateLicenseTypeNoQualifiedName");
        }
        catch (InvalidParameterException properties) {
        }
        catch (Throwable unexpectedError) {
            throw new FVTUnexpectedCondition("CreateLicenseTypeInvalidParameterTest", "testCreateLicenseTypeNoQualifiedName", unexpectedError);
        }
    }
}

