/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceprogram.fvt.errorhandling;

import org.odpi.openmetadata.accessservices.governanceprogram.client.CertificationManager;
import org.odpi.openmetadata.accessservices.governanceprogram.client.ExternalReferenceManager;
import org.odpi.openmetadata.accessservices.governanceprogram.client.GovernanceClassificationLevelManager;
import org.odpi.openmetadata.accessservices.governanceprogram.client.GovernanceDefinitionManager;
import org.odpi.openmetadata.accessservices.governanceprogram.client.GovernanceDomainManager;
import org.odpi.openmetadata.accessservices.governanceprogram.client.GovernanceMetricsManager;
import org.odpi.openmetadata.accessservices.governanceprogram.client.GovernanceProgramReviewManager;
import org.odpi.openmetadata.accessservices.governanceprogram.client.GovernanceRoleManager;
import org.odpi.openmetadata.accessservices.governanceprogram.client.GovernanceZoneManager;
import org.odpi.openmetadata.accessservices.governanceprogram.client.RightsManager;
import org.odpi.openmetadata.accessservices.governanceprogram.client.SubjectAreaManager;
import org.odpi.openmetadata.accessservices.governanceprogram.client.rest.GovernanceProgramRESTClient;
import org.odpi.openmetadata.accessservices.governanceprogram.fvt.errorhandling.CreateCertificationTypeInvalidParameterTest;
import org.odpi.openmetadata.accessservices.governanceprogram.fvt.errorhandling.CreateExternalReferenceInvalidParameterTest;
import org.odpi.openmetadata.accessservices.governanceprogram.fvt.errorhandling.CreateGovernanceDefinitionInvalidParameterTest;
import org.odpi.openmetadata.accessservices.governanceprogram.fvt.errorhandling.CreateGovernanceDomainInvalidParameterTest;
import org.odpi.openmetadata.accessservices.governanceprogram.fvt.errorhandling.CreateGovernanceMetricInvalidParameterTest;
import org.odpi.openmetadata.accessservices.governanceprogram.fvt.errorhandling.CreateLicenseTypeInvalidParameterTest;
import org.odpi.openmetadata.accessservices.governanceprogram.fvt.errorhandling.CreateRoleInvalidParameterTest;
import org.odpi.openmetadata.accessservices.governanceprogram.fvt.errorhandling.CreateStandardClassificationLevelsInvalidParameterTest;
import org.odpi.openmetadata.accessservices.governanceprogram.fvt.errorhandling.CreateSubjectAreaInvalidParameterTest;
import org.odpi.openmetadata.accessservices.governanceprogram.fvt.errorhandling.CreateZoneInvalidParameterTest;
import org.odpi.openmetadata.accessservices.governanceprogram.fvt.errorhandling.GetGovernanceDefinitionsForDomainInvalidParameterTest;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.auditlog.AuditLogDestination;
import org.odpi.openmetadata.fvt.utilities.FVTResults;
import org.odpi.openmetadata.fvt.utilities.auditlog.FVTAuditLogDestination;
import org.odpi.openmetadata.fvt.utilities.exceptions.FVTUnexpectedCondition;

public class InvalidParameterTest {
    private static final String testCaseName = "InvalidParameterTest";
    private static final int maxPageSize = 100;

    public static FVTResults performFVT(String serverName, String serverPlatformRootURL, String userId) {
        FVTResults results = new FVTResults(testCaseName);
        results.incrementNumberOfTests();
        try {
            InvalidParameterTest.runIt(serverPlatformRootURL, serverName, userId, results.getAuditLogDestination());
            results.incrementNumberOfSuccesses();
        }
        catch (Exception error) {
            results.addCapturedError(error);
        }
        return results;
    }

    private static void runIt(String serverPlatformRootURL, String serverName, String userId, FVTAuditLogDestination auditLogDestination) throws FVTUnexpectedCondition {
        InvalidParameterTest thisTest = new InvalidParameterTest();
        AuditLog auditLog = new AuditLog((AuditLogDestination)auditLogDestination, AccessServiceDescription.GOVERNANCE_PROGRAM_OMAS.getAccessServiceCode(), AccessServiceDescription.GOVERNANCE_PROGRAM_OMAS.getAccessServiceName(), AccessServiceDescription.GOVERNANCE_PROGRAM_OMAS.getAccessServiceDescription(), AccessServiceDescription.GOVERNANCE_PROGRAM_OMAS.getAccessServiceWiki());
        thisTest.testCertificationClient(serverName, serverPlatformRootURL, userId, auditLog);
        thisTest.testGovernanceClassificationsClient(serverName, serverPlatformRootURL, userId, auditLog);
        thisTest.testExternalReferenceClient(serverName, serverPlatformRootURL, userId, auditLog);
        thisTest.testGovernanceDefinitionClient(serverName, serverPlatformRootURL, userId, auditLog);
        thisTest.testGovernanceDomainClient(serverName, serverPlatformRootURL, userId, auditLog);
        thisTest.testGovernanceMetricsClient(serverName, serverPlatformRootURL, userId, auditLog);
        thisTest.testGovernanceProgramReviewClient(serverName, serverPlatformRootURL, userId, auditLog);
        thisTest.testGovernanceRoleClient(serverName, serverPlatformRootURL, userId, auditLog);
        thisTest.testGovernanceZoneClient(serverName, serverPlatformRootURL, userId, auditLog);
        thisTest.testLicenseClient(serverName, serverPlatformRootURL, userId, auditLog);
        thisTest.testSubjectAreaClient(serverName, serverPlatformRootURL, userId, auditLog);
    }

    private void testGovernanceClassificationsClient(String serverName, String serverPlatformRootURL, String userId, AuditLog auditLog) throws FVTUnexpectedCondition {
        String activityName = "testGovernanceClassificationsClient";
        try {
            GovernanceProgramRESTClient restClient = new GovernanceProgramRESTClient(serverName, serverPlatformRootURL, auditLog);
            GovernanceClassificationLevelManager client = new GovernanceClassificationLevelManager(serverName, serverPlatformRootURL, restClient, 100);
            new CreateStandardClassificationLevelsInvalidParameterTest(userId, client);
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Throwable unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "testGovernanceClassificationsClient", unexpectedError);
        }
    }

    private void testGovernanceDefinitionClient(String serverName, String serverPlatformRootURL, String userId, AuditLog auditLog) throws FVTUnexpectedCondition {
        String activityName = "testGovernanceDefinitionClient";
        try {
            GovernanceProgramRESTClient restClient = new GovernanceProgramRESTClient(serverName, serverPlatformRootURL, auditLog);
            GovernanceDefinitionManager client = new GovernanceDefinitionManager(serverName, serverPlatformRootURL, restClient, 100);
            new CreateGovernanceDefinitionInvalidParameterTest(userId, client);
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Throwable unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "testGovernanceDefinitionClient", unexpectedError);
        }
    }

    private void testGovernanceDomainClient(String serverName, String serverPlatformRootURL, String userId, AuditLog auditLog) throws FVTUnexpectedCondition {
        String activityName = "testGovernanceDomainClient";
        try {
            GovernanceProgramRESTClient restClient = new GovernanceProgramRESTClient(serverName, serverPlatformRootURL, auditLog);
            GovernanceDomainManager client = new GovernanceDomainManager(serverName, serverPlatformRootURL, restClient, 100);
            new CreateGovernanceDomainInvalidParameterTest(userId, client);
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Throwable unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "testGovernanceDomainClient", unexpectedError);
        }
    }

    private void testGovernanceRoleClient(String serverName, String serverPlatformRootURL, String userId, AuditLog auditLog) throws FVTUnexpectedCondition {
        String activityName = "testGovernanceRoleClient";
        try {
            GovernanceProgramRESTClient restClient = new GovernanceProgramRESTClient(serverName, serverPlatformRootURL, auditLog);
            GovernanceRoleManager client = new GovernanceRoleManager(serverName, serverPlatformRootURL, restClient, 100);
            new CreateRoleInvalidParameterTest(userId, client);
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Throwable unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "testGovernanceRoleClient", unexpectedError);
        }
    }

    private void testGovernanceMetricsClient(String serverName, String serverPlatformRootURL, String userId, AuditLog auditLog) throws FVTUnexpectedCondition {
        String activityName = "testGovernanceMetricsClient";
        try {
            GovernanceProgramRESTClient restClient = new GovernanceProgramRESTClient(serverName, serverPlatformRootURL, auditLog);
            GovernanceMetricsManager client = new GovernanceMetricsManager(serverName, serverPlatformRootURL, restClient, 100);
            new CreateGovernanceMetricInvalidParameterTest(userId, client);
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Throwable unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "testGovernanceMetricsClient", unexpectedError);
        }
    }

    private void testGovernanceProgramReviewClient(String serverName, String serverPlatformRootURL, String userId, AuditLog auditLog) throws FVTUnexpectedCondition {
        String activityName = "testGovernanceProgramReviewClient";
        try {
            GovernanceProgramRESTClient restClient = new GovernanceProgramRESTClient(serverName, serverPlatformRootURL, auditLog);
            GovernanceProgramReviewManager client = new GovernanceProgramReviewManager(serverName, serverPlatformRootURL, restClient, 100);
            new GetGovernanceDefinitionsForDomainInvalidParameterTest(userId, client);
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Throwable unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "testGovernanceProgramReviewClient", unexpectedError);
        }
    }

    private void testGovernanceZoneClient(String serverName, String serverPlatformRootURL, String userId, AuditLog auditLog) throws FVTUnexpectedCondition {
        String activityName = "testGovernanceZoneClient";
        try {
            GovernanceProgramRESTClient restClient = new GovernanceProgramRESTClient(serverName, serverPlatformRootURL, auditLog);
            GovernanceZoneManager client = new GovernanceZoneManager(serverName, serverPlatformRootURL, restClient, 100);
            new CreateZoneInvalidParameterTest(userId, client);
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Throwable unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "testGovernanceZoneClient", unexpectedError);
        }
    }

    private void testSubjectAreaClient(String serverName, String serverPlatformRootURL, String userId, AuditLog auditLog) throws FVTUnexpectedCondition {
        String activityName = "testSubjectAreaClient";
        try {
            GovernanceProgramRESTClient restClient = new GovernanceProgramRESTClient(serverName, serverPlatformRootURL, auditLog);
            SubjectAreaManager client = new SubjectAreaManager(serverName, serverPlatformRootURL, restClient, 100);
            new CreateSubjectAreaInvalidParameterTest(userId, client);
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Throwable unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "testSubjectAreaClient", unexpectedError);
        }
    }

    private void testCertificationClient(String serverName, String serverPlatformRootURL, String userId, AuditLog auditLog) throws FVTUnexpectedCondition {
        String activityName = "testCertificationClient";
        try {
            GovernanceProgramRESTClient restClient = new GovernanceProgramRESTClient(serverName, serverPlatformRootURL, auditLog);
            CertificationManager client = new CertificationManager(serverName, serverPlatformRootURL, restClient, 100);
            new CreateCertificationTypeInvalidParameterTest(userId, client);
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Throwable unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "testCertificationClient", unexpectedError);
        }
    }

    private void testLicenseClient(String serverName, String serverPlatformRootURL, String userId, AuditLog auditLog) throws FVTUnexpectedCondition {
        String activityName = "testLicenseClient";
        try {
            GovernanceProgramRESTClient restClient = new GovernanceProgramRESTClient(serverName, serverPlatformRootURL, auditLog);
            RightsManager client = new RightsManager(serverName, serverPlatformRootURL, restClient, 100);
            new CreateLicenseTypeInvalidParameterTest(userId, client);
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Throwable unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "testLicenseClient", unexpectedError);
        }
    }

    private void testExternalReferenceClient(String serverName, String serverPlatformRootURL, String userId, AuditLog auditLog) throws FVTUnexpectedCondition {
        String activityName = "testExternalReferenceClient";
        try {
            GovernanceProgramRESTClient restClient = new GovernanceProgramRESTClient(serverName, serverPlatformRootURL, auditLog);
            ExternalReferenceManager client = new ExternalReferenceManager(serverName, serverPlatformRootURL, restClient, 100);
            new CreateExternalReferenceInvalidParameterTest(userId, client);
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Throwable unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "testExternalReferenceClient", unexpectedError);
        }
    }
}

