/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceprogram.fvt.errorhandling;

import org.odpi.openmetadata.accessservices.governanceprogram.client.SubjectAreaManager;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.SubjectAreaProperties;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.fvt.utilities.exceptions.FVTUnexpectedCondition;

class CreateSubjectAreaInvalidParameterTest {
    private final String testCaseName = "CreateSubjectAreaInvalidParameterTest";

    CreateSubjectAreaInvalidParameterTest(String userId, SubjectAreaManager client) throws FVTUnexpectedCondition {
        String activityName = "testCreateSubjectArea";
        try {
            this.testCreateSubjectAreaNoUserId(client);
            this.testCreateSubjectAreaNoProperties(client, userId);
            this.testCreateSubjectAreaNoQualifiedName(client, userId);
        }
        catch (Throwable unexpectedError) {
            throw new FVTUnexpectedCondition("CreateSubjectAreaInvalidParameterTest", "testCreateSubjectArea", unexpectedError);
        }
    }

    private void testCreateSubjectAreaNoUserId(SubjectAreaManager client) throws FVTUnexpectedCondition {
        String activityName = "testCreateSubjectAreaNoUserId";
        SubjectAreaProperties properties = new SubjectAreaProperties();
        try {
            client.createSubjectArea(null, properties);
            throw new FVTUnexpectedCondition("CreateSubjectAreaInvalidParameterTest", "testCreateSubjectAreaNoUserId");
        }
        catch (InvalidParameterException invalidParameterException) {
        }
        catch (Throwable unexpectedError) {
            throw new FVTUnexpectedCondition("CreateSubjectAreaInvalidParameterTest", "testCreateSubjectAreaNoUserId", unexpectedError);
        }
    }

    private void testCreateSubjectAreaNoProperties(SubjectAreaManager client, String userId) throws FVTUnexpectedCondition {
        String activityName = "testCreateSubjectAreaNoProperties";
        try {
            client.createSubjectArea(userId, null);
            throw new FVTUnexpectedCondition("CreateSubjectAreaInvalidParameterTest", "testCreateSubjectAreaNoProperties");
        }
        catch (InvalidParameterException invalidParameterException) {
        }
        catch (Throwable unexpectedError) {
            throw new FVTUnexpectedCondition("CreateSubjectAreaInvalidParameterTest", "testCreateSubjectAreaNoProperties", unexpectedError);
        }
    }

    private void testCreateSubjectAreaNoQualifiedName(SubjectAreaManager client, String userId) throws FVTUnexpectedCondition {
        String activityName = "testCreateSubjectAreaNoQualifiedName";
        try {
            SubjectAreaProperties properties = new SubjectAreaProperties();
            client.createSubjectArea(userId, properties);
            throw new FVTUnexpectedCondition("CreateSubjectAreaInvalidParameterTest", "testCreateSubjectAreaNoQualifiedName");
        }
        catch (InvalidParameterException properties) {
        }
        catch (Throwable unexpectedError) {
            throw new FVTUnexpectedCondition("CreateSubjectAreaInvalidParameterTest", "testCreateSubjectAreaNoQualifiedName", unexpectedError);
        }
    }
}

