/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceprogram.fvt.errorhandling;

import org.odpi.openmetadata.accessservices.governanceprogram.client.GovernanceZoneManager;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.GovernanceZoneProperties;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.fvt.utilities.exceptions.FVTUnexpectedCondition;

class CreateZoneInvalidParameterTest {
    private final String testCaseName = "CreateZoneInvalidParameterTest";

    CreateZoneInvalidParameterTest(String userId, GovernanceZoneManager client) throws FVTUnexpectedCondition {
        String activityName = "testCreateZone";
        try {
            this.testCreateZoneNoUserId(client);
            this.testCreateZoneNoProperties(client, userId);
            this.testCreateZoneNoQualifiedName(client, userId);
        }
        catch (Throwable unexpectedError) {
            throw new FVTUnexpectedCondition("CreateZoneInvalidParameterTest", "testCreateZone", unexpectedError);
        }
    }

    private void testCreateZoneNoUserId(GovernanceZoneManager client) throws FVTUnexpectedCondition {
        String activityName = "testCreateZoneNoUserId";
        GovernanceZoneProperties properties = new GovernanceZoneProperties();
        try {
            client.createGovernanceZone(null, properties);
            throw new FVTUnexpectedCondition("CreateZoneInvalidParameterTest", "testCreateZoneNoUserId");
        }
        catch (InvalidParameterException invalidParameterException) {
        }
        catch (Throwable unexpectedError) {
            throw new FVTUnexpectedCondition("CreateZoneInvalidParameterTest", "testCreateZoneNoUserId", unexpectedError);
        }
    }

    private void testCreateZoneNoProperties(GovernanceZoneManager client, String userId) throws FVTUnexpectedCondition {
        String activityName = "testCreateZoneNoProperties";
        try {
            client.createGovernanceZone(userId, null);
            throw new FVTUnexpectedCondition("CreateZoneInvalidParameterTest", "testCreateZoneNoProperties");
        }
        catch (InvalidParameterException invalidParameterException) {
        }
        catch (Throwable unexpectedError) {
            throw new FVTUnexpectedCondition("CreateZoneInvalidParameterTest", "testCreateZoneNoProperties", unexpectedError);
        }
    }

    private void testCreateZoneNoQualifiedName(GovernanceZoneManager client, String userId) throws FVTUnexpectedCondition {
        String activityName = "testCreateZoneNoQualifiedName";
        try {
            GovernanceZoneProperties properties = new GovernanceZoneProperties();
            client.createGovernanceZone(userId, properties);
            throw new FVTUnexpectedCondition("CreateZoneInvalidParameterTest", "testCreateZoneNoQualifiedName");
        }
        catch (InvalidParameterException properties) {
        }
        catch (Throwable unexpectedError) {
            throw new FVTUnexpectedCondition("CreateZoneInvalidParameterTest", "testCreateZoneNoQualifiedName", unexpectedError);
        }
    }
}

