/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceprogram.fvt.clientconstructors;

import org.odpi.openmetadata.accessservices.governanceprogram.client.CertificationManager;
import org.odpi.openmetadata.accessservices.governanceprogram.client.ExternalReferenceManager;
import org.odpi.openmetadata.accessservices.governanceprogram.client.GovernanceClassificationLevelManager;
import org.odpi.openmetadata.accessservices.governanceprogram.client.GovernanceDefinitionManager;
import org.odpi.openmetadata.accessservices.governanceprogram.client.GovernanceDomainManager;
import org.odpi.openmetadata.accessservices.governanceprogram.client.GovernanceMetricsManager;
import org.odpi.openmetadata.accessservices.governanceprogram.client.GovernanceProgramReviewManager;
import org.odpi.openmetadata.accessservices.governanceprogram.client.GovernanceRoleManager;
import org.odpi.openmetadata.accessservices.governanceprogram.client.GovernanceZoneManager;
import org.odpi.openmetadata.accessservices.governanceprogram.client.RightsManager;
import org.odpi.openmetadata.accessservices.governanceprogram.client.SubjectAreaManager;
import org.odpi.openmetadata.accessservices.governanceprogram.client.rest.GovernanceProgramRESTClient;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.auditlog.AuditLogDestination;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.fvt.utilities.FVTResults;
import org.odpi.openmetadata.fvt.utilities.auditlog.FVTAuditLogDestination;

public class ClientConstructorTest {
    private static final String testCaseName = "ClientConstructorTest";
    private static final String serverUserId = "TestNPA";
    private static final String serverPassword = "TestNPAPassword";
    private static final int maxPageSize = 100;

    public static FVTResults performFVT(String serverName, String serverPlatformRootURL) {
        FVTResults results = new FVTResults(testCaseName);
        results.incrementNumberOfTests();
        try {
            ClientConstructorTest.runIt(serverPlatformRootURL, serverName, results.getAuditLogDestination());
            results.incrementNumberOfSuccesses();
        }
        catch (Exception error) {
            results.addCapturedError(error);
        }
        return results;
    }

    private static void runIt(String serverPlatformRootURL, String serverName, FVTAuditLogDestination auditLogDestination) throws InvalidParameterException {
        ClientConstructorTest thisTest = new ClientConstructorTest();
        AuditLog auditLog = new AuditLog((AuditLogDestination)auditLogDestination, AccessServiceDescription.GOVERNANCE_PROGRAM_OMAS.getAccessServiceCode(), AccessServiceDescription.GOVERNANCE_PROGRAM_OMAS.getAccessServiceName(), AccessServiceDescription.GOVERNANCE_PROGRAM_OMAS.getAccessServiceDescription(), AccessServiceDescription.GOVERNANCE_PROGRAM_OMAS.getAccessServiceWiki());
        thisTest.testCertificationManagerClient(serverName, serverPlatformRootURL, auditLog);
        thisTest.testExternalReferenceManagerClient(serverName, serverPlatformRootURL, auditLog);
        thisTest.testClassificationLevelClient(serverName, serverPlatformRootURL, auditLog);
        thisTest.testGovernanceDefinitionManagerClient(serverName, serverPlatformRootURL, auditLog);
        thisTest.testGovernanceDomainManagerClient(serverName, serverPlatformRootURL, auditLog);
        thisTest.testGovernanceMetricsManagerClient(serverName, serverPlatformRootURL, auditLog);
        thisTest.testGovernanceProgramReviewManagerClient(serverName, serverPlatformRootURL, auditLog);
        thisTest.testGovernanceRoleManagerClient(serverName, serverPlatformRootURL, auditLog);
        thisTest.testGovernanceZoneManagerClient(serverName, serverPlatformRootURL, auditLog);
        thisTest.testRightsManagerClient(serverName, serverPlatformRootURL, auditLog);
        thisTest.testSubjectAreaManagerClient(serverName, serverPlatformRootURL, auditLog);
    }

    private void testGovernanceRoleManagerClient(String serverName, String serverPlatformRootURL, AuditLog auditLog) throws InvalidParameterException {
        new GovernanceRoleManager(serverName, serverPlatformRootURL, 100, auditLog);
        new GovernanceRoleManager(serverName, serverPlatformRootURL);
        new GovernanceRoleManager(serverName, serverPlatformRootURL, serverUserId, serverPassword, 100, auditLog);
        new GovernanceRoleManager(serverName, serverPlatformRootURL, serverUserId, serverPassword);
        GovernanceProgramRESTClient restClient = new GovernanceProgramRESTClient(serverName, serverPlatformRootURL);
        new GovernanceRoleManager(serverName, serverPlatformRootURL, restClient, 100);
    }

    private void testGovernanceDefinitionManagerClient(String serverName, String serverPlatformRootURL, AuditLog auditLog) throws InvalidParameterException {
        new GovernanceDefinitionManager(serverName, serverPlatformRootURL, 100, auditLog);
        new GovernanceDefinitionManager(serverName, serverPlatformRootURL);
        new GovernanceDefinitionManager(serverName, serverPlatformRootURL, serverUserId, serverPassword, 100, auditLog);
        new GovernanceDefinitionManager(serverName, serverPlatformRootURL, serverUserId, serverPassword);
        GovernanceProgramRESTClient restClient = new GovernanceProgramRESTClient(serverName, serverPlatformRootURL);
        new GovernanceDefinitionManager(serverName, serverPlatformRootURL, restClient, 100);
    }

    private void testGovernanceDomainManagerClient(String serverName, String serverPlatformRootURL, AuditLog auditLog) throws InvalidParameterException {
        new GovernanceDomainManager(serverName, serverPlatformRootURL, 100, auditLog);
        new GovernanceDomainManager(serverName, serverPlatformRootURL);
        new GovernanceDomainManager(serverName, serverPlatformRootURL, serverUserId, serverPassword, 100, auditLog);
        new GovernanceDomainManager(serverName, serverPlatformRootURL, serverUserId, serverPassword);
        GovernanceProgramRESTClient restClient = new GovernanceProgramRESTClient(serverName, serverPlatformRootURL);
        new GovernanceDomainManager(serverName, serverPlatformRootURL, restClient, 100);
    }

    private void testGovernanceMetricsManagerClient(String serverName, String serverPlatformRootURL, AuditLog auditLog) throws InvalidParameterException {
        new GovernanceMetricsManager(serverName, serverPlatformRootURL, 100, auditLog);
        new GovernanceMetricsManager(serverName, serverPlatformRootURL);
        new GovernanceMetricsManager(serverName, serverPlatformRootURL, serverUserId, serverPassword, 100, auditLog);
        new GovernanceMetricsManager(serverName, serverPlatformRootURL, serverUserId, serverPassword);
        GovernanceProgramRESTClient restClient = new GovernanceProgramRESTClient(serverName, serverPlatformRootURL);
        new GovernanceMetricsManager(serverName, serverPlatformRootURL, restClient, 100);
    }

    private void testGovernanceProgramReviewManagerClient(String serverName, String serverPlatformRootURL, AuditLog auditLog) throws InvalidParameterException {
        new GovernanceProgramReviewManager(serverName, serverPlatformRootURL, 100, auditLog);
        new GovernanceProgramReviewManager(serverName, serverPlatformRootURL);
        new GovernanceProgramReviewManager(serverName, serverPlatformRootURL, serverUserId, serverPassword, 100, auditLog);
        new GovernanceProgramReviewManager(serverName, serverPlatformRootURL, serverUserId, serverPassword);
        GovernanceProgramRESTClient restClient = new GovernanceProgramRESTClient(serverName, serverPlatformRootURL);
        new GovernanceProgramReviewManager(serverName, serverPlatformRootURL, restClient, 100);
    }

    private void testGovernanceZoneManagerClient(String serverName, String serverPlatformRootURL, AuditLog auditLog) throws InvalidParameterException {
        new GovernanceZoneManager(serverName, serverPlatformRootURL, 100, auditLog);
        new GovernanceZoneManager(serverName, serverPlatformRootURL);
        new GovernanceZoneManager(serverName, serverPlatformRootURL, serverUserId, serverPassword, 100, auditLog);
        new GovernanceZoneManager(serverName, serverPlatformRootURL, serverUserId, serverPassword);
        GovernanceProgramRESTClient restClient = new GovernanceProgramRESTClient(serverName, serverPlatformRootURL);
        new GovernanceZoneManager(serverName, serverPlatformRootURL, restClient, 100);
    }

    private void testSubjectAreaManagerClient(String serverName, String serverPlatformRootURL, AuditLog auditLog) throws InvalidParameterException {
        new SubjectAreaManager(serverName, serverPlatformRootURL, 100, auditLog);
        new SubjectAreaManager(serverName, serverPlatformRootURL);
        new SubjectAreaManager(serverName, serverPlatformRootURL, serverUserId, serverPassword, 100, auditLog);
        new SubjectAreaManager(serverName, serverPlatformRootURL, serverUserId, serverPassword);
        GovernanceProgramRESTClient restClient = new GovernanceProgramRESTClient(serverName, serverPlatformRootURL);
        new SubjectAreaManager(serverName, serverPlatformRootURL, restClient, 100);
    }

    private void testCertificationManagerClient(String serverName, String serverPlatformRootURL, AuditLog auditLog) throws InvalidParameterException {
        new CertificationManager(serverName, serverPlatformRootURL, 100, auditLog);
        new CertificationManager(serverName, serverPlatformRootURL);
        new CertificationManager(serverName, serverPlatformRootURL, serverUserId, serverPassword, 100, auditLog);
        new CertificationManager(serverName, serverPlatformRootURL, serverUserId, serverPassword);
        GovernanceProgramRESTClient restClient = new GovernanceProgramRESTClient(serverName, serverPlatformRootURL);
        new CertificationManager(serverName, serverPlatformRootURL, restClient, 100);
    }

    private void testRightsManagerClient(String serverName, String serverPlatformRootURL, AuditLog auditLog) throws InvalidParameterException {
        new RightsManager(serverName, serverPlatformRootURL, 100, auditLog);
        new RightsManager(serverName, serverPlatformRootURL);
        new RightsManager(serverName, serverPlatformRootURL, serverUserId, serverPassword, 100, auditLog);
        new RightsManager(serverName, serverPlatformRootURL, serverUserId, serverPassword);
        GovernanceProgramRESTClient restClient = new GovernanceProgramRESTClient(serverName, serverPlatformRootURL);
        new RightsManager(serverName, serverPlatformRootURL, restClient, 100);
    }

    private void testExternalReferenceManagerClient(String serverName, String serverPlatformRootURL, AuditLog auditLog) throws InvalidParameterException {
        new ExternalReferenceManager(serverName, serverPlatformRootURL, 100, auditLog);
        new ExternalReferenceManager(serverName, serverPlatformRootURL);
        new ExternalReferenceManager(serverName, serverPlatformRootURL, serverUserId, serverPassword, 100, auditLog);
        new ExternalReferenceManager(serverName, serverPlatformRootURL, serverUserId, serverPassword);
        GovernanceProgramRESTClient restClient = new GovernanceProgramRESTClient(serverName, serverPlatformRootURL);
        new ExternalReferenceManager(serverName, serverPlatformRootURL, restClient, 100);
    }

    private void testClassificationLevelClient(String serverName, String serverPlatformRootURL, AuditLog auditLog) throws InvalidParameterException {
        new GovernanceClassificationLevelManager(serverName, serverPlatformRootURL, 100, auditLog);
        new GovernanceClassificationLevelManager(serverName, serverPlatformRootURL);
        new GovernanceClassificationLevelManager(serverName, serverPlatformRootURL, serverUserId, serverPassword, 100, auditLog);
        new GovernanceClassificationLevelManager(serverName, serverPlatformRootURL, serverUserId, serverPassword);
        GovernanceProgramRESTClient restClient = new GovernanceProgramRESTClient(serverName, serverPlatformRootURL);
        new GovernanceClassificationLevelManager(serverName, serverPlatformRootURL, restClient, 100);
    }
}

