/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceprogram.fvt.errorhandling;

import org.odpi.openmetadata.accessservices.governanceprogram.client.ExternalReferenceManager;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.ExternalReferenceProperties;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.fvt.utilities.exceptions.FVTUnexpectedCondition;

class CreateExternalReferenceInvalidParameterTest {
    private final String testCaseName = "CreateExternalReferenceInvalidParameterTest";
    private final String testAnchorGUID = "TestAnchorGUID";

    CreateExternalReferenceInvalidParameterTest(String userId, ExternalReferenceManager client) throws FVTUnexpectedCondition {
        String activityName = "testCreateExternalReference";
        try {
            this.testCreateExternalReferenceNoUserId(client);
            this.testCreateExternalReferenceNoProperties(client, userId);
            this.testCreateExternalReferenceNoQualifiedName(client, userId);
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition("CreateExternalReferenceInvalidParameterTest", "testCreateExternalReference", (Throwable)unexpectedError);
        }
    }

    private void testCreateExternalReferenceNoUserId(ExternalReferenceManager client) throws FVTUnexpectedCondition {
        String activityName = "testCreateExternalReferenceNoUserId";
        ExternalReferenceProperties properties = new ExternalReferenceProperties();
        try {
            client.createExternalReference(null, "TestAnchorGUID", properties);
            throw new FVTUnexpectedCondition("CreateExternalReferenceInvalidParameterTest", "testCreateExternalReferenceNoUserId");
        }
        catch (InvalidParameterException invalidParameterException) {
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition("CreateExternalReferenceInvalidParameterTest", "testCreateExternalReferenceNoUserId", (Throwable)unexpectedError);
        }
    }

    private void testCreateExternalReferenceNoProperties(ExternalReferenceManager client, String userId) throws FVTUnexpectedCondition {
        String activityName = "testCreateExternalReferenceNoProperties";
        try {
            client.createExternalReference(userId, "TestAnchorGUID", null);
            throw new FVTUnexpectedCondition("CreateExternalReferenceInvalidParameterTest", "testCreateExternalReferenceNoProperties");
        }
        catch (InvalidParameterException invalidParameterException) {
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition("CreateExternalReferenceInvalidParameterTest", "testCreateExternalReferenceNoProperties", (Throwable)unexpectedError);
        }
    }

    private void testCreateExternalReferenceNoQualifiedName(ExternalReferenceManager client, String userId) throws FVTUnexpectedCondition {
        String activityName = "testCreateExternalReferenceNoQualifiedName";
        try {
            ExternalReferenceProperties properties = new ExternalReferenceProperties();
            client.createExternalReference(userId, "TestAnchorGUID", properties);
            throw new FVTUnexpectedCondition("CreateExternalReferenceInvalidParameterTest", "testCreateExternalReferenceNoQualifiedName");
        }
        catch (InvalidParameterException properties) {
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition("CreateExternalReferenceInvalidParameterTest", "testCreateExternalReferenceNoQualifiedName", (Throwable)unexpectedError);
        }
    }
}

