/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceprogram.fvt.errorhandling;

import org.odpi.openmetadata.accessservices.governanceprogram.client.GovernanceDefinitionManager;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.GovernanceDefinitionProperties;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.GovernanceDefinitionStatus;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.fvt.utilities.exceptions.FVTUnexpectedCondition;

class CreateGovernanceDefinitionInvalidParameterTest {
    private final String testCaseName = "CreateGovernanceDefinitionInvalidParameterTest";

    CreateGovernanceDefinitionInvalidParameterTest(String userId, GovernanceDefinitionManager client) throws FVTUnexpectedCondition {
        String activityName = "testCreateGovernanceDefinition";
        try {
            this.testCreateGovernanceDefinitionNoUserId(client);
            this.testCreateGovernanceDefinitionNoProperties(client, userId);
            this.testCreateGovernanceDefinitionNoQualifiedName(client, userId);
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition("CreateGovernanceDefinitionInvalidParameterTest", "testCreateGovernanceDefinition", (Throwable)unexpectedError);
        }
    }

    private void testCreateGovernanceDefinitionNoUserId(GovernanceDefinitionManager client) throws FVTUnexpectedCondition {
        String activityName = "testCreateGovernanceDefinitionNoUserId";
        GovernanceDefinitionProperties properties = new GovernanceDefinitionProperties();
        try {
            client.createGovernanceDefinition(null, properties, GovernanceDefinitionStatus.ACTIVE);
            throw new FVTUnexpectedCondition("CreateGovernanceDefinitionInvalidParameterTest", "testCreateGovernanceDefinitionNoUserId");
        }
        catch (InvalidParameterException invalidParameterException) {
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition("CreateGovernanceDefinitionInvalidParameterTest", "testCreateGovernanceDefinitionNoUserId", (Throwable)unexpectedError);
        }
    }

    private void testCreateGovernanceDefinitionNoProperties(GovernanceDefinitionManager client, String userId) throws FVTUnexpectedCondition {
        String activityName = "testCreateGovernanceDefinitionNoProperties";
        try {
            client.createGovernanceDefinition(userId, null, GovernanceDefinitionStatus.ACTIVE);
            throw new FVTUnexpectedCondition("CreateGovernanceDefinitionInvalidParameterTest", "testCreateGovernanceDefinitionNoProperties");
        }
        catch (InvalidParameterException invalidParameterException) {
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition("CreateGovernanceDefinitionInvalidParameterTest", "testCreateGovernanceDefinitionNoProperties", (Throwable)unexpectedError);
        }
    }

    private void testCreateGovernanceDefinitionNoQualifiedName(GovernanceDefinitionManager client, String userId) throws FVTUnexpectedCondition {
        String activityName = "testCreateGovernanceDefinitionNoQualifiedName";
        try {
            GovernanceDefinitionProperties properties = new GovernanceDefinitionProperties();
            client.createGovernanceDefinition(userId, properties, GovernanceDefinitionStatus.ACTIVE);
            throw new FVTUnexpectedCondition("CreateGovernanceDefinitionInvalidParameterTest", "testCreateGovernanceDefinitionNoQualifiedName");
        }
        catch (InvalidParameterException properties) {
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition("CreateGovernanceDefinitionInvalidParameterTest", "testCreateGovernanceDefinitionNoQualifiedName", (Throwable)unexpectedError);
        }
    }
}

