/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceprogram.fvt;

import java.io.IOException;
import org.odpi.openmetadata.accessservices.governanceprogram.fvt.clientconstructors.ClientConstructorTest;
import org.odpi.openmetadata.accessservices.governanceprogram.fvt.definitions.CreateDefinitionTest;
import org.odpi.openmetadata.accessservices.governanceprogram.fvt.errorhandling.InvalidParameterTest;
import org.odpi.openmetadata.fvt.utilities.FVTResults;
import org.odpi.openmetadata.fvt.utilities.FVTSuiteBase;
import org.odpi.openmetadata.http.HttpHelper;

public class GovernanceProgramOMASFVTSuite
extends FVTSuiteBase {
    public static void main(String[] args) {
        int exitCode;
        try {
            String url = GovernanceProgramOMASFVTSuite.getUrl((String[])args);
            String serverName = GovernanceProgramOMASFVTSuite.getServerName((String[])args);
            String userId = GovernanceProgramOMASFVTSuite.getUserId((String[])args);
            GovernanceProgramOMASFVTSuite fvtSuite = new GovernanceProgramOMASFVTSuite();
            exitCode = fvtSuite.performFVT(serverName, url, userId);
        }
        catch (IOException error) {
            System.out.println("Error getting user input");
            error.printStackTrace();
            exitCode = -99;
        }
        System.exit(exitCode);
    }

    public int performFVT(String serverName, String serverPlatformRootURL, String userId) {
        HttpHelper.noStrictSSL();
        int returnCode = 0;
        FVTResults results = ClientConstructorTest.performFVT(serverName, serverPlatformRootURL);
        if (!results.isSuccessful()) {
            --returnCode;
        }
        results.printResults(serverName);
        results = InvalidParameterTest.performFVT(serverName, serverPlatformRootURL, userId);
        if (!results.isSuccessful()) {
            --returnCode;
        }
        results.printResults(serverName);
        results = CreateDefinitionTest.performFVT(serverName, serverPlatformRootURL, userId);
        if (!results.isSuccessful()) {
            --returnCode;
        }
        results.printResults(serverName);
        return returnCode;
    }
}

