/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceprogram.fvt.definitions;

import java.util.List;
import org.odpi.openmetadata.accessservices.governanceprogram.client.GovernanceDomainManager;
import org.odpi.openmetadata.accessservices.governanceprogram.client.rest.GovernanceProgramRESTClient;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.auditlog.AuditLogDestination;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.GovernanceDomainElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.GovernanceDomainSetElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.governance.GovernanceDomainProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.governance.GovernanceDomainSetProperties;
import org.odpi.openmetadata.fvt.utilities.FVTResults;
import org.odpi.openmetadata.fvt.utilities.auditlog.FVTAuditLogDestination;
import org.odpi.openmetadata.fvt.utilities.exceptions.FVTUnexpectedCondition;

public class CreateDefinitionTest {
    private static final String testCaseName = "CreateDefinitionTest";
    private static final int maxPageSize = 100;

    public static FVTResults performFVT(String serverName, String serverPlatformRootURL, String userId) {
        FVTResults results = new FVTResults(testCaseName);
        results.incrementNumberOfTests();
        try {
            CreateDefinitionTest.runIt(serverPlatformRootURL, serverName, userId, results.getAuditLogDestination());
            results.incrementNumberOfSuccesses();
        }
        catch (Exception error) {
            results.addCapturedError(error);
        }
        return results;
    }

    private static void runIt(String serverPlatformRootURL, String serverName, String userId, FVTAuditLogDestination auditLogDestination) throws FVTUnexpectedCondition {
        String governanceDomainSetName = "CocoPharmaceuticals";
        CreateDefinitionTest thisTest = new CreateDefinitionTest();
        AuditLog auditLog = new AuditLog((AuditLogDestination)auditLogDestination, AccessServiceDescription.GOVERNANCE_PROGRAM_OMAS.getAccessServiceCode(), AccessServiceDescription.GOVERNANCE_PROGRAM_OMAS.getAccessServiceDevelopmentStatus(), AccessServiceDescription.GOVERNANCE_PROGRAM_OMAS.getAccessServiceName(), AccessServiceDescription.GOVERNANCE_PROGRAM_OMAS.getAccessServiceDescription(), AccessServiceDescription.GOVERNANCE_PROGRAM_OMAS.getAccessServiceWiki());
        GovernanceDomainManager domainManagerClient = thisTest.getDomainManagerClient(serverName, serverPlatformRootURL);
        String activityName = "newDomain";
        try {
            String newDomainGUID = thisTest.createGovernanceDomain(domainManagerClient, userId, "CocoPharmaceuticals");
            thisTest.addStandardGovernanceDomains(domainManagerClient, userId, "CocoPharmaceuticals");
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, activityName, (Throwable)unexpectedError);
        }
    }

    private GovernanceDomainManager getDomainManagerClient(String serverName, String serverPlatformRootURL) throws FVTUnexpectedCondition {
        String activityName = "getDomainManagerClient";
        try {
            GovernanceProgramRESTClient restClient = new GovernanceProgramRESTClient(serverName, serverPlatformRootURL);
            return new GovernanceDomainManager(serverName, serverPlatformRootURL, restClient, 100);
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "getDomainManagerClient", (Throwable)unexpectedError);
        }
    }

    private void addStandardGovernanceDomains(GovernanceDomainManager domainManagerClient, String userId, String domainSetName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException, FVTUnexpectedCondition {
        String activityName = "addStandardGovernanceDomains";
        String standardGovernanceDomainSetName = "EgeriaStandardDomains";
        List domainSets = domainManagerClient.findGovernanceDomainSets(userId, ".*", 0, 0);
        if (domainSets == null) {
            throw new FVTUnexpectedCondition(testCaseName, "addStandardGovernanceDomains(No domain sets returned)");
        }
        if (domainSets.size() != 1) {
            throw new FVTUnexpectedCondition(testCaseName, "addStandardGovernanceDomains(Too many domain sets returned)");
        }
        GovernanceDomainSetElement cocoDomainSet = (GovernanceDomainSetElement)domainSets.get(0);
        if (cocoDomainSet == null) {
            throw new FVTUnexpectedCondition(testCaseName, "addStandardGovernanceDomains(No " + domainSetName + " domain set returned)");
        }
        if (!domainSetName.equals(cocoDomainSet.getProperties().getDisplayName())) {
            throw new FVTUnexpectedCondition(testCaseName, "addStandardGovernanceDomains(Bad values in " + domainSetName + ": " + cocoDomainSet + ")");
        }
        String standardDomainSetGUID = domainManagerClient.createStandardGovernanceDomains(userId);
        GovernanceDomainSetElement standardDomainSet = domainManagerClient.getGovernanceDomainSetByGUID(userId, standardDomainSetGUID);
        if (standardDomainSet == null) {
            throw new FVTUnexpectedCondition(testCaseName, "addStandardGovernanceDomains(No new domain set)");
        }
        if (standardDomainSet.getElementHeader() == null) {
            throw new FVTUnexpectedCondition(testCaseName, "addStandardGovernanceDomains(No new domain set header: " + standardDomainSet + ")");
        }
        if (standardDomainSet.getProperties() == null) {
            throw new FVTUnexpectedCondition(testCaseName, "addStandardGovernanceDomains(No new domain set properties: " + standardDomainSet + ")");
        }
        if (!standardDomainSetGUID.equals(standardDomainSet.getElementHeader().getGUID())) {
            throw new FVTUnexpectedCondition(testCaseName, "addStandardGovernanceDomains(Bad set GUID: " + standardDomainSet + ")");
        }
        if (standardDomainSet.getDomains() == null) {
            throw new FVTUnexpectedCondition(testCaseName, "addStandardGovernanceDomains(No domains in set: " + standardDomainSet + ")");
        }
        if (standardDomainSet.getDomains().isEmpty()) {
            throw new FVTUnexpectedCondition(testCaseName, "addStandardGovernanceDomains(Empty domains in set: " + standardDomainSet + ")");
        }
    }

    private String createGovernanceDomain(GovernanceDomainManager domainManagerClient, String userId, String domainSetName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException, FVTUnexpectedCondition {
        String activityName = "createGovernanceDomain";
        String domainSetDescription = "Governance Domains for Coco Pharmaceuticals";
        int governanceDomainIdentifier = 8;
        String governanceDomainName = "Product Assurance";
        String governanceDomainDescription = "Ensuring Coco Pharmaceutical products are developed in an ethical manner that complies with the regulations and provides efficacious treatments.";
        List domainSets = domainManagerClient.getGovernanceDomainSetsByName(userId, domainSetName, 0, 0);
        if (domainSets != null) {
            throw new FVTUnexpectedCondition(testCaseName, "createGovernanceDomain(Too many domain sets returned: " + domainSets + ")");
        }
        GovernanceDomainSetProperties setProperties = new GovernanceDomainSetProperties();
        setProperties.setQualifiedName("GovernanceDomainSet:" + domainSetName);
        setProperties.setDisplayName(domainSetName);
        setProperties.setDescription("Governance Domains for Coco Pharmaceuticals");
        String domainSetGUID = domainManagerClient.createGovernanceDomainSet(userId, setProperties);
        GovernanceDomainProperties properties = new GovernanceDomainProperties();
        properties.setDomainIdentifier(8);
        properties.setQualifiedName("GovernanceDomain:8");
        properties.setDisplayName("Product Assurance");
        properties.setDescription("Ensuring Coco Pharmaceutical products are developed in an ethical manner that complies with the regulations and provides efficacious treatments.");
        String domainGUID = domainManagerClient.createGovernanceDomain(userId, domainSetGUID, properties);
        GovernanceDomainElement newDomain = domainManagerClient.getGovernanceDomainByGUID(userId, domainGUID);
        if (newDomain == null) {
            throw new FVTUnexpectedCondition(testCaseName, "createGovernanceDomain(No new domain)");
        }
        if (newDomain.getElementHeader() == null) {
            throw new FVTUnexpectedCondition(testCaseName, "createGovernanceDomain(No new domain header: " + newDomain + ")");
        }
        if (newDomain.getProperties() == null) {
            throw new FVTUnexpectedCondition(testCaseName, "createGovernanceDomain(No new domain properties: " + newDomain + ")");
        }
        if (!domainGUID.equals(newDomain.getElementHeader().getGUID())) {
            throw new FVTUnexpectedCondition(testCaseName, "createGovernanceDomain(Bad GUID: " + newDomain + ")");
        }
        return domainGUID;
    }
}

