/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceprogram.fvt.errorhandling;

import org.odpi.openmetadata.accessservices.governanceprogram.client.GovernanceRoleManager;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.properties.governance.GovernanceRoleProperties;
import org.odpi.openmetadata.fvt.utilities.exceptions.FVTUnexpectedCondition;

class CreateRoleInvalidParameterTest {
    private final String testCaseName = "CreateRoleInvalidParameterTest";

    CreateRoleInvalidParameterTest(String userId, GovernanceRoleManager client) throws FVTUnexpectedCondition {
        String activityName = "testCreateRole";
        try {
            this.testCreateRoleNoUserId(client);
            this.testCreateRoleNoProperties(client, userId);
            this.testCreateRoleNoQualifiedName(client, userId);
            this.testCreateRoleNoTitle(client, userId);
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition("CreateRoleInvalidParameterTest", "testCreateRole", (Throwable)unexpectedError);
        }
    }

    private void testCreateRoleNoUserId(GovernanceRoleManager client) throws FVTUnexpectedCondition {
        String activityName = "testCreateRoleNoUserId";
        GovernanceRoleProperties properties = new GovernanceRoleProperties();
        try {
            client.createGovernanceRole(null, properties);
            throw new FVTUnexpectedCondition("CreateRoleInvalidParameterTest", "testCreateRoleNoUserId");
        }
        catch (InvalidParameterException invalidParameterException) {
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition("CreateRoleInvalidParameterTest", "testCreateRoleNoUserId", (Throwable)unexpectedError);
        }
    }

    private void testCreateRoleNoProperties(GovernanceRoleManager client, String userId) throws FVTUnexpectedCondition {
        String activityName = "testCreateRoleNoProperties";
        try {
            client.createGovernanceRole(userId, null);
            throw new FVTUnexpectedCondition("CreateRoleInvalidParameterTest", "testCreateRoleNoProperties");
        }
        catch (InvalidParameterException invalidParameterException) {
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition("CreateRoleInvalidParameterTest", "testCreateRoleNoProperties", (Throwable)unexpectedError);
        }
    }

    private void testCreateRoleNoQualifiedName(GovernanceRoleManager client, String userId) throws FVTUnexpectedCondition {
        String activityName = "testCreateRoleNoQualifiedName";
        try {
            GovernanceRoleProperties properties = new GovernanceRoleProperties();
            properties.setTitle("TestTitle");
            client.createGovernanceRole(userId, properties);
            throw new FVTUnexpectedCondition("CreateRoleInvalidParameterTest", "testCreateRoleNoQualifiedName");
        }
        catch (InvalidParameterException properties) {
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition("CreateRoleInvalidParameterTest", "testCreateRoleNoQualifiedName", (Throwable)unexpectedError);
        }
    }

    private void testCreateRoleNoTitle(GovernanceRoleManager client, String userId) throws FVTUnexpectedCondition {
        String activityName = "testCreateRoleNoQualifiedName";
        try {
            GovernanceRoleProperties properties = new GovernanceRoleProperties();
            properties.setRoleId("TestQualifiedName");
            client.createGovernanceRole(userId, properties);
            throw new FVTUnexpectedCondition("CreateRoleInvalidParameterTest", "testCreateRoleNoQualifiedName");
        }
        catch (InvalidParameterException properties) {
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition("CreateRoleInvalidParameterTest", "testCreateRoleNoQualifiedName", (Throwable)unexpectedError);
        }
    }
}

