/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceprogram.fvt.errorhandling;

import org.odpi.openmetadata.accessservices.governanceprogram.client.CertificationManager;
import org.odpi.openmetadata.frameworks.openmetadata.enums.GovernanceDefinitionStatus;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.properties.governance.CertificationTypeProperties;
import org.odpi.openmetadata.fvt.utilities.exceptions.FVTUnexpectedCondition;

class CreateCertificationTypeInvalidParameterTest {
    private final String testCaseName = "CreateCertificationTypeInvalidParameterTest";

    CreateCertificationTypeInvalidParameterTest(String userId, CertificationManager client) throws FVTUnexpectedCondition {
        String activityName = "testCreateCertificationType";
        try {
            this.testCreateCertificationTypeNoUserId(client);
            this.testCreateCertificationTypeNoProperties(client, userId);
            this.testCreateCertificationTypeNoQualifiedName(client, userId);
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition("CreateCertificationTypeInvalidParameterTest", "testCreateCertificationType", unexpectedError);
        }
    }

    private void testCreateCertificationTypeNoUserId(CertificationManager client) throws FVTUnexpectedCondition {
        String activityName = "testCreateCertificationTypeNoUserId";
        CertificationTypeProperties properties = new CertificationTypeProperties();
        try {
            client.createCertificationType(null, properties, GovernanceDefinitionStatus.ACTIVE);
            throw new FVTUnexpectedCondition("CreateCertificationTypeInvalidParameterTest", "testCreateCertificationTypeNoUserId");
        }
        catch (InvalidParameterException invalidParameterException) {
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition("CreateCertificationTypeInvalidParameterTest", "testCreateCertificationTypeNoUserId", unexpectedError);
        }
    }

    private void testCreateCertificationTypeNoProperties(CertificationManager client, String userId) throws FVTUnexpectedCondition {
        String activityName = "testCreateCertificationTypeNoProperties";
        try {
            client.createCertificationType(userId, null, GovernanceDefinitionStatus.ACTIVE);
            throw new FVTUnexpectedCondition("CreateCertificationTypeInvalidParameterTest", "testCreateCertificationTypeNoProperties");
        }
        catch (InvalidParameterException invalidParameterException) {
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition("CreateCertificationTypeInvalidParameterTest", "testCreateCertificationTypeNoProperties", unexpectedError);
        }
    }

    private void testCreateCertificationTypeNoQualifiedName(CertificationManager client, String userId) throws FVTUnexpectedCondition {
        String activityName = "testCreateCertificationTypeNoQualifiedName";
        try {
            CertificationTypeProperties properties = new CertificationTypeProperties();
            client.createCertificationType(userId, properties, GovernanceDefinitionStatus.ACTIVE);
            throw new FVTUnexpectedCondition("CreateCertificationTypeInvalidParameterTest", "testCreateCertificationTypeNoQualifiedName");
        }
        catch (InvalidParameterException properties) {
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition("CreateCertificationTypeInvalidParameterTest", "testCreateCertificationTypeNoQualifiedName", unexpectedError);
        }
    }
}

