/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceprogram.fvt.errorhandling;

import org.odpi.openmetadata.accessservices.governanceprogram.client.GovernanceMetricsManager;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.properties.governance.GovernanceMetricProperties;
import org.odpi.openmetadata.fvt.utilities.exceptions.FVTUnexpectedCondition;

class CreateGovernanceMetricInvalidParameterTest {
    private final String testCaseName = "CreateGovernanceMetricInvalidParameterTest";

    CreateGovernanceMetricInvalidParameterTest(String userId, GovernanceMetricsManager client) throws FVTUnexpectedCondition {
        String activityName = "testCreateGovernanceMetric";
        try {
            this.testCreateGovernanceMetricNoUserId(client);
            this.testCreateGovernanceMetricNoProperties(client, userId);
            this.testCreateGovernanceMetricNoQualifiedName(client, userId);
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition("CreateGovernanceMetricInvalidParameterTest", "testCreateGovernanceMetric", unexpectedError);
        }
    }

    private void testCreateGovernanceMetricNoUserId(GovernanceMetricsManager client) throws FVTUnexpectedCondition {
        String activityName = "testCreateGovernanceMetricNoUserId";
        GovernanceMetricProperties properties = new GovernanceMetricProperties();
        try {
            client.createGovernanceMetric(null, properties);
            throw new FVTUnexpectedCondition("CreateGovernanceMetricInvalidParameterTest", "testCreateGovernanceMetricNoUserId");
        }
        catch (InvalidParameterException invalidParameterException) {
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition("CreateGovernanceMetricInvalidParameterTest", "testCreateGovernanceMetricNoUserId", unexpectedError);
        }
    }

    private void testCreateGovernanceMetricNoProperties(GovernanceMetricsManager client, String userId) throws FVTUnexpectedCondition {
        String activityName = "testCreateGovernanceMetricNoProperties";
        try {
            client.createGovernanceMetric(userId, null);
            throw new FVTUnexpectedCondition("CreateGovernanceMetricInvalidParameterTest", "testCreateGovernanceMetricNoProperties");
        }
        catch (InvalidParameterException invalidParameterException) {
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition("CreateGovernanceMetricInvalidParameterTest", "testCreateGovernanceMetricNoProperties", unexpectedError);
        }
    }

    private void testCreateGovernanceMetricNoQualifiedName(GovernanceMetricsManager client, String userId) throws FVTUnexpectedCondition {
        String activityName = "testCreateGovernanceMetricNoQualifiedName";
        try {
            GovernanceMetricProperties properties = new GovernanceMetricProperties();
            client.createGovernanceMetric(userId, properties);
            throw new FVTUnexpectedCondition("CreateGovernanceMetricInvalidParameterTest", "testCreateGovernanceMetricNoQualifiedName");
        }
        catch (InvalidParameterException properties) {
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition("CreateGovernanceMetricInvalidParameterTest", "testCreateGovernanceMetricNoQualifiedName", unexpectedError);
        }
    }
}

