/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceprogram.server;

import java.util.List;
import org.odpi.openmetadata.accessservices.governanceprogram.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.governanceprogram.ffdc.exceptions.PropertyServerException;
import org.odpi.openmetadata.accessservices.governanceprogram.ffdc.exceptions.UnrecognizedGUIDException;
import org.odpi.openmetadata.accessservices.governanceprogram.ffdc.exceptions.UserNotAuthorizedException;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.ExternalReference;
import org.odpi.openmetadata.accessservices.governanceprogram.server.GovernanceProgramErrorHandler;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalReferencesHandler {
    private static final String externalReferenceTypeGUID = "af536f20-062b-48ef-9c31-1ddd05b04c56";
    private static final String externalReferenceTypeName = "ExternalReference";
    private static final String externalReferenceIdPropertyName = "qualifiedName";
    private static final String displayNamePropertyName = "displayName";
    private static final String uriPropertyName = "url";
    private static final String versionPropertyName = "version";
    private static final String resourceDescriptionPropertyName = "description";
    private static final String organizationPropertyName = "organization";
    private static final String additionalPropertiesName = "additionalProperties";
    private static final String externalReferenceLinkTypeGUID = "7d818a67-ab45-481c-bc28-f6b1caf12f06";
    private static final String externalReferenceLinkTypeName = "ExternalReferenceLink";
    private static final String localReferenceIdPropertyName = "referenceId";
    private static final String linkDescriptionPropertyName = "description";
    private static final Logger log = LoggerFactory.getLogger(ExternalReferencesHandler.class);
    private String serviceName;
    private OMRSRepositoryHelper repositoryHelper = null;
    private String serverName = null;
    private GovernanceProgramErrorHandler errorHandler = null;

    ExternalReferencesHandler(String serviceName, OMRSRepositoryConnector repositoryConnector) {
        this.serviceName = serviceName;
        if (repositoryConnector != null) {
            this.repositoryHelper = repositoryConnector.getRepositoryHelper();
            this.serverName = repositoryConnector.getServerName();
            this.errorHandler = new GovernanceProgramErrorHandler(repositoryConnector);
        }
    }

    public void storeExternalReferences(String userId, String attachedEntityGUID, List<ExternalReference> externalReferences) throws UnrecognizedGUIDException, InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "storeExternalReferences";
        log.warn("storeExternalReferences not implemented");
    }

    public List<ExternalReference> retrieveExternalReferences(String userId, String attachedEntityGUID) throws UnrecognizedGUIDException, InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "retrieveExternalReferences";
        log.warn("retrieveExternalReferences not implemented");
        return null;
    }
}

