/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceprogram.server;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.governanceprogram.ffdc.GovernanceProgramErrorCode;
import org.odpi.openmetadata.accessservices.governanceprogram.ffdc.exceptions.AppointmentIdNotUniqueException;
import org.odpi.openmetadata.accessservices.governanceprogram.ffdc.exceptions.GovernanceAppointeeNotUniqueException;
import org.odpi.openmetadata.accessservices.governanceprogram.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.governanceprogram.ffdc.exceptions.PropertyServerException;
import org.odpi.openmetadata.accessservices.governanceprogram.ffdc.exceptions.UnrecognizedGUIDException;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.ExternalReference;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.GovernanceDomain;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.GovernanceOfficer;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.GovernanceOfficerAppointee;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.PersonalProfile;
import org.odpi.openmetadata.accessservices.governanceprogram.server.ExternalReferencesHandler;
import org.odpi.openmetadata.accessservices.governanceprogram.server.GovernanceProgramBasicHandler;
import org.odpi.openmetadata.accessservices.governanceprogram.server.GovernanceProgramEnumHandler;
import org.odpi.openmetadata.accessservices.governanceprogram.server.GovernanceProgramErrorHandler;
import org.odpi.openmetadata.accessservices.governanceprogram.server.PersonalProfileHandler;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.MatchCriteria;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GovernanceOfficerHandler {
    private static final String governanceOfficerTypeGUID = "578a3510-9ad3-45fe-8ada-e4e9572c37c8";
    private static final String governanceOfficerTypeName = "GovernanceOfficer";
    private static final String appointmentIdPropertyName = "qualifiedName";
    private static final String titlePropertyName = "title";
    private static final String appointmentContextPropertyName = "scope";
    private static final String governanceDomainPropertyName = "domain";
    private static final String additionalPropertiesName = "additionalProperties";
    private static final String governancePostTypeGUID = "4c4d1d0c-a9fc-4305-8b71-4e691c0f9ae0";
    private static final String governancePostTypeName = "GovernancePost";
    private static final String personalProfileTypeName = "Person";
    private static final String governanceOfficerGUIDParameterName = "governanceOfficerGUID";
    private static final String governanceDomainParameterName = "governanceDomain";
    private static final String appointmentIdParameterName = "appointmentId";
    private static final String titleParameterName = "title";
    private static final String profileGUIDParameterName = "profileGUID";
    private static final Logger log = LoggerFactory.getLogger(GovernanceOfficerHandler.class);
    private String serviceName;
    private GovernanceProgramErrorHandler errorHandler;
    private GovernanceProgramBasicHandler basicHandler;
    private ExternalReferencesHandler externalReferencesHandler;
    private PersonalProfileHandler personalProfileHandler;
    private OMRSRepositoryHelper repositoryHelper = null;
    private String serverName = null;
    private GovernanceProgramEnumHandler enumHandler = null;

    GovernanceOfficerHandler(String serviceName, OMRSRepositoryConnector repositoryConnector) {
        this.serviceName = serviceName;
        this.errorHandler = new GovernanceProgramErrorHandler(repositoryConnector);
        this.basicHandler = new GovernanceProgramBasicHandler(serviceName, repositoryConnector);
        this.externalReferencesHandler = new ExternalReferencesHandler(serviceName, repositoryConnector);
        this.personalProfileHandler = new PersonalProfileHandler(serviceName, repositoryConnector);
        if (repositoryConnector != null) {
            this.repositoryHelper = repositoryConnector.getRepositoryHelper();
            this.serverName = repositoryConnector.getServerName();
            this.enumHandler = new GovernanceProgramEnumHandler(serviceName, this.repositoryHelper);
        }
    }

    private InstanceProperties createGovernanceOfficerProperties(String methodName, GovernanceDomain governanceDomain, String appointmentId, String appointmentContext, String title, Map<String, Object> additionalProperties) throws InvalidParameterException {
        this.errorHandler.validateEnum(governanceDomain, governanceDomainParameterName, methodName);
        this.errorHandler.validateName(appointmentId, appointmentIdParameterName, methodName);
        this.errorHandler.validateName(title, "title", methodName);
        InstanceProperties properties = this.enumHandler.addGovernanceDomainToProperties(null, governanceDomain, governanceDomainPropertyName, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, appointmentIdPropertyName, appointmentId, methodName);
        if (appointmentContext != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, appointmentContextPropertyName, appointmentContext, methodName);
        }
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "title", title, methodName);
        if (additionalProperties != null) {
            properties = this.repositoryHelper.addMapPropertyToInstance(this.serviceName, properties, additionalPropertiesName, additionalProperties, methodName);
        }
        log.debug("Instance properties: " + properties.toString());
        return properties;
    }

    private GovernanceOfficer getGovernanceOfficerFromInstances(EntityDetail governanceOfficerEntity, String userId, OMRSMetadataCollection metadataCollection, String methodName) throws PropertyServerException {
        GovernanceOfficer governanceOfficer = null;
        long now = new Date().getTime();
        if (governanceOfficerEntity != null) {
            governanceOfficer = new GovernanceOfficer();
            governanceOfficer.setGUID(governanceOfficerEntity.getGUID());
            governanceOfficer.setType(governanceOfficerTypeName);
            InstanceProperties instanceProperties = governanceOfficerEntity.getProperties();
            if (instanceProperties != null) {
                governanceOfficer.setAppointmentId(this.repositoryHelper.getStringProperty(this.serviceName, appointmentIdPropertyName, instanceProperties, methodName));
                governanceOfficer.setAppointmentContext(this.repositoryHelper.getStringProperty(this.serviceName, appointmentContextPropertyName, instanceProperties, methodName));
                governanceOfficer.setTitle(this.repositoryHelper.getStringProperty(this.serviceName, "title", instanceProperties, methodName));
                governanceOfficer.setGovernanceDomain(this.enumHandler.getGovernanceDomainFromProperties(instanceProperties, governanceDomainPropertyName, methodName));
                governanceOfficer.setAdditionalProperties(this.repositoryHelper.getMapFromProperty(this.serviceName, additionalPropertiesName, instanceProperties, methodName));
            }
            try {
                List relationships = metadataCollection.getRelationshipsForEntity(userId, governanceOfficerEntity.getGUID(), governancePostTypeGUID, 0, null, null, null, null, 100);
                if (relationships != null) {
                    List<GovernanceOfficerAppointee> currentIncumbents = this.getCurrentIncumbents(relationships, now, userId);
                    if (currentIncumbents == null) {
                        governanceOfficer.setAppointee(null);
                    } else if (currentIncumbents.size() == 1) {
                        governanceOfficer.setAppointee(currentIncumbents.get(0));
                    } else {
                        GovernanceDomain governanceDomain = governanceOfficer.getGovernanceDomain();
                        if (governanceDomain == null) {
                            governanceDomain = GovernanceDomain.OTHER;
                        }
                        GovernanceProgramErrorCode errorCode = GovernanceProgramErrorCode.MULTIPLE_INCUMBENTS_FOR_GOVERNANCE_OFFICER;
                        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{governanceDomain.getName(), governanceOfficer.getGUID(), governanceOfficer.getAppointmentId(), governanceOfficer.getAppointmentContext(), Integer.toString(currentIncumbents.size())});
                        throw new GovernanceAppointeeNotUniqueException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), currentIncumbents);
                    }
                    governanceOfficer.setPredecessors(this.getPredecessors(relationships, now, userId));
                    governanceOfficer.setSuccessors(this.getSuccessors(relationships, now, userId));
                }
            }
            catch (Throwable error) {
                this.errorHandler.handleRepositoryError(error, methodName, this.serverName, this.serviceName);
            }
            log.debug("Retrieved governance officer: " + governanceOfficer.toString());
        } else {
            log.debug("Null governance officer entity");
        }
        return governanceOfficer;
    }

    private GovernanceOfficerAppointee getAppointee(String governancePostGUID, String personalProfileGUID, String userId, Date startDate, Date endDate) throws UnrecognizedGUIDException, PropertyServerException, org.odpi.openmetadata.accessservices.governanceprogram.ffdc.exceptions.UserNotAuthorizedException {
        PersonalProfile personalProfile = this.personalProfileHandler.getPersonalProfileByGUID(userId, personalProfileGUID);
        GovernanceOfficerAppointee appointee = new GovernanceOfficerAppointee();
        appointee.setGUID(governancePostGUID);
        appointee.setType(governancePostTypeName);
        appointee.setProfile(personalProfile);
        appointee.setStartDate(startDate);
        appointee.setEndDate(endDate);
        return appointee;
    }

    private List<GovernanceOfficerAppointee> getPredecessors(List<Relationship> governancePostings, long now, String userId) throws UnrecognizedGUIDException, PropertyServerException, org.odpi.openmetadata.accessservices.governanceprogram.ffdc.exceptions.UserNotAuthorizedException {
        ArrayList<GovernanceOfficerAppointee> appointees = new ArrayList<GovernanceOfficerAppointee>();
        if (governancePostings != null) {
            for (Relationship governancePost : governancePostings) {
                if (governancePost == null) continue;
                Date endDate = null;
                Date startDate = null;
                InstanceProperties properties = governancePost.getProperties();
                if (properties != null) {
                    endDate = properties.getEffectiveToTime();
                    startDate = properties.getEffectiveFromTime();
                }
                if (endDate == null || endDate.getTime() >= now) continue;
                String personalProfileGUID = null;
                if (governancePost.getEntityTwoProxy() != null) {
                    personalProfileGUID = governancePost.getEntityTwoProxy().getGUID();
                }
                appointees.add(this.getAppointee(governancePost.getGUID(), personalProfileGUID, userId, startDate, endDate));
            }
        }
        if (appointees.isEmpty()) {
            return null;
        }
        return appointees;
    }

    private List<GovernanceOfficerAppointee> getCurrentIncumbents(List<Relationship> governancePostings, long now, String userId) throws UnrecognizedGUIDException, PropertyServerException, org.odpi.openmetadata.accessservices.governanceprogram.ffdc.exceptions.UserNotAuthorizedException {
        ArrayList<GovernanceOfficerAppointee> appointees = new ArrayList<GovernanceOfficerAppointee>();
        if (governancePostings != null) {
            for (Relationship governancePost : governancePostings) {
                if (governancePost == null) continue;
                Date endDate = null;
                Date startDate = null;
                InstanceProperties properties = governancePost.getProperties();
                if (properties != null) {
                    endDate = properties.getEffectiveToTime();
                    startDate = properties.getEffectiveFromTime();
                }
                if (startDate != null && startDate.getTime() > now || endDate != null && endDate.getTime() < now) continue;
                String personalProfileGUID = null;
                if (governancePost.getEntityTwoProxy() != null) {
                    personalProfileGUID = governancePost.getEntityTwoProxy().getGUID();
                }
                appointees.add(this.getAppointee(governancePost.getGUID(), personalProfileGUID, userId, startDate, endDate));
            }
        }
        if (appointees.isEmpty()) {
            return null;
        }
        return appointees;
    }

    private List<GovernanceOfficerAppointee> getSuccessors(List<Relationship> governancePostings, long now, String userId) throws UnrecognizedGUIDException, PropertyServerException, org.odpi.openmetadata.accessservices.governanceprogram.ffdc.exceptions.UserNotAuthorizedException {
        ArrayList<GovernanceOfficerAppointee> appointees = new ArrayList<GovernanceOfficerAppointee>();
        if (governancePostings != null) {
            for (Relationship governancePost : governancePostings) {
                if (governancePost == null) continue;
                Date endDate = null;
                Date startDate = null;
                InstanceProperties properties = governancePost.getProperties();
                if (properties != null) {
                    endDate = properties.getEffectiveToTime();
                    startDate = properties.getEffectiveFromTime();
                }
                if (startDate == null || startDate.getTime() <= now) continue;
                String personalProfileGUID = null;
                if (governancePost.getEntityTwoProxy() != null) {
                    personalProfileGUID = governancePost.getEntityTwoProxy().getGUID();
                }
                appointees.add(this.getAppointee(governancePost.getGUID(), personalProfileGUID, userId, startDate, endDate));
            }
        }
        if (appointees.isEmpty()) {
            return null;
        }
        return appointees;
    }

    String createGovernanceOfficer(String userId, GovernanceDomain governanceDomain, String appointmentId, String appointmentContext, String title, Map<String, Object> additionalProperties, List<ExternalReference> externalReferences) throws InvalidParameterException, PropertyServerException, org.odpi.openmetadata.accessservices.governanceprogram.ffdc.exceptions.UserNotAuthorizedException {
        String methodName = "createGovernanceOfficer";
        this.errorHandler.validateUserId(userId, "createGovernanceOfficer");
        OMRSMetadataCollection metadataCollection = this.errorHandler.validateRepositoryConnector("createGovernanceOfficer");
        InstanceProperties properties = this.createGovernanceOfficerProperties("createGovernanceOfficer", governanceDomain, appointmentId, appointmentContext, title, additionalProperties);
        String governanceOfficerGUID = null;
        try {
            EntityDetail governanceOfficer = metadataCollection.addEntity(userId, governanceOfficerTypeGUID, properties, null, null);
            if (governanceOfficer != null) {
                governanceOfficerGUID = governanceOfficer.getGUID();
                log.debug("New governance officer entity: " + governanceOfficerGUID);
                if (externalReferences != null) {
                    this.externalReferencesHandler.storeExternalReferences(userId, governanceOfficerGUID, externalReferences);
                }
            }
        }
        catch (UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, "createGovernanceOfficer", this.serverName, this.serviceName);
        }
        catch (Throwable error) {
            this.errorHandler.handleRepositoryError(error, "createGovernanceOfficer", this.serverName, this.serviceName);
        }
        return governanceOfficerGUID;
    }

    void updateGovernanceOfficer(String userId, String governanceOfficerGUID, GovernanceDomain governanceDomain, String appointmentId, String appointmentContext, String title, Map<String, Object> additionalProperties, List<ExternalReference> externalReferences) throws UnrecognizedGUIDException, InvalidParameterException, PropertyServerException, org.odpi.openmetadata.accessservices.governanceprogram.ffdc.exceptions.UserNotAuthorizedException {
        String methodName = "updateGovernanceOfficer";
        this.errorHandler.validateUserId(userId, "updateGovernanceOfficer");
        this.errorHandler.validateGUID(governanceOfficerGUID, governanceOfficerGUIDParameterName, governanceOfficerTypeName, "updateGovernanceOfficer");
        OMRSMetadataCollection metadataCollection = this.errorHandler.validateRepositoryConnector("updateGovernanceOfficer");
        InstanceProperties properties = this.createGovernanceOfficerProperties("updateGovernanceOfficer", governanceDomain, appointmentId, appointmentContext, title, additionalProperties);
        try {
            metadataCollection.updateEntityProperties(userId, governanceOfficerGUID, properties);
            this.externalReferencesHandler.storeExternalReferences(userId, governanceOfficerGUID, externalReferences);
        }
        catch (UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, "updateGovernanceOfficer", this.serverName, this.serviceName);
        }
        catch (EntityNotKnownException error) {
            this.errorHandler.handleUnrecognizedGUIDException(userId, "updateGovernanceOfficer", this.serverName, governanceOfficerTypeName, governanceOfficerGUID);
        }
        catch (Throwable error) {
            this.errorHandler.handleRepositoryError(error, "updateGovernanceOfficer", this.serverName, this.serviceName);
        }
        log.debug("Update of governance officer successful: " + governanceOfficerGUID);
    }

    void deleteGovernanceOfficer(String userId, String governanceOfficerGUID, String appointmentId, GovernanceDomain governanceDomain) throws UnrecognizedGUIDException, InvalidParameterException, PropertyServerException, org.odpi.openmetadata.accessservices.governanceprogram.ffdc.exceptions.UserNotAuthorizedException {
        String methodName = "deleteGovernanceOfficer";
        this.errorHandler.validateUserId(userId, "deleteGovernanceOfficer");
        this.errorHandler.validateGUID(userId, governanceOfficerGUIDParameterName, governanceOfficerGUID, "deleteGovernanceOfficer");
        this.errorHandler.validateName(appointmentId, appointmentIdParameterName, "deleteGovernanceOfficer");
        this.errorHandler.validateEnum(governanceDomain, governanceDomainParameterName, "deleteGovernanceOfficer");
        GovernanceOfficer governanceOfficer = this.getGovernanceOfficerByGUID(userId, governanceOfficerGUID);
        if (governanceOfficer == null || !governanceOfficer.getAppointmentId().equals(appointmentId) || !governanceOfficer.getGovernanceDomain().equals((Object)governanceDomain)) {
            GovernanceProgramErrorCode errorCode = GovernanceProgramErrorCode.GOVERNANCE_OFFICER_NOT_DELETED;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{governanceOfficerGUID, appointmentId, governanceDomain.getName()});
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "deleteGovernanceOfficer", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), appointmentIdParameterName);
        }
        this.basicHandler.deleteEntity(userId, governanceOfficerGUID, governanceOfficerTypeGUID, governanceOfficerTypeName, "deleteGovernanceOfficer");
        log.debug("Delete of governance officers successful: " + governanceOfficerGUID);
    }

    GovernanceOfficer getGovernanceOfficerByGUID(String userId, String governanceOfficerGUID) throws UnrecognizedGUIDException, PropertyServerException, org.odpi.openmetadata.accessservices.governanceprogram.ffdc.exceptions.UserNotAuthorizedException {
        String methodName = "getGovernanceOfficerByGUID";
        this.errorHandler.validateUserId(userId, "getGovernanceOfficerByGUID");
        this.errorHandler.validateGUID(governanceOfficerGUID, governanceOfficerGUIDParameterName, governanceOfficerTypeName, "getGovernanceOfficerByGUID");
        OMRSMetadataCollection metadataCollection = this.errorHandler.validateRepositoryConnector("getGovernanceOfficerByGUID");
        EntityDetail governanceOfficerEntity = this.basicHandler.getEntityByGUID(governanceOfficerGUID, governanceOfficerGUIDParameterName, userId, "getGovernanceOfficerByGUID", governanceOfficerTypeName);
        return this.getGovernanceOfficerFromInstances(governanceOfficerEntity, userId, metadataCollection, "getGovernanceOfficerByGUID");
    }

    GovernanceOfficer getGovernanceOfficerByAppointmentId(String userId, String appointmentId) throws InvalidParameterException, PropertyServerException, AppointmentIdNotUniqueException, org.odpi.openmetadata.accessservices.governanceprogram.ffdc.exceptions.UserNotAuthorizedException {
        String methodName = "getGovernanceOfficerByAppointmentId";
        this.errorHandler.validateUserId(userId, "getGovernanceOfficerByAppointmentId");
        this.errorHandler.validateName(appointmentId, appointmentIdParameterName, "getGovernanceOfficerByAppointmentId");
        OMRSMetadataCollection metadataCollection = this.errorHandler.validateRepositoryConnector("getGovernanceOfficerByAppointmentId");
        try {
            InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, appointmentIdPropertyName, appointmentId, "getGovernanceOfficerByAppointmentId");
            List governanceOfficerEntities = metadataCollection.findEntitiesByProperty(userId, governanceOfficerTypeGUID, properties, MatchCriteria.ANY, 0, null, null, null, null, null, 50);
            if (governanceOfficerEntities == null) {
                GovernanceProgramErrorCode errorCode = GovernanceProgramErrorCode.GOVERNANCE_OFFICER_NOT_FOUND_BY_APPOINTMENT_ID;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{appointmentId});
                throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "getGovernanceOfficerByAppointmentId", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), appointmentId);
            }
            if (governanceOfficerEntities.size() != 1) {
                GovernanceProgramErrorCode errorCode = GovernanceProgramErrorCode.DUPLICATE_GOVERNANCE_OFFICER_FOR_APPOINTMENT_ID;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{appointmentId});
                throw new AppointmentIdNotUniqueException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "getGovernanceOfficerByAppointmentId", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), governanceOfficerEntities);
            }
            return this.getGovernanceOfficerFromInstances((EntityDetail)governanceOfficerEntities.get(0), userId, metadataCollection, "getGovernanceOfficerByAppointmentId");
        }
        catch (UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, "getGovernanceOfficerByAppointmentId", this.serverName, this.serviceName);
        }
        catch (AppointmentIdNotUniqueException | InvalidParameterException error) {
            throw error;
        }
        catch (Throwable error) {
            this.errorHandler.handleRepositoryError(error, "getGovernanceOfficerByAppointmentId", this.serverName, this.serviceName);
        }
        log.debug("Null return from method: getGovernanceOfficerByAppointmentId");
        return null;
    }

    List<GovernanceOfficer> getGovernanceOfficers(String userId) throws PropertyServerException, org.odpi.openmetadata.accessservices.governanceprogram.ffdc.exceptions.UserNotAuthorizedException {
        String methodName = "getGovernanceOfficers";
        this.errorHandler.validateUserId(userId, "getGovernanceOfficers");
        OMRSMetadataCollection metadataCollection = this.errorHandler.validateRepositoryConnector("getGovernanceOfficers");
        try {
            List governanceOfficerEntities = metadataCollection.findEntitiesByProperty(userId, governanceOfficerTypeGUID, null, null, 0, null, null, null, null, null, 500);
            if (governanceOfficerEntities != null) {
                ArrayList<GovernanceOfficer> governanceOfficers = new ArrayList<GovernanceOfficer>();
                for (EntityDetail governanceOfficerEntity : governanceOfficerEntities) {
                    governanceOfficers.add(this.getGovernanceOfficerFromInstances(governanceOfficerEntity, userId, metadataCollection, "getGovernanceOfficers"));
                }
                if (governanceOfficers.isEmpty()) {
                    log.debug("No governance officers");
                    return null;
                }
                log.debug(governanceOfficers.size() + " governance officers");
                return governanceOfficers;
            }
        }
        catch (UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, "getGovernanceOfficers", this.serverName, this.serviceName);
        }
        catch (Throwable error) {
            this.errorHandler.handleRepositoryError(error, "getGovernanceOfficers", this.serverName, this.serviceName);
        }
        log.debug("Null return from method: getGovernanceOfficers");
        return null;
    }

    List<GovernanceOfficer> getActiveGovernanceOfficers(String userId) throws PropertyServerException, org.odpi.openmetadata.accessservices.governanceprogram.ffdc.exceptions.UserNotAuthorizedException {
        String methodName = "getActiveGovernanceOfficers";
        List<GovernanceOfficer> fullList = this.getGovernanceOfficers(userId);
        ArrayList<GovernanceOfficer> returnList = new ArrayList<GovernanceOfficer>();
        for (GovernanceOfficer governanceOfficer : fullList) {
            if (governanceOfficer == null || governanceOfficer.getAppointee() == null) continue;
            returnList.add(governanceOfficer);
        }
        if (returnList.isEmpty()) {
            log.debug("No governance officers for method: getActiveGovernanceOfficers");
            return null;
        }
        log.debug(returnList.size() + " active governance officers");
        return returnList;
    }

    List<GovernanceOfficer> getGovernanceOfficersByDomain(String userId, GovernanceDomain governanceDomain) throws InvalidParameterException, PropertyServerException, org.odpi.openmetadata.accessservices.governanceprogram.ffdc.exceptions.UserNotAuthorizedException {
        String methodName = "getGovernanceOfficersByDomain";
        this.errorHandler.validateEnum(governanceDomain, governanceDomainParameterName, "getGovernanceOfficersByDomain");
        List<GovernanceOfficer> fullList = this.getGovernanceOfficers(userId);
        ArrayList<GovernanceOfficer> returnList = new ArrayList<GovernanceOfficer>();
        for (GovernanceOfficer governanceOfficer : fullList) {
            if (governanceOfficer == null || governanceOfficer.getGovernanceDomain() != governanceDomain) continue;
            returnList.add(governanceOfficer);
        }
        if (returnList.isEmpty()) {
            log.debug("Null return from method: getGovernanceOfficersByDomain");
            return null;
        }
        log.debug(returnList.size() + " governance officers for domain: " + governanceDomain);
        return returnList;
    }

    void appointGovernanceOfficer(String userId, String governanceOfficerGUID, String profileGUID, Date startDate) throws UnrecognizedGUIDException, PropertyServerException, org.odpi.openmetadata.accessservices.governanceprogram.ffdc.exceptions.UserNotAuthorizedException {
        String methodName = "appointGovernanceOfficer";
        this.errorHandler.validateUserId(userId, "appointGovernanceOfficer");
        this.errorHandler.validateGUID(governanceOfficerGUID, governanceOfficerGUIDParameterName, governanceOfficerTypeName, "appointGovernanceOfficer");
        this.errorHandler.validateGUID(profileGUID, profileGUIDParameterName, personalProfileTypeName, "appointGovernanceOfficer");
        OMRSMetadataCollection metadataCollection = this.errorHandler.validateRepositoryConnector("appointGovernanceOfficer");
        GovernanceOfficer governanceOfficer = this.getGovernanceOfficerByGUID(userId, governanceOfficerGUID);
        Date endDate = null;
        Date now = new Date();
        Date actualStartDate = startDate;
        if (actualStartDate == null) {
            actualStartDate = now;
        }
        if (governanceOfficer.getSuccessors() != null) {
            for (GovernanceOfficerAppointee successor : governanceOfficer.getSuccessors()) {
                if (endDate == null) {
                    endDate = successor.getStartDate();
                    continue;
                }
                if (successor.getStartDate() == null || endDate.getTime() <= successor.getStartDate().getTime()) continue;
                endDate = successor.getStartDate();
            }
        }
        if (governanceOfficer.getAppointee() != null) {
            if (governanceOfficer.getAppointee().getProfile() != null) {
                try {
                    Date incumbentEndDate = new Date(actualStartDate.getTime() - 1L);
                    this.relieveGovernanceOfficer(userId, governanceOfficerGUID, governanceOfficer.getAppointee().getProfile().getGUID(), incumbentEndDate);
                }
                catch (Throwable error) {
                    GovernanceProgramErrorCode errorCode = GovernanceProgramErrorCode.FREE_ROLE_FOR_APPOINTMENT_FAILED;
                    String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{error.getMessage()});
                    throw new PropertyServerException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "appointGovernanceOfficer", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), error);
                }
            } else {
                GovernanceProgramErrorCode errorCode = GovernanceProgramErrorCode.NO_PROFILE_FOR_GOVERNANCE_POST;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{governanceOfficerGUID, governanceOfficer.getAppointee().getGUID()});
                throw new PropertyServerException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "appointGovernanceOfficer", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
        }
        InstanceProperties properties = new InstanceProperties();
        properties.setEffectiveFromTime(startDate);
        properties.setEffectiveToTime(endDate);
        try {
            metadataCollection.addRelationship(userId, governancePostTypeGUID, properties, governanceOfficerGUID, profileGUID, null);
        }
        catch (UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, "appointGovernanceOfficer", this.serverName, this.serviceName);
        }
        catch (EntityNotKnownException error) {
            this.errorHandler.handleUnrecognizedGUIDException(userId, "appointGovernanceOfficer", this.serverName, personalProfileTypeName, profileGUID);
        }
        catch (Throwable error) {
            this.errorHandler.handleRepositoryError(error, "appointGovernanceOfficer", this.serverName, this.serviceName);
        }
    }

    void relieveGovernanceOfficer(String userId, String governanceOfficerGUID, String profileGUID, Date endDate) throws UnrecognizedGUIDException, InvalidParameterException, PropertyServerException, org.odpi.openmetadata.accessservices.governanceprogram.ffdc.exceptions.UserNotAuthorizedException {
        String methodName = "relieveGovernanceOfficer";
        this.errorHandler.validateUserId(userId, "relieveGovernanceOfficer");
        this.errorHandler.validateGUID(governanceOfficerGUID, governanceOfficerGUIDParameterName, governanceOfficerTypeName, "relieveGovernanceOfficer");
        this.errorHandler.validateGUID(profileGUID, profileGUIDParameterName, personalProfileTypeName, "relieveGovernanceOfficer");
        OMRSMetadataCollection metadataCollection = this.errorHandler.validateRepositoryConnector("relieveGovernanceOfficer");
        Date actualEndDate = endDate;
        if (actualEndDate == null) {
            actualEndDate = new Date();
        }
        try {
            List governancePosts = metadataCollection.getRelationshipsForEntity(userId, governanceOfficerGUID, governancePostTypeGUID, 0, null, null, null, null, 500);
            if (governancePosts == null || governancePosts.isEmpty()) {
                GovernanceProgramErrorCode errorCode = GovernanceProgramErrorCode.PROFILE_NOT_LINKED_TO_GOVERNANCE_OFFICER;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{profileGUID, governanceOfficerGUID});
                throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "relieveGovernanceOfficer", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), profileGUIDParameterName);
            }
            Relationship relievedPost = null;
            for (Relationship governancePost : governancePosts) {
                if (governancePost == null) continue;
                EntityProxy appointeeProxy = governancePost.getEntityTwoProxy();
                if (appointeeProxy != null) {
                    if (!profileGUID.equals(appointeeProxy.getGUID())) continue;
                    if (relievedPost == null) {
                        relievedPost = governancePost;
                        continue;
                    }
                    Date governancePostEndDate = null;
                    Date relievedPostEndDate = null;
                    if (governancePost.getProperties() != null) {
                        governancePostEndDate = governancePost.getProperties().getEffectiveToTime();
                    }
                    if (relievedPost.getProperties() != null) {
                        relievedPostEndDate = relievedPost.getProperties().getEffectiveToTime();
                    }
                    if (relievedPostEndDate == null || governancePostEndDate != null && governancePostEndDate.getTime() <= relievedPostEndDate.getTime()) continue;
                    relievedPost = governancePost;
                    continue;
                }
                GovernanceProgramErrorCode errorCode = GovernanceProgramErrorCode.INVALID_GOVERNANCE_POST_RELATIONSHIP;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{governancePost.toString()});
                throw new PropertyServerException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "relieveGovernanceOfficer", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
            if (relievedPost == null) {
                GovernanceProgramErrorCode errorCode = GovernanceProgramErrorCode.PROFILE_NOT_LINKED_TO_GOVERNANCE_OFFICER;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{profileGUID, governanceOfficerGUID});
                throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "relieveGovernanceOfficer", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), profileGUIDParameterName);
            }
            InstanceProperties properties = relievedPost.getProperties();
            if (properties == null) {
                properties = new InstanceProperties();
            }
            properties.setEffectiveToTime(actualEndDate);
            metadataCollection.updateRelationshipProperties(userId, relievedPost.getGUID(), properties);
        }
        catch (UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, "relieveGovernanceOfficer", this.serverName, this.serviceName);
        }
        catch (EntityNotKnownException error) {
            this.errorHandler.handleUnrecognizedGUIDException(userId, "relieveGovernanceOfficer", this.serverName, personalProfileTypeName, profileGUID);
        }
        catch (InvalidParameterException | PropertyServerException error) {
            throw error;
        }
        catch (Throwable error) {
            this.errorHandler.handleRepositoryError(error, "relieveGovernanceOfficer", this.serverName, this.serviceName);
        }
    }
}

