/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceprogram.server;

import org.odpi.openmetadata.accessservices.governanceprogram.ffdc.GovernanceProgramErrorCode;
import org.odpi.openmetadata.accessservices.governanceprogram.ffdc.exceptions.PropertyServerException;
import org.odpi.openmetadata.accessservices.governanceprogram.ffdc.exceptions.UnrecognizedGUIDException;
import org.odpi.openmetadata.accessservices.governanceprogram.ffdc.exceptions.UserNotAuthorizedException;
import org.odpi.openmetadata.accessservices.governanceprogram.server.GovernanceProgramErrorHandler;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryValidator;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GovernanceProgramBasicHandler {
    private static final Logger log = LoggerFactory.getLogger(GovernanceProgramBasicHandler.class);
    private String serviceName;
    private GovernanceProgramErrorHandler errorHandler;
    private OMRSRepositoryHelper repositoryHelper = null;
    private OMRSRepositoryValidator repositoryValidator = null;
    private String serverName = null;

    GovernanceProgramBasicHandler(String serviceName, OMRSRepositoryConnector repositoryConnector) {
        this.serviceName = serviceName;
        this.errorHandler = new GovernanceProgramErrorHandler(repositoryConnector);
        if (repositoryConnector != null) {
            this.repositoryHelper = repositoryConnector.getRepositoryHelper();
            this.repositoryValidator = repositoryConnector.getRepositoryValidator();
            this.serverName = repositoryConnector.getServerName();
        }
    }

    EntityDetail getEntityByGUID(String guid, String guidParameterName, String userId, String methodName, String expectedType) throws UnrecognizedGUIDException, PropertyServerException, UserNotAuthorizedException {
        this.errorHandler.validateUserId(userId, methodName);
        this.errorHandler.validateGUID(guid, guidParameterName, expectedType, methodName);
        OMRSMetadataCollection metadataCollection = this.errorHandler.validateRepositoryConnector(methodName);
        try {
            EntityDetail entity = metadataCollection.getEntityDetail(userId, guid);
            if (entity != null) {
                if (this.repositoryValidator.isATypeOf(this.serverName, (InstanceHeader)entity, expectedType, methodName)) {
                    log.debug("Entity retrieved: " + entity.toString());
                    return entity;
                }
                InstanceType type = entity.getType();
                String typeName = "<null>";
                if (type != null) {
                    typeName = type.getTypeDefName();
                }
                this.errorHandler.handleWrongTypeForGUIDException(guid, methodName, typeName, expectedType);
            }
        }
        catch (EntityNotKnownException error) {
            this.errorHandler.handleUnrecognizedGUIDException(userId, methodName, this.serverName, expectedType, guid);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName, this.serverName, this.serviceName);
        }
        catch (Throwable error) {
            this.errorHandler.handleRepositoryError(error, methodName, this.serverName, this.serviceName);
        }
        log.debug("Null return from method: " + methodName);
        return null;
    }

    void deleteEntity(String userId, String guid, String typeGUID, String typeName, String methodName) throws PropertyServerException {
        Throwable deleteException;
        OMRSMetadataCollection metadataCollection = this.errorHandler.validateRepositoryConnector(methodName);
        try {
            metadataCollection.deleteEntity(userId, typeGUID, typeName, guid);
            log.debug("Entity soft-deleted: " + guid);
            return;
        }
        catch (FunctionNotSupportedException exception) {
            log.debug("Soft-delete not supported: " + this.serverName);
            try {
                metadataCollection.purgeEntity(userId, typeGUID, typeName, guid);
                log.debug("Entity purged: " + guid);
                return;
            }
            catch (Throwable error) {
                log.debug("Entity purge failed: " + error.getMessage());
                deleteException = error;
            }
        }
        catch (Throwable error) {
            log.debug("Entity soft-delete failed: " + error.getMessage());
            deleteException = error;
        }
        GovernanceProgramErrorCode errorCode = GovernanceProgramErrorCode.INSTANCE_NOT_DELETED;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{guid});
        throw new PropertyServerException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), deleteException);
    }
}

