/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceprogram.server;

import org.odpi.openmetadata.accessservices.governanceprogram.ffdc.GovernanceProgramErrorCode;
import org.odpi.openmetadata.accessservices.governanceprogram.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.governanceprogram.ffdc.exceptions.PropertyServerException;
import org.odpi.openmetadata.accessservices.governanceprogram.ffdc.exceptions.UnrecognizedGUIDException;
import org.odpi.openmetadata.accessservices.governanceprogram.ffdc.exceptions.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GovernanceProgramErrorHandler {
    private static final Logger log = LoggerFactory.getLogger(GovernanceProgramErrorHandler.class);
    private OMRSRepositoryConnector repositoryConnector;

    GovernanceProgramErrorHandler(OMRSRepositoryConnector repositoryConnector) {
        this.repositoryConnector = repositoryConnector;
    }

    void validateUserId(String userId, String methodName) throws UserNotAuthorizedException {
        if (userId == null) {
            GovernanceProgramErrorCode errorCode = GovernanceProgramErrorCode.NULL_USER_ID;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName});
            throw new UserNotAuthorizedException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), null);
        }
        log.debug("Non null userId: " + userId);
    }

    void validateGUID(String guid, String parameterName, String expectedTypeName, String methodName) throws UnrecognizedGUIDException {
        if (guid == null) {
            GovernanceProgramErrorCode errorCode = GovernanceProgramErrorCode.NULL_GUID;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{parameterName, methodName});
            throw new UnrecognizedGUIDException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), expectedTypeName, null);
        }
        log.debug("Non null guid: " + guid);
    }

    void validateEnum(Object enumValue, String parameterName, String methodName) throws InvalidParameterException {
        if (enumValue == null) {
            GovernanceProgramErrorCode errorCode = GovernanceProgramErrorCode.NULL_ENUM;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{parameterName, methodName});
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), parameterName);
        }
        log.debug("Non null enum: " + enumValue.toString());
    }

    void validateName(String name, String parameterName, String methodName) throws InvalidParameterException {
        if (name == null) {
            GovernanceProgramErrorCode errorCode = GovernanceProgramErrorCode.NULL_NAME;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{parameterName, methodName});
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), parameterName);
        }
        log.debug("Non null " + parameterName + ": " + name);
    }

    OMRSMetadataCollection validateRepositoryConnector(String methodName) throws PropertyServerException {
        if (this.repositoryConnector == null) {
            GovernanceProgramErrorCode errorCode = GovernanceProgramErrorCode.OMRS_NOT_INITIALIZED;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName});
            throw new PropertyServerException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        if (!this.repositoryConnector.isActive()) {
            GovernanceProgramErrorCode errorCode = GovernanceProgramErrorCode.OMRS_NOT_AVAILABLE;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName});
            throw new PropertyServerException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        log.debug("Active repository connector: " + this.repositoryConnector.getMetadataCollectionId());
        try {
            return this.repositoryConnector.getMetadataCollection();
        }
        catch (Throwable error) {
            GovernanceProgramErrorCode errorCode = GovernanceProgramErrorCode.NO_METADATA_COLLECTION;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName});
            throw new PropertyServerException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    void handleUnrecognizedGUIDException(String userId, String methodName, String serverName, String expectedType, String guid) throws UnrecognizedGUIDException {
        GovernanceProgramErrorCode errorCode = GovernanceProgramErrorCode.INSTANCE_NOT_FOUND_BY_GUID;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName, expectedType, guid, userId, serverName});
        throw new UnrecognizedGUIDException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), expectedType, guid);
    }

    void handleWrongTypeForGUIDException(String guid, String methodName, String actualType, String expectedType) throws UnrecognizedGUIDException {
        GovernanceProgramErrorCode errorCode = GovernanceProgramErrorCode.INSTANCE_WRONG_TYPE_FOR_GUID;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName, guid, actualType, expectedType});
        throw new UnrecognizedGUIDException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), expectedType, guid);
    }

    void handleUnauthorizedUser(String userId, String methodName, String serverName, String serviceName) throws UserNotAuthorizedException {
        GovernanceProgramErrorCode errorCode = GovernanceProgramErrorCode.USER_NOT_AUTHORIZED;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{userId, methodName, serviceName, serverName});
        throw new UserNotAuthorizedException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), userId);
    }

    void handleRepositoryError(Throwable error, String methodName, String serverName, String serviceName) throws PropertyServerException {
        GovernanceProgramErrorCode errorCode = GovernanceProgramErrorCode.PROPERTY_SERVER_ERROR;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{error.getMessage(), methodName, serviceName, serverName});
        throw new PropertyServerException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }
}

