/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceprogram.server;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.governanceprogram.admin.GovernanceProgramAdmin;
import org.odpi.openmetadata.accessservices.governanceprogram.ffdc.GovernanceProgramErrorCode;
import org.odpi.openmetadata.accessservices.governanceprogram.ffdc.exceptions.AppointmentIdNotUniqueException;
import org.odpi.openmetadata.accessservices.governanceprogram.ffdc.exceptions.EmployeeNumberNotUniqueException;
import org.odpi.openmetadata.accessservices.governanceprogram.ffdc.exceptions.GovernanceProgramCheckedExceptionBase;
import org.odpi.openmetadata.accessservices.governanceprogram.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.governanceprogram.ffdc.exceptions.PropertyServerException;
import org.odpi.openmetadata.accessservices.governanceprogram.ffdc.exceptions.UnrecognizedGUIDException;
import org.odpi.openmetadata.accessservices.governanceprogram.ffdc.exceptions.UserNotAuthorizedException;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.GovernanceDomain;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.AppointmentRequestBody;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GUIDResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceDomainRequestBody;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceOfficerDetailsRequestBody;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceOfficerListResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceOfficerResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceOfficerValidatorRequestBody;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceProgramOMASAPIResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.PersonalDetailsRequestBody;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.PersonalProfileListResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.PersonalProfileResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.PersonalProfileValidatorRequestBody;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.VoidResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.server.GovernanceOfficerHandler;
import org.odpi.openmetadata.accessservices.governanceprogram.server.PersonalProfileHandler;
import org.odpi.openmetadata.adminservices.OMAGAccessServiceRegistration;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceOperationalStatus;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceRegistration;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GovernanceProgramRESTServices {
    private static String accessServiceName = null;
    private static OMRSRepositoryConnector repositoryConnector = null;
    private static final Logger log = LoggerFactory.getLogger(GovernanceProgramRESTServices.class);

    public static void setRepositoryConnector(String accessServiceName, OMRSRepositoryConnector repositoryConnector) {
        GovernanceProgramRESTServices.accessServiceName = accessServiceName;
        GovernanceProgramRESTServices.repositoryConnector = repositoryConnector;
    }

    public GovernanceProgramRESTServices() {
        AccessServiceDescription myDescription = AccessServiceDescription.GOVERNANCE_PROGRAM_OMAS;
        AccessServiceRegistration myRegistration = new AccessServiceRegistration(myDescription.getAccessServiceCode(), myDescription.getAccessServiceName(), myDescription.getAccessServiceDescription(), myDescription.getAccessServiceWiki(), AccessServiceOperationalStatus.ENABLED, GovernanceProgramAdmin.class.getName());
        OMAGAccessServiceRegistration.registerAccessService((AccessServiceRegistration)myRegistration);
    }

    public GUIDResponse createPersonalProfile(String userId, PersonalDetailsRequestBody requestBody) {
        String methodName = "createPersonalProfile";
        log.debug("Calling method: createPersonalProfile");
        GUIDResponse response = new GUIDResponse();
        try {
            this.validateInitialization("createPersonalProfile");
            String employeeNumber = null;
            String fullName = null;
            String knownName = null;
            String jobTitle = null;
            String jobRoleDescription = null;
            Map additionalProperties = null;
            if (requestBody != null) {
                employeeNumber = requestBody.getEmployeeNumber();
                fullName = requestBody.getFullName();
                knownName = requestBody.getKnownName();
                jobTitle = requestBody.getJobTitle();
                jobRoleDescription = requestBody.getJobRoleDescription();
                additionalProperties = requestBody.getAdditionalProperties();
            }
            PersonalProfileHandler handler = new PersonalProfileHandler(accessServiceName, repositoryConnector);
            response.setGUID(handler.createPersonalProfile(userId, employeeNumber, fullName, knownName, jobTitle, jobRoleDescription, additionalProperties));
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((GovernanceProgramOMASAPIResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.capturePropertyServerException((GovernanceProgramOMASAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((GovernanceProgramOMASAPIResponse)response, error);
        }
        log.debug("Returning from method: createPersonalProfile with response: " + response.toString());
        return response;
    }

    public VoidResponse updatePersonalProfile(String userId, String profileGUID, PersonalDetailsRequestBody requestBody) {
        String methodName = "updatePersonalProfile";
        log.debug("Calling method: updatePersonalProfile");
        VoidResponse response = new VoidResponse();
        try {
            this.validateInitialization("updatePersonalProfile");
            String employeeNumber = null;
            String fullName = null;
            String knownName = null;
            String jobTitle = null;
            String jobRoleDescription = null;
            Map additionalProperties = null;
            if (requestBody != null) {
                employeeNumber = requestBody.getEmployeeNumber();
                fullName = requestBody.getFullName();
                knownName = requestBody.getKnownName();
                jobTitle = requestBody.getJobTitle();
                jobRoleDescription = requestBody.getJobRoleDescription();
                additionalProperties = requestBody.getAdditionalProperties();
            }
            PersonalProfileHandler handler = new PersonalProfileHandler(accessServiceName, repositoryConnector);
            handler.updatePersonalProfile(userId, profileGUID, employeeNumber, fullName, knownName, jobTitle, jobRoleDescription, additionalProperties);
        }
        catch (UnrecognizedGUIDException error) {
            this.captureUnrecognizedGUIDException((GovernanceProgramOMASAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((GovernanceProgramOMASAPIResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.capturePropertyServerException((GovernanceProgramOMASAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((GovernanceProgramOMASAPIResponse)response, error);
        }
        log.debug("Returning from method: updatePersonalProfile with response: " + response.toString());
        return response;
    }

    public VoidResponse deletePersonalProfile(String userId, String profileGUID, PersonalProfileValidatorRequestBody requestBody) {
        String methodName = "deletePersonalProfile";
        log.debug("Calling method: deletePersonalProfile");
        VoidResponse response = new VoidResponse();
        try {
            this.validateInitialization("deletePersonalProfile");
            String employeeNumber = null;
            if (requestBody != null) {
                employeeNumber = requestBody.getEmployeeNumber();
            }
            PersonalProfileHandler handler = new PersonalProfileHandler(accessServiceName, repositoryConnector);
            handler.deletePersonalProfile(userId, profileGUID, employeeNumber);
        }
        catch (UnrecognizedGUIDException error) {
            this.captureUnrecognizedGUIDException((GovernanceProgramOMASAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((GovernanceProgramOMASAPIResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.capturePropertyServerException((GovernanceProgramOMASAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((GovernanceProgramOMASAPIResponse)response, error);
        }
        log.debug("Returning from method: deletePersonalProfile with response: " + response.toString());
        return response;
    }

    public PersonalProfileResponse getPersonalProfileByGUID(String userId, String profileGUID) {
        String methodName = "getPersonalProfileByGUID";
        log.debug("Calling method: getPersonalProfileByGUID");
        PersonalProfileResponse response = new PersonalProfileResponse();
        try {
            this.validateInitialization("getPersonalProfileByGUID");
            PersonalProfileHandler handler = new PersonalProfileHandler(accessServiceName, repositoryConnector);
            response.setPersonalProfile(handler.getPersonalProfileByGUID(userId, profileGUID));
        }
        catch (UnrecognizedGUIDException error) {
            this.captureUnrecognizedGUIDException((GovernanceProgramOMASAPIResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.capturePropertyServerException((GovernanceProgramOMASAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((GovernanceProgramOMASAPIResponse)response, error);
        }
        log.debug("Returning from method: getPersonalProfileByGUID with response: " + response.toString());
        return response;
    }

    public PersonalProfileResponse getPersonalProfileByEmployeeNumber(String userId, String employeeNumber) {
        String methodName = "getPersonalProfileByEmployeeNumber";
        log.debug("Calling method: getPersonalProfileByEmployeeNumber");
        PersonalProfileResponse response = new PersonalProfileResponse();
        try {
            this.validateInitialization("getPersonalProfileByEmployeeNumber");
            PersonalProfileHandler handler = new PersonalProfileHandler(accessServiceName, repositoryConnector);
            response.setPersonalProfile(handler.getPersonalProfileByEmployeeNumber(userId, employeeNumber));
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((GovernanceProgramOMASAPIResponse)response, error);
        }
        catch (EmployeeNumberNotUniqueException error) {
            this.captureEmployeeNumberNotUniqueException((GovernanceProgramOMASAPIResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.capturePropertyServerException((GovernanceProgramOMASAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((GovernanceProgramOMASAPIResponse)response, error);
        }
        log.debug("Returning from method: getPersonalProfileByEmployeeNumber with response: " + response.toString());
        return response;
    }

    public PersonalProfileListResponse getPersonalProfilesByName(String userId, String name) {
        String methodName = "getPersonalProfilesByName";
        log.debug("Calling method: getPersonalProfilesByName");
        PersonalProfileListResponse response = new PersonalProfileListResponse();
        try {
            this.validateInitialization("getPersonalProfilesByName");
            PersonalProfileHandler handler = new PersonalProfileHandler(accessServiceName, repositoryConnector);
            response.setPersonalProfiles(handler.getPersonalProfilesByName(userId, name));
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((GovernanceProgramOMASAPIResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.capturePropertyServerException((GovernanceProgramOMASAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((GovernanceProgramOMASAPIResponse)response, error);
        }
        log.debug("Returning from method: getPersonalProfilesByName with response: " + response.toString());
        return response;
    }

    public GUIDResponse createGovernanceOfficer(String userId, GovernanceOfficerDetailsRequestBody requestBody) {
        String methodName = "createGovernanceOfficer";
        log.debug("Calling method: createGovernanceOfficer");
        GUIDResponse response = new GUIDResponse();
        GovernanceDomain governanceDomain = null;
        String appointmentId = null;
        String appointmentContext = null;
        String title = null;
        Map additionalProperties = null;
        List externalReferences = null;
        if (requestBody != null) {
            governanceDomain = requestBody.getGovernanceDomain();
            appointmentId = requestBody.getAppointmentId();
            appointmentContext = requestBody.getAppointmentContext();
            title = requestBody.getTitle();
            additionalProperties = requestBody.getAdditionalProperties();
            externalReferences = requestBody.getExternalReferences();
        }
        try {
            this.validateInitialization("createGovernanceOfficer");
            GovernanceOfficerHandler handler = new GovernanceOfficerHandler(accessServiceName, repositoryConnector);
            response.setGUID(handler.createGovernanceOfficer(userId, governanceDomain, appointmentId, appointmentContext, title, additionalProperties, externalReferences));
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((GovernanceProgramOMASAPIResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.capturePropertyServerException((GovernanceProgramOMASAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((GovernanceProgramOMASAPIResponse)response, error);
        }
        log.debug("Returning from method: createGovernanceOfficer with response: " + response.toString());
        return response;
    }

    public VoidResponse updateGovernanceOfficer(String userId, String governanceOfficerGUID, GovernanceOfficerDetailsRequestBody requestBody) {
        String methodName = "updateGovernanceOfficer";
        log.debug("Calling method: updateGovernanceOfficer");
        VoidResponse response = new VoidResponse();
        GovernanceDomain governanceDomain = null;
        String appointmentId = null;
        String appointmentContext = null;
        String title = null;
        Map additionalProperties = null;
        List externalReferences = null;
        if (requestBody != null) {
            governanceDomain = requestBody.getGovernanceDomain();
            appointmentId = requestBody.getAppointmentId();
            appointmentContext = requestBody.getAppointmentContext();
            title = requestBody.getTitle();
            additionalProperties = requestBody.getAdditionalProperties();
            externalReferences = requestBody.getExternalReferences();
        }
        try {
            this.validateInitialization("updateGovernanceOfficer");
            GovernanceOfficerHandler handler = new GovernanceOfficerHandler(accessServiceName, repositoryConnector);
            handler.updateGovernanceOfficer(userId, governanceOfficerGUID, governanceDomain, appointmentId, appointmentContext, title, additionalProperties, externalReferences);
        }
        catch (UnrecognizedGUIDException error) {
            this.captureUnrecognizedGUIDException((GovernanceProgramOMASAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((GovernanceProgramOMASAPIResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.capturePropertyServerException((GovernanceProgramOMASAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((GovernanceProgramOMASAPIResponse)response, error);
        }
        log.debug("Returning from method: updateGovernanceOfficer with response: " + response.toString());
        return response;
    }

    public VoidResponse deleteGovernanceOfficer(String userId, String governanceOfficerGUID, GovernanceOfficerValidatorRequestBody requestBody) {
        String methodName = "deleteGovernanceOfficer";
        log.debug("Calling method: deleteGovernanceOfficer");
        VoidResponse response = new VoidResponse();
        try {
            this.validateInitialization("deleteGovernanceOfficer");
            GovernanceDomain governanceDomain = null;
            String appointmentId = null;
            if (requestBody != null) {
                governanceDomain = requestBody.getGovernanceDomain();
                appointmentId = requestBody.getAppointmentId();
            }
            GovernanceOfficerHandler handler = new GovernanceOfficerHandler(accessServiceName, repositoryConnector);
            handler.deleteGovernanceOfficer(userId, governanceOfficerGUID, appointmentId, governanceDomain);
        }
        catch (UnrecognizedGUIDException error) {
            this.captureUnrecognizedGUIDException((GovernanceProgramOMASAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((GovernanceProgramOMASAPIResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.capturePropertyServerException((GovernanceProgramOMASAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((GovernanceProgramOMASAPIResponse)response, error);
        }
        log.debug("Returning from method: deleteGovernanceOfficer with response: " + response.toString());
        return response;
    }

    public GovernanceOfficerResponse getGovernanceOfficerByGUID(String userId, String governanceOfficerGUID) {
        String methodName = "getGovernanceOfficerByGUID";
        log.debug("Calling method: getGovernanceOfficerByGUID");
        GovernanceOfficerResponse response = new GovernanceOfficerResponse();
        try {
            this.validateInitialization("getGovernanceOfficerByGUID");
            GovernanceOfficerHandler handler = new GovernanceOfficerHandler(accessServiceName, repositoryConnector);
            response.setGovernanceOfficer(handler.getGovernanceOfficerByGUID(userId, governanceOfficerGUID));
        }
        catch (UnrecognizedGUIDException error) {
            this.captureUnrecognizedGUIDException((GovernanceProgramOMASAPIResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.capturePropertyServerException((GovernanceProgramOMASAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((GovernanceProgramOMASAPIResponse)response, error);
        }
        log.debug("Returning from method: getGovernanceOfficerByGUID with response: " + response.toString());
        return response;
    }

    public GovernanceOfficerResponse getGovernanceOfficerByAppointmentId(String userId, String appointmentId) {
        String methodName = "getGovernanceOfficerByAppointmentId";
        log.debug("Calling method: getGovernanceOfficerByAppointmentId");
        GovernanceOfficerResponse response = new GovernanceOfficerResponse();
        try {
            this.validateInitialization("getGovernanceOfficerByAppointmentId");
            GovernanceOfficerHandler handler = new GovernanceOfficerHandler(accessServiceName, repositoryConnector);
            response.setGovernanceOfficer(handler.getGovernanceOfficerByAppointmentId(userId, appointmentId));
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((GovernanceProgramOMASAPIResponse)response, error);
        }
        catch (AppointmentIdNotUniqueException error) {
            this.captureAppointmentIdNotUniqueException((GovernanceProgramOMASAPIResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.capturePropertyServerException((GovernanceProgramOMASAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((GovernanceProgramOMASAPIResponse)response, error);
        }
        log.debug("Returning from method: getGovernanceOfficerByAppointmentId with response: " + response.toString());
        return response;
    }

    public GovernanceOfficerListResponse getGovernanceOfficers(String userId) {
        String methodName = "getGovernanceOfficers";
        log.debug("Calling method: getGovernanceOfficers");
        GovernanceOfficerListResponse response = new GovernanceOfficerListResponse();
        try {
            this.validateInitialization("getGovernanceOfficers");
            GovernanceOfficerHandler handler = new GovernanceOfficerHandler(accessServiceName, repositoryConnector);
            response.setGovernanceOfficers(handler.getGovernanceOfficers(userId));
        }
        catch (PropertyServerException error) {
            this.capturePropertyServerException((GovernanceProgramOMASAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((GovernanceProgramOMASAPIResponse)response, error);
        }
        log.debug("Returning from method: getGovernanceOfficers with response: " + response.toString());
        return response;
    }

    public GovernanceOfficerListResponse getActiveGovernanceOfficers(String userId) {
        String methodName = "getActiveGovernanceOfficers";
        log.debug("Calling method: getActiveGovernanceOfficers");
        GovernanceOfficerListResponse response = new GovernanceOfficerListResponse();
        try {
            this.validateInitialization("getActiveGovernanceOfficers");
            GovernanceOfficerHandler handler = new GovernanceOfficerHandler(accessServiceName, repositoryConnector);
            response.setGovernanceOfficers(handler.getActiveGovernanceOfficers(userId));
        }
        catch (PropertyServerException error) {
            this.capturePropertyServerException((GovernanceProgramOMASAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((GovernanceProgramOMASAPIResponse)response, error);
        }
        log.debug("Returning from method: getActiveGovernanceOfficers with response: " + response.toString());
        return response;
    }

    public GovernanceOfficerListResponse getGovernanceOfficersByDomain(String userId, GovernanceDomainRequestBody requestBody) {
        String methodName = "getGovernanceOfficersByDomain";
        log.debug("Calling method: getGovernanceOfficersByDomain");
        GovernanceOfficerListResponse response = new GovernanceOfficerListResponse();
        try {
            this.validateInitialization("getGovernanceOfficersByDomain");
            GovernanceDomain governanceDomain = null;
            if (requestBody != null) {
                governanceDomain = requestBody.getGovernanceDomain();
            }
            GovernanceOfficerHandler handler = new GovernanceOfficerHandler(accessServiceName, repositoryConnector);
            response.setGovernanceOfficers(handler.getGovernanceOfficersByDomain(userId, governanceDomain));
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((GovernanceProgramOMASAPIResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.capturePropertyServerException((GovernanceProgramOMASAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((GovernanceProgramOMASAPIResponse)response, error);
        }
        log.debug("Returning from method: getGovernanceOfficersByDomain with response: " + response.toString());
        return response;
    }

    public VoidResponse appointGovernanceOfficer(String userId, String governanceOfficerGUID, AppointmentRequestBody requestBody) {
        String methodName = "appointGovernanceOfficer";
        log.debug("Calling method: appointGovernanceOfficer");
        VoidResponse response = new VoidResponse();
        try {
            this.validateInitialization("appointGovernanceOfficer");
            String profileGUID = null;
            Date startDate = null;
            if (requestBody != null) {
                profileGUID = requestBody.getGUID();
                startDate = requestBody.getEffectiveDate();
            }
            GovernanceOfficerHandler handler = new GovernanceOfficerHandler(accessServiceName, repositoryConnector);
            handler.appointGovernanceOfficer(userId, governanceOfficerGUID, profileGUID, startDate);
        }
        catch (UnrecognizedGUIDException error) {
            this.captureUnrecognizedGUIDException((GovernanceProgramOMASAPIResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.capturePropertyServerException((GovernanceProgramOMASAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((GovernanceProgramOMASAPIResponse)response, error);
        }
        log.debug("Returning from method: appointGovernanceOfficer with response: " + response.toString());
        return response;
    }

    public VoidResponse relieveGovernanceOfficer(String userId, String governanceOfficerGUID, AppointmentRequestBody requestBody) {
        String methodName = "relieveGovernanceOfficer";
        log.debug("Calling method: relieveGovernanceOfficer");
        VoidResponse response = new VoidResponse();
        try {
            this.validateInitialization("relieveGovernanceOfficer");
            String profileGUID = null;
            Date endDate = null;
            if (requestBody != null) {
                profileGUID = requestBody.getGUID();
                endDate = requestBody.getEffectiveDate();
            }
            GovernanceOfficerHandler handler = new GovernanceOfficerHandler(accessServiceName, repositoryConnector);
            handler.relieveGovernanceOfficer(userId, governanceOfficerGUID, profileGUID, endDate);
        }
        catch (UnrecognizedGUIDException error) {
            this.captureUnrecognizedGUIDException((GovernanceProgramOMASAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((GovernanceProgramOMASAPIResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.capturePropertyServerException((GovernanceProgramOMASAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((GovernanceProgramOMASAPIResponse)response, error);
        }
        log.debug("Returning from method: relieveGovernanceOfficer with response: " + response.toString());
        return response;
    }

    private void captureCheckedException(GovernanceProgramOMASAPIResponse response, GovernanceProgramCheckedExceptionBase error, String exceptionClassName) {
        response.setRelatedHTTPCode(error.getReportedHTTPCode());
        response.setExceptionClassName(exceptionClassName);
        response.setExceptionErrorMessage(error.getErrorMessage());
        response.setExceptionSystemAction(error.getReportedSystemAction());
        response.setExceptionUserAction(error.getReportedUserAction());
    }

    private void captureCheckedException(GovernanceProgramOMASAPIResponse response, GovernanceProgramCheckedExceptionBase error, String exceptionClassName, Map<String, Object> exceptionProperties) {
        this.captureCheckedException(response, error, exceptionClassName);
        response.setExceptionProperties(exceptionProperties);
    }

    private void captureUnrecognizedGUIDException(GovernanceProgramOMASAPIResponse response, UnrecognizedGUIDException error) {
        String guid = error.getGUID();
        String expectedTypeName = error.getExpectedTypeName();
        if (guid != null || expectedTypeName != null) {
            HashMap<String, Object> exceptionProperties = new HashMap<String, Object>();
            exceptionProperties.put("guid", guid);
            exceptionProperties.put("expectedTypeName", expectedTypeName);
            this.captureCheckedException(response, (GovernanceProgramCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName(), exceptionProperties);
        } else {
            this.captureCheckedException(response, (GovernanceProgramCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
        }
        this.captureCheckedException(response, (GovernanceProgramCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
    }

    private void captureInvalidParameterException(GovernanceProgramOMASAPIResponse response, InvalidParameterException error) {
        String parameterName = error.getParameterName();
        if (parameterName != null) {
            HashMap<String, Object> exceptionProperties = new HashMap<String, Object>();
            exceptionProperties.put("parameterName", parameterName);
            this.captureCheckedException(response, (GovernanceProgramCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName(), exceptionProperties);
        } else {
            this.captureCheckedException(response, (GovernanceProgramCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
        }
    }

    private void captureEmployeeNumberNotUniqueException(GovernanceProgramOMASAPIResponse response, EmployeeNumberNotUniqueException error) {
        List duplicateProfiles = error.getDuplicateProfiles();
        if (duplicateProfiles != null) {
            HashMap<String, Object> exceptionProperties = new HashMap<String, Object>();
            exceptionProperties.put("duplicateProfiles", duplicateProfiles);
            this.captureCheckedException(response, (GovernanceProgramCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName(), exceptionProperties);
        } else {
            this.captureCheckedException(response, (GovernanceProgramCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
        }
    }

    private void captureAppointmentIdNotUniqueException(GovernanceProgramOMASAPIResponse response, AppointmentIdNotUniqueException error) {
        List duplicatePosts = error.getDuplicatePosts();
        if (duplicatePosts != null) {
            HashMap<String, Object> exceptionProperties = new HashMap<String, Object>();
            exceptionProperties.put("duplicatePosts", duplicatePosts);
            this.captureCheckedException(response, (GovernanceProgramCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName(), exceptionProperties);
        } else {
            this.captureCheckedException(response, (GovernanceProgramCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
        }
    }

    private void capturePropertyServerException(GovernanceProgramOMASAPIResponse response, PropertyServerException error) {
        this.captureCheckedException(response, (GovernanceProgramCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
    }

    private void captureUserNotAuthorizedException(GovernanceProgramOMASAPIResponse response, UserNotAuthorizedException error) {
        String userId = error.getUserId();
        if (userId != null) {
            HashMap<String, Object> exceptionProperties = new HashMap<String, Object>();
            exceptionProperties.put("userId", userId);
            this.captureCheckedException(response, (GovernanceProgramCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName(), exceptionProperties);
        } else {
            this.captureCheckedException(response, (GovernanceProgramCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
        }
    }

    private void validateInitialization(String methodName) throws PropertyServerException {
        if (repositoryConnector == null) {
            GovernanceProgramErrorCode errorCode = GovernanceProgramErrorCode.SERVICE_NOT_INITIALIZED;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName});
            throw new PropertyServerException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }
}

