/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceprogram.server;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.governanceprogram.ffdc.GovernanceProgramErrorCode;
import org.odpi.openmetadata.accessservices.governanceprogram.ffdc.exceptions.EmployeeNumberNotUniqueException;
import org.odpi.openmetadata.accessservices.governanceprogram.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.governanceprogram.ffdc.exceptions.PropertyServerException;
import org.odpi.openmetadata.accessservices.governanceprogram.ffdc.exceptions.UnrecognizedGUIDException;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.PersonalProfile;
import org.odpi.openmetadata.accessservices.governanceprogram.server.GovernanceProgramBasicHandler;
import org.odpi.openmetadata.accessservices.governanceprogram.server.GovernanceProgramErrorHandler;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.MatchCriteria;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PersonalProfileHandler {
    private static final String personalDetailsTypeGUID = "ac406bf8-e53e-49f1-9088-2af28bbbd285";
    private static final String personalDetailsTypeName = "Person";
    private static final String employeeNumberPropertyName = "qualifiedName";
    private static final String fullNamePropertyName = "fullName";
    private static final String knownNamePropertyName = "name";
    private static final String jobTitlePropertyName = "jobTitle";
    private static final String jobDescriptionPropertyName = "description";
    private static final String additionalPropertiesName = "additionalProperties";
    private static final String profileGUIDParameterName = "profileGUID";
    private static final String employeeNumberParameterName = "employeeNumber";
    private static final String knownNameParameterName = "knownName";
    private static final Logger log = LoggerFactory.getLogger(PersonalProfileHandler.class);
    private String serviceName;
    private OMRSRepositoryHelper repositoryHelper = null;
    private String serverName = null;
    private GovernanceProgramErrorHandler errorHandler = null;
    private GovernanceProgramBasicHandler basicHandler = null;

    PersonalProfileHandler(String serviceName, OMRSRepositoryConnector repositoryConnector) {
        this.serviceName = serviceName;
        if (repositoryConnector != null) {
            this.repositoryHelper = repositoryConnector.getRepositoryHelper();
            this.serverName = repositoryConnector.getServerName();
            this.errorHandler = new GovernanceProgramErrorHandler(repositoryConnector);
            this.basicHandler = new GovernanceProgramBasicHandler(serviceName, repositoryConnector);
        }
    }

    private InstanceProperties createPersonalProfileProperties(String methodName, String employeeNumber, String fullName, String knownName, String jobTitle, String jobRoleDescription, Map<String, Object> additionalProperties) throws InvalidParameterException {
        this.errorHandler.validateName(employeeNumber, employeeNumberParameterName, methodName);
        this.errorHandler.validateName(knownName, knownNameParameterName, methodName);
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, employeeNumberPropertyName, employeeNumber, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, fullNamePropertyName, fullName, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, knownNamePropertyName, knownName, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, jobTitlePropertyName, jobTitle, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, jobDescriptionPropertyName, jobRoleDescription, methodName);
        properties = this.repositoryHelper.addMapPropertyToInstance(this.serviceName, properties, additionalPropertiesName, additionalProperties, methodName);
        log.debug("Instance properties: " + properties.toString());
        return properties;
    }

    PersonalProfile getPersonalProfileFromEntity(EntityDetail entity, String methodName) {
        PersonalProfile personalProfile = null;
        if (entity != null) {
            personalProfile = new PersonalProfile();
            personalProfile.setGUID(entity.getGUID());
            personalProfile.setType(personalDetailsTypeName);
            InstanceProperties instanceProperties = entity.getProperties();
            if (instanceProperties != null) {
                personalProfile.setEmployeeNumber(this.repositoryHelper.getStringProperty(this.serviceName, employeeNumberPropertyName, instanceProperties, methodName));
                personalProfile.setFullName(this.repositoryHelper.getStringProperty(this.serviceName, fullNamePropertyName, instanceProperties, methodName));
                personalProfile.setKnownName(this.repositoryHelper.getStringProperty(this.serviceName, knownNamePropertyName, instanceProperties, methodName));
                personalProfile.setJobTitle(this.repositoryHelper.getStringProperty(this.serviceName, jobTitlePropertyName, instanceProperties, methodName));
                personalProfile.setJobRoleDescription(this.repositoryHelper.getStringProperty(this.serviceName, jobDescriptionPropertyName, instanceProperties, methodName));
                personalProfile.setAdditionalProperties(this.repositoryHelper.getMapFromProperty(this.serviceName, additionalPropertiesName, instanceProperties, methodName));
            }
            log.debug("Personal details: " + personalProfile.toString());
        } else {
            log.debug("Personal details: <null>");
        }
        return personalProfile;
    }

    String createPersonalProfile(String userId, String employeeNumber, String fullName, String knownName, String jobTitle, String jobRoleDescription, Map<String, Object> additionalProperties) throws InvalidParameterException, PropertyServerException, org.odpi.openmetadata.accessservices.governanceprogram.ffdc.exceptions.UserNotAuthorizedException {
        String methodName = "createPersonalProfile";
        this.errorHandler.validateUserId(userId, "createPersonalProfile");
        OMRSMetadataCollection metadataCollection = this.errorHandler.validateRepositoryConnector("createPersonalProfile");
        InstanceProperties properties = this.createPersonalProfileProperties("createPersonalProfile", employeeNumber, fullName, knownName, jobTitle, jobRoleDescription, additionalProperties);
        try {
            EntityDetail personalDetailsEntity = metadataCollection.addEntity(userId, personalDetailsTypeGUID, properties, null, null);
            if (personalDetailsEntity != null) {
                log.debug("New personal details entity: " + personalDetailsEntity.getGUID());
                return personalDetailsEntity.getGUID();
            }
        }
        catch (UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, "createPersonalProfile", this.serverName, this.serviceName);
        }
        catch (Throwable error) {
            this.errorHandler.handleRepositoryError(error, "createPersonalProfile", this.serverName, this.serviceName);
        }
        log.debug("Null return from method: createPersonalProfile");
        return null;
    }

    void updatePersonalProfile(String userId, String profileGUID, String employeeNumber, String fullName, String knownName, String jobTitle, String jobRoleDescription, Map<String, Object> additionalProperties) throws UnrecognizedGUIDException, InvalidParameterException, PropertyServerException, org.odpi.openmetadata.accessservices.governanceprogram.ffdc.exceptions.UserNotAuthorizedException {
        String methodName = "updatePersonalProfile";
        this.errorHandler.validateUserId(userId, "updatePersonalProfile");
        OMRSMetadataCollection metadataCollection = this.errorHandler.validateRepositoryConnector("updatePersonalProfile");
        InstanceProperties properties = this.createPersonalProfileProperties("updatePersonalProfile", employeeNumber, fullName, knownName, jobTitle, jobRoleDescription, additionalProperties);
        try {
            metadataCollection.updateEntityProperties(userId, profileGUID, properties);
        }
        catch (UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, "updatePersonalProfile", this.serverName, this.serviceName);
        }
        catch (EntityNotKnownException error) {
            this.errorHandler.handleUnrecognizedGUIDException(userId, "updatePersonalProfile", this.serverName, personalDetailsTypeName, profileGUID);
        }
        catch (Throwable error) {
            this.errorHandler.handleRepositoryError(error, "updatePersonalProfile", this.serverName, this.serviceName);
        }
        log.debug("Update of personal details successful: " + profileGUID);
    }

    void deletePersonalProfile(String userId, String profileGUID, String employeeNumber) throws UnrecognizedGUIDException, InvalidParameterException, PropertyServerException, org.odpi.openmetadata.accessservices.governanceprogram.ffdc.exceptions.UserNotAuthorizedException {
        String methodName = "deletePersonalProfile";
        this.errorHandler.validateUserId(userId, "deletePersonalProfile");
        this.errorHandler.validateGUID(userId, profileGUIDParameterName, profileGUID, "deletePersonalProfile");
        this.errorHandler.validateName(employeeNumber, employeeNumberParameterName, "deletePersonalProfile");
        PersonalProfile personalProfile = this.getPersonalProfileByGUID(userId, profileGUID);
        if (personalProfile == null || !personalProfile.getEmployeeNumber().equals(employeeNumber)) {
            GovernanceProgramErrorCode errorCode = GovernanceProgramErrorCode.PERSONAL_DETAILS_NOT_DELETED;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{profileGUID});
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "deletePersonalProfile", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), employeeNumberParameterName);
        }
        this.basicHandler.deleteEntity(userId, profileGUID, personalDetailsTypeGUID, personalDetailsTypeName, "deletePersonalProfile");
        log.debug("Delete of personal details successful: " + profileGUID);
    }

    PersonalProfile getPersonalProfileByGUID(String userId, String profileGUID) throws UnrecognizedGUIDException, PropertyServerException, org.odpi.openmetadata.accessservices.governanceprogram.ffdc.exceptions.UserNotAuthorizedException {
        String methodName = "getPersonalProfileByGUID";
        String guidParameter = profileGUIDParameterName;
        this.errorHandler.validateUserId(userId, "getPersonalProfileByGUID");
        this.errorHandler.validateGUID(profileGUID, profileGUIDParameterName, personalDetailsTypeName, "getPersonalProfileByGUID");
        OMRSMetadataCollection metadataCollection = this.errorHandler.validateRepositoryConnector("getPersonalProfileByGUID");
        try {
            return this.getPersonalProfileFromEntity(metadataCollection.getEntityDetail(userId, profileGUID), "getPersonalProfileByGUID");
        }
        catch (EntityNotKnownException error) {
            this.errorHandler.handleUnrecognizedGUIDException(userId, "getPersonalProfileByGUID", this.serverName, personalDetailsTypeName, profileGUID);
        }
        catch (UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, "getPersonalProfileByGUID", this.serverName, this.serviceName);
        }
        catch (Throwable error) {
            this.errorHandler.handleRepositoryError(error, "getPersonalProfileByGUID", this.serverName, this.serviceName);
        }
        log.debug("Null return from method: getPersonalProfileByGUID");
        return null;
    }

    PersonalProfile getPersonalProfileByEmployeeNumber(String userId, String employeeNumber) throws InvalidParameterException, EmployeeNumberNotUniqueException, PropertyServerException, org.odpi.openmetadata.accessservices.governanceprogram.ffdc.exceptions.UserNotAuthorizedException {
        String methodName = "getPersonalProfileByEmployeeNumber";
        String employeeNumberParameterName = employeeNumberParameterName;
        this.errorHandler.validateUserId(userId, "getPersonalProfileByEmployeeNumber");
        this.errorHandler.validateName(employeeNumber, employeeNumberParameterName, "getPersonalProfileByEmployeeNumber");
        OMRSMetadataCollection metadataCollection = this.errorHandler.validateRepositoryConnector("getPersonalProfileByEmployeeNumber");
        try {
            InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, employeeNumberPropertyName, employeeNumber, "getPersonalProfileByEmployeeNumber");
            List personalDetails = metadataCollection.findEntitiesByProperty(userId, personalDetailsTypeGUID, properties, MatchCriteria.ANY, 0, null, null, null, null, null, 2);
            if (personalDetails == null) {
                GovernanceProgramErrorCode errorCode = GovernanceProgramErrorCode.PERSONAL_DETAILS_NOT_FOUND_BY_EMP_ID;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{employeeNumber});
                throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "getPersonalProfileByEmployeeNumber", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), employeeNumber);
            }
            if (personalDetails.size() != 1) {
                GovernanceProgramErrorCode errorCode = GovernanceProgramErrorCode.DUPLICATE_PERSONAL_DETAILS_FOR_EMP_ID;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{employeeNumber});
                throw new EmployeeNumberNotUniqueException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "getPersonalProfileByEmployeeNumber", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), personalDetails);
            }
            return this.getPersonalProfileFromEntity((EntityDetail)personalDetails.get(0), "getPersonalProfileByEmployeeNumber");
        }
        catch (UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, "getPersonalProfileByEmployeeNumber", this.serverName, this.serviceName);
        }
        catch (EmployeeNumberNotUniqueException | InvalidParameterException error) {
            throw error;
        }
        catch (Throwable error) {
            this.errorHandler.handleRepositoryError(error, "getPersonalProfileByEmployeeNumber", this.serverName, this.serviceName);
        }
        log.debug("Null return from method: getPersonalProfileByEmployeeNumber");
        return null;
    }

    List<PersonalProfile> getPersonalProfilesByName(String userId, String name) throws InvalidParameterException, PropertyServerException, org.odpi.openmetadata.accessservices.governanceprogram.ffdc.exceptions.UserNotAuthorizedException {
        String methodName = "getPersonalProfilesByName";
        String nameParameter = knownNamePropertyName;
        this.errorHandler.validateUserId(userId, "getPersonalProfilesByName");
        this.errorHandler.validateName(name, knownNamePropertyName, "getPersonalProfilesByName");
        OMRSMetadataCollection metadataCollection = this.errorHandler.validateRepositoryConnector("getPersonalProfilesByName");
        try {
            InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, fullNamePropertyName, name, "getPersonalProfilesByName");
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, knownNamePropertyName, name, "getPersonalProfilesByName");
            List personalDetails = metadataCollection.findEntitiesByProperty(userId, personalDetailsTypeGUID, properties, MatchCriteria.ANY, 0, null, null, null, null, null, 2);
            if (personalDetails == null || personalDetails.isEmpty()) {
                GovernanceProgramErrorCode errorCode = GovernanceProgramErrorCode.PERSONAL_DETAILS_NOT_FOUND_BY_NAME;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{name});
                throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "getPersonalProfilesByName", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), name);
            }
            ArrayList<PersonalProfile> resultsList = new ArrayList<PersonalProfile>();
            for (EntityDetail entity : personalDetails) {
                resultsList.add(this.getPersonalProfileFromEntity(entity, "getPersonalProfilesByName"));
            }
            return resultsList;
        }
        catch (UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, "getPersonalProfilesByName", this.serverName, this.serviceName);
        }
        catch (InvalidParameterException error) {
            throw error;
        }
        catch (Throwable error) {
            this.errorHandler.handleRepositoryError(error, "getPersonalProfilesByName", this.serverName, this.serviceName);
        }
        log.debug("Null return from method: getPersonalProfilesByName");
        return null;
    }
}

