/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceprogram.server;

import org.odpi.openmetadata.accessservices.governanceprogram.ffdc.GovernanceProgramErrorCode;
import org.odpi.openmetadata.accessservices.governanceprogram.ffdc.exceptions.PropertyServerException;
import org.odpi.openmetadata.accessservices.governanceprogram.server.GovernanceProgramRegistration;
import org.odpi.openmetadata.accessservices.governanceprogram.server.GovernanceProgramServicesInstance;
import org.odpi.openmetadata.accessservices.governanceprogram.server.GovernanceProgramServicesInstanceMap;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;

class GovernanceProgramInstanceHandler {
    private static GovernanceProgramServicesInstanceMap instanceMap = new GovernanceProgramServicesInstanceMap();
    private static AccessServiceDescription myDescription = AccessServiceDescription.GOVERNANCE_PROGRAM_OMAS;

    GovernanceProgramInstanceHandler() {
        GovernanceProgramRegistration.registerAccessService();
    }

    public String getAccessServiceName() {
        return myDescription.getAccessServiceName();
    }

    OMRSMetadataCollection getMetadataCollection(String serverName) throws PropertyServerException {
        GovernanceProgramServicesInstance instance = instanceMap.getInstance(serverName);
        if (instance != null) {
            return instance.getMetadataCollection();
        }
        String methodName = "getMetadataCollection";
        GovernanceProgramErrorCode errorCode = GovernanceProgramErrorCode.SERVICE_NOT_INITIALIZED;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{serverName, "getMetadataCollection"});
        throw new PropertyServerException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "getMetadataCollection", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }

    OMRSRepositoryConnector getRepositoryConnector(String serverName) throws PropertyServerException {
        GovernanceProgramServicesInstance instance = instanceMap.getInstance(serverName);
        if (instance != null) {
            return instance.getRepositoryConnector();
        }
        String methodName = "getRepositoryConnector";
        GovernanceProgramErrorCode errorCode = GovernanceProgramErrorCode.SERVICE_NOT_INITIALIZED;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{serverName, "getRepositoryConnector"});
        throw new PropertyServerException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "getRepositoryConnector", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }
}

